/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.info;

import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.performance.dao.PerformanceSaverManager;
import com.fr.performance.info.CellInfo;
import com.fr.performance.info.DataSourceInfo;
import com.fr.performance.info.ExportInfo;
import com.fr.performance.info.IExportInfo;
import com.fr.performance.info.IReportPerformanceInfo;
import com.fr.performance.info.ISubmitInfo;
import com.fr.performance.info.InfoUtils;
import com.fr.performance.info.SubmitInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPerformanceInfo
implements IReportPerformanceInfo {
    private static final long serialVersionUID = 1L;
    public static final long CACHE_MARK = -2L;
    public static final ReportPerformanceInfo EOF = new ReportPerformanceInfo();
    private long createTime;
    private Map<String, DataSourceInfo> dataSourceInfoMap = new HashMap<String, DataSourceInfo>();
    private Map<String, CellInfo> cellInfoMap = new HashMap<String, CellInfo>();
    private long totalCalculateTime = -1L;
    private Map<String, Long> sheetMemoryMap = new HashMap<String, Long>();
    private String workBookName;
    private List<IExportInfo> exportInfoList = new ArrayList<IExportInfo>();
    private List<ISubmitInfo> submitInfoList = new ArrayList<ISubmitInfo>();
    private String parameterString = "";
    private Map<String, Long> sqlFunExecuteTimes = new HashMap<String, Long>();
    private Map<String, Long> imageMap = new HashMap<String, Long>();
    private Map<String, Long> cacheImageMap = new HashMap<String, Long>();

    private ReportPerformanceInfo() {
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(long l2) {
        this.createTime = l2;
    }

    @Override
    public long getId() {
        return this.createTime;
    }

    public static ReportPerformanceInfo newInstance() {
        ReportPerformanceInfo reportPerformanceInfo = new ReportPerformanceInfo();
        reportPerformanceInfo.setCreateTime(PerformanceSaverManager.getUniqueCreateTime());
        return reportPerformanceInfo;
    }

    @Override
    public void putDataModelRowCount(String string, int n2) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
        dataSourceInfo.setRowCount(n2);
    }

    @Override
    public void putDataModelColCount(String string, int n2) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
        dataSourceInfo.setColCount(n2);
    }

    @Override
    public void putDataSourceExecuteTime(String string, long l2) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
        dataSourceInfo.setExecuteTime(l2);
    }

    @Override
    public void putDataSourceTransferTime(String string, long l2) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
        dataSourceInfo.setTransferTime(l2);
    }

    @Override
    public void addBuildDataTime(String string, long l2) {
        this.getDataSourceInfo(string).addBuildDataTime(l2);
    }

    public DataSourceInfo getDataSourceInfo(String string) {
        DataSourceInfo dataSourceInfo = this.dataSourceInfoMap.get(string);
        if (dataSourceInfo == null) {
            dataSourceInfo = new DataSourceInfo(string);
            this.dataSourceInfoMap.put(string, dataSourceInfo);
        }
        return dataSourceInfo;
    }

    @Override
    public void putCellCalculateTime(String string, long l2) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.setCalculateTime(l2);
    }

    @Override
    public void addCellPresentTime(String string, long l2) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addPresentTime(l2);
    }

    @Override
    public void addCellFilterTime(String string, long l2) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addFilterTime(l2);
    }

    @Override
    public void addCellDynamicParameter(String string, long l2) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addDynamicParameterTime(l2);
    }

    @Override
    public void addCellCustomDisplayTime(String string, long l2) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addFilterTime(l2);
    }

    @Override
    public void addCellHighlightTime(String string, long l2) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addHighlightTime(l2);
    }

    @Override
    public void addCellHyperlinkTime(String string, long l2) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addHyperlinkTime(l2);
    }

    private CellInfo getCellInfo(String string) {
        CellInfo cellInfo = this.cellInfoMap.get(string);
        if (cellInfo == null) {
            cellInfo = new CellInfo();
            cellInfo.setName(string);
            this.cellInfoMap.put(string, cellInfo);
        }
        return cellInfo;
    }

    @Override
    public long getTotalCalculateTime() {
        return this.totalCalculateTime;
    }

    @Override
    public void setCalculateTime(long l2) {
        this.totalCalculateTime = l2;
    }

    @Override
    public void putReportMemory(String string, long l2) {
        this.sheetMemoryMap.put(string, l2);
    }

    @Override
    public String getWorkBookName() {
        return this.workBookName;
    }

    @Override
    public void setWorkBookName(String string) {
        this.workBookName = string;
    }

    public Map<String, Long> getSheetMemoryMap() {
        return this.sheetMemoryMap;
    }

    public Map<String, DataSourceInfo> getDataSourceInfoMap() {
        return this.dataSourceInfoMap;
    }

    public Map<String, CellInfo> getCellInfoMap() {
        return this.cellInfoMap;
    }

    void setCellInfoMap(Map<String, CellInfo> map) {
        this.cellInfoMap = map;
    }

    void setDataSourceInfoMap(Map<String, DataSourceInfo> map) {
        this.dataSourceInfoMap = map;
    }

    @Override
    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("baseInfo", this.createBaseInfo());
        jSONObject.put("dataSourceInfo", new JSONArray(this.getSortedValues(this.dataSourceInfoMap)));
        jSONObject.put("cellInfo", new JSONArray(this.getSortedValues(this.cellInfoMap)));
        if (!this.exportInfoList.isEmpty()) {
            jSONObject.put("exportInfo", new JSONArray(this.exportInfoList));
        }
        if (!this.submitInfoList.isEmpty()) {
            jSONObject.put("submitInfo", new JSONArray(this.submitInfoList));
        }
        if (!this.sqlFunExecuteTimes.isEmpty()) {
            jSONObject.put("sqlFunInfo", this.getEntryArray(this.sqlFunExecuteTimes, "mark", "time"));
        }
        if (!this.imageMap.isEmpty()) {
            jSONObject.put("imageInfo", this.getEntryArray(this.imageMap, "mark", "memory"));
        }
        if (!this.cacheImageMap.isEmpty()) {
            jSONObject.put("cacheImageInfo", this.getEntryArray(this.cacheImageMap, "mark", "memory"));
        }
        return jSONObject;
    }

    private JSONArray getEntryArray(Map<String, Long> map, String string, String string2) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(string, entry.getKey());
            jSONObject.put(string2, entry.getValue());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    @Override
    public void parseJSON(JSONObject jSONObject) throws Exception {
        this.parseBaseJSON(jSONObject);
        this.parseCellInfoJSON(jSONObject);
        this.parseDataSourceInfoJSON(jSONObject);
        this.parseExportInfo(jSONObject);
        this.parseSubmitInfo(jSONObject);
        this.parseSqlFun(jSONObject);
        this.parseImageInfo(jSONObject);
    }

    private void parseImageInfo(JSONObject jSONObject) throws JSONException {
        this.parseImageInfoToMap(this.imageMap, jSONObject.optJSONArray("imageInfo"));
        this.parseImageInfoToMap(this.cacheImageMap, jSONObject.optJSONArray("cacheImageInfo"));
    }

    private void parseImageInfoToMap(Map<String, Long> map, JSONArray jSONArray) throws JSONException {
        if (jSONArray != null) {
            map.clear();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                String string = jSONObject.getString("mark");
                Long l2 = jSONObject.getLong("memory");
                map.put(string, l2);
            }
        }
    }

    private void parseSqlFun(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray("sqlFunInfo");
        if (jSONArray != null) {
            this.sqlFunExecuteTimes.clear();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                String string = jSONObject2.getString("mark");
                Long l2 = jSONObject2.getLong("time");
                this.sqlFunExecuteTimes.put(string, l2);
            }
        }
    }

    private void parseSubmitInfo(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.optJSONArray("submitInfo");
        if (jSONArray != null) {
            this.submitInfoList.clear();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                SubmitInfo submitInfo = new SubmitInfo();
                submitInfo.parseJSON(jSONArray.getJSONObject(i2));
                this.submitInfoList.add(submitInfo);
            }
        }
    }

    private void parseExportInfo(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.optJSONArray("exportInfo");
        if (jSONArray != null) {
            this.exportInfoList.clear();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                ExportInfo exportInfo = new ExportInfo();
                exportInfo.parseJSON(jSONArray.getJSONObject(i2));
                this.exportInfoList.add(exportInfo);
            }
        }
    }

    private void parseDataSourceInfoJSON(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.getJSONArray("dataSourceInfo");
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            DataSourceInfo dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.parseJSON(jSONArray.getJSONObject(i2));
            this.dataSourceInfoMap.put(dataSourceInfo.getName(), dataSourceInfo);
        }
    }

    private void parseCellInfoJSON(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.getJSONArray("cellInfo");
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            CellInfo cellInfo = new CellInfo();
            cellInfo.parseJSON(jSONArray.getJSONObject(i2));
            this.cellInfoMap.put(cellInfo.getName(), cellInfo);
        }
    }

    private void parseBaseJSON(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject("baseInfo");
        this.setWorkBookName(jSONObject2.getString("name"));
        this.setCalculateTime(jSONObject2.getLong("calculateTime"));
        this.setCreateTime(jSONObject2.getLong("createTime"));
        this.putReportMemory("all", jSONObject2.getLong("memory"));
        this.putParameterString(jSONObject2.optString("parameter"));
    }

    private JSONObject createBaseInfo() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("name", this.workBookName);
        jSONObject.put("calculateTime", this.totalCalculateTime);
        jSONObject.put("memory", this.getReportMemory());
        long l2 = this.getImageMemory();
        if (l2 != 0L) {
            jSONObject.put("imgMemory", this.getImageMemory());
        }
        jSONObject.put("createTime", this.createTime);
        jSONObject.put("parameter", this.parameterString);
        return jSONObject;
    }

    private long getImageMemory() {
        long l2 = 0L;
        for (long l3 : this.imageMap.values()) {
            l2 += l3;
        }
        return l2;
    }

    @Override
    public long getReportMemory() {
        long l2 = 0L;
        for (Map.Entry<String, Long> entry : this.sheetMemoryMap.entrySet()) {
            l2 += entry.getValue().longValue();
        }
        return l2;
    }

    @Override
    public long getTotalMemory() {
        return this.getReportMemory() + this.getImageMemory();
    }

    @Override
    public void addExportInfo(IExportInfo iExportInfo) {
        this.exportInfoList.add(iExportInfo);
    }

    @Override
    public void addSubmitInfo(ISubmitInfo iSubmitInfo) {
        this.submitInfoList.add(iSubmitInfo);
    }

    @Override
    public void putParameterString(String string) {
        this.parameterString = string;
    }

    @Override
    public String getParameterString() {
        return this.parameterString;
    }

    @Override
    public Map<String, Long> getImageMap() {
        return this.imageMap;
    }

    @Override
    public void addImageMemory(String string, long l2, boolean bl) {
        if (bl) {
            this.addImageMemory(this.cacheImageMap, string + "(from cache)", l2);
        } else {
            this.addImageMemory(this.imageMap, string, l2);
        }
    }

    @Override
    public void addImageMemory(String string, long l2) {
        this.addImageMemory(string, l2, false);
    }

    private void addImageMemory(Map<String, Long> map, String string, long l2) {
        Long l3 = map.get(string);
        if (l3 == null) {
            map.put(string, l2);
        } else {
            map.put(string, l3 + l2);
        }
    }

    @Override
    public Map<String, Long> getSqlFunExecuteTimes() {
        return this.sqlFunExecuteTimes;
    }

    @Override
    public void addSqlFunExecuteTimes(String string, long l2) {
        Long l3 = this.sqlFunExecuteTimes.get(string);
        if (l3 == null) {
            this.sqlFunExecuteTimes.put(string, l2);
        } else {
            this.sqlFunExecuteTimes.put(string, l3 + l2);
        }
    }

    List<ISubmitInfo> getSubmitInfoList() {
        return this.submitInfoList;
    }

    public List<IExportInfo> getExportInfoList() {
        return this.exportInfoList;
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        return InfoUtils.toJSONString(this);
    }

    private <T extends Comparable<? super T>> List<T> getSortedValues(Collection<T> collection) {
        List<T> list = this.getValueList(collection);
        Collections.sort(list);
        return list;
    }

    private <T extends Comparable<? super T>> List<T> getSortedValues(Map<?, T> map) {
        List<T> list = this.getValueList(map);
        Collections.sort(list);
        return list;
    }

    private <T> List<T> getValueList(Map<?, T> map) {
        ArrayList<T> arrayList = new ArrayList<T>(map.size());
        for (Map.Entry<?, T> entry : map.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    private <T> List<T> getValueList(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection.size());
        for (T t2 : collection) {
            arrayList.add(t2);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        DataSourceInfo dataSourceInfo = new DataSourceInfo();
        DataSourceInfo dataSourceInfo2 = new DataSourceInfo();
    }
}

