/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.dao;

import com.fr.base.FRContext;
import com.fr.general.FRLogger;
import com.fr.stable.StableUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class FileManager {
    public static final String CHARSET = "UTF-8";
    private static final String SAVE_NAME = "performanceAnalyze.db";
    private static final String SAVE_PREFIX = "performance";
    private static final String OVER_MEMORY_DIR_NAME = "memory";
    public static final String OVER_MEMORY_NAME = "over_memory";
    public static final String MEMORY_NAME_SUFFIX = ".info";
    public static final byte[] INFO_MARK = new byte[]{72, 51, -22, 91, -85, -75, 6, 32};
    public static final ReentrantLock FILE_LOCK = new ReentrantLock();

    public static File getInfoSaveFile() {
        try {
            FileManager.lock();
            File file = new File(StableUtils.pathJoin(FRContext.getCurrentEnv().getPath(), SAVE_PREFIX, SAVE_NAME));
            FileManager.ensureParentDirExists(file);
            FileManager.createFile(file);
            File file2 = file;
            return file2;
        }
        finally {
            FileManager.unlock();
        }
    }

    private static void createFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                FRLogger.getLogger().log(Level.WARNING, iOException.getMessage());
            }
        }
    }

    public static void lock() {
        FILE_LOCK.lock();
    }

    public static boolean deleteInfoSaveFile() {
        FileManager.lock();
        try {
            File file = FileManager.getInfoSaveFile();
            if (file.exists()) {
                boolean bl = file.delete();
                return bl;
            }
        }
        finally {
            FileManager.unlock();
        }
        return false;
    }

    public static File createOverMemoryFile() {
        File file;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date();
        File file2 = file = new File(FileManager.getOverMemoryPathName(simpleDateFormat.format(date)));
        FileManager.ensureParentDirExists(file);
        while (file2.exists()) {
            file2 = new File(FileManager.getOverMemoryPathName(simpleDateFormat.format(date) + "_" + System.currentTimeMillis()));
        }
        FileManager.createFile(file2);
        return file2;
    }

    private static String getOverMemoryPathName(String string) {
        return StableUtils.pathJoin(FRContext.getCurrentEnv().getPath(), SAVE_PREFIX, OVER_MEMORY_DIR_NAME, OVER_MEMORY_NAME + string + MEMORY_NAME_SUFFIX);
    }

    public static String getOverMemoryDir() {
        return StableUtils.pathJoin(FRContext.getCurrentEnv().getPath(), SAVE_PREFIX, OVER_MEMORY_DIR_NAME);
    }

    private static void ensureParentDirExists(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    public static File getOverMemoryFile(String string) {
        return new File(StableUtils.pathJoin(FileManager.getOverMemoryDir(), string));
    }

    public static void unlock() {
        FILE_LOCK.unlock();
    }

    public static void main(String[] stringArray) {
        System.out.println(new Date());
    }
}

