/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance;

import com.fr.performance.EnginePerformanceManager;
import com.fr.performance.IRuntimeMonitor;
import com.fr.performance.info.IRuntimeInfo;
import com.fr.performance.memory.MemoryMonitor;
import com.fr.performance.status.ReportStatus;
import com.fr.web.core.SessionIDInfor;

public class RuntimeMonitor
implements IRuntimeMonitor {
    private static final int CHECK_COUNT = 1000;
    private static final int CHECK_MEMORY = 102400;
    private static final RuntimeMonitor INSTANCE = new RuntimeMonitor();

    private RuntimeMonitor() {
    }

    public static RuntimeMonitor getInstance() {
        return INSTANCE;
    }

    public void checkAddBoxCeCount(int n2) {
        this.checkAddUnitCount(n2, 120);
    }

    public void checkAddUnitCount(int n2, int n3) {
        this.addUnitCount(n2);
        RuntimeMonitor.getInstance().addMemoryAndCheck(n2 * n3);
    }

    public void addUnitCount(int n2) {
        IRuntimeInfo iRuntimeInfo = this.getCurrentRuntimeInfo();
        if (iRuntimeInfo == null) {
            return;
        }
        iRuntimeInfo.addUnitCount(n2);
    }

    public void addMemoryAndCheck(long l2) {
        IRuntimeInfo iRuntimeInfo = this.getCurrentRuntimeInfo();
        if (iRuntimeInfo == null) {
            return;
        }
        iRuntimeInfo.addMemory(l2);
        if (iRuntimeInfo.getNewMemory() > 102400L) {
            iRuntimeInfo.resetNewMemory();
            this.checkPoint();
        }
    }

    public IRuntimeInfo getCurrentRuntimeInfo() {
        SessionIDInfor sessionIDInfor = EnginePerformanceManager.getThreadSession();
        if (sessionIDInfor != null) {
            return sessionIDInfor.getRuntimeInfo();
        }
        return null;
    }

    public void checkPoint() {
        MemoryMonitor.checkMemory();
    }

    public void checkAddBeCount(int n2) {
        RuntimeMonitor.getInstance().addMemoryAndCheck(n2 * 84);
    }

    public void setCurrentSessionStatus(ReportStatus reportStatus) {
        SessionIDInfor sessionIDInfor = EnginePerformanceManager.getThreadSession();
        if (sessionIDInfor == null) {
            return;
        }
        sessionIDInfor.setStatus(reportStatus);
        if (reportStatus.isOperate()) {
            sessionIDInfor.resetRuntimeInfo();
        }
    }

    public ReportStatus getCurrentSessionStatus() {
        SessionIDInfor sessionIDInfor = EnginePerformanceManager.getThreadSession();
        if (sessionIDInfor != null) {
            return sessionIDInfor.getStatus();
        }
        return ReportStatus.UNKNOWN;
    }
}

