/*
 * Decompiled with CFR 0.152.
 */
package com.fr.module;

import com.fr.base.BaseObjectTokenizer;
import com.fr.base.ConfigManager;
import com.fr.base.ConfigProvider;
import com.fr.base.Formula;
import com.fr.base.MultiFieldParameter;
import com.fr.base.Parameter;
import com.fr.base.ResultFormula;
import com.fr.cache.CacheProvider;
import com.fr.file.CacheManager;
import com.fr.general.BaseObjectXMLWriterFinder;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.general.ManagerFactory;
import com.fr.general.ModuleContext;
import com.fr.general.SiteCenter;
import com.fr.script.Calculator;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.module.Module;
import com.fr.stable.script.CalculatorProviderContext;
import com.fr.stable.script.ValueConverter;
import com.fr.stable.xml.ObjectTokenizer;
import com.fr.stable.xml.ObjectXMLWriterFinder;

public abstract class TopModule
implements Module {
    private boolean hasLoadLocaleFiles = false;

    public void start() {
        SiteCenter.getInstance();
        StableFactory.registerXMLDescription("Formula", new Formula());
        StableFactory.registerXMLDescription("TFC", new ResultFormula());
        StableFactory.registerXMLDescription("Parameter", new Parameter());
        StableFactory.registerXMLDescription("MultiFieldParameter", new MultiFieldParameter());
        CalculatorProviderContext.registerCalculatorProvider(Calculator.createCalculator());
        ManagerFactory.registerCacheProvider((CacheProvider)((Object)CacheManager.getProviderInstance()));
        ManagerFactory.registerConfigProvider((ConfigProvider)((Object)ConfigManager.getProviderInstance()));
        ModuleContext.registerStartedModule(TopModule.class.getName(), this);
        this.loadLocaleFiles();
    }

    private void loadLocaleFiles() {
        if (!this.hasLoadLocaleFiles) {
            String[] stringArray;
            for (String string : stringArray = this.getLocaleFile()) {
                Inter.loadLocaleFile(GeneralContext.getLocale(), string);
            }
            this.hasLoadLocaleFiles = true;
        }
    }

    public ValueConverter valueConverter() {
        return ValueConverter.DEFAULT;
    }

    public ObjectTokenizer startXMLReadObjectTokenizer() {
        return new BaseObjectTokenizer();
    }

    public ObjectXMLWriterFinder startObjectXMLWriterFinder() {
        return new BaseObjectXMLWriterFinder();
    }

    public String getRealInternationalName() {
        this.loadLocaleFiles();
        return this.getInterNationalName();
    }

    public void startFinish() {
    }

    public void stop() {
    }
}

