/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.DynamicUnitList;
import com.fr.cache.list.IntList;
import com.fr.general.ComparatorUtils;
import com.fr.io.core.ExcelExporterReport;
import com.fr.main.FineBook;
import com.fr.report.ReportHelper;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.stable.ColumnRow;
import com.fr.stable.ExportConstants;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ColumnRowLiteral;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.script.ExTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelHiddenCellsTool
implements ExTool {
    private IntList rowHiddenList = null;
    private IntList colHiddenList = null;
    private Report report = null;
    private Map<Integer, IntList[]> hhMap = null;

    public void setRowHiddenList(IntList intList) {
        this.rowHiddenList = intList;
    }

    public void setColHiddenList(IntList intList) {
        this.colHiddenList = intList;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void setHhMap(Map<Integer, IntList[]> map) {
        this.hhMap = map;
    }

    @Override
    public void setCreateRelation(boolean bl) {
    }

    @Override
    public String exSIL(CalculatorProvider calculatorProvider, String string, ColumnRowRange columnRowRange) {
        FineBook fineBook;
        if (StringUtils.isBlank(string) || columnRowRange == null) {
            return null;
        }
        if (this.report != null && this.report instanceof ExcelExporterReport && (fineBook = this.report.getBook()) != null) {
            for (int i2 = 0; i2 < fineBook.getReportCount(); ++i2) {
                IntList[] intListArray;
                if (!ComparatorUtils.equals(string, fineBook.getReportName(i2))) continue;
                Report report = fineBook.getReport(i2);
                if (report == null || !(report instanceof ECReport)) break;
                ECReport eCReport = (ECReport)report;
                if (eCReport.getRowCount() > ExportConstants.MAX_ROWS_2007 || eCReport.getColumnCount() > ExportConstants.MAX_COLS_2007) {
                    return null;
                }
                if (this.hhMap == null) {
                    this.hhMap = new HashMap<Integer, IntList[]>();
                }
                if ((intListArray = this.hhMap.get(i2)) == null) {
                    IntList intList = new IntList();
                    DynamicUnitList dynamicUnitList = ReportHelper.getRowHeightList(eCReport);
                    for (int i3 = dynamicUnitList.size() - 1; i3 >= 0; --i3) {
                        if (!eCReport.getRowHeight(i3).equal_zero()) continue;
                        intList.add(i3);
                    }
                    IntList intList2 = new IntList();
                    DynamicUnitList dynamicUnitList2 = ReportHelper.getColumnWidthList(eCReport);
                    for (int i4 = dynamicUnitList2.size() - 1; i4 >= 0; --i4) {
                        if (!eCReport.getColumnWidth(i4).equal_zero()) continue;
                        intList2.add(i4);
                    }
                    intListArray = new IntList[]{intList, intList2};
                    this.hhMap.put(i2, intListArray);
                }
                return "'" + string + "'!" + this.deleteFromHiddenList(columnRowRange, intListArray[0], intListArray[1]).toString();
            }
        }
        return null;
    }

    @Override
    public List exBoxes(ColumnRowRange columnRowRange) {
        return null;
    }

    public ColumnRow deleteFromHiddenList(ColumnRowRange columnRowRange, IntList intList, IntList intList2) {
        if (columnRowRange == null) {
            return null;
        }
        ColumnRowLiteral columnRowLiteral = columnRowRange.getFrom();
        ColumnRowLiteral columnRowLiteral2 = columnRowRange.getTo();
        ColumnRow columnRow = columnRowLiteral.getTargetColumnRow();
        ColumnRow columnRow2 = columnRowLiteral2 == null ? null : columnRowLiteral2.getTargetColumnRow();
        ArrayList arrayList = new ArrayList();
        if (columnRowLiteral2 == null) {
            return this.getHiddenColumnRow(columnRow.getColumn(), columnRow.getRow(), intList, intList2);
        }
        throw new RuntimeException();
    }

    private ColumnRow getHiddenColumnRow(int n2, int n3, IntList intList, IntList intList2) {
        int n4;
        int n5 = n2;
        int n6 = n3;
        for (n4 = 0; n4 < n2; ++n4) {
            if (!intList2.contain(n4)) continue;
            --n5;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            if (!intList.contain(n4)) continue;
            --n6;
        }
        return ColumnRow.valueOf(n5, n6);
    }

    @Override
    public String ex(CalculatorProvider calculatorProvider, ColumnRowRange columnRowRange) {
        ColumnRow columnRow = this.deleteFromHiddenList(columnRowRange, this.rowHiddenList, this.colHiddenList);
        if (columnRow != null) {
            return columnRow.toString();
        }
        return "";
    }
}

