/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.reg;

import com.fr.form.ui.reg.AbstractReg;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneReg
extends AbstractReg {
    public static final String XML_TAG = "PhoneReg";
    private static final int THIRD = 3;
    private static final int FOUR = 4;
    private static final int SEVEN = 7;
    private static final int EIGHT = 8;
    private String regString;

    public String toRegText() {
        return this.stringToPhoneReg(this.regString);
    }

    public boolean equals(Object object) {
        return object instanceof PhoneReg && ComparatorUtils.equals(this.regString, ((PhoneReg)object).getRegString());
    }

    public String stringToPhoneReg(String string) {
        if (string == null) {
            string = "025-85679591";
        }
        String string2 = "^";
        String string3 = "\\d";
        String string4 = "\\D+";
        Pattern pattern = Pattern.compile(string4);
        Matcher matcher = pattern.matcher(string);
        int n2 = 0;
        while (matcher.find()) {
            String string5 = string.substring(n2, matcher.end() - matcher.group().length());
            if (string5.length() != 0) {
                string2 = string2 + string3 + "{" + this.uncertainPhoneLength(string5.length()) + "}";
            }
            string2 = string2 + matcher.group();
            n2 = matcher.end();
        }
        if (n2 < string.length()) {
            string2 = string2 + string3 + "{" + this.uncertainPhoneLength(string.length() - n2) + "}$";
        }
        return string2;
    }

    private String uncertainPhoneLength(int n2) {
        if (n2 == 3 || n2 == 7) {
            return n2 + "," + (n2 + 1);
        }
        if (n2 == 4 || n2 == 8) {
            return n2 - 1 + "," + n2;
        }
        return n2 + "";
    }

    public void setRegString(String string) {
        this.regString = string;
    }

    public String getRegString() {
        return this.regString;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.regString = xMLableReader.getAttrAsString("phoneReg", "");
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotEmpty(this.regString)) {
            xMLPrintWriter.startTAG(XML_TAG);
            xMLPrintWriter.attr("phoneReg", this.regString);
            xMLPrintWriter.end();
        }
    }
}

