/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.chart.BaseChartCollection;
import com.fr.base.chart.BaseChartPainter;
import com.fr.base.io.IOFile;
import com.fr.base.io.XMLReadHelper;
import com.fr.chart.chartattr.Bar2DPlot;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartCollection;
import com.fr.chart.chartattr.ChartFactory;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;

public class ChartBook
extends IOFile {
    private static final int DEFAULT_HEIGHT = 500;
    private static final int DEFAULT_WIDTH = 810;
    public static final String XML_TAG = "com.fr.form.ui.ChartBook";
    private int width = 810;
    private int height = 500;
    private ChartCollection chartCollection;

    public ChartBook() {
        Bar2DPlot bar2DPlot = ChartFactory.createBar2DPlot();
        bar2DPlot.getLegend().setFRFont(FRContext.getDefaultValues().getFRFont());
        Chart chart = new Chart(bar2DPlot);
        this.chartCollection = new ChartCollection();
        this.chartCollection.addNamedChart(chart.getTitle().getTextObject().toString(), chart);
    }

    public BaseChartCollection getChartCollection() {
        return this.chartCollection;
    }

    public void readStream(InputStream inputStream) throws Exception {
        XMLableReader xMLableReader = XMLReadHelper.createXMLableReader(inputStream, "UTF-8");
        String string = xMLableReader.getTagName();
        if (!XML_TAG.equals(string)) {
            FRContext.getLogger().info("nodeName[" + string + "] does not match as " + XML_TAG + ", might not read success");
        }
        xMLableReader.readXMLObject(this);
        xMLableReader.close();
        inputStream.close();
    }

    protected String openTag() {
        return XML_TAG;
    }

    protected void mainContent(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ChartSize").attr("width", this.width).attr("height", this.height).end();
        if (this.chartCollection != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.chartCollection, "InnerWidget");
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("ChartSize".endsWith(string)) {
                this.height = xMLableReader.getAttrAsInt("height", 500);
                this.width = xMLableReader.getAttrAsInt("width", 810);
            }
            if ("InnerWidget".equals(string)) {
                this.chartCollection = (ChartCollection)GeneralXMLTools.readXMLable(xMLableReader);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ChartBook chartBook = (ChartBook)super.clone();
        if (this.chartCollection != null) {
            chartBook.chartCollection = (ChartCollection)this.chartCollection.clone();
        }
        return chartBook;
    }

    public JSONObject createContentJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        this.chartCollection.setID("chart_name");
        BaseChartPainter baseChartPainter = this.chartCollection.createChartPainterJustTableDataAndDealFormual(calculator, this.width, this.height);
        return baseChartPainter.createJSONConfig(repository, this.width, this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }
}

