/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core;

import com.fr.base.TableData;
import com.fr.base.TableDataNameObserver;
import com.fr.data.TableDataSource;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.impl.Connection;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.data.util.function.DataFunction;
import com.fr.file.DatasourceManager;
import com.fr.file.DatasourceManagerProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleTypes;

public class DataCoreUtils {
    private static Map schemaMap = new HashMap();
    private static Map tableMap = new HashMap();
    private static Map viewMap = new HashMap();
    private static Map procedureMap = new HashMap();
    private static final int NUM = 1200;

    private DataCoreUtils() {
    }

    public static int getColumnIndexByName(DataModel dataModel, String string) throws TableDataException {
        int n2 = dataModel.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.tableDataColumnNameEquals(dataModel.getColumnName(i2), string)) continue;
            return i2;
        }
        return -1;
    }

    public static int calculateOracleType(String string) {
        try {
            Field field = OracleTypes.class.getDeclaredField(string.toUpperCase());
            return field.getInt(OracleTypes.class);
        }
        catch (Exception exception) {
            return -10;
        }
    }

    public static String getFunctionDisplayName(DataFunction dataFunction) {
        if (dataFunction == null) {
            return "";
        }
        String string = dataFunction.getClass().getName();
        int n2 = string.lastIndexOf(".");
        n2 = n2 != -1 ? ++n2 : 0;
        StringBuffer stringBuffer = new StringBuffer("DataFunction-");
        stringBuffer.append(string.substring(n2, string.length() - "Function".length()));
        return Inter.getLocText(stringBuffer.toString());
    }

    public static String createSelectSQL(String string, String string2, Dialect dialect) {
        return DataCoreUtils.createSelectSQL(new Table(string, string2), null, dialect);
    }

    public static String createSelectSQL(String string, String string2) {
        return DataCoreUtils.createSelectSQL(new Table(string, string2), null, null);
    }

    public static String createSelectSQL(Table table, Dialect dialect) {
        return DataCoreUtils.createSelectSQL(table, null, dialect);
    }

    public static String createSelectSQL(Table table, String[] stringArray, Dialect dialect) {
        int n2;
        Select select = new Select(table, dialect);
        int n3 = n2 = stringArray == null ? 0 : stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            select.addColumnName(stringArray[i2]);
        }
        return select.toNormalSQLString();
    }

    public static Object getResultSetObject(ResultSet resultSet, int n2, int n3, String string, String string2, Dialect dialect, SQLTypeHandler sQLTypeHandler, boolean bl) throws SQLException {
        Object object = DataCoreUtils.getResultSetObject(resultSet, n2, n3, dialect, sQLTypeHandler);
        if (bl && object instanceof String) {
            return DBUtils.changeCharset((String)object, string, string2);
        }
        return object == null ? Primitive.NULL : object;
    }

    public static TableData getClonedTableData(DatasourceManagerProvider datasourceManagerProvider, String string) throws Exception {
        return datasourceManagerProvider.getTableData(string);
    }

    public static Object getResultSetObject(ResultSet resultSet, int n2, int n3, Dialect dialect, SQLTypeHandler sQLTypeHandler) throws SQLException {
        return sQLTypeHandler.getValue(resultSet, n3, n2);
    }

    public static String writeDictObject(Object object) {
        if (object == null) {
            return "null:null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            if (object instanceof Integer) {
                return object + ":I";
            }
            if (object instanceof Long) {
                return object + ":L";
            }
            if (object instanceof Float) {
                return object + ":F";
            }
            if (object instanceof Double) {
                return object + ":D";
            }
            if (object instanceof BigInteger) {
                return object + ":BI";
            }
            if (object instanceof BigDecimal) {
                return object + ":BD";
            }
        } else {
            if (object instanceof Boolean) {
                return object + ":B";
            }
            if (object instanceof Date) {
                return DateUtils.DATEFORMAT2.format((Date)object) + ":DT";
            }
        }
        return object.toString();
    }

    public static Object readDictObject(String string) {
        Object object = string;
        if (string != null && string.matches(".*:.*")) {
            if (string.equals("null:null")) {
                return null;
            }
            try {
                if (string.endsWith(":I")) {
                    object = Integer.valueOf(string.substring(0, string.length() - 2));
                } else if (string.endsWith(":L")) {
                    object = Long.valueOf(string.substring(0, string.length() - 2));
                } else if (string.endsWith(":F")) {
                    object = Float.valueOf(string.substring(0, string.length() - 2));
                } else if (string.endsWith(":D")) {
                    object = Double.valueOf(string.substring(0, string.length() - 2));
                } else if (string.endsWith(":BI")) {
                    object = new BigInteger(string.substring(0, string.length() - 3));
                } else if (string.endsWith(":BD")) {
                    object = new BigDecimal(string.substring(0, string.length() - 3));
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = string;
            }
            if (string.endsWith(":B")) {
                object = Boolean.valueOf(string.substring(0, string.length() - 2));
            } else if (string.endsWith(":DT")) {
                object = DateUtils.object2Date(string.substring(0, string.length() - 3), true);
            }
        }
        return object;
    }

    public static Object getTableDataValue(DataModel dataModel, int n2, int n3) {
        if (n3 < -1) {
            return null;
        }
        try {
            return n3 == -1 ? new Integer(n2 + 1) : dataModel.getValueAt(n2, n3);
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            return null;
        }
    }

    public static String getOnlyColumnName(List list, String string) {
        if (list.contains(string = StableUtils.replaceAllString(string, " ", "_"))) {
            for (int i2 = 2; i2 < 1200; ++i2) {
                String string2 = string + "_" + i2;
                if (list.contains(string2)) continue;
                return string2;
            }
        }
        return string;
    }

    public static String[] getDatabaseSchema(Connection connection) {
        String[] stringArray = (String[])schemaMap.get(connection);
        if (stringArray == null) {
            try {
                stringArray = GeneralContext.getEnvProvider().getTableSchema(connection);
                if (stringArray == null) {
                    stringArray = new String[]{};
                }
                schemaMap.put(connection, stringArray);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return stringArray;
    }

    public static void refreshSchema(Connection connection) {
        try {
            String[] stringArray = GeneralContext.getEnvProvider().getTableSchema(connection);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            schemaMap.put(connection, stringArray);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public static TableProcedure[] getTables(Connection connection, String string, String string2, boolean bl) throws Exception {
        Map map;
        tableMap.clear();
        if (ComparatorUtils.equals(string, "TABLE")) {
            map = tableMap;
        } else if (ComparatorUtils.equals(string, "VIEW")) {
            map = viewMap;
        } else if (ComparatorUtils.equals(string, "PROCEDURE")) {
            map = procedureMap;
        } else {
            return null;
        }
        if (bl && ComparatorUtils.equals(string, "TABLE")) {
            string = "ALLTABLE";
        }
        Map map2 = (Map)map.get(connection);
        TableProcedure[] tableProcedureArray = null;
        if (map2 == null) {
            HashMap<String, TableProcedure[]> hashMap = new HashMap<String, TableProcedure[]>();
            tableProcedureArray = (TableProcedure[])GeneralContext.getEnvProvider().getTableProcedure(connection, string, string2);
            if (tableProcedureArray == null) {
                tableProcedureArray = new TableProcedure[]{};
            }
            hashMap.put(string2, tableProcedureArray);
            map.put(connection, hashMap);
        } else {
            tableProcedureArray = (TableProcedure[])map2.get(string2);
            if (tableProcedureArray == null) {
                tableProcedureArray = (TableProcedure[])GeneralContext.getEnvProvider().getTableProcedure(connection, string, string2);
                if (tableProcedureArray == null) {
                    tableProcedureArray = new TableProcedure[]{};
                }
                map2.put(string2, tableProcedureArray);
                map.put(connection, map2);
            }
        }
        return tableProcedureArray;
    }

    public static List getProcedures(Connection connection, String[] stringArray, boolean bl, boolean bl2) throws Exception {
        procedureMap.clear();
        Map map = (Map)procedureMap.get(connection);
        List<TableProcedure[]> list = null;
        if (map == null) {
            list = GeneralContext.getEnvProvider().getProcedures(connection, stringArray, bl, bl2);
        } else {
            list = new ArrayList();
            if (stringArray.length > 0) {
                for (String string : stringArray) {
                    TableProcedure[] tableProcedureArray = (TableProcedure[])map.get(string);
                    list.add(tableProcedureArray);
                }
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    list.add((TableProcedure[])entry.getValue());
                }
            }
        }
        return list;
    }

    public static void putProcedureMap(Connection connection, Map map) {
        procedureMap.put(connection, map);
    }

    public static TableProcedure[] getTableProcedureOfStoreProcedure(DatabaseMetaData databaseMetaData, String string, String string2, boolean bl) throws Exception {
        TableProcedure[] tableProcedureArray = null;
        ResultSet resultSet = null;
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        try {
            resultSet = databaseMetaData.getProcedures(string, string2, "%");
            while (resultSet.next()) {
                String string3 = resultSet.getString(3);
                int n2 = string3.lastIndexOf(";");
                if (n2 > 0) {
                    string3 = string3.substring(0, n2);
                }
                String string4 = resultSet.getString(1);
                if (bl && string4 != null && string4.indexOf("\\") == -1) {
                    string3 = string4 + "." + string3;
                }
                Dialect dialect = null;
                arrayList.add(new TableProcedure(resultSet.getString(2), string3, "PROCEDURE", dialect));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
        tableProcedureArray = arrayList.toArray(new TableProcedure[arrayList.size()]);
        return tableProcedureArray;
    }

    public static void refreshTables(Connection connection, String string, String string2) {
        Map map;
        if (ComparatorUtils.equals(string, "TABLE")) {
            map = tableMap;
        } else if (ComparatorUtils.equals(string, "VIEW")) {
            map = viewMap;
        } else if (ComparatorUtils.equals(string, "PROCEDURE")) {
            map = procedureMap;
        } else {
            return;
        }
        Map map2 = (Map)map.get(connection);
        if (map2 == null) {
            return;
        }
        map2.remove(string2);
    }

    public static TableData getTableData(Calculator calculator, String string) {
        if (calculator == null || StringUtils.isBlank(string)) {
            return null;
        }
        TableData tableData = null;
        TableDataSource tableDataSource = (TableDataSource)calculator.getAttribute(TableDataSource.KEY);
        if (tableDataSource != null) {
            tableData = tableDataSource.getTableData(string);
        }
        if (tableData == null) {
            DatasourceManagerProvider datasourceManagerProvider = DatasourceManager.getProviderInstance();
            try {
                tableData = DataCoreUtils.getClonedTableData(datasourceManagerProvider, string);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return tableData;
    }

    public static DataModel getLiveDataModel(Calculator calculator, String string) {
        int n2;
        Object[] objectArray;
        DataModel dataModel = null;
        TableData tableData = DataCoreUtils.getTableData(calculator, string);
        if (tableData != null && (dataModel = tableData.createDataModel(calculator, string)) != null) {
            return dataModel;
        }
        DatasourceManagerProvider datasourceManagerProvider = DatasourceManager.getProviderInstance();
        List<String> list = datasourceManagerProvider.getProcedureNames();
        boolean bl = datasourceManagerProvider.isProcedureName(string);
        StoreProcedure storeProcedure = datasourceManagerProvider.getProcedure(string);
        String string2 = string;
        if (!bl) {
            objectArray = string.split("_");
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                stringBuffer.append((String)(n2 == 0 ? objectArray[n2] : "_" + (String)objectArray[n2]));
                if (!list.contains(stringBuffer.toString())) continue;
                string2 = stringBuffer.toString();
                storeProcedure = datasourceManagerProvider.getProcedure(stringBuffer.toString());
                break;
            }
        }
        if (storeProcedure == null) {
            storeProcedure = datasourceManagerProvider.getProcedureBy_dsName(string);
        }
        if (storeProcedure == null) {
            return DataModel.EMPTY_DATAMODEL;
        }
        objectArray = storeProcedure.creatDataModel(calculator);
        int n3 = objectArray.length;
        if (n3 > 0) {
            if (bl) {
                return objectArray[0];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Object object = objectArray[n2];
                if (!ComparatorUtils.equals(string2 + "_" + ((ProcedureDataModel)object).getName(), string)) continue;
                return object;
            }
        }
        return dataModel;
    }

    public static String[] getColValuesInData(TableDataSource tableDataSource, String string, String string2) {
        ArrayList<String> arrayList;
        block9: {
            TableData tableData;
            DataModel dataModel;
            block8: {
                dataModel = null;
                arrayList = new ArrayList<String>();
                tableData = tableDataSource.getTableData(string);
                if (tableData == null) {
                    tableData = DatasourceManager.getProviderInstance().getTableData(string);
                }
                if (!(tableData instanceof StoreProcedure)) break block8;
                StoreProcedure storeProcedure = (StoreProcedure)tableData;
                ProcedureDataModel[] procedureDataModelArray = storeProcedure.creatDataModel(Calculator.createCalculator());
                for (int i2 = 0; i2 < procedureDataModelArray.length; ++i2) {
                    dataModel = procedureDataModelArray[i2];
                    try {
                        int n2 = DataCoreUtils.getColumnIndexByName(dataModel, string2);
                        for (int i3 = 0; i3 < dataModel.getRowCount(); ++i3) {
                            String string3 = GeneralUtils.objectToString(dataModel.getValueAt(i3, n2));
                            if (arrayList.contains(string3)) continue;
                            arrayList.add(string3);
                        }
                        continue;
                    }
                    catch (TableDataException tableDataException) {
                        FRLogger.getLogger().error(Inter.getLocText("FR-Engine_Fail_To_Select_A_Data_Field"));
                    }
                }
                break block9;
            }
            if (tableData == null) break block9;
            dataModel = tableData.createDataModel(Calculator.createCalculator());
            try {
                int n3 = DataCoreUtils.getColumnIndexByName(dataModel, string2);
                for (int i4 = 0; i4 < dataModel.getRowCount(); ++i4) {
                    String string4 = GeneralUtils.objectToString(dataModel.getValueAt(i4, n3));
                    if (arrayList.contains(string4)) continue;
                    arrayList.add(string4);
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(Inter.getLocText("FR-Engine_Fail_To_Select_A_Data_Field"));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int[] getColumnIndics(DataModel dataModel, String[] stringArray) {
        int n2;
        if (dataModel == null) {
            return new int[0];
        }
        int[] nArray = new int[stringArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = -1;
        }
        try {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                int n3 = dataModel.getColumnCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (!ComparatorUtils.tableDataColumnNameEquals(stringArray[n2], dataModel.getColumnName(i2))) continue;
                    nArray[n2] = i2;
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return nArray;
    }

    public static TableData existsName(String string, TableDataNameObserver tableDataNameObserver) {
        TableData tableData = null;
        if (string == null) {
            return TableData.EMPTY_TABLEDATA;
        }
        String[] stringArray = string.split("_");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 == 0) {
                stringBuffer.append(stringArray[i2]);
            } else {
                stringBuffer.append("_" + stringArray[i2]);
            }
            tableData = tableDataNameObserver.isEmptyTableData(stringBuffer.toString());
            if (tableData == null) continue;
            return tableData;
        }
        return tableData;
    }
}

