/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.AxisHelper;
import com.fr.chart.chartglyph.ChartAlertValueGlyph;
import com.fr.chart.chartglyph.NumberAxisGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.FArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ValueAxisGlyph
extends NumberAxisGlyph {
    private static final long serialVersionUID = 2649354991884111487L;
    private static final int UNIT_GAP_LABEL = 3;
    private static final int ALERT_LABEL_LINE_GAP = 2;
    private static final double ALERT_LABEL_MAX_WIDTH_PERCENT = 0.12;
    private static final double LABEL_WIDTH = 8.0;
    private static final double LOG_MIN = 1.0E-10;
    private static final double BASE_LOG = 10.0;
    private static final double MAX_TICK = 1000.0;
    private static final double TICK_NUMBER = 20.0;
    private static final double DEFAULT_WIDTH = 30.0;
    private static final double MAX_LABEL_PERCENT = 0.28;
    private static final double LABEL_GAP = 8.0;
    private boolean alignZeroValue = false;

    public void setAlignZeroValue(boolean bl) {
        this.alignZeroValue = bl;
    }

    public boolean isAlignZeroValue() {
        return this.alignZeroValue;
    }

    public void dealPlotBoundsWithAxisLabel(Rectangle2D rectangle2D, int n2) {
        super.dealPlotBoundsWithAxisLabel(rectangle2D, n2);
        this.dealPlotBoundsWithAlert(rectangle2D, n2);
    }

    public void dealPlotBoundsWithAlert(Rectangle2D rectangle2D, int n2) {
        double d2;
        this.dealAlertLabelWidth(n2);
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getY();
        double d5 = this.maxLeftAlert > 0.0 ? this.maxLeftAlert + 2.0 : 0.0;
        double d6 = this.maxRightAlert > 0.0 ? this.maxRightAlert + 2.0 : 0.0;
        double d7 = d2 = StringUtils.isNotEmpty(this.getShowUnit()) && this.isShowAxisLabel() ? this.getMaxLabelWidth(n2) : 0.0;
        if (this.getPosition() == 2 || this.getPosition() == 4) {
            if (this.axisReversed) {
                rectangle2D.setRect(d3 + d5, d4, rectangle2D.getWidth() - d6 - d5, rectangle2D.getHeight() - d2 - 3.0);
            } else {
                rectangle2D.setRect(d3 + d5, d4, rectangle2D.getWidth() - d6 - d5, rectangle2D.getHeight());
            }
        } else if (this.axisReversed) {
            rectangle2D.setRect(d3 + d2, d4 + d6, rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d5 - d6);
        } else {
            rectangle2D.setRect(d3, d4 + d6, rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d5 - d6);
        }
    }

    public double getPreLeftWidth4DataSheet(int n2) {
        double d2;
        this.calculateTitleDimesion(n2);
        this.dealAlertLabelWidth(n2);
        double d3 = d2 = this.maxLeftAlert == 0.0 ? 0.0 : 2.0 + this.maxLeftAlert;
        if (this.position == 2) {
            return this.getMaxLabelWidthAndInitStartEndLabelDim(n2) + d2 + this.titleDim.getWidth() + this.getTickLengthShow();
        }
        if (this.position == 4) {
            return d2;
        }
        return 0.0;
    }

    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n2) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d2 = 8.0;
        List list = this.getAxisLabelDimList(n2);
        if (list == null || list.isEmpty()) {
            return d2;
        }
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Dimension2D dimension2D = (Dimension2D)list.get(i2);
            double d3 = this.shouldBeHeight() ? dimension2D.getHeight() : dimension2D.getWidth();
            double d4 = d2 = d3 < d2 ? d2 : d3;
            if (i2 == 0) {
                this.startLabelDim = dimension2D;
            }
            if (i2 != n3 - 1) continue;
            this.endLabelDim = dimension2D;
        }
        return d2;
    }

    private List getAxisLabelDimList(int n2) {
        BigDecimal bigDecimal = this.calculateIncrementValue();
        if (bigDecimal.doubleValue() <= 0.0) {
            return null;
        }
        ArrayList<Dimension2D> arrayList = new ArrayList<Dimension2D>();
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.minValue));
        BigDecimal bigDecimal3 = bigDecimal;
        double d2 = 1.0;
        String string = this.getShowUnit();
        if (StringUtils.isNotEmpty(string)) {
            d2 = AxisHelper.getDivideUnit(string);
        }
        if (this.isLog() && this.minValue == 0.0) {
            this.minValue = 1.0;
        }
        bigDecimal = this.checkIncrementNotTooSmall(bigDecimal, this.maxValue - this.minValue);
        double d3 = this.minValue;
        while (d3 <= this.maxValue) {
            BigDecimal bigDecimal4 = bigDecimal2.multiply(new BigDecimal(Double.toString(1.0 / d2)));
            Dimension2D dimension2D = this.getAxisLabelDim(this.value2String(bigDecimal4.doubleValue()), n2);
            arrayList.add(dimension2D);
            bigDecimal2 = this.isLog() ? bigDecimal2.multiply(bigDecimal3) : bigDecimal2.add(bigDecimal3);
            d3 = this.isLog() ? d3 * bigDecimal.doubleValue() : d3 + bigDecimal.doubleValue();
        }
        return arrayList;
    }

    private BigDecimal checkIncrementNotTooSmall(BigDecimal bigDecimal, double d2) {
        BigDecimal bigDecimal2;
        if (!this.isLog() && (bigDecimal2 = bigDecimal.multiply(new BigDecimal(1000))).doubleValue() < d2) {
            return new BigDecimal(this.getTickSamplingTime());
        }
        return bigDecimal;
    }

    private double getMaxLabelWidth(int n2) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d2 = 8.0;
        List list = this.getAxisLabelDimList(n2);
        if (list == null || list.isEmpty()) {
            return d2;
        }
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Dimension2D dimension2D = (Dimension2D)list.get(i2);
            double d3 = this.shouldBeHeight() ? dimension2D.getWidth() : dimension2D.getHeight();
            d2 = d3 < d2 ? d2 : d3;
        }
        return d2;
    }

    private BigDecimal calculateIncrementValue() {
        if (this.isCustomMainUnit()) {
            return this.getBigDecimalMainUnit();
        }
        if (this.isLog()) {
            return new BigDecimal(Double.toString(this.getBaseLog()));
        }
        return AxisHelper.calculateIncrement(this.minValue, this.maxValue);
    }

    protected void dealAlertLabelWidth(int n2) {
        this.maxLeftAlert = 0.0;
        this.maxRightAlert = 0.0;
        for (int i2 = 0; i2 < this.getAlertValues().length; ++i2) {
            double d2;
            Object object;
            ChartAlertValueGlyph chartAlertValueGlyph = this.getAlertValues()[i2];
            TextAttr textAttr = new TextAttr();
            textAttr.setFRFont(chartAlertValueGlyph.getAlertFont());
            String string = chartAlertValueGlyph.getAlertContent();
            Object object2 = chartAlertValueGlyph.getAlertValueFormula().getResult();
            if (object2 == null) {
                object2 = "(" + this.value2String(this.getModelAlertValue(chartAlertValueGlyph, i2)) + ")";
            } else if (object2 instanceof FArray) {
                object = this.calWithFArray((FArray)object2);
                if (StringUtils.isNotEmpty((String)object)) {
                    object2 = object;
                }
            } else {
                object = object2.toString();
                if (Utils.string2Number((String)object) != null) {
                    d2 = Utils.string2Number((String)object).doubleValue();
                    object2 = "(" + this.value2String(d2) + ")";
                }
            }
            string = string + object2;
            if (this.isNeedAutoWrap()) {
                string = ChartBaseUtils.dealLabelStringAutoWrap(string, textAttr, n2, this.plotZeroBounds.getWidth() * 0.12);
            }
            object = GlyphUtils.calculateTextDimensionWithNoRotation(string, textAttr, n2);
            double d3 = d2 = this.getPosition() == 2 || this.getPosition() == 4 ? ((Dimension2D)object).getWidth() : ((Dimension2D)object).getHeight();
            if (chartAlertValueGlyph.getAlertPosition() == 2) {
                this.maxLeftAlert = Math.max(d2, this.maxLeftAlert);
                continue;
            }
            this.maxRightAlert = Math.max(d2, this.maxRightAlert);
        }
    }

    public boolean isNeedAutoWrap() {
        return (this.getPosition() == 2 || this.getPosition() == 4) && this.plotZeroBounds != null;
    }

    protected double getCateLabelWidth(Rectangle2D rectangle2D, int n2) {
        if (this.getCubic() == null) {
            return super.getCateLabelWidth(rectangle2D, n2);
        }
        double d2 = this.getMaxLabelWidthAndInitStartEndLabelDim(n2);
        d2 += 16.0;
        d2 = Math.max(30.0, d2);
        if (this.shouldBeHeight()) {
            return Math.min(rectangle2D.getHeight() * 0.28, d2);
        }
        return Math.min(rectangle2D.getWidth() * 0.28, d2);
    }

    private String calWithFArray(FArray fArray) {
        for (int i2 = 0; i2 < fArray.length(); ++i2) {
            Number number = Utils.string2Number(fArray.elementAt(i2).toString());
            if (number == null) continue;
            double d2 = number.doubleValue();
            return "(" + this.value2String(d2) + ")";
        }
        return null;
    }

    public void calculateAxisLengthUnit() {
        if (this.isLog()) {
            this.unitLength = this.axisLength / (Math.log(this.maxValue) / Math.log(this.getMainUnit()) - Math.log(this.minValue) / Math.log(this.getMainUnit()));
        } else if (this.maxValue - this.minValue > 0.0) {
            this.unitLength = this.axisLength / (this.maxValue - this.minValue);
        }
    }

    public double getCrossValue() {
        return this.minValue;
    }

    public double getCrossValueInPlot() {
        if (this.isLog()) {
            return 1.0;
        }
        return 0.0;
    }

    public double getArrowValue() {
        return this.maxValue;
    }

    public Point2D getPointInBounds(double d2) {
        if (!this.isLog() || !(this.getCrossValue() > 0.0)) {
            if (d2 < this.getCrossValue()) {
                d2 = this.getCrossValue();
            }
            if (d2 > this.getArrowValue()) {
                d2 = this.getArrowValue();
            }
        }
        return this.getPoint2D(d2);
    }

    public Point2D getPoint2D(double d2) {
        double d3;
        if (this.isLog() && this.getCrossValue() > 0.0) {
            if (d2 <= 1.0E-10) {
                d2 = this.getCrossValue();
            }
            d2 = (Math.log(d2) - Math.log(this.getCrossValue())) / Math.log(this.getMainUnit());
        } else {
            d2 -= this.getCrossValue();
        }
        double d4 = this.unitLength * d2;
        double d5 = this.hasAxisReversed() ? d4 : -d4;
        double d6 = d3 = this.hasAxisReversed() ? -d4 : d4;
        if (this.getPosition() == 2 || this.getPosition() == 4) {
            return new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + d5);
        }
        return new Point2D.Double(this.originPoint.getX() + d3, this.originPoint.getY());
    }

    public int getTickSamplingTime() {
        int n2 = 1;
        double d2 = (this.getMaxValue() - this.getMinValue()) / this.mainUnit.doubleValue();
        if (this.isLog()) {
            double d3 = Math.abs(this.getMaxValue() - this.getMinValue());
            int n3 = 0;
            double d4 = 10.0;
            if (this.mainUnit.doubleValue() >= 0.0) {
                d4 = this.mainUnit.doubleValue();
            }
            while (Math.pow(d4, n3) < d3) {
                if (Math.pow(d4, n3 + 1) > d3) {
                    d2 = n3;
                    break;
                }
                ++n3;
            }
        }
        while (this.axisLength > 1.0 && this.axisLength / Math.ceil(d2 / (double)n2) < 1.0) {
            ++n2;
        }
        return n2;
    }

    public void draw4ThreeD(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D point2D = this.getCubic().getPoints()[4];
        if (this.position == 4) {
            point2D = this.getCubic().getPoints()[5];
            point2D.setLocation(point2D.getX() - this.getBounds().getWidth(), point2D.getY());
        }
        graphics2D.translate(point2D.getX(), point2D.getY());
        this.drawValueAxisBackground(graphics, n2);
        this.drawAxisGrid(graphics);
        this.drawTickLable(graphics, n2);
        this.drawAxisTitle(graphics2D, n2);
        graphics2D.translate(-point2D.getX(), -point2D.getY());
    }

    private void drawValueAxisBackground(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        Color color = new Color(145, 151, 156);
        Color color2 = new Color(198, 205, 210);
        Rectangle2D rectangle2D = this.getBounds();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.18f));
        if (this.position == 2 || this.position == 4) {
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
            GradientPaint gradientPaint = new GradientPaint(double_, color, double_2, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangle2D);
        } else if (this.position == 3) {
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
            Point2D.Double double_3 = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
            GradientPaint gradientPaint = new GradientPaint(double_, color, double_3, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangle2D);
        }
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public void drawAxisGrid(Graphics graphics) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null) {
            int n2 = this.getTickSamplingTime();
            this.drawMainGridLine(graphics2D, n2);
        }
    }

    protected void drawAfterPlot4AlertValues(Graphics2D graphics2D, int n2) {
        if (this.getAlertValues() != null) {
            this.dealWithAlertLinesLabel();
            for (int i2 = 0; i2 < this.getAlertValues().length; ++i2) {
                ChartAlertValueGlyph chartAlertValueGlyph = this.getAlertValues()[i2];
                chartAlertValueGlyph.dealWithAlertLine();
                chartAlertValueGlyph.draw(graphics2D, n2);
            }
        }
    }

    private void drawMainGridLine(Graphics2D graphics2D, int n2) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.getMainGridColor());
        graphics2D.setStroke(GraphHelper.getStroke(this.getMainGridStyle()));
        if (this.isLog()) {
            this.drawMainGridLineWithLog(graphics2D);
        } else {
            this.drawMainGridLineWithGeneral(graphics2D, n2);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    private void drawMainGridLineWithLog(Graphics2D graphics2D) {
        if (this.getMainUnit() > 1.0) {
            double d2 = this.getCrossValue();
            double d3 = Math.log(d2) / Math.log(this.getMainUnit());
            while (d2 <= this.maxValue) {
                Line2D[] line2DArray = this.getGridLine(d2);
                for (int i2 = 0; i2 < line2DArray.length; ++i2) {
                    graphics2D.draw(line2DArray[i2]);
                }
                d2 = Math.exp((d3 += 1.0) * Math.log(this.getMainUnit()));
            }
        }
    }

    private void drawMainGridLineWithGeneral(Graphics2D graphics2D, int n2) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(this.minValue));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.getMainUnit() * (double)n2));
        BigDecimal bigDecimal3 = new BigDecimal(Double.toString(this.maxValue));
        while (bigDecimal.compareTo(bigDecimal3) < 0) {
            Line2D[] line2DArray = this.getGridLine(bigDecimal.doubleValue());
            for (int i2 = 0; i2 < line2DArray.length; ++i2) {
                graphics2D.draw(line2DArray[i2]);
            }
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
    }

    private void drawAlertValueLines(Graphics2D graphics2D, int n2) {
        if (this.getAlertValues() != null) {
            for (int i2 = 0; i2 < this.getAlertValues().length; ++i2) {
                this.getAlertValues()[i2].draw(graphics2D, n2);
            }
        }
    }

    protected void drawAxisLine(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.minValue == this.maxValue) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        int n3 = this.getLineStyle();
        if (this.getLineColor() != null && n3 != 0) {
            graphics2D.setStroke(GraphHelper.getStroke(n3));
            graphics2D.setPaint(this.getLineColor());
            Line2D.Double double_ = new Line2D.Double(this.getPoint2D(this.minValue), this.getPoint2D(this.maxValue));
            graphics2D.draw(double_);
            this.drawArrow(graphics2D, this.getPoint2D(this.minValue), this.getPoint2D(this.maxValue));
        }
        this.drawTicks(graphics2D, n2);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    protected void drawTicks(Graphics graphics, int n2) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        int n3 = this.getTickSamplingTime();
        if (this.isLog()) {
            this.drawTicks4Log(graphics2D, basicStroke);
        } else if (this.maxValue > this.minValue && this.getMainUnit() > 0.0 && this.getSecUnit() > 0.0) {
            this.drawTicks4General(graphics2D, basicStroke, n3);
        }
        this.drawTickLable(graphics, n2);
    }

    private void drawTickLable(Graphics graphics, int n2) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d2 = 1.0;
        String string = this.getShowUnit();
        if (StringUtils.isNotEmpty(string) && this.isShowAxisLabel()) {
            d2 = AxisHelper.getDivideUnit(string);
            this.drawUnitGlyph(graphics2D, ChartConstants.getUnitKey2Value(string), n2);
        }
        int n3 = this.getLabelNumber() > 0 ? this.getLabelNumber() : this.getTickSamplingTime();
        BigDecimal bigDecimal = this.getBigDecimalMainUnit();
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(n3));
        if (this.isLog()) {
            this.drawLabel4Log(graphics, d2, bigDecimal, bigDecimal2, n2);
        } else if (this.maxValue > this.minValue && this.getMainUnit() > 0.0 && this.getSecUnit() > 0.0) {
            this.drawLabel4General(graphics, d2, bigDecimal, bigDecimal2, n2);
        }
    }

    private void drawTicks4Log(Graphics graphics, BasicStroke basicStroke) {
        double d2;
        if (this.getMainUnit() > 1.0) {
            d2 = this.getCrossValue();
            double d3 = Math.log(d2) / Math.log(this.getMainUnit());
            while (d2 <= this.maxValue) {
                Line2D line2D = this.getTickLine(d2, 5, this.getTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke);
                d2 = Math.exp((d3 += 1.0) * Math.log(this.getMainUnit()));
            }
        }
        if (this.getSecUnit() > 1.0) {
            d2 = this.getCrossValue();
            int n2 = 0;
            while (d2 <= this.maxValue) {
                Line2D line2D = this.getTickLine(d2, 3, this.getSecTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke);
                d2 += (double)n2;
                ++n2;
            }
        }
    }

    private void drawTicks4General(Graphics graphics, BasicStroke basicStroke, int n2) {
        Line2D line2D;
        double d2;
        double d3 = this.getMainUnit() * (double)n2;
        for (d2 = this.minValue + d3; d2 <= this.maxValue; d2 += d3) {
            line2D = this.getTickLine(d2, 5, this.getTickMarkType());
            this.drawTickLine(graphics, line2D, basicStroke);
        }
        if (n2 <= 1) {
            for (d2 = this.minValue + this.getSecUnit(); d2 <= this.maxValue; d2 += this.getSecUnit()) {
                line2D = this.getTickLine(d2, 3, this.getSecTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke);
            }
        }
    }

    private void drawUnitGlyph(Graphics2D graphics2D, String string, int n2) {
        TextGlyph textGlyph = new TextGlyph(string, new TextAttr());
        Dimension2D dimension2D = textGlyph.preferredDimension(n2);
        double d2 = this.getMaxLabelWidth(n2);
        TextAttr textAttr = this.getTextAttr();
        double d3 = textAttr.getFRFont().getSize();
        Rectangle2D.Double double_ = null;
        if (this.getPosition() == 1) {
            double_ = this.axisReversed ? new Rectangle2D.Double(-dimension2D.getWidth() - 3.0 - d2 / 2.0, dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(this.getBounds().getWidth() + d2 / 2.0 + 3.0, dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        } else if (this.getPosition() == 2) {
            double_ = this.axisReversed ? new Rectangle2D.Double(0.0, this.getBounds().getHeight() + 3.0 + d3 / 2.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(0.0, -dimension2D.getHeight() - 3.0 - d3 / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        } else if (this.getPosition() == 3) {
            double_ = this.axisReversed ? new Rectangle2D.Double(-dimension2D.getWidth() - 3.0 - d2 / 2.0, -dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(this.getBounds().getWidth() + d2 / 2.0 + 3.0, -dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        } else if (this.getPosition() == 4) {
            double_ = this.axisReversed ? new Rectangle2D.Double(d2 - dimension2D.getWidth(), this.getBounds().getHeight() + 3.0 + d3 / 2.0, dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(d2 - dimension2D.getWidth(), -dimension2D.getHeight() - 3.0 - d3 / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        }
        textGlyph.setBounds(double_);
        textGlyph.draw(graphics2D, n2);
    }

    private void drawLabel4Log(Graphics graphics, double d2, BigDecimal bigDecimal, BigDecimal bigDecimal2, int n2) {
        if (this.getMainUnit() > 1.0) {
            BigDecimal bigDecimal3 = new BigDecimal(Double.toString(this.getCrossValue()));
            BigDecimal bigDecimal4 = new BigDecimal(Math.pow(bigDecimal.doubleValue(), bigDecimal2.doubleValue()));
            double d3 = this.getCrossValue();
            while (d3 <= this.maxValue) {
                BigDecimal bigDecimal5 = bigDecimal3.multiply(new BigDecimal(Double.toString(1.0 / d2)));
                this.drawLabel(graphics, d3, 0.0, this.value2String(bigDecimal5.doubleValue()), n2);
                bigDecimal3 = bigDecimal4.multiply(bigDecimal3);
                d3 = bigDecimal3.doubleValue();
            }
        }
    }

    private void drawLabel4General(Graphics graphics, double d2, BigDecimal bigDecimal, BigDecimal bigDecimal2, int n2) {
        BigDecimal bigDecimal3 = new BigDecimal(Double.toString(this.minValue));
        GeneralPath generalPath = new GeneralPath();
        double d3 = this.minValue;
        while (d3 - this.maxValue < 1.0E-6) {
            BigDecimal bigDecimal4 = bigDecimal3.multiply(new BigDecimal(Double.toString(1.0 / d2)));
            String string = this.value2String(bigDecimal4.doubleValue());
            this.drawLabel(graphics, d3, 0.0, string, generalPath, n2);
            bigDecimal3 = bigDecimal3.add(bigDecimal.multiply(bigDecimal2));
            d3 = bigDecimal3.doubleValue();
        }
    }

    private void dealWithAlertLinesLabel() {
        Cloneable cloneable;
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.getAlertValues().length; ++i2) {
            cloneable = this.getAlertValues()[i2];
            Object object = cloneable.getAlertValueFormula().getResult();
            if (object == null) {
                this.addAlertValueInOrder(arrayList, this.getModelAlertValue((ChartAlertValueGlyph)cloneable, i2), (ChartAlertValueGlyph)cloneable);
                continue;
            }
            if (object instanceof FArray) {
                this.addMultipleAlertValueInOrder((FArray)object, arrayList, (ChartAlertValueGlyph)cloneable);
                continue;
            }
            this.addSingleAlertValueInOrder(Utils.string2Number(object.toString()), arrayList, (ChartAlertValueGlyph)cloneable);
        }
        GeneralPath generalPath = new GeneralPath();
        cloneable = new GeneralPath();
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            List list = (List)arrayList.get(i3);
            double d2 = Utils.string2Number(list.get(0).toString()).doubleValue();
            ChartAlertValueGlyph chartAlertValueGlyph = (ChartAlertValueGlyph)list.get(1);
            Cloneable cloneable2 = chartAlertValueGlyph.getAlertPosition() == 2 ? cloneable : generalPath;
            chartAlertValueGlyph.setIndexValue(d2);
            chartAlertValueGlyph.setAlertLabelPaths((GeneralPath)cloneable2);
        }
    }

    protected Rectangle2D getLabelBounds(double d2, double d3, String string, int n2) {
        if (this.getCubic() == null) {
            return super.getLabelBounds(d2, d3, string, n2);
        }
        if (this.plotLastBounds == null) {
            return null;
        }
        Rectangle2D.Double double_ = null;
        Point2D point2D = this.getPoint2D(d2 + d3);
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n2);
        int n3 = this.getPosition();
        double d4 = dimension2D.getHeight();
        double d5 = dimension2D.getWidth();
        if (n3 == 2 || n3 == 4) {
            double_ = new Rectangle2D.Double(point2D.getX() - this.getBounds().getWidth() / 2.0 - d5 / 2.0, point2D.getY() - d4 / 2.0, d5, d4);
        } else if (n3 == 3) {
            double_ = new Rectangle2D.Double(point2D.getX() - d5 / 2.0, point2D.getY() + this.bounds.getHeight() / 2.0 - d4 / 2.0, d5, d4);
        }
        return double_;
    }

    private void addMultipleAlertValueInOrder(FArray fArray, List list, ChartAlertValueGlyph chartAlertValueGlyph) {
        for (int i2 = 0; i2 < fArray.length(); ++i2) {
            double d2;
            Number number = Utils.string2Number(fArray.elementAt(i2).toString());
            if (number == null || !((d2 = number.doubleValue()) >= this.getMinValue()) || !(d2 <= this.getMaxValue())) continue;
            this.addAlertValueInOrder(list, d2, chartAlertValueGlyph);
        }
    }

    private void addSingleAlertValueInOrder(Number number, List list, ChartAlertValueGlyph chartAlertValueGlyph) {
        double d2;
        if (number != null && (d2 = number.doubleValue()) >= this.getMinValue() && d2 <= this.getMaxValue()) {
            this.addAlertValueInOrder(list, d2, chartAlertValueGlyph);
        }
    }

    private void addAlertValueInOrder(List list, double d2, ChartAlertValueGlyph chartAlertValueGlyph) {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        arrayList.add(new Double(d2));
        arrayList.add(chartAlertValueGlyph);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List list2 = (List)list.get(i2);
            double d3 = Utils.string2Number(list2.get(0).toString()).doubleValue();
            if (!(d3 > d2)) continue;
            list.add(i2, arrayList);
            return;
        }
        list.add(arrayList);
    }

    public double getModelAlertValue(ChartAlertValueGlyph chartAlertValueGlyph, int n2) {
        return (this.maxValue - this.minValue) * (double)(n2 + 1) / (double)(this.getAlertValues().length + 2);
    }

    public boolean equals(Object object) {
        return object instanceof ValueAxisGlyph && super.equals(object) && ((ValueAxisGlyph)object).alignZeroValue == this.alignZeroValue;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("alignZeroValue", this.alignZeroValue);
        return jSONObject;
    }

    public String getJSAxisType() {
        return "ValueAxisGlyph";
    }

    public String getAxisName() {
        return "ValueAxis";
    }
}

