/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Base64;
import com.fr.base.BaseUtils;
import com.fr.base.MapXMLHelper;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartEnumDefinitions;
import com.fr.chart.base.ColorSelect4Shape;
import com.fr.chart.base.MapSvgAttr;
import com.fr.chart.base.MapSvgXMLHelper;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.BubblePlotGlyph;
import com.fr.chart.chartglyph.CategoryAxisGlyph;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Bubble;
import com.fr.chart.chartglyph.DataPoint4Map;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.MapAttr;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MapShapeValue;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Device;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;

public class MapPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 1111932837975659038L;
    private static final double RADIUSSIZE = 5.0;
    private static final String DEFAULT_PATH = "./map";
    private String mapName = "";
    private MapChartData mapData;
    private boolean isSvgMap = true;
    private boolean isHeatMap = true;
    private int heatIndex = 0;
    private ChartEnumDefinitions.MapType mapType = ChartEnumDefinitions.MapType.Map_Normal;
    private BubblePlotGlyph bubblePlotGlyph;
    private PiePlotGlyph piePlotGlyph;
    private Bar2DPlotGlyph bar2DPlotGlyph;
    private double bubbleMax = -1.0;
    private double columnMax = -1.0;
    private HashMap pathMap = new HashMap();
    private MapHotAreaColor areaColors = new MapHotAreaColor();

    public void layoutAxisGlyph(int n2) {
    }

    public void layoutDataSeriesGlyph(int n2) {
        if (!this.shouldDrawMap()) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                Cloneable cloneable;
                Object object;
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (!ComparatorUtils.equals(dataPoint.getSeriesName(), this.mapName)) continue;
                if (dataPoint.isValueIsNull()) {
                    object = null;
                    dataPoint.setDrawImpl((Glyph)object);
                    cloneable = null;
                    dataPoint.setDataLabel((TextGlyph)cloneable);
                    continue;
                }
                if (this.isSvgMap) {
                    if (!this.isHeatMap) continue;
                    object = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName);
                    cloneable = new GeneralPath(((MapSvgAttr)object).getShapeValue(dataPoint.getCategoryOriginalName()));
                    ((Path2D.Float)cloneable).transform(affineTransform);
                    dataPoint.setDrawImpl(this.createDrawGlyph(dataPoint, (Shape)((Object)cloneable)));
                    this.recalculateTextGlyphBounds(dataPoint, (Shape)((Object)cloneable), n2);
                    continue;
                }
                object = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
                cloneable = ((MapAttr)object).getShapeValue(dataPoint.getCategoryOriginalName());
                if (cloneable == null) continue;
                Shape shape = this.createDataPointShape((MapShapeValue)cloneable, (MapAttr)object, affineTransform);
                dataPoint.setDrawImpl(this.createDrawGlyph(dataPoint, shape));
                this.recalculateTextGlyphBounds(dataPoint, shape, n2);
            }
        }
        if (this.isSvgMap) {
            this.layoutShapeForEachDataPoint();
        }
    }

    private void layoutShapeForEachDataPoint() {
        AffineTransform affineTransform = this.getTransform();
        MapSvgAttr mapSvgAttr = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName);
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            int n2 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i3);
                if (!ComparatorUtils.equals(dataPoint4Map.getSeriesName(), this.mapName) || dataPoint4Map.getCombineGlyph() == null) continue;
                GeneralPath generalPath = new GeneralPath(mapSvgAttr.getShapeValue(dataPoint4Map.getCategoryOriginalName()));
                generalPath.transform(affineTransform);
                Rectangle2D rectangle2D = generalPath.getBounds2D();
                Object t2 = dataPoint4Map.getCombineGlyph().getPlotGlyph();
                double d2 = ((PlotGlyph)t2).getCombinedSize();
                double d3 = rectangle2D.getCenterX() - d2 / 2.0;
                double d4 = rectangle2D.getCenterY() - d2 / 2.0;
                if (this.mapType == ChartEnumDefinitions.MapType.Map_Column) {
                    d4 = rectangle2D.getMaxY() - d2;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d2, d2);
                dataPoint4Map.getCombineGlyph().setBounds(double_);
            }
        }
    }

    public void calculateMapTitlePercentValue() {
        int n2;
        int n3;
        MapAreaValue mapAreaValue;
        DataPoint4Map dataPoint4Map;
        int n4;
        int n5;
        DataSeries dataSeries;
        int n6;
        double[] dArray = null;
        int n7 = this.getSeriesSize();
        for (n6 = 0; n6 < n7; ++n6) {
            dataSeries = this.getSeries(n6);
            n5 = dataSeries.getDataPointCount();
            for (n4 = 0; n4 < n5; ++n4) {
                dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(n4);
                if (dataPoint4Map.getAreaValue() == null) continue;
                mapAreaValue = dataPoint4Map.getAreaValue();
                n3 = 0;
                n2 = mapAreaValue.titleValueSize();
                while (n3 < n2) {
                    if (dArray == null) {
                        dArray = new double[mapAreaValue.titleValueSize()];
                    }
                    double d2 = mapAreaValue.getTitleValueByIndex(n3);
                    int n8 = n3++;
                    dArray[n8] = dArray[n8] + d2;
                }
            }
        }
        n7 = this.getSeriesSize();
        for (n6 = 0; n6 < n7; ++n6) {
            dataSeries = this.getSeries(n6);
            n5 = dataSeries.getDataPointCount();
            for (n4 = 0; n4 < n5; ++n4) {
                dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(n4);
                if (dataPoint4Map.getAreaValue() == null) continue;
                mapAreaValue = dataPoint4Map.getAreaValue();
                n2 = mapAreaValue.titleValueSize();
                for (n3 = 0; n3 < n2; ++n3) {
                    MapTitleValue mapTitleValue = mapAreaValue.getTitleValue(n3);
                    mapTitleValue.setPercentValue(mapTitleValue.getValue() / dArray[n3]);
                }
            }
        }
    }

    public void calculateGlyphFromAreaValue() {
        if (this.isSvgMap) {
            for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
                DataSeries dataSeries = this.getSeries(i2);
                int n2 = dataSeries.getDataPointCount();
                for (int i3 = 0; i3 < n2; ++i3) {
                    DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i3);
                    if (dataPoint4Map.getAreaValue() == null) continue;
                    ChartGlyph chartGlyph = this.getChartGlyph4DataPoint(dataPoint4Map);
                    dataPoint4Map.setCombineGlyph(chartGlyph);
                }
            }
            if (this.mapType == ChartEnumDefinitions.MapType.Map_Bubble) {
                this.calculateBubblePercentValue();
            }
        }
    }

    private void calculateBubblePercentValue() {
        int n2;
        int n3;
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            n3 = dataSeries.getDataPointCount();
            for (n2 = 0; n2 < n3; ++n2) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(n2);
                ChartGlyph chartGlyph = dataPoint4Map.getCombineGlyph();
                if (chartGlyph == null || chartGlyph.getPlotGlyph() == null) continue;
                arrayList.add(((PlotGlyph)chartGlyph.getPlotGlyph()).getFirstDataPoint());
            }
        }
        double d2 = 0.0;
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            d2 += ((DataPoint)arrayList.get(n2)).getValue();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            ((DataPoint)arrayList.get(n2)).setPercentValue(((DataPoint)arrayList.get(n2)).getValue() / d2);
        }
    }

    private ChartGlyph getChartGlyph4DataPoint(DataPoint4Map dataPoint4Map) {
        PlotGlyph plotGlyph = null;
        double d2 = 50.0;
        switch (this.mapType) {
            case Map_Bubble: {
                plotGlyph = this.getPlotGlyph4Bubble(dataPoint4Map);
                d2 = this.bubblePlotGlyph.getCombinedSize();
                break;
            }
            case Map_Pie: {
                plotGlyph = this.getPlotGlyph4Pie(dataPoint4Map);
                d2 = this.piePlotGlyph.getCombinedSize();
                break;
            }
            case Map_Column: {
                plotGlyph = this.getPlotGlyph4Column(dataPoint4Map);
                d2 = this.bar2DPlotGlyph.getCombinedSize();
            }
        }
        if (plotGlyph != null) {
            plotGlyph.setCombinedSize(d2);
            plotGlyph.calculateDataPointPercentValue();
            plotGlyph.setHotTooltipStyle(this.getHotTooltipStyle());
            plotGlyph.setHotHyperLink(this.getHotHyperLink());
            ChartGlyph chartGlyph = new ChartGlyph();
            chartGlyph.setPlotGlyph(plotGlyph);
            return chartGlyph;
        }
        return null;
    }

    private PlotGlyph getPlotGlyph4Bubble(DataPoint4Map dataPoint4Map) {
        int n2;
        MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
        int n3 = mapAreaValue.titleValueSize();
        if (this.notEnoughTitleVale(n3)) {
            return null;
        }
        if (this.isHeatMap) {
            for (n2 = 0; n2 == this.heatIndex; ++n2) {
            }
        }
        double d2 = this.getMaxValueForIndex(n2);
        BubblePlotGlyph bubblePlotGlyph = new BubblePlotGlyph();
        bubblePlotGlyph.setCustomizedMaxValue(d2);
        double d3 = mapAreaValue.getTitleValueByIndex(n2);
        ValueAxisGlyph valueAxisGlyph = new ValueAxisGlyph();
        this.setEmptyAxisAttrs(valueAxisGlyph, 3, "xAxis");
        valueAxisGlyph.setMinMaxValue(0.0, d3 * 2.0);
        ValueAxisGlyph valueAxisGlyph2 = new ValueAxisGlyph();
        this.setEmptyAxisAttrs(valueAxisGlyph2, 2, "yAxis");
        valueAxisGlyph2.setMinMaxValue(0.0, d3 * 2.0);
        bubblePlotGlyph.setxAxisGlyph(valueAxisGlyph);
        bubblePlotGlyph.setyAxisGlyph(valueAxisGlyph2);
        DataPoint4Bubble dataPoint4Bubble = new DataPoint4Bubble();
        dataPoint4Bubble.setX(mapAreaValue.getTitleValueByIndex(n2));
        dataPoint4Bubble.setValue(d3);
        dataPoint4Bubble.setSizeValue(mapAreaValue.getTitleValueByIndex(n2));
        this.addSingleSeries(mapAreaValue, 0, n2, bubblePlotGlyph, dataPoint4Map, dataPoint4Bubble);
        bubblePlotGlyph.setPlotFillStyle(this.bubblePlotGlyph.getPlotFillStyle());
        bubblePlotGlyph.setShowNegativeBubble(this.bubblePlotGlyph.isShowNegativeBubble());
        bubblePlotGlyph.setSeriesEqualsBubbleType(this.bubblePlotGlyph.getSeriesEqualsBubbleInWidthOrArea());
        bubblePlotGlyph.setMaxBubblePixel(this.bubblePlotGlyph.getMaxBubblePixel());
        return bubblePlotGlyph;
    }

    private PlotGlyph getPlotGlyph4Pie(DataPoint4Map dataPoint4Map) {
        MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
        int n2 = mapAreaValue.titleValueSize();
        if (this.notEnoughTitleVale(n2)) {
            return null;
        }
        PiePlotGlyph piePlotGlyph = new PiePlotGlyph();
        int n3 = 0;
        int n4 = mapAreaValue.titleValueSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.isHeatMap && i2 == this.heatIndex) continue;
            DataPoint4Pie dataPoint4Pie = new DataPoint4Pie();
            this.addSingleSeries(mapAreaValue, n3, i2, piePlotGlyph, dataPoint4Map, dataPoint4Pie);
            ++n3;
        }
        piePlotGlyph.setPlotFillStyle(this.piePlotGlyph.getPlotFillStyle());
        piePlotGlyph.setPlotStyle(this.piePlotGlyph.getPlotStyle());
        if (piePlotGlyph.getConditionCollection() != null) {
            ConditionAttr conditionAttr = piePlotGlyph.getConditionCollection().getDefaultAttr();
            conditionAttr.addDataSeriesCondition(new AttrAlpha(0.8f));
        }
        return piePlotGlyph;
    }

    private PlotGlyph getPlotGlyph4Column(DataPoint4Map dataPoint4Map) {
        MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
        int n2 = mapAreaValue.titleValueSize();
        if (this.notEnoughTitleVale(n2)) {
            return null;
        }
        Bar2DPlotGlyph bar2DPlotGlyph = this.getSimplePlotGlyph();
        int n3 = 0;
        int n4 = mapAreaValue.titleValueSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.isHeatMap && i2 == this.heatIndex) continue;
            DataPoint dataPoint = new DataPoint();
            this.addSingleSeries(mapAreaValue, n3, i2, bar2DPlotGlyph, dataPoint4Map, dataPoint);
            ++n3;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(dataPoint4Map.getCategoryOriginalName());
        ((CategoryAxisGlyph)bar2DPlotGlyph.getxAxisGlyph()).setCategoryLabelList(arrayList);
        bar2DPlotGlyph.getxAxisGlyph().setMinMaxValue(0.0, arrayList.size());
        bar2DPlotGlyph.setPlotFillStyle(this.bar2DPlotGlyph.getPlotFillStyle());
        bar2DPlotGlyph.setPlotStyle(this.bar2DPlotGlyph.getPlotStyle());
        if (bar2DPlotGlyph.getConditionCollection() != null) {
            ConditionAttr conditionAttr = bar2DPlotGlyph.getConditionCollection().getDefaultAttr();
            conditionAttr.addDataSeriesCondition(new AttrAlpha(0.8f));
        }
        return bar2DPlotGlyph;
    }

    private boolean notEnoughTitleVale(int n2) {
        return n2 <= 0 || this.isHeatMap && n2 <= 1;
    }

    private void addSingleSeries(MapAreaValue mapAreaValue, int n2, int n3, PlotGlyph plotGlyph, DataPoint4Map dataPoint4Map, DataPoint dataPoint) {
        MapTitleValue mapTitleValue = mapAreaValue.getTitleValue(n3);
        DataSeries<DataPoint> dataSeries = new DataSeries<DataPoint>(n2);
        dataPoint.setSeriesIndex(n2);
        dataPoint.setCategoryIndex(0);
        dataPoint.setCategoryName(dataPoint4Map.getCategoryOriginalName());
        dataPoint.setCategoryOriginalName(dataPoint4Map.getCategoryOriginalName());
        dataPoint.setSeriesName(mapTitleValue.getTitle());
        dataPoint.setValue(mapTitleValue.getValue());
        dataSeries.addDataPoint(dataPoint);
        plotGlyph.addSeries(dataSeries);
    }

    private double getMaxValueForIndex(int n2) {
        if (this.bubbleMax > 0.0) {
            return this.bubbleMax;
        }
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i3);
                if (!ComparatorUtils.equals(dataPoint4Map.getSeriesName(), this.mapName) || dataPoint4Map.getAreaValue() == null) continue;
                double d2 = dataPoint4Map.getAreaValue().getTitleValueByIndex(n2);
                this.bubbleMax = Math.max(this.bubbleMax, d2);
            }
        }
        return this.bubbleMax;
    }

    private double getMaxValueOfAll() {
        if (this.columnMax > 0.0) {
            return this.columnMax;
        }
        int n2 = this.isHeatMap ? this.heatIndex : -1;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i3);
                if (!ComparatorUtils.equals(dataPoint4Map.getSeriesName(), this.mapName) || dataPoint4Map.getAreaValue() == null) continue;
                MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
                int n4 = mapAreaValue.titleValueSize();
                for (int i4 = 0; i4 < n4; ++i4) {
                    if (i4 == n2) continue;
                    this.columnMax = Math.max(this.columnMax, mapAreaValue.getTitleValueByIndex(i4));
                }
            }
        }
        return this.columnMax;
    }

    private Bar2DPlotGlyph getSimplePlotGlyph() {
        double d2 = this.getMaxValueOfAll();
        ValueAxisGlyph valueAxisGlyph = new ValueAxisGlyph();
        this.setEmptyAxisAttrs(valueAxisGlyph, 2, "xAxis");
        valueAxisGlyph.setMinMaxValue(0.0, d2);
        CategoryAxisGlyph categoryAxisGlyph = new CategoryAxisGlyph();
        this.setEmptyAxisAttrs(categoryAxisGlyph, 3, "yAxis");
        Bar2DPlotGlyph bar2DPlotGlyph = new Bar2DPlotGlyph();
        bar2DPlotGlyph.setxAxisGlyph(categoryAxisGlyph);
        bar2DPlotGlyph.setyAxisGlyph(valueAxisGlyph);
        return bar2DPlotGlyph;
    }

    private void setEmptyAxisAttrs(AxisGlyph axisGlyph, int n2, String string) {
        axisGlyph.setAxisType(string);
        axisGlyph.setPosition(n2);
        axisGlyph.setShowAxisLabel(false);
        axisGlyph.setLineStyle(0);
        axisGlyph.setTickMarkType(0);
        axisGlyph.setSecTickMarkType(0);
        axisGlyph.setCustomMinValue(true);
        axisGlyph.setCustomMaxValue(true);
        axisGlyph.setCustomMainUnit(true);
        axisGlyph.setCustomSecUnit(true);
        axisGlyph.setMainUnit(new BigDecimal("1"));
        axisGlyph.setSecUnit(0.2);
    }

    private boolean shouldDrawMap() {
        MapAttr mapAttr;
        MapSvgAttr mapSvgAttr;
        return !(this.isSvgMap ? (mapSvgAttr = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName)) == null || mapSvgAttr.getMapImage() == null : (mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName)) == null || mapAttr.getMapImage() == null);
    }

    private Shape createDataPointShape(MapShapeValue mapShapeValue, MapAttr mapAttr, AffineTransform affineTransform) {
        Image image = mapAttr.getMapImage();
        Point[] pointArray = mapShapeValue.getShape();
        int n2 = mapShapeValue.getMarkType();
        GeneralPath generalPath = new GeneralPath();
        ColorSelect4Shape colorSelect4Shape = new ColorSelect4Shape();
        colorSelect4Shape.makesureImage(image);
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            Point point = pointArray[i2];
            if (n2 == 0) {
                generalPath.moveTo((float)point.getX(), (float)point.getY());
                double d2 = 5.0;
                double d3 = point.getX() - d2;
                double d4 = point.getY() - d2;
                generalPath.append(new Arc2D.Double(d3, d4, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 0), false);
                continue;
            }
            colorSelect4Shape.makesureClickPoint(point.getX(), point.getY());
            GeneralPath generalPath2 = colorSelect4Shape.getSelectedPath();
            generalPath.append(generalPath2, false);
        }
        return generalPath.createTransformedShape(affineTransform);
    }

    private Image getMapImage() {
        if (this.isSvgMap) {
            MapSvgAttr mapSvgAttr = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName);
            if (mapSvgAttr != null) {
                return mapSvgAttr.getMapImage();
            }
        } else {
            MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
            if (mapAttr != null) {
                return mapAttr.getMapImage();
            }
        }
        return null;
    }

    private AffineTransform getTransform() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Image image = this.getMapImage();
        if (image == null) {
            return new AffineTransform();
        }
        double_.setFrame(0.0, 0.0, image.getWidth(new JPanel()), image.getHeight(new JPanel()));
        Rectangle2D.Double double_2 = double_;
        Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
        double d2 = ((RectangularShape)double_3).getWidth() / ((RectangularShape)double_2).getWidth();
        double d3 = ((RectangularShape)double_3).getHeight() / ((RectangularShape)double_2).getHeight();
        d2 = d3 = Math.min(d2, d3);
        double d4 = ((RectangularShape)double_3).getX() - d2 * ((RectangularShape)double_2).getX();
        double d5 = ((RectangularShape)double_3).getY() - d3 * ((RectangularShape)double_2).getY();
        if (d2 * ((RectangularShape)double_2).getWidth() < ((RectangularShape)double_3).getWidth()) {
            d4 += (((RectangularShape)double_3).getWidth() - d2 * ((RectangularShape)double_2).getWidth()) / 2.0;
        }
        if (d3 * ((RectangularShape)double_2).getHeight() < ((RectangularShape)double_3).getHeight()) {
            d5 += (((RectangularShape)double_3).getHeight() - d3 * ((RectangularShape)double_2).getHeight()) / 2.0;
        }
        return new AffineTransform(d2, 0.0, 0.0, d3, d4, d5);
    }

    public void setAreaColors(MapHotAreaColor mapHotAreaColor) {
        this.areaColors = mapHotAreaColor;
    }

    public MapHotAreaColor getAreaColors() {
        return this.areaColors;
    }

    private Glyph createDrawGlyph(DataPoint dataPoint, Shape shape) {
        ShapeGlyph shapeGlyph = new ShapeGlyph();
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            shape = new Arc2D.Double(rectangle2D.getX() - 2.0, rectangle2D.getY() - 2.0, 4.0, 4.0, 0.0, 360.0, 0);
        }
        shapeGlyph.setShape(shape);
        AttrBackground attrBackground = this.getConditionCollection().getAttrByResult(dataPoint).getExisted(AttrBackground.class);
        if (attrBackground != null) {
            shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
        } else if (this.areaColors != null) {
            Color color = this.areaColors.getColorWithValue(dataPoint.getValue());
            if (!dataPoint.isValueIsNull()) {
                shapeGlyph.setBackground(ColorBackground.getInstance(color));
            }
        }
        return shapeGlyph;
    }

    private void recalculateTextGlyphBounds(DataPoint dataPoint, Shape shape, int n2) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph != null) {
            Dimension2D dimension2D = textGlyph.preferredDimension(n2);
            Rectangle2D rectangle2D = shape.getBounds2D();
            double d2 = dimension2D.getWidth();
            double d3 = dimension2D.getHeight();
            double d4 = rectangle2D.getCenterX() - d2 / 2.0;
            double d5 = rectangle2D.getCenterY() - d3 / 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4 + 2.0, d5 + 2.0, d2 - 2.0, d3 - 3.0);
            textGlyph.setBounds(double_);
        }
    }

    public String getPlotGlyphType() {
        return "MapPlotGlyph";
    }

    public void setMapName(String string) {
        this.mapName = string;
    }

    public void setSvgMap(boolean bl) {
        this.isSvgMap = bl;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapData(MapChartData mapChartData) {
        this.mapData = mapChartData;
    }

    public void setPathMap(HashMap hashMap) {
        this.pathMap = hashMap;
    }

    public void setHeatMap(boolean bl) {
        this.isHeatMap = bl;
    }

    public boolean isHeatMap() {
        return this.isHeatMap;
    }

    public boolean isSvgMap() {
        return this.isSvgMap;
    }

    public void setHeatIndex(int n2) {
        this.heatIndex = n2;
    }

    public void setMapType(ChartEnumDefinitions.MapType mapType) {
        this.mapType = mapType;
    }

    public ChartEnumDefinitions.MapType getMapType() {
        return this.mapType;
    }

    public void setBubblePlotGlyph(BubblePlotGlyph bubblePlotGlyph) {
        this.bubblePlotGlyph = bubblePlotGlyph;
    }

    public void setPiePlotGlyph(PiePlotGlyph piePlotGlyph) {
        this.piePlotGlyph = piePlotGlyph;
    }

    public void setBar2DPlotGlyph(Bar2DPlotGlyph bar2DPlotGlyph) {
        this.bar2DPlotGlyph = bar2DPlotGlyph;
    }

    public void draw(Graphics graphics, int n2) {
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawBackgroundWithShapes(graphics2D);
        int n4 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            this.getSeries(n3).draw(graphics, n2);
        }
        if (this.mapType != ChartEnumDefinitions.MapType.Map_Column) {
            n4 = this.getSeriesSize();
            for (n3 = 0; n3 < n4; ++n3) {
                DataSeries dataSeries = this.getSeries(n3);
                int n5 = dataSeries.getDataPointCount();
                for (int i2 = 0; i2 < n5; ++i2) {
                    DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i2);
                    dataPoint4Map.drawCombine(graphics, n2);
                }
            }
        }
        n4 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            this.getSeries(n3).drawLabel(graphics, n2);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawBackgroundWithShapes(Graphics2D graphics2D) {
        Image image = this.getMapImage();
        if (image != null) {
            Rectangle2D rectangle2D = this.getBounds();
            int n2 = (int)rectangle2D.getWidth();
            int n3 = (int)rectangle2D.getHeight();
            if (n2 <= 0 || n3 <= 0) {
                return;
            }
            int n4 = image.getWidth(null);
            int n5 = image.getHeight(null);
            for (int i2 = 0; i2 < n2; i2 += n2) {
                for (int i3 = 0 % n3; i3 < n3; i3 += n3) {
                    double d2 = (double)n2 / (double)n4;
                    double d3 = (double)n3 / (double)n5;
                    int n6 = n2;
                    int n7 = n3;
                    if (d2 > d3) {
                        n6 = (int)((double)n2 * d3 / d2);
                        i2 = (n2 - n6) / 2;
                    } else {
                        n7 = (int)((double)n3 * d2 / d3);
                        i3 = (n3 - n7) / 2 + i3;
                    }
                    graphics2D.drawImage(image, i2, i3, n6, n7, null);
                }
            }
        }
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("isSvgMap", this.isSvgMap);
        jSONObject.put("mapAreaColor", this.getAreaColors().toJSONObject());
        jSONObject.put("mapName", this.mapName);
        if (!this.isSvgMap) {
            this.bitMapToJson(jSONObject, repository);
        }
        jSONObject.put("isHeatMap", this.isHeatMap);
        jSONObject.put("heatIndex", this.heatIndex);
        jSONObject.put("mapType", this.mapType.ordinal());
        return jSONObject;
    }

    private void bitMapToJson(JSONObject jSONObject, Repository repository) throws JSONException {
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        if (mapAttr != null) {
            jSONObject.put("versionid", mapAttr.getVersionID());
        }
        if (!repository.getDevice().isMobile()) {
            this.putMapReturnButtonToJS(jSONObject, repository);
            this.pathMap.clear();
            HashMap<String, Dimension> hashMap = new HashMap<String, Dimension>();
            HashMap<String, Image> hashMap2 = new HashMap<String, Image>();
            ColorSelect4Shape colorSelect4Shape = new ColorSelect4Shape();
            if (mapAttr != null) {
                Image image = mapAttr.getMapImage();
                int n2 = image.getWidth(new JPanel());
                int n3 = image.getHeight(new JPanel());
                if (!colorSelect4Shape.hasLoadedImage(image)) {
                    colorSelect4Shape.makesureImage(image);
                }
                hashMap2.put(this.mapName, image);
                hashMap.put(this.mapName, new Dimension(n2, n3));
                Iterator iterator = mapAttr.shapeValuesIterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    MapShapeValue mapShapeValue = mapAttr.getShapeValue(string);
                    GeneralPath generalPath = this.createPathWithPoints(mapShapeValue, colorSelect4Shape);
                    this.pathMap.put(string, generalPath);
                }
            }
            if (!this.pathMap.isEmpty()) {
                jSONObject.put("pathMap", MapPlotGlyph.pathMap2JSONArray(mapAttr, this.pathMap));
            }
            this.putImageBounds4JS(hashMap, hashMap2, jSONObject, repository);
        }
    }

    private void putImageBounds4JS(HashMap hashMap, HashMap hashMap2, JSONObject jSONObject, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object k2 : hashMap.keySet()) {
            Dimension dimension = (Dimension)hashMap.get(k2);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("mapName", k2);
            jSONObject2.put("mapWidth", dimension.getWidth());
            jSONObject2.put("mapHeight", dimension.getHeight());
            Image image = (Image)hashMap2.get(k2);
            if (repository.getDevice().isMobile()) {
                jSONObject2.put("img", Base64.encode(image, "png"));
            } else if (repository.getBrowser().isIE()) {
                jSONObject2.put("onie", ChartBaseUtils.addImageAsEmb(image));
            } else {
                jSONObject2.put("onsrc", "data:image/png;base64," + Base64.encode(image, "png"));
            }
            jSONArray.put(jSONObject2);
        }
        jSONObject.put("imageBounds", jSONArray);
    }

    private void putMapReturnButtonToJS(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.getSeriesSize() > 1) {
            BufferedImage bufferedImage = BaseUtils.readImage("com/fr/chart/base/mapNormal.png");
            if (repository.getDevice().isMobile()) {
                jSONObject.put("bimg", Base64.encode(bufferedImage, "png"));
            } else if (repository.getBrowser().isIE()) {
                jSONObject.put("normalIEsrc", ChartBaseUtils.addImageAsEmb(bufferedImage));
            } else {
                jSONObject.put("normalsrc", "data:image/png;base64," + Base64.encode(bufferedImage, "png"));
            }
        }
    }

    private GeneralPath createPathWithPoints(MapShapeValue mapShapeValue, ColorSelect4Shape colorSelect4Shape) {
        Point[] pointArray = mapShapeValue.getShape();
        GeneralPath generalPath = new GeneralPath();
        if (mapShapeValue.getMarkType() == 0) {
            for (int i2 = 0; i2 < pointArray.length; ++i2) {
                generalPath.moveTo((float)pointArray[i2].getX(), (float)pointArray[i2].getY());
                double d2 = 5.0;
                double d3 = pointArray[i2].getX() - d2;
                double d4 = pointArray[i2].getY() - d2;
                generalPath.append(new Arc2D.Double(d3, d4, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 0), false);
            }
        } else {
            for (int i3 = 0; i3 < pointArray.length; ++i3) {
                colorSelect4Shape.makesureClickPoint(pointArray[i3].getX(), pointArray[i3].getY());
                GeneralPath generalPath2 = colorSelect4Shape.getSelectedPath();
                generalPath.append(generalPath2, false);
            }
        }
        return generalPath;
    }

    public boolean equals(Object object) {
        return object instanceof MapPlotGlyph && super.equals(object);
    }

    public static void putPathMap2Json(Device device, MapAttr mapAttr, HashMap hashMap, JSONObject jSONObject) throws JSONException {
        if (device.isAndroid()) {
            jSONObject.put("pathMap", MapPlotGlyph.pathMap2JSONArray(mapAttr, hashMap));
        } else {
            jSONObject.put("pathMap", MapPlotGlyph.pathMap2JSONArray(mapAttr, hashMap));
        }
    }

    public static void putPathMap2Json(Device device, MapSvgAttr mapSvgAttr, HashMap hashMap, JSONObject jSONObject) throws JSONException {
        jSONObject.put("pathMap", MapPlotGlyph.pathMap2JSONArray(mapSvgAttr, hashMap));
    }

    private static String pathMap2String4Android(MapAttr mapAttr, HashMap hashMap) throws JSONException {
        String string = "";
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = Utils.objectToString(iterator.next());
            MapShapeValue mapShapeValue = mapAttr.getShapeValue(string2);
            GeneralPath generalPath = (GeneralPath)hashMap.get(string2);
            string = string + string2 + "_ms_";
            string = string + ChartBaseUtils.generalPath2Android(generalPath) + "_ms_";
            string = string + mapShapeValue.getMarkType() + "_op_";
        }
        return string;
    }

    private static JSONArray pathMap2JSONArray(MapAttr mapAttr, HashMap hashMap) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = Utils.objectToString(iterator.next());
            MapShapeValue mapShapeValue = mapAttr.getShapeValue(string);
            GeneralPath generalPath = (GeneralPath)hashMap.get(string);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("key", string);
            jSONObject.put("path", ChartBaseUtils.generalPath2JS(generalPath));
            jSONObject.put("markType", mapShapeValue.getMarkType());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private static JSONArray pathMap2JSONArray(MapSvgAttr mapSvgAttr, HashMap hashMap) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = Utils.objectToString(iterator.next());
            GeneralPath generalPath = (GeneralPath)hashMap.get(string);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("key", string);
            jSONObject.put("path", ChartBaseUtils.generalPath2JS(generalPath));
            jSONObject.put("markType", 1);
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    public DataPoint4Map getCurrentMapDataPoint() {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            int n2 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (!ComparatorUtils.equals(dataPoint.getSeriesName(), this.mapName) || dataPoint.isValueIsNull()) continue;
                return (DataPoint4Map)dataPoint;
            }
        }
        return null;
    }

    public int getAdditionalCanvasCount() {
        int n2 = 0;
        n2 += this.mapType != ChartEnumDefinitions.MapType.Map_Normal ? 1 : 0;
        return n2 += this.isSvgMap && this.isHeatMap ? 1 : 0;
    }

    public String getChartType() {
        return "Map";
    }
}

