/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrCurveLine;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.base.OuterLight;
import com.fr.chart.base.Shadow;
import com.fr.chart.chartglyph.AreaHighLightChartStyle;
import com.fr.chart.chartglyph.AreaPlane3DStyle;
import com.fr.chart.chartglyph.AreaTopDownShadeStyle;
import com.fr.chart.chartglyph.AreaTransparentChartStyle;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSeries4Area;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;

public class AreaPlotGlyph
extends CategoryPlotGlyph {
    public static final String XML_TAG = "AreaPlotGlyph";
    private static final long serialVersionUID = -8812027062679027417L;
    private static final double MARKERRAD = 5.0;
    private boolean isCurve = false;

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public boolean isCurve(DataSeries dataSeries) {
        DataSeriesCondition dataSeriesCondition = this.conditionCollection.getDataSeriesCondition(AttrCurveLine.class, dataSeries);
        if (dataSeriesCondition != null) {
            return ((AttrCurveLine)dataSeriesCondition).isCurve();
        }
        return this.isCurve;
    }

    public void drawShape4Series(Graphics graphics, int n2) {
        int[] nArray = this.getDrawSequence();
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.getSeries(nArray[i2]).draw(graphics, n2);
        }
    }

    public void layoutDataSeriesGlyph(int n2) {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            this.dealAreaShape4PlotGlyph((DataSeries4Area)this.getSeries(i2), this, this.getxAxisGlyph(), this.getSeriesAxisGlyph(i2), n2);
        }
        this.dealLabelBoundsInOrder();
    }

    public void dealAreaShape4PlotGlyph(DataSeries4Area dataSeries4Area, CategoryPlotGlyph categoryPlotGlyph, AxisGlyph axisGlyph, AxisGlyph axisGlyph2, int n2) {
        if (dataSeries4Area == null) {
            return;
        }
        GeneralPath generalPath = new GeneralPath(1);
        LineStyleInfo lineStyleInfo = new LineStyleInfo();
        this.fillLineStyleInfo(dataSeries4Area, generalPath, lineStyleInfo);
        GeneralPath generalPath2 = new GeneralPath(1);
        GeneralPath generalPath3 = new GeneralPath(1);
        ShapeGlyph shapeGlyph = new ShapeGlyph(generalPath2);
        dataSeries4Area.setDrawImpl(shapeGlyph);
        shapeGlyph.dealCondition(this.getConditionCollection(), dataSeries4Area, this.createColors4Series());
        if (!this.isExistAttrByResult(dataSeries4Area, AttrAlpha.class)) {
            shapeGlyph.setAlpha(0.5f);
        }
        this.dealLineStyle(shapeGlyph, lineStyleInfo);
        this.dealPath4DataSeriese(dataSeries4Area, categoryPlotGlyph, axisGlyph, axisGlyph2, generalPath, generalPath3, generalPath2, n2);
        this.addChartStyle4DataSeries(this.plotStyle, dataSeries4Area, shapeGlyph, generalPath2);
    }

    private void addChartStyle4DataSeries(int n2, DataSeries4Area dataSeries4Area, ShapeGlyph shapeGlyph, GeneralPath generalPath) {
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ChartStyle chartStyle = null;
            boolean bl = this.getyAxisGlyph().hasAxisReversed();
            if (n2 == 1) {
                LineStyleInfo lineStyleInfo = new LineStyleInfo();
                lineStyleInfo.setAttrLineColor(new AttrColor(color));
                lineStyleInfo.setAttrLineStyle(new AttrLineStyle(0));
                dataSeries4Area.getTopFoldLine().setLineStyleInfo(lineStyleInfo);
                chartStyle = new AreaPlane3DStyle(color, true, generalPath, bl);
            } else if (n2 == 2) {
                LineStyleInfo lineStyleInfo = new LineStyleInfo();
                lineStyleInfo.setAttrLineColor(new AttrColor(color));
                lineStyleInfo.setAttrLineStyle(new AttrLineStyle(5));
                dataSeries4Area.getTopFoldLine().setLineStyleInfo(lineStyleInfo);
                chartStyle = new AreaHighLightChartStyle(color, true, generalPath, bl);
            } else if (n2 == 4) {
                LineStyleInfo lineStyleInfo = new LineStyleInfo();
                lineStyleInfo.setAttrLineColor(new AttrColor(color));
                lineStyleInfo.setAttrLineStyle(new AttrLineStyle(5));
                dataSeries4Area.getTopFoldLine().setLineStyleInfo(lineStyleInfo);
                chartStyle = new AreaTopDownShadeStyle(color, true, generalPath, bl);
            } else if (n2 == 5) {
                LineStyleInfo lineStyleInfo = new LineStyleInfo();
                lineStyleInfo.setAttrLineColor(new AttrColor(color));
                lineStyleInfo.setAttrLineStyle(new AttrLineStyle(5));
                dataSeries4Area.getTopFoldLine().setLineStyleInfo(lineStyleInfo);
                chartStyle = new AreaTransparentChartStyle(color, true, generalPath);
            }
            if (chartStyle != null) {
                dataSeries4Area.setDataSeriesStyle(chartStyle);
            }
        }
    }

    private void fillLineStyleInfo(DataSeries4Area dataSeries4Area, GeneralPath generalPath, LineStyleInfo lineStyleInfo) {
        FoldLine foldLine = new FoldLine(generalPath);
        dataSeries4Area.setTopFoldLine(foldLine);
        foldLine.setLineStyleInfo(lineStyleInfo);
        OuterLight outerLight = new OuterLight();
        outerLight.setOuterAlpha(0.4f);
        outerLight.setOutSize(10);
        outerLight.setOuterColor(Color.gray);
        lineStyleInfo.setOuterLight(outerLight);
        Shadow shadow = new Shadow();
        shadow.setShadowAlpha(0.2f);
        shadow.setShadowColor(Color.gray);
        shadow.setShadowSize(4);
        lineStyleInfo.setShadow(shadow);
    }

    private void dealLineStyle(ShapeGlyph shapeGlyph, LineStyleInfo lineStyleInfo) {
        Color color = Color.blue;
        Background background = shapeGlyph.getBackground();
        if (background instanceof ColorBackground) {
            color = ((ColorBackground)background).getColor();
        }
        lineStyleInfo.setAttrLineColor(new AttrColor(color));
        lineStyleInfo.setAttrLineStyle(new AttrLineStyle(5));
    }

    private void dealPath4DataSeriese(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, AxisGlyph axisGlyph, AxisGlyph axisGlyph2, GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, int n2) {
        boolean bl = this.isCurve(dataSeries);
        double[] dArray = new double[dataSeries.getDataPointCount()];
        double d2 = axisGlyph2.getCrossValueInPlot();
        float f2 = (float)axisGlyph2.getPoint2D(d2).getY();
        for (int i2 = 0; i2 < dataSeries.getDataPointCount(); ++i2) {
            DataPoint dataPoint = dataSeries.getDataPoint(i2);
            if (dataPoint.isValueIsNull()) continue;
            double d3 = categoryPlotGlyph.getDataPointPercentValue(dataSeries.getSeriesIndex(), i2);
            float f3 = (float)axisGlyph.getPoint2D(axisGlyph.getTickIndex4Value(i2)).getX();
            if (this.isDataPointXNotInPlotBounds(f3)) continue;
            double d4 = categoryPlotGlyph.getPreSum4Area(dataSeries.getSeriesIndex(), i2);
            float f4 = (float)(axisGlyph2.getBounds().getY() + (double)((float)axisGlyph2.getPoint2D(d4 + d3).getY()));
            dArray[i2] = axisGlyph2.getBounds().getY() + (double)((float)axisGlyph2.getPoint2D(d4).getY());
            this.movePathWithEveryDataPoint(generalPath2, generalPath, generalPath3, i2, f3, f4, bl);
            dataPoint.setShape(new Arc2D.Double(f3 - 3.0f, f4 - 3.0f, 6.0, 6.0, 0.0, 360.0, 2));
            this.initMarkerGlyph(dataPoint, f3, f4);
            this.dealDataPointLabel(dataPoint, n2);
        }
        this.completionCurve(generalPath2, generalPath, generalPath3, bl);
        this.areaAndCurvePathMove(dataSeries, generalPath2, generalPath3, axisGlyph, dArray, f2, bl);
    }

    private void initMarkerGlyph(DataPoint dataPoint, float f2, float f3) {
        this.checkComMarker();
        MarkerGlyph markerGlyph = new MarkerGlyph();
        markerGlyph.dealCondition4Line(this.getConditionCollection(), dataPoint, this.createColors4Series());
        markerGlyph.setShape(new Rectangle2D.Double((double)f2 - 5.0, (double)f3 - 5.0, 10.0, 10.0));
        markerGlyph.getMarker().setPlotBackground(this.getBackground() != null ? this.getBackground() : this.getWholeChartBackground());
        dataPoint.setDrawImpl(markerGlyph);
    }

    private void checkComMarker() {
        ConditionCollection conditionCollection = this.getConditionCollection();
        ConditionAttr conditionAttr = conditionCollection.getDefaultAttr();
        AttrMarkerType attrMarkerType = conditionAttr.getExisted(AttrMarkerType.class);
        if (attrMarkerType == null) {
            conditionAttr.addDataSeriesCondition(new AttrMarkerType("NullMarker"));
        }
    }

    private void movePathWithXAxisGlyph(DataSeries dataSeries, AxisGlyph axisGlyph, GeneralPath generalPath, GeneralPath generalPath2, int n2, float f2) {
        if (n2 == 0) {
            generalPath.moveTo((float)axisGlyph.getPoint2D(n2 - 1).getX(), f2);
        }
        if (n2 > 0) {
            generalPath.lineTo((float)axisGlyph.getPoint2D(n2 - 1).getX(), f2);
            generalPath2.lineTo((float)axisGlyph.getPoint2D(n2 - 1).getX(), f2);
        }
        generalPath.lineTo((float)axisGlyph.getPoint2D(n2).getX(), f2);
        generalPath2.lineTo((float)axisGlyph.getPoint2D(n2).getX(), f2);
        if (n2 < dataSeries.getDataPointCount() && dataSeries.getDataPointCount() > 1) {
            generalPath2.lineTo((float)axisGlyph.getPoint2D(n2 + 1).getX(), f2);
            generalPath.lineTo((float)axisGlyph.getPoint2D(n2 + 1).getX(), f2);
        }
    }

    private void movePathWithEveryDataPoint(GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, int n2, float f2, float f3, boolean bl) {
        if (bl) {
            if (n2 == 0 || generalPath.getCurrentPoint() == null) {
                generalPath.moveTo(f2, f3);
            } else {
                generalPath.lineTo(f2, f3);
            }
        } else {
            if (n2 == 0 || generalPath2.getCurrentPoint() == null) {
                generalPath2.moveTo(f2, f3);
            } else {
                generalPath2.lineTo(f2, f3);
            }
            if (n2 == 0 || generalPath3.getCurrentPoint() == null) {
                generalPath3.moveTo(f2, f3);
            } else {
                generalPath3.lineTo(f2, f3);
            }
        }
    }

    private void completionCurve(GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, boolean bl) {
        if (bl) {
            ChartUtils.curveTo(generalPath2, generalPath);
            ChartUtils.curveTo(generalPath3, generalPath);
            generalPath.reset();
        }
    }

    private void areaAndCurvePathMove(DataSeries dataSeries, GeneralPath generalPath, GeneralPath generalPath2, AxisGlyph axisGlyph, double[] dArray, float f2, boolean bl) {
        this.pathMoveWithStacked(dataSeries, generalPath, generalPath2, axisGlyph, dArray, bl);
    }

    private void pathMoveWithStacked(DataSeries dataSeries, GeneralPath generalPath, GeneralPath generalPath2, AxisGlyph axisGlyph, double[] dArray, boolean bl) {
        if (bl) {
            for (int i2 = dArray.length - 1; i2 >= 0; --i2) {
                float f2;
                if (dataSeries.getDataPoint(i2).isValueIsNull() || this.isDataPointXNotInPlotBounds(f2 = (float)axisGlyph.getPoint2D(axisGlyph.getTickIndex4Value(i2)).getX())) continue;
                if (i2 == dArray.length - 1) {
                    generalPath.moveTo(f2, (float)dArray[i2]);
                    continue;
                }
                generalPath.lineTo(f2, (float)dArray[i2]);
            }
            ChartUtils.curveTo(generalPath2, generalPath);
            generalPath.reset();
        } else {
            for (int i3 = dArray.length - 1; i3 >= 0; --i3) {
                float f3;
                if (dataSeries.getDataPoint(i3).isValueIsNull() || this.isDataPointXNotInPlotBounds(f3 = (float)axisGlyph.getPoint2D(axisGlyph.getTickIndex4Value(i3)).getX())) continue;
                generalPath2.lineTo(f3, (float)dArray[i3]);
            }
        }
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        return this.getDataPointLabelBoundsWithPosition4Line(dimension2D, rectangle2D, n2);
    }

    public int[] getDrawSequence() {
        if (this.isStacked()) {
            int n2 = this.getSeriesSize();
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
                nArray[i2] = n2 - i2 - 1;
            }
            return nArray;
        }
        Integer[] integerArray = new Integer[this.getSeriesSize()];
        final double[] dArray = new double[this.getSeriesSize()];
        for (int i3 = 0; i3 < this.getSeriesSize(); ++i3) {
            integerArray[i3] = new Integer(i3);
            dArray[i3] = -1.0;
            DataSeries dataSeries = this.getSeries(i3);
            for (int i4 = 0; i4 < dataSeries.getDataPointCount(); ++i4) {
                if (dataSeries.getDataPoint(i4).isValueIsNull() || !(Math.abs(dataSeries.getDataPoint(i4).getValue()) > dArray[i3])) continue;
                dArray[i3] = Math.abs(dataSeries.getDataPoint(i4).getValue());
            }
        }
        Arrays.sort(integerArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Integer n2 = (Integer)object;
                Integer n3 = (Integer)object2;
                return dArray[n2] > dArray[n3] ? -1 : (dArray[n2] < dArray[n3] ? 1 : 0);
            }
        });
        int[] nArray = new int[integerArray.length];
        for (int i5 = 0; i5 < integerArray.length; ++i5) {
            nArray[i5] = integerArray[i5];
        }
        return nArray;
    }

    public boolean equals(Object object) {
        return object instanceof AreaPlotGlyph && super.equals(object) && ((AreaPlotGlyph)object).isCurve == this.isCurve;
    }

    public Object clone() throws CloneNotSupportedException {
        AreaPlotGlyph areaPlotGlyph = (AreaPlotGlyph)super.clone();
        return areaPlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("isCurve", this.isCurve);
        return jSONObject;
    }

    public String getPlotDetailType() {
        String string = XML_TAG;
        if (this.isStacked()) {
            string = string + "-Stack";
        }
        if (this.getyAxisGlyph().isPercentage()) {
            string = string + "-Percent";
        }
        return string;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }

    public String getChartType() {
        return "Area";
    }
}

