/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.cache.list.IntList;
import com.fr.general.FRLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import sun.misc.Cleaner;

public class MappedByteBufferList
extends AbstractList {
    private File cacheFile = null;
    private MappedByteBuffer mapped_read;
    private MappedByteBuffer mapped_write;
    private byte[] page;
    private int pageSize = 0x2FFFFF;
    private int pageoffset = 0;
    private FileChannel fc;
    private int total_size;
    private IntList size_array;
    private IntList index_array;
    private int count = 0;

    public MappedByteBufferList(File file, int n2) {
        this.pageSize = n2;
        this.page = new byte[this.pageSize];
        this.size_array = new IntList(2000);
        this.index_array = new IntList(2001);
        this.index_array.add(0);
        this.cacheFile = file;
    }

    public static void un_map(final MappedByteBuffer mappedByteBuffer) {
        if (mappedByteBuffer != null) {
            mappedByteBuffer.force();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
                        method.setAccessible(true);
                        Cleaner cleaner = (Cleaner)method.invoke((Object)mappedByteBuffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.clean();
                            cleaner.clear();
                        }
                    }
                    catch (Exception exception) {
                        FRLogger.getLogger().error(exception.getMessage(), exception);
                    }
                    return null;
                }
            });
        }
    }

    public boolean add(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.pageoffset + byArray.length < this.pageSize) {
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    this.page[this.pageoffset++] = byArray[i2];
                }
            } else {
                for (int i3 = 0; i3 < byArray.length; ++i3) {
                    this.page[this.pageoffset++] = byArray[i3];
                    if (this.pageoffset < this.pageSize) continue;
                    if (this.mapped_write != null) {
                        this.mapped_write.clear();
                        MappedByteBufferList.un_map(this.mapped_write);
                        this.mapped_write = null;
                    }
                    this.getFileChannel();
                    this.mapped_write = this.fc.map(FileChannel.MapMode.READ_WRITE, this.fc.size(), this.pageSize);
                    this.mapped_write.put(this.page);
                    this.pageoffset = 0;
                    this.total_size += this.pageSize;
                    if (this.mapped_read == null) continue;
                    this.mapped_read.clear();
                    MappedByteBufferList.un_map(this.mapped_read);
                    this.mapped_read = null;
                }
            }
            this.size_array.add(this.count, byArray.length);
            this.index_array.add(this.count + 1, this.index_array.get(this.count) + byArray.length);
            ++this.count;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return true;
    }

    public Object get(int n2) {
        try {
            byte[] byArray = new byte[this.size_array.get(n2)];
            int n3 = this.index_array.get(n2) + this.size_array.get(n2);
            if (this.total_size == 0) {
                return this.readWhenNoCache(n2, n3, byArray);
            }
            return this.readWhenHasCache(n2, n3, byArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private Object readWhenNoCache(int n2, int n3, byte[] byArray) throws IOException, ClassNotFoundException {
        int n4 = 0;
        int n5 = this.index_array.get(n2);
        while (n5 < n3) {
            byArray[n4] = this.page[n5];
            ++n5;
            ++n4;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    private Object readWhenHasCache(int n2, int n3, byte[] byArray) throws IOException, ClassNotFoundException {
        int n4;
        int n5 = 0;
        this.getFileChannel();
        if (this.mapped_read == null) {
            this.mapped_read = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.total_size);
        }
        if ((long)n3 <= this.fc.size()) {
            n4 = this.index_array.get(n2);
            while (n4 < n3) {
                byArray[n5] = this.mapped_read.get(n4);
                ++n4;
                ++n5;
            }
        } else if (n3 > this.total_size && this.index_array.get(n2) < this.total_size) {
            n4 = this.index_array.get(n2);
            while ((long)n4 < this.fc.size()) {
                byArray[n5] = this.mapped_read.get(n4);
                ++n4;
                ++n5;
            }
            n4 = this.total_size;
            while (n4 < n3) {
                byArray[n5] = this.page[n4 - this.total_size];
                ++n4;
                ++n5;
            }
        } else {
            n4 = this.index_array.get(n2);
            while (n4 < n3) {
                byArray[n5] = this.page[n4 - this.total_size];
                ++n4;
                ++n5;
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    private FileChannel getFileChannel() {
        if (this.fc == null) {
            try {
                this.fc = new RandomAccessFile(this.cacheFile, "rw").getChannel();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.fc;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.size_array = null;
        if (this.mapped_read != null) {
            this.mapped_read.clear();
            MappedByteBufferList.un_map(this.mapped_read);
            this.mapped_read = null;
        }
        if (this.mapped_write != null) {
            this.mapped_write.clear();
            MappedByteBufferList.un_map(this.mapped_write);
            this.mapped_write = null;
        }
        this.pageoffset = 0;
        if (this.fc != null) {
            try {
                this.fc.close();
                this.fc = null;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.page = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

