/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.BaseScriptUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.AbstractFormulaProvider;
import com.fr.stable.ColumnRow;
import com.fr.stable.ColumnRowRelated;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.CalculatorUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.antlr.ANTLRException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Formula
extends AbstractFormulaProvider
implements XMLable,
ColumnRowRelated {
    private String content = "";
    private transient Object result = null;
    private transient Object originResult = null;
    private boolean reserveInResult = false;
    private boolean reserveOnWriteOrAnaly = true;

    public void setOriginResult(Object object) {
        this.originResult = object;
    }

    public Formula() {
    }

    public Formula(String string) {
        this.setContent(string);
    }

    public static String getPureFormulaContent(String string) {
        if (StableUtils.canBeFormula(string)) {
            return string.substring(1);
        }
        return string;
    }

    public static boolean isEmptyFormula(Object object) {
        return object instanceof Formula && StringUtils.isNotBlank(((Formula)object).getContent());
    }

    public String getContent() {
        if (this.content.trim().startsWith("=")) {
            return this.content;
        }
        return "=" + this.content;
    }

    public String getPureContent() {
        if (this.content.trim().startsWith("=")) {
            return this.content.substring(1);
        }
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
        if (this.content.trim().startsWith("=")) {
            this.content = this.content.trim().substring(1);
        }
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object object) {
        this.result = object;
    }

    public Object getResultForCurrentValue() {
        if (this.originResult != null && this.originResult != Primitive.NULL) {
            return this.originResult;
        }
        return this.result;
    }

    public boolean isReserveInResult() {
        return this.reserveInResult;
    }

    public void setReserveInResult(boolean bl) {
        this.reserveInResult = bl;
    }

    public boolean isReserveOnWriteOrAnaly() {
        return this.reserveOnWriteOrAnaly;
    }

    public void setReserveOnWriteOrAnaly(boolean bl) {
        this.reserveOnWriteOrAnaly = bl;
    }

    public boolean isEmpty() {
        return ComparatorUtils.equals("=", this.getContent());
    }

    public boolean isResult() {
        return false;
    }

    public void modColumnRow(ModColumnRowProvider modColumnRowProvider) {
        if (StringUtils.isNotBlank(this.content)) {
            this.setContent(modColumnRowProvider.mod_fm_statement(this.content));
        }
    }

    public ColumnRow[] getRelatedColumnRows() {
        if (StringUtils.isNotBlank(this.content)) {
            try {
                return CalculatorUtils.relatedColumnRowArray(this.content);
            }
            catch (ANTLRException aNTLRException) {
                FRLogger.getLogger().error(aNTLRException.getMessage(), aNTLRException);
            }
        }
        return new ColumnRow[0];
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.result = objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.result);
    }

    public String getXmlTag() {
        return "Formula";
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                this.setReserveInResult(xMLableReader.getAttrAsBoolean("reserveExecute", false));
                this.setReserveOnWriteOrAnaly(xMLableReader.getAttrAsBoolean("reserveInWeb", true));
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setContent(string2);
                }
            } else if ("O".equals(string)) {
                this.setResult(GeneralXMLTools.readObject(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes");
        if (this.isReserveInResult()) {
            xMLPrintWriter.attr("reserveExecute", this.isReserveInResult());
        }
        if (!this.isReserveOnWriteOrAnaly()) {
            xMLPrintWriter.attr("reserveInWeb", this.isReserveOnWriteOrAnaly());
        }
        xMLPrintWriter.textNode(this.getContent());
        xMLPrintWriter.end();
        Object object = this.result;
        if (object != null) {
            GeneralXMLTools.writeObject(xMLPrintWriter, object);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Formula && this.isReserveInResult() == ((Formula)object).isReserveInResult() && this.isReserveOnWriteOrAnaly() == ((Formula)object).isReserveOnWriteOrAnaly() && ComparatorUtils.equals(this.getContent(), ((Formula)object).getContent());
    }

    public String toString() {
        return this.getContent();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        String string = this.getPureContent();
        return BaseScriptUtils.getDependenceByFormula(string);
    }
}

