/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.file.FunctionManager;
import com.fr.file.FunctionManagerProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.plugin.ExtraClassManager;
import com.fr.script.Calculator;
import com.fr.stable.InterpreterError;
import com.fr.stable.LicUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.fun.FunctionDefContainer;
import com.fr.stable.fun.mark.Mutable;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.Function;
import com.fr.stable.script.FunctionDef;
import com.fr.stable.script.NameSpace;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DefaultNameSpace
extends AbstractNameSpace {
    private static NameSpace instance = null;
    private Map initedFunctionClasses;

    public static NameSpace getInstance() {
        if (instance == null) {
            instance = new DefaultNameSpace();
        }
        return instance;
    }

    private DefaultNameSpace() {
    }

    public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.equalsIgnoreCase("null")) {
                return Primitive.NULL;
            }
            if (string.equalsIgnoreCase("nofilter")) {
                return Primitive.NOFILTER;
            }
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if ("FR_HOME".equalsIgnoreCase(string)) {
                return StableUtils.getInstallHome();
            }
            if ("ENV_HOME".equalsIgnoreCase(string)) {
                return FRContext.getCurrentEnv().getPath();
            }
            if ("lic_PROJECTNAME".equalsIgnoreCase(string)) {
                return LicUtils.getItemFromLic("PROJECTNAME");
            }
        }
        return this.resloveFromThreadContext(object, calculatorProvider);
    }

    private Object resloveFromThreadContext(Object object, CalculatorProvider calculatorProvider) {
        NameSpace nameSpace;
        Object object2;
        Object object3 = null;
        if (object instanceof String && ((String)(object2 = object.toString())).startsWith("$")) {
            object = ((String)object2).substring(1);
        }
        if ((object2 = Calculator.getSavedVariables()) != null) {
            object3 = object2.get(object);
        }
        if (object3 == null && (nameSpace = (NameSpace)Calculator.getSavedSessionNameSpace()) != null) {
            object3 = nameSpace.getVariable(object, calculatorProvider);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getMethod(Object object, CalculatorProvider calculatorProvider) {
        Class clazz;
        Object object2;
        if (!(object instanceof String)) {
            throw new InterpreterError(Inter.getLocText("FR-Engine_Function_Name_Should_Not_Be") + object + (object != null ? " " + object.getClass() : ""));
        }
        String string = ((String)object).toUpperCase();
        if (this.initedFunctionClasses == null) {
            object2 = this;
            synchronized (object2) {
                if (this.initedFunctionClasses == null) {
                    this.initedFunctionClasses = new ConcurrentHashMap();
                }
            }
        }
        if ((clazz = (Class)this.initedFunctionClasses.get(string)) == null) {
            block15: {
                object2 = this.getClassName(string);
                try {
                    clazz = GeneralUtils.classForName((String)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (ComparatorUtils.equals((String)object2, "com.fr.function." + string)) break block15;
                    try {
                        clazz = GeneralUtils.classForName("com.fr.function." + string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        // empty catch block
                    }
                }
            }
            if (clazz != null) {
                this.initedFunctionClasses.put(string, clazz);
            }
        }
        if (clazz == null) {
            return null;
        }
        try {
            object2 = clazz.newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            return null;
        }
        return (Function)object2;
    }

    private String getClassName(String string) {
        Object object;
        String string2 = null;
        FunctionManagerProvider functionManagerProvider = FunctionManager.getProviderInstance();
        int n2 = functionManagerProvider.getFunctionDefCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = functionManagerProvider.getFunctionDef(i2);
            if (!((FunctionDef)object).getName().equalsIgnoreCase(string)) continue;
            string2 = ((FunctionDef)object).getClassName();
        }
        FunctionDef[] functionDefArray = ExtraClassManager.getInstance().getFunctionDef();
        for (FunctionDef functionDefArray2 : functionDefArray) {
            if (!functionDefArray2.getName().equalsIgnoreCase(string)) continue;
            string2 = functionDefArray2.getClassName();
        }
        object = ExtraClassManager.getInstance().getArray("FunctionGroup");
        if (!object.isEmpty()) {
            Iterator iterator = object.iterator();
            block2: while (iterator.hasNext()) {
                FunctionDef[] functionDefArray2;
                Mutable mutable = (Mutable)iterator.next();
                for (FunctionDef functionDef : functionDefArray2 = ((FunctionDefContainer)mutable).getFunctionDefs()) {
                    if (!functionDef.getName().equalsIgnoreCase(string)) continue;
                    string2 = functionDef.getClassName();
                    continue block2;
                }
            }
        }
        if (string2 == null) {
            string2 = "com.fr.function." + string;
        }
        return string2;
    }

    public String toString() {
        return "FUNCTION_NAMESPACE";
    }
}

