/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.range;

import com.fr.base.BaseXMLUtils;
import com.fr.general.ComparatorUtils;
import com.fr.plugin.chart.attr.VanChartHtmlLabel;
import com.fr.plugin.chart.range.glyph.LegendLabelFormatGlyph;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;
import java.text.Format;

public class LegendLabelFormat
implements XMLReadable,
Cloneable,
Serializable {
    private Format format;
    private VanChartHtmlLabel htmlLabel;
    private boolean commonValueFormat = true;

    public LegendLabelFormat() {
        this("function(){ return this; }");
    }

    public LegendLabelFormat(String string) {
        this.htmlLabel = new VanChartHtmlLabel(string);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public VanChartHtmlLabel getHtmlLabel() {
        return this.htmlLabel;
    }

    public void setHtmlLabel(VanChartHtmlLabel vanChartHtmlLabel) {
        this.htmlLabel = vanChartHtmlLabel;
    }

    public boolean isCommonValueFormat() {
        return this.commonValueFormat;
    }

    public void setCommonValueFormat(boolean bl) {
        this.commonValueFormat = bl;
    }

    public LegendLabelFormatGlyph createLegendLabelFormatGlyph() {
        LegendLabelFormatGlyph legendLabelFormatGlyph = new LegendLabelFormatGlyph();
        legendLabelFormatGlyph.setFormat(this.getFormat());
        legendLabelFormatGlyph.setHtmlLabel(this.getHtmlLabel());
        legendLabelFormatGlyph.setCommonValueFormat(this.isCommonValueFormat());
        return legendLabelFormatGlyph;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("LegendLabelFormat");
        xMLPrintWriter.startTAG("IsCommon").attr("commonValueFormat", this.isCommonValueFormat()).end();
        if (this.isCommonValueFormat()) {
            if (this.getFormat() != null) {
                BaseXMLUtils.writeFormat((XMLPrintWriter)xMLPrintWriter, (Format)this.getFormat());
            }
        } else if (this.getHtmlLabel() != null) {
            this.getHtmlLabel().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("IsCommon".equals(string)) {
                this.setCommonValueFormat(xMLableReader.getAttrAsBoolean("commonValueFormat", true));
            }
            if (ComparatorUtils.equals((Object)string, (Object)"Format")) {
                this.setFormat(BaseXMLUtils.readFormat((XMLableReader)xMLableReader));
            } else if (ComparatorUtils.equals((Object)string, (Object)"HtmlLabel")) {
                this.readOldHtmlLabel(xMLableReader);
            }
        }
    }

    private void readOldHtmlLabel(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("customText", "");
        boolean bl = xMLableReader.getAttrAsBoolean("useHtml", false);
        if (StringUtils.isNotEmpty((String)string) || bl) {
            if (this.htmlLabel == null) {
                this.htmlLabel = new VanChartHtmlLabel();
            }
            this.htmlLabel.setCustomText(string);
            this.htmlLabel.setUseHtml(bl);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LegendLabelFormat legendLabelFormat = (LegendLabelFormat)super.clone();
        legendLabelFormat.setCommonValueFormat(this.isCommonValueFormat());
        if (this.getFormat() != null) {
            legendLabelFormat.setFormat((Format)this.getFormat().clone());
        }
        legendLabelFormat.setHtmlLabel((VanChartHtmlLabel)this.getHtmlLabel().clone());
        return legendLabelFormat;
    }
}

