/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.pie;

import com.fr.chart.chartattr.Plot;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.ispinner.UISpinner;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.gui.ChartStylePane;
import com.fr.general.Inter;
import com.fr.plugin.chart.PiePlot4VanChart;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.style.series.VanChartAbstractPlotSeriesPane;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartPieSeriesPane
extends VanChartAbstractPlotSeriesPane {
    private static final long serialVersionUID = 2800670681079289596L;
    private static final double MIN_ANGLE = 0.0;
    private static final double MAX_ANGLE = 360.0;
    private UISpinner startAngle;
    private UISpinner endAngle;
    private UISpinner innerRadius;
    private UIToggleButton supportRotation;

    public VanChartPieSeriesPane(ChartStylePane chartStylePane, Plot plot) {
        super(chartStylePane, plot);
    }

    protected JPanel getContentInPlotType() {
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{this.createStylePane()}, {new JSeparator()}, {this.createSeriesStylePane(dArray2, new double[]{d, d2})}, {new JSeparator()}, {this.createBorderPane()}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    private JPanel createSeriesStylePane(double[] dArray, double[] dArray2) {
        this.startAngle = new UISpinner(0.0, 360.0, 1.0, 0.0);
        this.endAngle = new UISpinner(0.0, 360.0, 1.0, 0.0);
        this.innerRadius = new UISpinner(0.0, 100.0, 1.0, 0.0);
        this.supportRotation = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_Rotation"));
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_StartAngle")), this.startAngle}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_EndAngle")), this.endAngle}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_InnerRadius")), this.innerRadius}, {this.supportRotation, null}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Designer-Widget_Style"), jPanel);
    }

    @Override
    public void populateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.populateBean(plot);
        if (plot.accept(PiePlot4VanChart.class)) {
            PiePlot4VanChart piePlot4VanChart = (PiePlot4VanChart)plot;
            this.startAngle.setValue(piePlot4VanChart.getStartAngle());
            this.endAngle.setValue(piePlot4VanChart.getEndAngle());
            this.innerRadius.setValue(piePlot4VanChart.getInnerRadiusPercent());
            this.supportRotation.setSelected(piePlot4VanChart.isSupportRotation());
        }
    }

    @Override
    public void updateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.updateBean(plot);
        if (plot.accept(PiePlot4VanChart.class)) {
            PiePlot4VanChart piePlot4VanChart = (PiePlot4VanChart)plot;
            piePlot4VanChart.setStartAngle(this.startAngle.getValue());
            piePlot4VanChart.setEndAngle(this.endAngle.getValue());
            piePlot4VanChart.setInnerRadiusPercent(this.innerRadius.getValue());
            piePlot4VanChart.setSupportRotation(this.supportRotation.isSelected());
        }
    }
}

