/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph;

import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartEquationType;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.LinearEquation;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.chart.chartglyph.TrendLineGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.VanChartDateUtils;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.base.VanChartAttrTrendLine;
import com.fr.plugin.chart.glyph.VanChartAxisPlotGlyphInterface;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartDataSheetGlyph;
import com.fr.plugin.chart.glyph.VanChartDataSheetPlotGlyphInterface;
import com.fr.plugin.chart.glyph.VanChartPlotGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartTimeAxisGlyph;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class VanChartRectanglePlotGlyph
extends VanChartPlotGlyph
implements VanChartAxisPlotGlyphInterface,
VanChartDataSheetPlotGlyphInterface {
    private static final double GAP = 4.0;
    private static final long serialVersionUID = -8454856294551338692L;
    protected List<VanChartBaseAxisGlyph> xAxisGlyphList = new ArrayList<VanChartBaseAxisGlyph>();
    protected List<VanChartBaseAxisGlyph> yAxisGlyphList = new ArrayList<VanChartBaseAxisGlyph>();
    private VanChartAttrTrendLine defaultAttrTrendLine;

    public List<VanChartBaseAxisGlyph> getYAxisGlyphList() {
        return this.yAxisGlyphList;
    }

    public List<VanChartBaseAxisGlyph> getXAxisGlyphList() {
        return this.xAxisGlyphList;
    }

    protected VanChartAttrTrendLine getDefaultAttrTrendLine() {
        if (this.defaultAttrTrendLine == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrTrendLine = (VanChartAttrTrendLine)conditionAttr.getExisted(VanChartAttrTrendLine.class);
        }
        return this.defaultAttrTrendLine;
    }

    protected VanChartAttrTrendLine getAttrTrendLine(VanChartDataSeries vanChartDataSeries) {
        VanChartAttrTrendLine vanChartAttrTrendLine = vanChartDataSeries.getAttrTrendLine();
        if (vanChartAttrTrendLine == null) {
            vanChartAttrTrendLine = this.getDefaultAttrTrendLine();
        }
        return vanChartAttrTrendLine;
    }

    public void addXAxisGlyph(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        this.xAxisGlyphList.add(vanChartBaseAxisGlyph);
    }

    public void addYAxisGlyph(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        this.yAxisGlyphList.add(vanChartBaseAxisGlyph);
    }

    @Override
    public int getBottomXAxisCount() {
        int n = 0;
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.xAxisGlyphList) {
            if (vanChartBaseAxisGlyph == null || vanChartBaseAxisGlyph.getPosition() != 3) continue;
            ++n;
        }
        return n;
    }

    public DataSheetGlyph createDataSheetGlyph(DataSheet dataSheet, LegendItem[] legendItemArray) {
        AxisGlyph axisGlyph = this.getXAxisGlyphList().get(0);
        if (axisGlyph != null) {
            axisGlyph.notShowAllAttr();
        }
        return new VanChartDataSheetGlyph(dataSheet.getFont(), dataSheet.getFormat(), (GeneralInfo)dataSheet);
    }

    @Override
    public void adjustAxisGlyphWithLeftGap(double d) {
        Rectangle2D rectangle2D;
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.xAxisGlyphList) {
            if (vanChartBaseAxisGlyph == null) continue;
            rectangle2D = vanChartBaseAxisGlyph.getBounds();
            vanChartBaseAxisGlyph.calculateAxisGlyph(this.getBounds());
            vanChartBaseAxisGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - d, rectangle2D.getHeight()));
        }
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.yAxisGlyphList) {
            if (vanChartBaseAxisGlyph == null || vanChartBaseAxisGlyph.getPosition() != 4) continue;
            rectangle2D = vanChartBaseAxisGlyph.getBounds();
            vanChartBaseAxisGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX() - d, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
        }
    }

    @Override
    public void adjustAxisGlyphWithBottomGap(double d) {
        Rectangle2D rectangle2D;
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.xAxisGlyphList) {
            if (vanChartBaseAxisGlyph == null || vanChartBaseAxisGlyph.getPosition() != 3) continue;
            rectangle2D = vanChartBaseAxisGlyph.getBounds();
            vanChartBaseAxisGlyph.finallyUpdateAxisGridLength(this.getBounds().getHeight());
            vanChartBaseAxisGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() - d, rectangle2D.getWidth(), rectangle2D.getHeight() - d));
        }
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.yAxisGlyphList) {
            if (vanChartBaseAxisGlyph == null) continue;
            rectangle2D = vanChartBaseAxisGlyph.getBounds();
            vanChartBaseAxisGlyph.calculateAxisGlyph(this.getBounds());
            vanChartBaseAxisGlyph.setBounds(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d));
        }
        this.dealOnZeroAxisGlyphLocation();
    }

    @Override
    public void layoutAxisGlyph(Rectangle2D rectangle2D, int n) {
        VanChartBaseAxisGlyph vanChartBaseAxisGlyph2;
        int n2;
        Rectangle2D rectangle2D2 = this.getBounds();
        Rectangle2D rectangle2D3 = this.getBounds();
        for (n2 = this.xAxisGlyphList.size() - 1; n2 >= 0; --n2) {
            vanChartBaseAxisGlyph2 = this.xAxisGlyphList.get(n2);
            this.initXAxisGlyphMinMaxValue(n2, vanChartBaseAxisGlyph2);
            this.initXAxisLabelDrawPosition(vanChartBaseAxisGlyph2);
            this.initAxisGlyphBoundsAndZeroBoundsAndOriginalChartBounds(rectangle2D, vanChartBaseAxisGlyph2, rectangle2D2);
            this.dealPlotBoundsWithAxisGlyph(vanChartBaseAxisGlyph2, rectangle2D3, n);
            this.dealPlotBoundsWidthAxisInHorizontal(vanChartBaseAxisGlyph2, rectangle2D3);
            this.initAxisGlyphStartPoint(vanChartBaseAxisGlyph2, rectangle2D3);
        }
        for (n2 = this.yAxisGlyphList.size() - 1; n2 >= 0; --n2) {
            vanChartBaseAxisGlyph2 = this.yAxisGlyphList.get(n2);
            this.initYAxisGlyphMinMaxValue(n2, vanChartBaseAxisGlyph2);
            this.initYAxisLabelDrawPosition(vanChartBaseAxisGlyph2);
            this.initAxisGlyphBoundsAndZeroBoundsAndOriginalChartBounds(rectangle2D, vanChartBaseAxisGlyph2, rectangle2D2);
            this.dealPlotBoundsWithAxisGlyph(vanChartBaseAxisGlyph2, rectangle2D3, n);
            this.dealPlotBoundsWidthAxisInHorizontal(vanChartBaseAxisGlyph2, rectangle2D3);
            this.initAxisGlyphStartPoint(vanChartBaseAxisGlyph2, rectangle2D3);
        }
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph2 : this.xAxisGlyphList) {
            this.calculateAxisGlyphAttr(vanChartBaseAxisGlyph2, rectangle2D3);
        }
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph2 : this.yAxisGlyphList) {
            this.calculateAxisGlyphAttr(vanChartBaseAxisGlyph2, rectangle2D3);
        }
        this.dealOnZeroAxisGlyphLocation();
        this.setBounds(rectangle2D3);
    }

    private void dealOnZeroAxisGlyphLocation() {
        double d = this.getDefaultXAxisGlyph().getPoint2D(0.0).getX();
        double d2 = this.getDefaultYAxisGlyph().getPoint2D(0.0).getY();
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.xAxisGlyphList) {
            this.dealOnZeroAxisGlyphLocation(vanChartBaseAxisGlyph, d2);
        }
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.yAxisGlyphList) {
            this.dealOnZeroAxisGlyphLocation(vanChartBaseAxisGlyph, d);
        }
    }

    protected void initAxisGlyphBoundsAndZeroBoundsAndOriginalChartBounds(Rectangle2D rectangle2D, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, Rectangle2D rectangle2D2) {
        if (vanChartBaseAxisGlyph != null) {
            vanChartBaseAxisGlyph.setChartBounds(rectangle2D);
            vanChartBaseAxisGlyph.setBounds(rectangle2D2);
            vanChartBaseAxisGlyph.setPlotZeroBounds(rectangle2D2);
        }
    }

    protected void dealPlotBoundsWithAxisGlyph(VanChartBaseAxisGlyph vanChartBaseAxisGlyph, Rectangle2D rectangle2D, int n) {
        if (vanChartBaseAxisGlyph != null) {
            vanChartBaseAxisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D, n);
        }
    }

    protected void dealPlotBoundsWidthAxisInHorizontal(VanChartBaseAxisGlyph vanChartBaseAxisGlyph, Rectangle2D rectangle2D) {
        if (vanChartBaseAxisGlyph != null) {
            vanChartBaseAxisGlyph.dealPlotBoundsWithLabelInHorizontal(rectangle2D);
        }
    }

    protected void calculateAxisGlyphAttr(VanChartBaseAxisGlyph vanChartBaseAxisGlyph, Rectangle2D rectangle2D) {
        if (vanChartBaseAxisGlyph != null) {
            vanChartBaseAxisGlyph.calculateAxisGlyph(rectangle2D);
        }
    }

    protected void initAxisGlyphStartPoint(VanChartBaseAxisGlyph vanChartBaseAxisGlyph, Rectangle2D rectangle2D) {
        if (vanChartBaseAxisGlyph != null) {
            vanChartBaseAxisGlyph.initAxisGlyphStartPoint(rectangle2D);
        }
    }

    protected void dealOnZeroAxisGlyphLocation(VanChartBaseAxisGlyph vanChartBaseAxisGlyph, double d) {
        if (vanChartBaseAxisGlyph != null) {
            vanChartBaseAxisGlyph.dealOnZeroAxisGlyphLocation(d);
        }
    }

    protected void initXAxisLabelDrawPosition(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        this.setAxisLabelDrawBetween(vanChartBaseAxisGlyph);
    }

    protected void initYAxisLabelDrawPosition(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
    }

    protected void setAxisLabelDrawBetween(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        vanChartBaseAxisGlyph.setDrawBetweenTick(ComparatorUtils.equals((Object)((Object)vanChartBaseAxisGlyph.getVanAxisType()), (Object)((Object)AxisType.AXIS_CATEGORY)));
    }

    protected void initXAxisGlyphMinMaxValue(int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (ComparatorUtils.equals((Object)((Object)vanChartBaseAxisGlyph.getVanAxisType()), (Object)((Object)AxisType.AXIS_VALUE))) {
            this.initCateAxisGlyphMinMaxValue(n, vanChartBaseAxisGlyph, false);
        } else if (ComparatorUtils.equals((Object)((Object)vanChartBaseAxisGlyph.getVanAxisType()), (Object)((Object)AxisType.AXIS_TIME))) {
            this.initCateAxisGlyphMinMaxValue(n, vanChartBaseAxisGlyph, true);
        }
    }

    protected void initYAxisGlyphMinMaxValue(int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        this.initValueAxisGlyphMinMaxValue(n, vanChartBaseAxisGlyph);
    }

    private void initCateAxisGlyphMinMaxValue(int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, boolean bl) {
        if (vanChartBaseAxisGlyph.isPercentage()) {
            vanChartBaseAxisGlyph.initMinMaxValue(0.0, 1.0);
            return;
        }
        double[] dArray = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        boolean bl2 = false;
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            int n3;
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = vanChartDataSeries.getAttrSeriesStackAndAxis();
            int n4 = n3 = attrSeriesStackAndAxis == null ? 0 : attrSeriesStackAndAxis.getXAxisIndex();
            if (n != n3) continue;
            bl2 = true;
            dArray = bl ? this.getSeriesMinMaxCateDateValue(vanChartDataSeries, dArray) : this.getSeriesMinMaxCateValue(vanChartDataSeries, dArray);
        }
        if (!bl2 && !bl) {
            dArray[0] = 0.0;
            dArray[1] = 1.0;
        }
        vanChartBaseAxisGlyph.initMinMaxValue(dArray[0], dArray[1], this.isAdjustXAxisMinMaxValue());
    }

    protected boolean isAdjustXAxisMinMaxValue() {
        return false;
    }

    public double[] getSeriesMinMaxCateValue(DataSeries dataSeries, double[] dArray) {
        int n = dataSeries.getDataPointCount();
        for (int i = 0; i < n; ++i) {
            DataPoint dataPoint = dataSeries.getDataPoint(i);
            Number number = Utils.string2Number((String)dataPoint.getCategoryName());
            if (number == null) continue;
            double d = number.doubleValue();
            dArray[0] = Math.min(dArray[0], d);
            dArray[1] = Math.max(dArray[1], d);
        }
        return dArray;
    }

    private double[] getSeriesMinMaxCateDateValue(DataSeries dataSeries, double[] dArray) {
        int n = dataSeries.getDataPointCount();
        for (int i = 0; i < n; ++i) {
            DataPoint dataPoint = dataSeries.getDataPoint(i);
            Date date = VanChartDateUtils.object2Date(dataPoint.getCategoryName(), true);
            if (date == null) continue;
            double d = ChartBaseUtils.date2Int((Date)date, (int)6);
            dArray[0] = Math.min(dArray[0], d);
            dArray[1] = Math.max(dArray[1], d);
        }
        return dArray;
    }

    protected void initValueAxisGlyphMinMaxValue(int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        Object object;
        if (vanChartBaseAxisGlyph.isPercentage()) {
            vanChartBaseAxisGlyph.initMinMaxValue(0.0, 1.0);
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = -d;
        HashMap<String, Map<String, Number>> hashMap = new HashMap<String, Map<String, Number>>();
        int n2 = this.getSeriesSize();
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (int i = 0; i < n2; ++i) {
            Object object2 = (VanChartDataSeries)this.getSeries(i);
            object = object2.getAttrSeriesStackAndAxis();
            int n3 = this.getValueAxisIndex((AttrSeriesStackAndAxis)((Object)object));
            Object object3 = this.getCateAxis(this.getCateAxisIndex((AttrSeriesStackAndAxis)((Object)object)));
            if (n != n3) continue;
            this.getSeriesValue((Map<String, Map<String, Number>>)hashMap, (VanChartDataSeries)((Object)object2), (AttrSeriesStackAndAxis)((Object)object), (VanChartBaseAxisGlyph)((Object)object3));
            arrayList.add(i);
        }
        for (Object object2 : hashMap.keySet()) {
            object = (Map)hashMap.get(object2);
            for (Object object3 : object.keySet()) {
                double d3 = ((Number)object.get(object3)).doubleValue();
                d = Math.min(d3, d);
                d2 = Math.max(d3, d2);
            }
        }
        vanChartBaseAxisGlyph.initMinMaxValue(d, d2);
        this.initDataSeriesBandsDefaultMinMaxValue(vanChartBaseAxisGlyph.getMinValue(), vanChartBaseAxisGlyph.getMaxValue(), arrayList);
    }

    protected int getValueAxisIndex(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        return attrSeriesStackAndAxis == null ? 0 : attrSeriesStackAndAxis.getYAxisIndex();
    }

    protected int getCateAxisIndex(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        return attrSeriesStackAndAxis == null ? 0 : attrSeriesStackAndAxis.getXAxisIndex();
    }

    protected VanChartBaseAxisGlyph getCateAxis(int n) {
        return this.xAxisGlyphList.get(n);
    }

    public void getSeriesValue(Map<String, Map<String, Number>> map, VanChartDataSeries vanChartDataSeries, AttrSeriesStackAndAxis attrSeriesStackAndAxis, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        boolean bl = ComparatorUtils.equals((Object)((Object)vanChartBaseAxisGlyph.getVanAxisType()), (Object)((Object)AxisType.AXIS_TIME));
        String string = vanChartDataSeries.getSeriesName();
        if (attrSeriesStackAndAxis == null || !attrSeriesStackAndAxis.isStacked()) {
            if (map.get(string) == null) {
                map.put(string, new HashMap());
            }
            Map<String, Number> map2 = map.get(string);
            int n = vanChartDataSeries.getDataPointCount();
            for (int i = 0; i < n; ++i) {
                map2.put(vanChartDataSeries.getDataPoint(i).getCategoryName(), vanChartDataSeries.getDataPoint(i).getValue());
            }
        } else {
            String string2 = attrSeriesStackAndAxis.getStackID() + "POSITIVE";
            String string3 = attrSeriesStackAndAxis.getStackID() + "NEGATIVE";
            if (map.get(string2) == null) {
                map.put(string2, new HashMap());
            }
            if (map.get(string3) == null) {
                map.put(string3, new HashMap());
            }
            Map<String, Number> map3 = map.get(string2);
            Map<String, Number> map4 = map.get(string3);
            int n = vanChartDataSeries.getDataPointCount();
            for (int i = 0; i < n; ++i) {
                Serializable serializable;
                double d = vanChartDataSeries.getDataPoint(i).getValue();
                String string4 = vanChartDataSeries.getDataPoint(i).getCategoryName();
                if (bl && (serializable = VanChartDateUtils.object2Date(string4, true)) != null) {
                    Number number;
                    double d2 = ChartBaseUtils.date2Int((Date)serializable, (int)((VanChartTimeAxisGlyph)vanChartBaseAxisGlyph).getMainType().getTimeType());
                    if (d > 0.0) {
                        number = map3.get(String.valueOf(d2));
                        map3.put(String.valueOf(d2), vanChartDataSeries.getDataPoint(i).getValue() + (number == null ? 0.0 : number.doubleValue()));
                        continue;
                    }
                    number = map4.get(String.valueOf(d2));
                    map4.put(String.valueOf(d2), vanChartDataSeries.getDataPoint(i).getValue() + (number == null ? 0.0 : number.doubleValue()));
                    continue;
                }
                if (d > 0.0) {
                    serializable = map3.get(string4);
                    map3.put(string4, vanChartDataSeries.getDataPoint(i).getValue() + (serializable == null ? 0.0 : ((Number)serializable).doubleValue()));
                    continue;
                }
                serializable = map4.get(string4);
                map4.put(string4, vanChartDataSeries.getDataPoint(i).getValue() + (serializable == null ? 0.0 : ((Number)serializable).doubleValue()));
            }
        }
    }

    protected void initDataSeriesBandsDefaultMinMaxValue(double d, double d2, List<Number> list) {
    }

    protected Map<String, List<List<Number>>> buildAxisMap(boolean bl) {
        HashMap<String, List<Number>> hashMap = new HashMap<String, List<Number>>();
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            String string = this.getDataSeriesCateAxisGlyph(vanChartDataSeries).getVanAxisName();
            ArrayList<Integer> arrayList = (ArrayList<Integer>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(i);
        }
        return this.buildLocation2SeriesMap(hashMap, bl);
    }

    private Map<String, List<List<Number>>> buildLocation2SeriesMap(Map<String, List<Number>> map, boolean bl) {
        HashMap<String, List<List<Number>>> hashMap = new HashMap<String, List<List<Number>>>();
        for (String string : map.keySet()) {
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            int n = 0;
            List<Number> list = map.get(string);
            ArrayList arrayList = new ArrayList();
            if (list == null || list.size() < 1) continue;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(list.get(i).intValue());
                String string2 = bl ? "combineUnStack" : vanChartDataSeries.getSeriesName();
                AttrSeriesStackAndAxis attrSeriesStackAndAxis = vanChartDataSeries.getAttrSeriesStackAndAxis();
                if (attrSeriesStackAndAxis != null && attrSeriesStackAndAxis.isStacked()) {
                    string2 = attrSeriesStackAndAxis.getStackID();
                }
                if (hashMap2.get(string2) != null) {
                    ((List)arrayList.get(((Number)hashMap2.get(string2)).intValue())).add(list.get(i));
                    continue;
                }
                hashMap2.put(string2, n);
                ArrayList<Number> arrayList2 = new ArrayList<Number>();
                arrayList2.add(list.get(i));
                arrayList.add(n, arrayList2);
                ++n;
            }
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    protected VanChartBaseAxisGlyph getDataSeriesValueAxisGlyph(VanChartDataSeries vanChartDataSeries) {
        return this.yAxisGlyphList.get(this.getYAxisGlyphIndex(vanChartDataSeries.getAttrSeriesStackAndAxis()));
    }

    protected VanChartBaseAxisGlyph getDataSeriesCateAxisGlyph(VanChartDataSeries vanChartDataSeries) {
        return this.xAxisGlyphList.get(this.getXAxisGlyphIndex(vanChartDataSeries.getAttrSeriesStackAndAxis()));
    }

    protected int getXAxisGlyphIndex(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        return attrSeriesStackAndAxis == null ? 0 : attrSeriesStackAndAxis.getXAxisIndex();
    }

    protected int getYAxisGlyphIndex(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        return attrSeriesStackAndAxis == null ? 0 : attrSeriesStackAndAxis.getYAxisIndex();
    }

    @Override
    public VanChartBaseAxisGlyph getDefaultXAxisGlyph() {
        return this.xAxisGlyphList.get(0);
    }

    public VanChartBaseAxisGlyph getDefaultYAxisGlyph() {
        return this.yAxisGlyphList.get(0);
    }

    protected void dealDataPointLabel(VanChartDataPoint vanChartDataPoint, int n) {
        TextGlyph textGlyph = vanChartDataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        if (this.notDealDataPointLabel(vanChartDataPoint, textGlyph)) {
            textGlyph.setBounds(null);
        } else {
            Dimension2D dimension2D = textGlyph.preferredDimension(n);
            Rectangle2D rectangle2D = vanChartDataPoint.getShape().getBounds2D();
            AttrLabel attrLabel = this.getAttrLabel(vanChartDataPoint);
            int n2 = attrLabel.getPosition();
            Rectangle2D rectangle2D2 = this.getDataPointLabelBoundsWithPosition(dimension2D, rectangle2D, n2, vanChartDataPoint);
            textGlyph.setBounds((RectangularShape)rectangle2D2);
        }
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n, DataPoint dataPoint) {
        double d = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
        double d2 = rectangle2D.getY() - dimension2D.getHeight() - 4.0;
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void calculateDataPointPercentValue() {
        if (this.getSeriesSize() < 1) {
            return;
        }
        int n = this.getSeries(0).getDataPointCount();
        Map<String, List<List<Number>>> map = this.buildAxisMap(true);
        for (String string : map.keySet()) {
            int n2;
            List<List<Number>> list = map.get(string);
            VanChartBaseAxisGlyph vanChartBaseAxisGlyph = this.getAxisGlyphFromAxisName(string);
            AxisType axisType = vanChartBaseAxisGlyph.getVanAxisType();
            if (ComparatorUtils.equals((Object)((Object)axisType), (Object)((Object)AxisType.AXIS_CATEGORY))) {
                for (n2 = 0; n2 < n; ++n2) {
                    for (List<Number> list2 : list) {
                        double d = 0.0;
                        for (Number number : list2) {
                            d += Math.abs(this.getSeries(number.intValue()).getDataPoint(n2).getValue());
                        }
                        for (Number number : list2) {
                            double d2 = Math.abs(this.getSeries(number.intValue()).getDataPoint(n2).getValue());
                            if (d == 0.0) continue;
                            this.getSeries(number.intValue()).getDataPoint(n2).setPercentValue(d2 / d);
                        }
                    }
                }
                continue;
            }
            n2 = ComparatorUtils.equals((Object)((Object)axisType), (Object)((Object)AxisType.AXIS_TIME));
            this.calculateDoubleValueDataPointPercentValue(list, n2 != 0, vanChartBaseAxisGlyph);
        }
    }

    private void calculateDoubleValueDataPointPercentValue(List<List<Number>> list, boolean bl, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        int n = this.getSeries(0).getDataPointCount();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            List<Number> list2 = list.get(i);
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(list2.get(0).intValue());
            boolean bl2 = vanChartDataSeries.getAttrSeriesStackAndAxis() == null ? false : vanChartDataSeries.getAttrSeriesStackAndAxis().isStacked();
            if (i == n2 - 1 && !bl2 || list2.size() == 1) {
                this.setDoubleValueDataPointDefaultPercentValue(list2, n);
                continue;
            }
            HashMap<String, List<Number>> hashMap = new HashMap<String, List<Number>>();
            for (Number number : list2) {
                for (int j = 0; j < n; ++j) {
                    double d;
                    Serializable serializable;
                    String string = this.getSeries(number.intValue()).getDataPoint(j).getCategoryName();
                    if (bl) {
                        serializable = VanChartDateUtils.object2Date(string, true);
                        if (serializable == null) continue;
                        d = ChartBaseUtils.date2Int((Date)serializable, (int)((VanChartTimeAxisGlyph)vanChartBaseAxisGlyph).getMainType().getTimeType());
                    } else {
                        serializable = Utils.objectToNumber((Object)string, (boolean)true);
                        if (serializable == null) continue;
                        d = ((Number)serializable).doubleValue();
                    }
                    serializable = (List)hashMap.get(String.valueOf(d));
                    if (serializable == null) {
                        serializable = new ArrayList<Number>();
                        hashMap.put(String.valueOf(d), (List<Number>)((Object)serializable));
                    }
                    serializable.add(number);
                }
            }
            this.setDoubleValueDataPointPercentValue(list2, n, bl, vanChartBaseAxisGlyph, hashMap);
        }
    }

    private void setDoubleValueDataPointDefaultPercentValue(List<Number> list, int n) {
        for (Number number : list) {
            for (int i = 0; i < n; ++i) {
                this.getSeries(number.intValue()).getDataPoint(i).setPercentValue(1.0);
            }
        }
    }

    private void setDoubleValueDataPointPercentValue(List<Number> list, int n, boolean bl, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, Map<String, List<Number>> map) {
        for (Number number : list) {
            for (int i = 0; i < n; ++i) {
                double d;
                Object object;
                DataPoint dataPoint = this.getSeries(number.intValue()).getDataPoint(i);
                String string = dataPoint.getCategoryName();
                if (bl) {
                    object = VanChartDateUtils.object2Date(string, true);
                    if (object == null) continue;
                    d = ChartBaseUtils.date2Int((Date)object, (int)((VanChartTimeAxisGlyph)vanChartBaseAxisGlyph).getMainType().getTimeType());
                } else {
                    object = Utils.objectToNumber((Object)string, (boolean)true);
                    if (object == null) continue;
                    d = ((Number)object).doubleValue();
                }
                object = map.get(String.valueOf(d));
                double d2 = 0.0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Number number2 = (Number)iterator.next();
                    d2 += Math.abs(this.getSeries(number2.intValue()).getDataPoint(i).getValue());
                }
                dataPoint.setPercentValue(Math.abs(dataPoint.getValue() / d2));
            }
        }
    }

    private VanChartBaseAxisGlyph getAxisGlyphFromAxisName(String string) {
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.xAxisGlyphList) {
            if (!ComparatorUtils.equals((Object)vanChartBaseAxisGlyph.getVanAxisName(), (Object)string)) continue;
            return vanChartBaseAxisGlyph;
        }
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.yAxisGlyphList) {
            if (!ComparatorUtils.equals((Object)vanChartBaseAxisGlyph.getVanAxisName(), (Object)string)) continue;
            return vanChartBaseAxisGlyph;
        }
        return this.getDefaultXAxisGlyph();
    }

    protected double getCateValue(VanChartBaseAxisGlyph vanChartBaseAxisGlyph, DataPoint dataPoint, boolean bl) {
        if (ComparatorUtils.equals((Object)((Object)vanChartBaseAxisGlyph.getVanAxisType()), (Object)((Object)AxisType.AXIS_CATEGORY))) {
            return (double)dataPoint.getCategoryIndex() + (vanChartBaseAxisGlyph.isDrawBetweenTick() && bl ? 0.5 : 0.0);
        }
        if (ComparatorUtils.equals((Object)((Object)vanChartBaseAxisGlyph.getVanAxisType()), (Object)((Object)AxisType.AXIS_VALUE))) {
            Number number = Utils.string2Number((String)dataPoint.getCategoryName());
            if (number != null) {
                return number.doubleValue();
            }
        } else {
            Date date = VanChartDateUtils.object2Date(dataPoint.getCategoryName(), true);
            if (date != null) {
                return ChartBaseUtils.date2Int((Date)date, (int)((VanChartTimeAxisGlyph)vanChartBaseAxisGlyph).getMainType().getTimeType());
            }
        }
        return 0.0;
    }

    protected int calculateLineDataCount(DataSeries dataSeries) {
        int n = 0;
        for (int i = 0; i < dataSeries.getDataPointCount(); ++i) {
            if (dataSeries.getDataPoint(i).isValueIsNull()) continue;
            ++n;
        }
        return n;
    }

    protected void trendLineFitting(double[] dArray, double[] dArray2, VanChartDataSeries vanChartDataSeries) {
        vanChartDataSeries.clearTrendLineGlyph();
        VanChartAttrTrendLine vanChartAttrTrendLine = this.getAttrTrendLine(vanChartDataSeries);
        if (vanChartAttrTrendLine != null && dArray.length > 1) {
            TrendLineGlyph trendLineGlyph = new TrendLineGlyph(ChartEquationType.LINEAR, 6, 5);
            try {
                trendLineGlyph.setLineStyleInfo((LineStyleInfo)vanChartAttrTrendLine.getLineStyleInfo().clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
            }
            this.initTrendLineGlyph(trendLineGlyph, dArray, dArray2);
            vanChartDataSeries.addTrendLineGlyph(trendLineGlyph);
        }
    }

    protected void initTrendLineGlyph(TrendLineGlyph trendLineGlyph, double[] dArray, double[] dArray2) {
        int n = dArray.length - 1;
        trendLineGlyph.fitting(dArray, dArray2);
        LinearEquation linearEquation = (LinearEquation)trendLineGlyph.getEquation();
        double d = linearEquation.execute(dArray[0]);
        double d2 = linearEquation.execute(dArray[n]);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(dArray[0], d);
        generalPath.lineTo(dArray[n], d2);
        generalPath.closePath();
        trendLineGlyph.setGeneralPath(generalPath);
    }

    @Override
    public void drawInfo(Graphics graphics, int n) {
        super.drawInfo(graphics, n);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxis(graphics, n);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    protected void drawAxis(Graphics graphics, int n) {
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.xAxisGlyphList) {
            if (vanChartBaseAxisGlyph == null) continue;
            vanChartBaseAxisGlyph.draw(graphics, n);
        }
        for (VanChartBaseAxisGlyph vanChartBaseAxisGlyph : this.yAxisGlyphList) {
            if (vanChartBaseAxisGlyph == null) continue;
            vanChartBaseAxisGlyph.draw(graphics, n);
        }
    }

    @Override
    public void addXAxisJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (AxisGlyph axisGlyph : this.xAxisGlyphList) {
            jSONArray.put((Object)axisGlyph.toJSONObject(repository));
        }
        jSONObject.put("xAxis", (Object)jSONArray);
    }

    @Override
    public void addYAxisJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (AxisGlyph axisGlyph : this.yAxisGlyphList) {
            jSONArray.put((Object)axisGlyph.toJSONObject(repository));
        }
        jSONObject.put("yAxis", (Object)jSONArray);
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        VanChartAttrTrendLine vanChartAttrTrendLine = this.getDefaultAttrTrendLine();
        if (vanChartAttrTrendLine != null && vanChartAttrTrendLine.getLineStyleInfo().getAttrLineStyle().getLineStyle() > 0) {
            jSONObject.put("trendLine", (Object)vanChartAttrTrendLine.toJSONObject(repository));
        }
        return jSONObject;
    }
}

