/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style;

import com.fr.base.BaseUtils;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.design.dialog.BasicPane;
import com.fr.design.gui.frpane.UIBubbleFloatPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.gui.icheckbox.UICheckBox;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.ispinner.UISpinner;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.PaneTitleConstants;
import com.fr.design.mainframe.chart.gui.style.ChartTextAttrPane;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartLegend;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.VanChartFloatPositionPane;
import com.fr.plugin.chart.designer.component.background.VanChartBackgroundWithOutImagePane;
import com.fr.plugin.chart.designer.component.border.VanChartBorderWithRadiusPane;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VanChartPlotLegendPane
extends BasicPane {
    private static final long serialVersionUID = 1614283200308877353L;
    private static final int WIDTH = 165;
    private static final int HEIGHT = 100;
    private static final int GAP = 20;
    protected UICheckBox isLegendVisible;
    protected JPanel legendPane;
    protected ChartTextAttrPane textAttrPane;
    protected VanChartBorderWithRadiusPane borderPane;
    protected VanChartBackgroundWithOutImagePane backgroundPane;
    protected UIButtonGroup<Integer> location;
    protected UIToggleButton customFloatPositionButton;
    protected VanChartFloatPositionPane customFloatPositionPane;
    protected UIButtonGroup<Integer> limitSize;
    protected UISpinner maxProportion;
    protected VanChartStylePane parent;

    public VanChartPlotLegendPane() {
        this.initComponents();
    }

    public VanChartPlotLegendPane(VanChartStylePane vanChartStylePane) {
        this.parent = vanChartStylePane;
        this.initComponents();
    }

    protected void initComponents() {
        this.isLegendVisible = new UICheckBox(Inter.getLocText((String)"Chart-Legend_Is_Visible"));
        this.legendPane = this.createLegendPane();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2};
        double[] dArray2 = new double[]{d, d, d};
        Component[][] componentArray = new Component[][]{{this.isLegendVisible}, {new JSeparator()}, {this.legendPane}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
        this.addLegendListener();
    }

    protected void addLegendListener() {
        this.isLegendVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartPlotLegendPane.this.checkBoxUse();
            }
        });
    }

    protected JPanel createLegendPane() {
        this.borderPane = new VanChartBorderWithRadiusPane();
        this.backgroundPane = new VanChartBackgroundWithOutImagePane();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{this.createTitlePositionPane(new double[]{d, d}, dArray), null}, {new JSeparator(), null}, {this.createTitleStylePane(), null}, {new JSeparator(), null}, {this.borderPane, null}, {this.backgroundPane, null}, {this.createDisplayStrategy(), null}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    protected JPanel createTitlePositionPane(double[] dArray, double[] dArray2) {
        String[] stringArray = new String[]{Inter.getLocText((String)"Chart-StyleAlignment_Top"), Inter.getLocText((String)"Chart-StyleAlignment_Bottom"), Inter.getLocText((String)"Chart-StyleAlignment_Left"), Inter.getLocText((String)"Chart-StyleAlignment_Right"), Inter.getLocText((String)"Chart-Right_Top")};
        Object[] objectArray = new Integer[]{1, 3, 2, 4, 8};
        Icon[] iconArray = new Icon[]{BaseUtils.readIcon((String)"/com/fr/design/images/chart/ChartLegend/layout_top.png"), BaseUtils.readIcon((String)"/com/fr/design/images/chart/ChartLegend/layout_bottom.png"), BaseUtils.readIcon((String)"/com/fr/design/images/chart/ChartLegend/layout_left.png"), BaseUtils.readIcon((String)"/com/fr/design/images/chart/ChartLegend/layout_right.png"), BaseUtils.readIcon((String)"/com/fr/design/images/chart/ChartLegend/layout_top_right.png")};
        this.location = new UIButtonGroup(iconArray, objectArray);
        this.location.setAllToolTips(stringArray);
        this.customFloatPositionButton = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_CustomFloatPosition"));
        this.customFloatPositionButton.setEventBannded(true);
        Component[][] componentArray = new Component[][]{{this.location, null}, {this.customFloatPositionButton, null}};
        this.customFloatPositionPane = new VanChartFloatPositionPane();
        this.initPositionListener();
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Chart-Layout_Position"), jPanel);
    }

    private void initPositionListener() {
        this.location.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                VanChartPlotLegendPane.this.customFloatPositionButton.setSelected(false);
                VanChartPlotLegendPane.this.checkDisplayStrategyUse();
            }
        });
        this.customFloatPositionButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!VanChartPlotLegendPane.this.customFloatPositionButton.isSelected()) {
                    VanChartPlotLegendPane.this.customFloatPositionButton.setSelected(true);
                    VanChartPlotLegendPane.this.checkDisplayStrategyUse();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                VanChartPlotLegendPane.this.location.setSelectedIndex(-1);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                if (VanChartPlotLegendPane.this.customFloatPositionPane == null) {
                    VanChartPlotLegendPane.this.customFloatPositionPane = new VanChartFloatPositionPane();
                }
                Point point = VanChartPlotLegendPane.this.customFloatPositionButton.getLocationOnScreen();
                Point point2 = new Point(point.x + VanChartPlotLegendPane.this.customFloatPositionButton.getWidth() / 2 - 20, point.y + VanChartPlotLegendPane.this.customFloatPositionButton.getHeight());
                UIBubbleFloatPane uIBubbleFloatPane = new UIBubbleFloatPane(1, point2, VanChartPlotLegendPane.this.customFloatPositionPane, 165, 100){

                    public void updateContentPane() {
                        VanChartPlotLegendPane.this.parent.attributeChanged();
                    }
                };
                uIBubbleFloatPane.show((JComponent)((Object)VanChartPlotLegendPane.this), null);
            }
        });
    }

    private JPanel createTitleStylePane() {
        this.textAttrPane = new ChartTextAttrPane();
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Designer-Widget_Style"), (Component)this.textAttrPane);
    }

    protected JPanel createDisplayStrategy() {
        this.maxProportion = new UISpinner(0.0, 100.0, 1.0, 30.0);
        this.limitSize = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_LimitAreaSize"), Inter.getLocText((String)"Plugin-ChartF_NotLimitAreaSize")});
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2, d};
        double[] dArray2 = new double[]{d, d};
        Component[][] componentArray = new Component[][]{{this.limitSize, null}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_LegendMaxProportion") + ":"), this.maxProportion}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
        this.limitSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartPlotLegendPane.this.checkMaxProPortionUse();
            }
        });
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_DisplayStrategy"), jPanel);
    }

    protected void checkAllUse() {
        this.checkBoxUse();
        this.checkDisplayStrategyUse();
        this.repaint();
    }

    protected void checkDisplayStrategyUse() {
        this.limitSize.setEnabled(!this.customFloatPositionButton.isSelected());
        this.checkMaxProPortionUse();
    }

    private void checkMaxProPortionUse() {
        this.maxProportion.setEnabled(this.limitSize.getSelectedIndex() == 0 && this.limitSize.isEnabled());
    }

    protected void checkBoxUse() {
        this.isLegendVisible.setEnabled(true);
        this.legendPane.setVisible(this.isLegendVisible.isSelected());
    }

    public String title4PopupWindow() {
        return PaneTitleConstants.CHART_STYLE_LEGNED_TITLE;
    }

    public void updateBean(VanChartLegend vanChartLegend) {
        if (vanChartLegend == null) {
            vanChartLegend = new VanChartLegend();
        }
        vanChartLegend.setLegendVisible(this.isLegendVisible.isSelected());
        vanChartLegend.setFRFont(this.textAttrPane.updateFRFont());
        this.borderPane.update((GeneralInfo)vanChartLegend);
        this.backgroundPane.update((GeneralInfo)vanChartLegend);
        if (!this.customFloatPositionButton.isSelected()) {
            vanChartLegend.setPosition((Integer)this.location.getSelectedItem());
        } else {
            vanChartLegend.setPosition(-1);
        }
        vanChartLegend.setFloating(this.customFloatPositionButton.isSelected());
        vanChartLegend.setLimitSize(this.limitSize.getSelectedIndex() == 0);
        vanChartLegend.setMaxHeight(this.maxProportion.getValue());
        vanChartLegend.setFloatPercentX(this.customFloatPositionPane.getFloatPosition_x());
        vanChartLegend.setFloatPercentY(this.customFloatPositionPane.getFloatPosition_y());
    }

    public void populateBean(VanChartLegend vanChartLegend) {
        if (vanChartLegend != null) {
            this.isLegendVisible.setSelected(vanChartLegend.isLegendVisible());
            this.textAttrPane.populate(vanChartLegend.getFRFont());
            this.borderPane.populate((GeneralInfo)vanChartLegend);
            this.backgroundPane.populate((GeneralInfo)vanChartLegend);
            if (!vanChartLegend.isFloating()) {
                this.location.setSelectedItem((Object)vanChartLegend.getPosition());
            }
            this.customFloatPositionButton.setSelected(vanChartLegend.isFloating());
            this.customFloatPositionPane.setFloatPosition_x(vanChartLegend.getFloatPercentX());
            this.customFloatPositionPane.setFloatPosition_y(vanChartLegend.getFloatPercentY());
            this.limitSize.setSelectedIndex(vanChartLegend.isLimitSize() ? 0 : 1);
            this.maxProportion.setValue(vanChartLegend.getMaxHeight());
        }
        this.checkAllUse();
    }
}

