/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr;

import com.fr.base.CoreDecimalFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.GradientBackground;
import com.fr.base.background.ImageBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.MarkerType;
import com.fr.plugin.chart.attr.axis.AxisTickLineType;
import com.fr.plugin.chart.attr.axis.TimeType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.axis.VanChartValueAxis;
import com.fr.plugin.chart.base.AttrSeriesImageBackground;
import com.fr.plugin.chart.base.AttrTooltipContent;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.scatter.VanChartScatterDataPoint;
import com.fr.plugin.chart.scatter.VanChartScatterPlotGlyph;
import com.fr.plugin.chart.scatter.attr.ScatterAttrTooltipContent;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Image;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;

public class VanChartAttrHelper {
    public static final double PERCENT = 100.0;
    public static final String STRING_PERCENT = "%";
    public static final DecimalFormat PERCENT_FORMAT = new CoreDecimalFormat(new DecimalFormat("#.##%"), "#.##%");
    public static final DecimalFormat VALUE_FORMAT = new CoreDecimalFormat(new DecimalFormat("#.##"), "#.##");
    private static final String BREAK = ",";
    private static final String COLON = ":";
    public static final String NEWLINE = "\n";
    public static final String LEFT_BRACKET = "(";
    public static final String RIGHT_BRACKET = ")";
    public static final double HALF_ALPHA = 0.5;
    public static final String PT = "pt";
    public static final String BOLD = "bold";
    public static final String ITALIC = "italic";
    public static final FRFont DEFAULT_LABEL_FONT = FRFont.getInstance((String)"verdana", (int)1, (float)9.0f, (Color)Color.black);
    public static final FRFont DEFAULT_AXIS_TITLE_LABLE_FONT = FRFont.getInstance((String)"verdana", (int)0, (float)11.0f, (Color)new Color(102, 102, 102));
    public static final String TRANSPARENT_COLOR = "rgba(255,255,255,0)";
    private static final double DEFAULT_GRADIENT_VALUE_MIN = 0.0;
    private static final double DEFAULT_GRADIENT_VALUE_MAX = 1.0;
    public static final String X_AXIS_PREFIX = Inter.getLocText((String)"ChartF-X_Axis");
    public static final String Y_AXIS_PREFIX = Inter.getLocText((String)"ChartF-Y_Axis");
    public static final Color DEFAULT_MAIN_GRID_COLOR = new Color(196, 196, 196);
    public static final FRFont DEFAULT_RADAR_AXIS_LABLE_FONT = FRFont.getInstance((String)"verdana", (int)0, (float)9.0f, (Color)new Color(102, 102, 102));

    public static Format getNotNullValueFormat(Format format) {
        return format == null ? VALUE_FORMAT : format;
    }

    public static Background getNotNullBackground(Background background) {
        return background == null ? ColorBackground.getInstance((Color)Color.WHITE) : background;
    }

    public static String getStringColor(Color color) {
        return color == null ? TRANSPARENT_COLOR : StableUtils.javaColorToCSSColor((Color)color);
    }

    public static String getRGBAColorWithColorAndAlpha(Color color, double d) {
        return VanChartAttrHelper.getRGBAColorWithColorAndAlpha(color, (float)d);
    }

    public static String getRGBAColorWithColorAndAlpha(Color color, float f) {
        color = color == null ? new Color(255, 255, 255, 0) : new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(f * 255.0f));
        return StableUtils.javaColor2JSColorWithAlpha((Color)color);
    }

    public static JSONObject getGradientBackgroundJSON(GradientBackground gradientBackground, float f) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("x1", 0.0);
        jSONObject.put("y1", 0.0);
        if (gradientBackground.getDirection() == 0) {
            jSONObject.put("x2", 1.0);
            jSONObject.put("y2", 0.0);
        } else {
            jSONObject.put("x2", 0.0);
            jSONObject.put("y2", 1.0);
        }
        jSONObject.put("startColor", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(gradientBackground.getStartColor(), f));
        jSONObject.put("endColor", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(gradientBackground.getEndColor(), f));
        return jSONObject;
    }

    public static String getImageBackground(ImageBackground imageBackground, Repository repository) {
        Image image = imageBackground.getImage();
        if (image == null) {
            return "";
        }
        String string = ChartBaseUtils.addImageAsEmb((Image)image);
        return repository.getServletURL() + "?op=fr_attach&cmd=ah_image&id=" + string;
    }

    public static void addImageBackgroundAndWidthAndHeight(JSONObject jSONObject, AttrSeriesImageBackground attrSeriesImageBackground, Repository repository) throws JSONException {
        ImageBackground imageBackground = (ImageBackground)attrSeriesImageBackground.getSeriesBackground();
        if (imageBackground == null || imageBackground.getImage() == null) {
            return;
        }
        int n = imageBackground.getImage().getWidth(new JPanel());
        int n2 = imageBackground.getImage().getHeight(new JPanel());
        jSONObject.put("image", (Object)VanChartAttrHelper.getImageBackground(imageBackground, repository));
        jSONObject.put("imageWidth", n);
        jSONObject.put("imageHeight", n2);
    }

    public static JSONObject getCSSFontJSONWithFont(FRFont fRFont) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (fRFont == null) {
            return jSONObject;
        }
        jSONObject.put("fontFamily", (Object)fRFont.getName());
        jSONObject.put("fontSize", (Object)(fRFont.getSize() + PT));
        jSONObject.put("color", (Object)StableUtils.javaColor2JSColorWithAlpha((Color)fRFont.getForeground()));
        if (StringUtils.contains((String)fRFont.getStyleName(), (String)Inter.getLocText((String)"FR-Designer-FRFont_Bold"))) {
            jSONObject.put("fontWeight", (Object)BOLD);
        } else {
            jSONObject.put("fontWeight", (Object)"");
        }
        if (StringUtils.contains((String)fRFont.getStyleName(), (String)Inter.getLocText((String)"FR-Designer-FRFont_Italic"))) {
            jSONObject.put("fontStyle", (Object)ITALIC);
        }
        return jSONObject;
    }

    public static int getAxisLineStyle(int n) {
        switch (n) {
            case 5: {
                return 3;
            }
            case 21: {
                return 1;
            }
            case 22: {
                return 2;
            }
            case 23: {
                return 3;
            }
        }
        return n;
    }

    public static void addDashLineStyleJSON(JSONObject jSONObject, int n) throws JSONException {
        int n2 = n;
        boolean bl = false;
        switch (n) {
            case 5: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 1;
                bl = true;
                break;
            }
            case 3: {
                n2 = 2;
                bl = true;
                break;
            }
            case 8: {
                n2 = 3;
                bl = true;
            }
        }
        jSONObject.put("width", n2);
        if (bl) {
            jSONObject.put("dashStyle", (Object)"Dash");
        }
    }

    public static String getPlotStyle(int n) {
        switch (n) {
            case 4: {
                return "gradual";
            }
            case 0: {
                return "normal";
            }
        }
        return "normal";
    }

    public static String getLabelText(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        if (attrTooltipContent.isCommon()) {
            return VanChartAttrHelper.getCateAndSeries(attrTooltipContent, dataPoint) + VanChartAttrHelper.getValueAndPercent(attrTooltipContent, dataPoint);
        }
        return "";
    }

    public static String getScatterLabelText(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        if (attrTooltipContent.isCommon()) {
            return VanChartAttrHelper.getScatterSeries(attrTooltipContent, dataPoint) + VanChartAttrHelper.getScatterXAndYAndSize(attrTooltipContent, dataPoint);
        }
        return "";
    }

    public static String getScatterSeries(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        String string = "";
        if (attrTooltipContent.getSeriesFormat().isEnable()) {
            string = string + VanChartAttrHelper.getStringWithFormat(dataPoint.getSeriesName(), attrTooltipContent.getSeriesFormat().getFormat());
        }
        return string;
    }

    public static String getScatterXAndYAndSize(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        VanChartScatterDataPoint vanChartScatterDataPoint = (VanChartScatterDataPoint)dataPoint;
        String string = "";
        ScatterAttrTooltipContent scatterAttrTooltipContent = (ScatterAttrTooltipContent)attrTooltipContent;
        if (scatterAttrTooltipContent.getXFormat().isEnable()) {
            string = string + (attrTooltipContent.getSeriesFormat().isEnable() ? NEWLINE : "");
            string = string + LEFT_BRACKET + VanChartAttrHelper.getStringWithFormat(dataPoint.getCategoryName(), scatterAttrTooltipContent.getXFormat().getFormat());
            string = string + (scatterAttrTooltipContent.getYFormat().isEnable() ? "" : RIGHT_BRACKET);
        }
        if (scatterAttrTooltipContent.getYFormat().isEnable()) {
            string = string + (scatterAttrTooltipContent.getXFormat().isEnable() ? BREAK : LEFT_BRACKET);
            string = string + VanChartAttrHelper.getValueStringWithFormat(dataPoint.getValue(), scatterAttrTooltipContent.getYFormat().getFormat());
            string = string + RIGHT_BRACKET;
        }
        if (scatterAttrTooltipContent.getSizeFormat().isEnable()) {
            string = scatterAttrTooltipContent.getXFormat().isEnable() || scatterAttrTooltipContent.getYFormat().isEnable() ? string + " " : (attrTooltipContent.getSeriesFormat().isEnable() ? string + NEWLINE : string + "");
            string = string + (vanChartScatterDataPoint.isSizeIsNull() ? "" : VanChartAttrHelper.getValueStringWithFormat(vanChartScatterDataPoint.getSizeValue(), scatterAttrTooltipContent.getSizeFormat().getFormat()));
        }
        return string;
    }

    public static String getCateAndSeries(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        String string = "";
        if (attrTooltipContent.getCategoryFormat().isEnable()) {
            string = string + VanChartAttrHelper.getStringWithFormat(dataPoint.getCategoryName(), attrTooltipContent.getCategoryFormat().getFormat());
        }
        if (attrTooltipContent.getSeriesFormat().isEnable()) {
            string = string + (attrTooltipContent.getCategoryFormat().isEnable() ? " " : "");
            string = string + VanChartAttrHelper.getStringWithFormat(dataPoint.getSeriesName(), attrTooltipContent.getSeriesFormat().getFormat());
        }
        return string;
    }

    public static String getValueAndPercent(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        String string = "";
        if (attrTooltipContent.getValueFormat().isEnable()) {
            string = string + (attrTooltipContent.getCategoryFormat().isEnable() || attrTooltipContent.getSeriesFormat().isEnable() ? NEWLINE : "");
            string = string + (dataPoint.isValueIsNull() ? "" : VanChartAttrHelper.getValueStringWithFormat(dataPoint.getValue(), attrTooltipContent.getValueFormat().getFormat()));
        }
        if (attrTooltipContent.getPercentFormat().isEnable()) {
            string = attrTooltipContent.getValueFormat().isEnable() ? string + " " : string + (attrTooltipContent.getCategoryFormat().isEnable() || attrTooltipContent.getSeriesFormat().isEnable() ? NEWLINE : "");
            string = string + VanChartAttrHelper.getValueStringWithFormat(dataPoint.getPercentValue(), attrTooltipContent.getPercentFormat().getFormat());
        }
        return string;
    }

    public static String getCategoryName(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        if (attrTooltipContent.isCommon() && attrTooltipContent.getCategoryFormat().isEnable()) {
            return VanChartAttrHelper.getStringWithFormat(dataPoint.getCategoryName(), attrTooltipContent.getCategoryFormat().getFormat());
        }
        return "";
    }

    public static String getPercent(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        if (attrTooltipContent.isCommon() && attrTooltipContent.getPercentFormat().isEnable()) {
            return VanChartAttrHelper.getValueStringWithFormat(dataPoint.getPercentValue(), attrTooltipContent.getPercentFormat().getFormat());
        }
        return "";
    }

    public static String getLabelWithOutCategory(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        String string = "";
        if (attrTooltipContent.isCommon()) {
            if (attrTooltipContent.getSeriesFormat().isEnable()) {
                string = string + VanChartAttrHelper.getStringWithFormat(dataPoint.getSeriesName(), attrTooltipContent.getSeriesFormat().getFormat());
            }
            if (attrTooltipContent.getValueFormat().isEnable()) {
                string = string + (attrTooltipContent.getSeriesFormat().isEnable() ? COLON : "");
                string = string + VanChartAttrHelper.getValueStringWithFormat(dataPoint.getValue(), attrTooltipContent.getValueFormat().getFormat());
            }
            if (attrTooltipContent.getPercentFormat().isEnable()) {
                string = string + (attrTooltipContent.getSeriesFormat().isEnable() || attrTooltipContent.getValueFormat().isEnable() ? " " : "");
                string = string + VanChartAttrHelper.getValueStringWithFormat(dataPoint.getPercentValue(), attrTooltipContent.getPercentFormat().getFormat());
            }
        }
        return string;
    }

    public static String getCateAndValue(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        String string = "";
        if (attrTooltipContent.isCommon()) {
            if (attrTooltipContent.getCategoryFormat().isEnable()) {
                string = string + VanChartAttrHelper.getStringWithFormat(dataPoint.getCategoryName(), attrTooltipContent.getCategoryFormat().getFormat());
            }
            if (attrTooltipContent.getValueFormat().isEnable()) {
                string = string + (attrTooltipContent.getCategoryFormat().isEnable() ? COLON : "");
                string = string + VanChartAttrHelper.getValueStringWithFormat(dataPoint.getValue(), attrTooltipContent.getValueFormat().getFormat());
            }
        }
        return string;
    }

    public static String getSlotCateAndValue(AttrTooltipContent attrTooltipContent, DataPoint dataPoint) {
        String string = "";
        if (attrTooltipContent.isCommon()) {
            if (attrTooltipContent.getCategoryFormat().isEnable()) {
                string = string + VanChartAttrHelper.getStringWithFormat(dataPoint.getCategoryName(), attrTooltipContent.getCategoryFormat().getFormat());
            }
            if (attrTooltipContent.getValueFormat().isEnable()) {
                string = string + (attrTooltipContent.getCategoryFormat().isEnable() ? NEWLINE : "");
                string = string + VanChartAttrHelper.getValueStringWithFormat(dataPoint.getValue(), attrTooltipContent.getValueFormat().getFormat());
            }
        }
        return string;
    }

    public static String getValueStringWithFormat(double d, Format format) {
        format = VanChartAttrHelper.getNotNullValueFormat(format);
        String string = format.format(d);
        return Utils.objectToString((Object)string);
    }

    public static String getStringWithFormat(String string, Format format) {
        if (format == null) {
            return string;
        }
        Number number = Utils.objectToNumber((Object)string, (boolean)true);
        if (number != null && format instanceof NumberFormat) {
            return format.format(number);
        }
        Date date = DateUtils.object2Date((Object)string, (boolean)true);
        if (date != null && format instanceof DateFormat) {
            return format.format(date);
        }
        return string;
    }

    public static GeneralInfo createDefaultTooltipBackground() {
        GeneralInfo generalInfo = new GeneralInfo();
        ColorBackground colorBackground = ColorBackground.getInstance((Color)Color.black);
        generalInfo.setBackground((Background)colorBackground);
        generalInfo.setAlpha(0.5f);
        generalInfo.setRoundRadius(2);
        return generalInfo;
    }

    public static boolean isXAxis(String string) {
        return StringUtils.contains((String)string, (String)X_AXIS_PREFIX);
    }

    public static boolean isDefaultAxis(String string) {
        return ComparatorUtils.equals((Object)string, (Object)X_AXIS_PREFIX) || ComparatorUtils.equals((Object)string, (Object)Y_AXIS_PREFIX);
    }

    public static List<VanChartAxis> createDefaultXAxisList() {
        ArrayList<VanChartAxis> arrayList = new ArrayList<VanChartAxis>();
        VanChartAxis vanChartAxis = new VanChartAxis(X_AXIS_PREFIX, 3);
        arrayList.add(vanChartAxis);
        return arrayList;
    }

    public static List<VanChartAxis> createDefaultYAxisList() {
        ArrayList<VanChartAxis> arrayList = new ArrayList<VanChartAxis>();
        VanChartValueAxis vanChartValueAxis = new VanChartValueAxis(Y_AXIS_PREFIX, 2);
        vanChartValueAxis.setAxisStyle(0);
        vanChartValueAxis.setMainTickLine(AxisTickLineType.TICK_LINE_NONE);
        arrayList.add(vanChartValueAxis);
        return arrayList;
    }

    public static List<VanChartAxis> createScatterXAxisList() {
        ArrayList<VanChartAxis> arrayList = new ArrayList<VanChartAxis>();
        VanChartValueAxis vanChartValueAxis = new VanChartValueAxis(X_AXIS_PREFIX, 3);
        arrayList.add(vanChartValueAxis);
        return arrayList;
    }

    public static List<VanChartAxis> createRadarYAxisList() {
        ArrayList<VanChartAxis> arrayList = new ArrayList<VanChartAxis>();
        VanChartValueAxis vanChartValueAxis = new VanChartValueAxis(Y_AXIS_PREFIX, 2);
        vanChartValueAxis.setMainGridColor(DEFAULT_MAIN_GRID_COLOR);
        vanChartValueAxis.getTextAttr().setFRFont(DEFAULT_RADAR_AXIS_LABLE_FONT);
        arrayList.add(vanChartValueAxis);
        return arrayList;
    }

    public static List<VanChartAxis> createRadarXAxisList() {
        ArrayList<VanChartAxis> arrayList = new ArrayList<VanChartAxis>();
        VanChartAxis vanChartAxis = new VanChartAxis(X_AXIS_PREFIX, 3);
        vanChartAxis.getTextAttr().setFRFont(DEFAULT_RADAR_AXIS_LABLE_FONT);
        arrayList.add(vanChartAxis);
        return arrayList;
    }

    public static VanChartAxis createDefaultY2Axis() {
        VanChartValueAxis vanChartValueAxis = new VanChartValueAxis(Y_AXIS_PREFIX + "2", 4);
        vanChartValueAxis.setAxisStyle(0);
        vanChartValueAxis.setMainTickLine(AxisTickLineType.TICK_LINE_NONE);
        return vanChartValueAxis;
    }

    public static List<VanChartAxis> createDefaultBarXAxisList() {
        ArrayList<VanChartAxis> arrayList = new ArrayList<VanChartAxis>();
        VanChartValueAxis vanChartValueAxis = new VanChartValueAxis(X_AXIS_PREFIX, 3);
        vanChartValueAxis.setAxisStyle(0);
        vanChartValueAxis.setMainTickLine(AxisTickLineType.TICK_LINE_NONE);
        arrayList.add(vanChartValueAxis);
        return arrayList;
    }

    public static List<VanChartAxis> createDefaultBarYAxisList() {
        ArrayList<VanChartAxis> arrayList = new ArrayList<VanChartAxis>();
        VanChartAxis vanChartAxis = new VanChartAxis(Y_AXIS_PREFIX, 2);
        arrayList.add(vanChartAxis);
        return arrayList;
    }

    public static VanChartAxis createDefaultBarX2Axis() {
        VanChartValueAxis vanChartValueAxis = new VanChartValueAxis(X_AXIS_PREFIX + "2", 1);
        vanChartValueAxis.setAxisStyle(0);
        vanChartValueAxis.setMainTickLine(AxisTickLineType.TICK_LINE_NONE);
        return vanChartValueAxis;
    }

    public static String[] getAllAxisNames(List<VanChartAxis> list, List<VanChartAxis> list2) {
        int n;
        int n2 = list.size();
        int n3 = list2.size();
        String[] stringArray = new String[n2 + n3];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = list.get(n).getAxisName();
        }
        for (n = 0; n < n3; ++n) {
            stringArray[n + n2] = list2.get(n).getAxisName();
        }
        return stringArray;
    }

    public static String[] getAxisNames(List<VanChartAxis> list) {
        int n = list.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = list.get(i).getAxisName();
        }
        return stringArray;
    }

    public static long getTimeTypeSecond(TimeType timeType) {
        return VanChartAttrHelper.getTimeTypeMilliSecond(timeType) / 1000L;
    }

    public static long getTimeTypeMilliSecond(TimeType timeType) {
        switch (timeType) {
            case TIME_SECOND: {
                return 1000L;
            }
            case TIME_YEAR: {
                return 31104000000L;
            }
            case TIME_MINUTE: {
                return 60000L;
            }
            case TIME_HOUR: {
                return 3600000L;
            }
            case TIME_MONTH: {
                return 2592000000L;
            }
            case TIME_DAY: {
                return 86400000L;
            }
        }
        return 86400000L;
    }

    public static long getTimeTypeMilliSecond4MinMax(TimeType timeType) {
        switch (timeType) {
            case TIME_SECOND: {
                return 1000L;
            }
            case TIME_MINUTE: {
                return 60000L;
            }
            case TIME_HOUR: {
                return 3600000L;
            }
        }
        return 86400000L;
    }

    public static String getMarkerType(MarkerType markerType) {
        switch (markerType) {
            case MARKER_NULL: {
                return "null_marker";
            }
            case MARKER_CIRCLE: {
                return "circle";
            }
            case MARKER_CIRCLE_HOLLOW: {
                return "circle_hollow";
            }
            case MARKER_DIAMOND: {
                return "diamond";
            }
            case MARKER_DIAMOND_HOLLOW: {
                return "diamond_hollow";
            }
            case MARKER_SQUARE: {
                return "square";
            }
            case MARKER_SQUARE_HOLLOW: {
                return "square_hollow";
            }
            case MARKER_TRIANGLE: {
                return "triangle";
            }
            case MARKER_TRIANGLE_HOLLOW: {
                return "triangle_hollow";
            }
        }
        return "null_marker";
    }

    public static String getDefaultMarkerType(int n) {
        MarkerType[] markerTypeArray = new MarkerType[]{MarkerType.MARKER_CIRCLE, MarkerType.MARKER_CIRCLE_HOLLOW, MarkerType.MARKER_SQUARE, MarkerType.MARKER_SQUARE_HOLLOW, MarkerType.MARKER_DIAMOND, MarkerType.MARKER_DIAMOND_HOLLOW, MarkerType.MARKER_TRIANGLE, MarkerType.MARKER_TRIANGLE_HOLLOW};
        return markerTypeArray[n % markerTypeArray.length].getType();
    }

    public static String getFormatFunction(Format format) {
        String string = ChartBaseUtils.format2JS((Format)format);
        string = string == null ? "" : string;
        return String.format("function(){return window.FR ? FR.contentFormat(arguments[0], '%s') : arguments[0]}", string);
    }

    public static String getIntervalLegendFormatFunction(Format format) {
        String string = ChartBaseUtils.format2JS((Format)format);
        string = string == null ? "" : string;
        return String.format("function(){return (window.FR ? FR.contentFormat(this.from, '%s') : this.from) + '-' + (window.FR ? FR.contentFormat(this.to, '%s') : this.to)}", string, string);
    }

    public static boolean largeDataModel(Chart chart) {
        return chart == null ? false : chart.getDataProcessor().getMark() == 1;
    }

    public static double[] getScatterMinAndMaxValue(VanChartScatterPlotGlyph vanChartScatterPlotGlyph, double d, double d2) {
        int n = vanChartScatterPlotGlyph.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)vanChartScatterPlotGlyph.getSeries(i);
            int n2 = vanChartDataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                VanChartScatterDataPoint vanChartScatterDataPoint = (VanChartScatterDataPoint)vanChartDataSeries.getDataPoint(j);
                double d3 = vanChartScatterPlotGlyph.getDataPointValue(vanChartScatterDataPoint);
                if (!vanChartScatterPlotGlyph.isDisplayDataPointWithAttrBubble(vanChartScatterDataPoint) || vanChartScatterPlotGlyph.isDataPointValueIsNull(vanChartScatterDataPoint)) continue;
                d2 = Math.max(d3, d2);
                d = Math.min(d3, d);
            }
        }
        return new double[]{d, d2};
    }

    public static double roundValue(double d, boolean bl) {
        if (bl) {
            return d > 0.0 ? Math.ceil(d) : -Math.floor(-d);
        }
        return d > 0.0 ? Math.floor(d) : -Math.ceil(-d);
    }
}

