/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp.server;

import cn.com.jshx.smgp.bean.Deliver;
import cn.com.jshx.smgp.bean.Login;
import cn.com.jshx.smgp.bean.Submit;
import cn.com.jshx.smgp.message.ActiveTestMessage;
import cn.com.jshx.smgp.message.ActiveTestRespMessage;
import cn.com.jshx.smgp.message.DeliverMessage;
import cn.com.jshx.smgp.message.ExitRespMessage;
import cn.com.jshx.smgp.message.LoginMessage;
import cn.com.jshx.smgp.message.LoginRespMessage;
import cn.com.jshx.smgp.message.Package;
import cn.com.jshx.smgp.message.SubmitMessage;
import cn.com.jshx.smgp.message.SubmitRespMessage;
import cn.com.jshx.smgp.protocol.RequestId;
import cn.com.jshx.smgp.server.Server;
import cn.com.jshx.smgp.server.result.LoginResult;
import cn.com.jshx.smgp.server.result.SubmitResult;
import cn.com.jshx.util.DateUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class ServerHandleConnect
extends Thread {
    private Socket clientsocket;
    private String ipaddress;
    private String account;
    private int loginMode = 0;
    private DataInputStream in;
    private DataOutputStream out;
    private Server serversim;
    private Long LastActiveTime;
    private int TimeOut;
    private boolean hasLogin = false;

    public ServerHandleConnect(Server server2, Socket socket, int timeout) {
        this.serversim = server2;
        this.clientsocket = socket;
        this.TimeOut = timeout;
    }

    @Override
    public void run() {
        try {
            this.clientsocket.setSoTimeout(this.TimeOut * 1000);
            this.in = new DataInputStream(this.clientsocket.getInputStream());
            this.out = new DataOutputStream(this.clientsocket.getOutputStream());
            block10: while (true) {
                int PackLen;
                if ((PackLen = this.in.readInt()) > 2500) {
                    this.exit();
                }
                byte[] Message2 = new byte[PackLen - 4];
                this.in.read(Message2);
                this.LastActiveTime = DateUtil.getTimeStampL();
                Package mpackage = new Package(Message2);
                int SequenceId = mpackage.SequenceId;
                if (this.hasLogin || mpackage.ReqestId == RequestId.ActiveTest || mpackage.ReqestId == RequestId.ActiveTest_Resp || mpackage.ReqestId == RequestId.Login) {
                    switch (mpackage.ReqestId) {
                        case 1: {
                            LoginMessage loginMessage = new LoginMessage(Message2);
                            this.ipaddress = this.clientsocket.getRemoteSocketAddress().toString();
                            if (this.ipaddress.indexOf("/") == 0) {
                                this.ipaddress = this.ipaddress.substring(1);
                            }
                            if (this.ipaddress.indexOf(":") > 0) {
                                this.ipaddress = this.ipaddress.substring(0, this.ipaddress.indexOf(":"));
                            }
                            byte[] AuthenticatorClient = loginMessage.getAuthenticatorClient();
                            Login login = new Login(loginMessage, this.ipaddress);
                            LoginResult loginresult = this.serversim.onLogin(login, this);
                            LoginRespMessage loginRespMessage = new LoginRespMessage(SequenceId, loginresult.getStatus(), AuthenticatorClient, loginresult.getShareKey(), loginresult.getServerVersion());
                            this.SendBuf(loginRespMessage.getBuf());
                            if (loginresult.getStatus() == 0) {
                                this.account = login.Account;
                                this.hasLogin = true;
                                this.setLoginMode(login.LoginMode);
                                continue block10;
                            }
                            this.exit();
                            continue block10;
                        }
                        case 2: {
                            SubmitMessage submitMessage = new SubmitMessage(Message2);
                            Submit submit = submitMessage.getSubmit();
                            SubmitResult submitResult = this.serversim.onSumit(submit, this.account);
                            SubmitRespMessage submitRespMessage = new SubmitRespMessage(SequenceId, submitResult.getStatus(), submitResult.getMsgID());
                            this.SendBuf(submitRespMessage.getBuf());
                            continue block10;
                        }
                        case 4: {
                            ActiveTestRespMessage activeTestRespMessage = new ActiveTestRespMessage(SequenceId);
                            this.SendBuf(activeTestRespMessage.getBuf());
                            continue block10;
                        }
                        case 6: {
                            ExitRespMessage exitRespMessage = new ExitRespMessage(SequenceId);
                            this.SendBuf(exitRespMessage.getBuf());
                            continue block10;
                        }
                        case -2147483645: {
                            continue block10;
                        }
                    }
                    continue;
                }
                System.out.println("Package Error!");
                this.exit();
            }
        }
        catch (SocketException e) {
            System.out.println("Client has close socket connect!");
            this.exit();
        }
        catch (IOException e) {
            System.out.println("Client Exit !");
            this.exit();
        }
    }

    public void SendDeliver(Deliver deliver) {
        DeliverMessage dlm = new DeliverMessage(deliver);
        try {
            this.SendBuf(dlm.getBuf());
        }
        catch (IOException e) {
            this.exit();
        }
    }

    public void ActiveTest() {
        this.checkConnect();
        if (this.hasLogin) {
            ActiveTestMessage activeTestMessage = new ActiveTestMessage();
            try {
                this.SendBuf(activeTestMessage.getBuf());
            }
            catch (IOException e) {
                this.exit();
            }
        }
    }

    private void checkConnect() {
        if (DateUtil.getTimeStampL() - this.LastActiveTime > (long)(this.TimeOut * 1000)) {
            this.exit();
        }
    }

    private void exit() {
        if (this.hasLogin) {
            this.serversim.disconnect(this.account, this.ipaddress, this);
        } else {
            this.serversim.disconnect(this);
        }
    }

    private synchronized void SendBuf(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    public void setLoginMode(int loginMode) {
        this.loginMode = loginMode;
    }

    public int getLoginMode() {
        return this.loginMode;
    }

    public String getIpaddress() {
        return this.ipaddress;
    }

    public String getAccount() {
        return this.account;
    }
}

