/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.sender;

import cn.com.jshx.isag.ChargingInformation;
import cn.com.jshx.isag.PolicyException;
import cn.com.jshx.isag.ServiceException;
import cn.com.jshx.isag.SimpleReference;
import cn.com.jshx.isag.send.SendSmsServiceLocator;
import cn.com.jshx.isag.send.interfaces.SendSms;
import cn.com.jshx.isag.util.Correlator;
import cn.com.jshx.sender.interfaces.Sender;
import cn.com.jshx.util.Config;
import cn.com.jshx.util.ISAGSenderMemory;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Map;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ISAGSender
implements Sender {
    private static final Log logger = LogFactory.getLog(ISAGSender.class);
    private static String wsUrl = Config.getProperty("isag_url");
    private static String senderNamePro = Config.getProperty("isag_send_name");

    @Override
    public int send(String mobile, String content) {
        String correlator = "";
        try {
            URL url = new URL(wsUrl);
            SendSmsServiceLocator ssl = new SendSmsServiceLocator();
            SendSms service = ssl.getSendSms(url);
            URI[] uri = new URI[1];
            String reqId = null;
            uri[0] = new URI("tel:" + mobile);
            SimpleReference receiptRequest = this.getreceiptRequest(mobile);
            correlator = receiptRequest.getCorrelator();
            ISAGSenderMemory.getInstance().add(correlator, 0x100002);
            reqId = service.sendSms(uri, senderNamePro, this.getCharging(), content, receiptRequest);
            int result = ISAGSenderMemory.getInstance().getResult(correlator);
            if (result == 0x100002) {
                result = 0x100001;
            }
            logger.info((Object)result);
            return result;
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Send message exception, message:" + e.getMessage()));
            e.printStackTrace();
        }
        catch (ServiceException e) {
            logger.error((Object)("Send message exception, message:" + e.getMessage()));
            e.printStackTrace();
        }
        catch (URI.MalformedURIException e) {
            logger.error((Object)("Send message exception, message:" + e.getMessage()));
            e.printStackTrace();
        }
        catch (PolicyException e) {
            logger.error((Object)("Send message exception, message:" + e.getMessage()));
            e.printStackTrace();
        }
        catch (RemoteException e) {
            logger.error((Object)("Send message exception, message:" + e.getMessage()));
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)("Send message exception, message:" + e.getMessage()));
            e.printStackTrace();
        }
        ISAGSenderMemory.getInstance().remove(correlator);
        return 0xFFFFFF;
    }

    private SimpleReference getreceiptRequest(String mobile) throws URI.MalformedURIException {
        SimpleReference receiptRequest = new SimpleReference();
        Correlator correlator = new Correlator();
        String correlatorValue = correlator.creatCorrelator(senderNamePro, mobile);
        receiptRequest.setCorrelator(correlatorValue);
        receiptRequest.setEndpoint(new URI("tel:1234567890A"));
        receiptRequest.setInterfaceName("sendSms");
        return receiptRequest;
    }

    private ChargingInformation getCharging() {
        return null;
    }

    @Override
    public int send(Map<String, String> map, String mobile, String content) {
        return 0;
    }
}

