$(function() {
	var $reportPane = $("<div class='reportPane'></div>");
	window.contentPane = FR.createWidget($.extend({renderEl : $reportPane}, ${panel_config}));
	// alex:此处必须把contentPane注册到FR.SessionMgr里面,不然下面初始化工具栏时的_g(sessionID)会返回null
	FR.SessionMgr.register('${sessionID}', contentPane);
	${widgetCss};
	var $toolbar_Conf = ${toolbar_conf};
	var float_toolbars = [];
	contentPane.on("init", function() {
		var regions = [{region:'center', el:$reportPane}];
		// 装载工具栏
		// carl:浮动工具栏假如在reportContent之后生成，那么它里面的背景在readContent的时候就会被clear，所以提前生成，afterload之后显示
        // contentPane.toolbar如果是多个工具栏就搞成数组
        if($toolbar_Conf.length > 1) {
            contentPane.toolbar = [];
        }
		FR.hasTopToolbar = false;
		FR.hasBottomToolbar = false;
		$.each($toolbar_Conf, function(idx, conf) {
            var toolbarSettings = $.extend(conf.toolbarConf, {disabled : false});
			var toolbar = FR.createWidget($.extend({
				type : "toolbar"
			}, toolbarSettings));
            if($toolbar_Conf.length == 1) {
                contentPane.toolbar = toolbar;
            } else {
                contentPane.toolbar.push(toolbar);
            }
			if (conf.position == 'north') {
				toolbar.element.addClass("fs-tab-content-top-toolbar");
				FR.hasTopToolbar = true;
				regions.push({region:conf.position, el:toolbar.element});
			}
			else if (conf.position == 'south') {
				FR.hasBottomToolbar = true;
				regions.push({region:conf.position, el:toolbar.element});
			} else {
				var position = {position:'absolute', 'z-index': 1};
				$.extend(position, conf.position);
				toolbar.element.css(position).appendTo($reportPane);
				float_toolbars[float_toolbars.length] = toolbar;
				float_toolbars[float_toolbars.length - 1].position = position;
				float_toolbars[float_toolbars.length - 1].element.css(position.left ? 'left' : 'right',9999);
			}
		});

		var $container = FR.createWidget({
			type : "border",
			items : regions,
			renderEl : "body"
		});

        function reLayout() {
            //ext的x-toolbar带了样式, 跟报表整合后, 会出现偏差导致反复doLayout.
            $('.x-toolbar').css('border-width', '0px 0px 0px 0px');
            $('.x-toolbar').css('padding', '0px');
            $container.doLayout();
        }

        reLayout();

        $(window).resize(function() {
            //ext 默认有个toolbar
            reLayout()
        })
	});
	contentPane.on("afterload", function(){
		// 显示浮动工具栏
		$.each(float_toolbars, function(idx, float_toolbar){
			float_toolbar.element.css(float_toolbar.position);
		});
	});
	
	(function() {
		${loading}
    }).apply(contentPane);
});