/**
 * Created by vito on 2016/12/19.
 *
 * +-----------------------------------------+
 * |+---------------------------------------+|
 * ||           forbidWordLabel             ||
 * |+---------------------------------------+|
 * |+---+ +-------------------------+        |
 * || l | |   useForbidWordSwitch   |        |
 * |+---+ +-------------------------+        |
 * |+---------------------------------------+|
 * ||           forbidWordContent           ||
 * ||+-----------------------------+ +-----+||
 * |||                             | | bar |||
 * ||+-----------------------------+ +-----+||
 * ||+-------------------------------------+||
 * |||               tagpane               |||
 * |||                                     |||
 * ||+-------------------------------------+||
 * |+---------------------------------------+|
 * |              ...another...              |
 * +-----------------------------------------+
 *
 */
(function ($) {
    var Constants = {
        FORBID_WORD_PANE: {
            SwitchWD: 'useForbidWordSwitch',
            EditWD: 'editForbidWord',
            ContentWD: 'forbidWordContent',
            TransferWD: 'fwTransferWD',
            AddCustomWD: 'addCustomFWWD',
            InputWD: 'forbidWordInputWD',
            Ajax: {
                SET_SELECTED: {
                    op: 'fs_psi',
                    cmd: 'set_config',
                    type: 'add_fw'
                },
                REMOVE_CUSTOM: {
                    op: 'fs_psi',
                    cmd: 'change_custom',
                    type: 'forbidword',
                    method: 'remove'
                },
                ADD_CUSTOM: {
                    op: 'fs_psi',
                    cmd: 'change_custom',
                    type: 'forbidword',
                    method: 'add'
                },
                GET_CUSTOM: {
                    op: 'fs_psi',
                    cmd: 'get_config',
                    type: 'customfw'
                }
            },
            I18n: {
                EditPaneTitle: 'FS-PSqlInj-FW_Edit_Title',
                AddCustomTitle: 'FS-PSqlInj-Custom_Forbid_Word',
                RemoveCustom: 'FS-PSqlInj-Remove_Custom_FW',
                AddCustom: 'FS-PSqlInj-Add_Custom_FW',
                AddCustomError: 'FS-PSqlInj-Exist_Custom_FW',
                InputHint: 'FS-PSqlInj-Forbid_Word_Input_Hint'
            }
        },

        SPECIAL_CHAR_PANE: {
            SwitchWD: 'useSpecialCharSwitch',
            EditWD: 'editSpecialChar',
            ContentWD: 'specialCharContent',
            TransferWD: 'scTransferWD',
            AddCustomWD: 'addCustomSCWD',
            InputWD: 'specialCharInputWD',
            Ajax: {
                SET_SELECTED: {
                    op: 'fs_psi',
                    cmd: 'set_config',
                    type: 'add_sc'
                },
                REMOVE_CUSTOM: {
                    op: 'fs_psi',
                    cmd: 'change_custom',
                    type: 'specialchar',
                    method: 'remove'
                },
                ADD_CUSTOM: {
                    op: 'fs_psi',
                    cmd: 'change_custom',
                    type: 'specialchar',
                    method: 'add'
                },
                GET_CUSTOM: {
                    op: 'fs_psi',
                    cmd: 'get_config',
                    type: 'customsc'
                }
            },
            I18n: {
                EditPaneTitle: 'FS-PSqlInj-SC_Edit_Title',
                AddCustomTitle: 'FS-PSqlInj-Custom_Special_Char',
                RemoveCustom: 'FS-PSqlInj-Remove_Custom_SC',
                AddCustom: 'FS-PSqlInj-ADD_Custom_SC',
                AddCustomError: 'FS-PSqlInj-Exist_Custom_SC',
                InputHint: ''
            }
        }


    };

    function getInitData() {
        var data = FS.Sync.ajax({
            url: FR.servletURL,
            type: 'POST',
            data: {
                op: 'fs_psi',
                cmd: 'get_config'
            }
        });
        for (var val in data) {
            if (_.isArray(data[val]) && data[val].length > 0) {
                data[val] = _.map(data[val], function (item) {
                    return {key: item, value: item};
                });
            }
        }
        return data;
    }

    function createAddCustomDialog(config) {
        var self = this;
        this.removeArr = [];
        var addDialog = new FR.Dialog({
            confirm: true,
            title: FR.i18nText(config.I18n.AddCustomTitle),
            width: 350,
            height: 250,
            doSize: true,
            resizeable: false,
            destroyOnClose: true,
            text4OK: FR.i18nText("FS-Generic-Simple_OK"),
            contentWidget: {
                type: 'absolute',
                items: [{
                    el: {
                        type: 'llabel',
                        levelStyle: 1,
                        width: 330,
                        value: FR.i18nText(config.I18n.RemoveCustom)
                    }, x: 10, y: 10
                }, {
                    el: {
                        type: 'tagpane',
                        widgetName: config.AddCustomWD,
                        width: 330,
                        height: 65,
                        isInitWithData: true,
                        async: {
                            url: FR.servletURL,
                            data: config.Ajax.GET_CUSTOM
                        },
                        baseCls: 'fs-tagpane-addcustom',
                        onAsyncSuccess: function (res) {
                            this.options.items = _.map(FR.jsonDecode(res).data, function (val) {
                                return {key: val, value: val};
                            });
                        },
                        renderTag: function (item) {
                            var $tag = $('<span/>').addClass('fs-tagpane-edittag').data('value', item);
                            $('<span/>').text(item.value).appendTo($tag);
                            $('<div/>').addClass('fs-tagpane-del').appendTo($tag);
                            return $tag;
                        },
                        tagClick: function (e) {
                            var target = e.target;
                            var edittag = $(target).closest('.fs-tagpane-edittag');
                            if (edittag.length > 0) {
                                var value = $(edittag[0]).data('value');
                                this.getWidgetByName(config.AddCustomWD).delItem(value);
                                self.removeArr.push(value);
                            }
                        }
                    }, x: 10, y: 45
                }, {
                    el: {
                        type: 'llabel',
                        levelStyle: 1,
                        width: 330,
                        value: FR.i18nText(config.I18n.AddCustom)
                    }, x: 10, y: 110
                }, {
                    el: {
                        type: 'text',
                        width: 120,
                        widgetName: config.InputWD,
                        watermark: FR.i18nText(config.I18n.InputHint),
                        autoSearch: true,
                        allowBlank: true
                    }, x: 10, y: 145
                }]
            },
            onOK: function () {
                var addWord = $.trim(this.getWidgetByName(config.InputWD).getValue());
                if (self.removeArr.length > 0) {
                    FR.Msg.confirm(FR.i18nText("FS-Generic-Simple_Delete"), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                        if (result) {
                            FS.Async.ajax({
                                url: FR.servletURL,
                                type: 'POST',
                                data: $.extend(config.Ajax.REMOVE_CUSTOM, {
                                    data: encodeURIComponent(_.map(self.removeArr, function (item) {
                                        return item.value;
                                    }).join('|'))
                                }),
                                success: function () {
                                    self.getWidgetByName(config.TransferWD).removeValues(self.removeArr);
                                }
                            });
                        }
                    });
                }
                if (addWord !== '') {
                    var newItem = {key: addWord, value: addWord};
                    FS.Async.ajax({
                        url: FR.servletURL,
                        type: 'POST',
                        data: $.extend(config.Ajax.ADD_CUSTOM, {
                            data: encodeURIComponent(addWord)
                        }),
                        success: function (res) {
                            var status = FR.jsonDecode(res).status;
                            if (status === 'ok') {
                                self.getWidgetByName(config.TransferWD).addToSelectedPane(newItem);
                            } else {
                                FR.Msg.toast(FR.i18nText(config.I18n.AddCustomError));
                            }
                        }
                    });
                }
            }
        });
        addDialog.setVisible(true);
    }

    function createEditPaneDialog(config) {
        var self = this;
        var dialog = new FR.Dialog({
            confirm: true,
            title: FR.i18nText(config.I18n.EditPaneTitle),
            width: 550,
            height: 445,
            doSize: true,
            resizeable: false,
            destroyOnClose: true,
            text4OK: FR.i18nText("FS-Generic-Simple_OK"),
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        el: {
                            type: 'quickbutton',
                            width: Math.max(80, FR.i18nTextWidth("FS-PSqlInj-Add_Custom_FW") + 30),
                            height: 28,
                            style: 'blue',
                            text: FR.i18nText(config.I18n.AddCustom),
                            handler: function () {
                                createAddCustomDialog.call(this, config);
                            }
                        }, x: 15, y: 12
                    },
                    {
                        el: {
                            type: 'search',
                            width: 230,
                            autoSearch: true,
                            onKeyup: function (e) {
                                if (!FR.isNavKeyPress(e)) {
                                    var keyword = this.getValue();
                                    this.getWidgetByName(config.TransferWD).search(keyword);
                                }
                            }
                        }, x: 300, y: 10
                    },
                    {
                        el: {
                            type: 'transfer',
                            widgetName: config.TransferWD
                        }, x: 15, y: 50
                    }]
            },
            onOK: function () {
                var widgetData = dialog.getWidgetByName(config.TransferWD).getValue();
                FS.Async.ajax({
                    url: FR.servletURL,
                    type: 'POST',
                    data: $.extend(config.Ajax.SET_SELECTED, {
                        selectedValue: encodeURIComponent(widgetData.selectedValue)
                    }),
                    success: function () {
                        self.getWidgetByName(config.ContentWD).refresh();
                    }
                });
            },
            onCancel: function () {
                self.getWidgetByName(config.ContentWD).refresh();
            }
        });
        return dialog;
    }

    var psiUI = function () {
        var self = this;
        var forbidWordLabel = {
            type: 'llabel',
            levelStyle: 1,
            value: FR.i18nText("FS-PSqlInj-Forbid_Word")
        };

        var useForbidWordSwitch = {
            type: 'tablepane',
            colSize: [Math.max(40, FR.i18nTextWidth("FS-PSqlInj-Use_Forbid_Word", 6.5) + 15), 122],
            rowSize: [25],
            vgap: 10,
            items: [
                [
                    {type: 'llabel', value: FR.i18nText("FS-PSqlInj-Use_Forbid_Word")},
                    {
                        type: 'switch',
                        widgetName: Constants.FORBID_WORD_PANE.SwitchWD,
                        onTurnOn: function () {
                            var res = FS.Sync.ajax({
                                url: FR.servletURL,
                                type: 'POST',
                                data: {
                                    op: 'fs_psi',
                                    cmd: 'set_config',
                                    type: 'set_fw',
                                    usefw: true
                                }
                            });
                            if (res.status === 'ok') {
                                setPaneEnable.call(self, Constants.FORBID_WORD_PANE, true);
                            }
                        },
                        onTurnOff: function () {
                            var res = FS.Sync.ajax({
                                url: FR.servletURL,
                                type: 'POST',
                                data: {
                                    op: 'fs_psi',
                                    cmd: 'set_config',
                                    type: 'set_fw',
                                    usefw: false
                                }
                            });
                            if (res.status === 'ok') {
                                setPaneEnable.call(self, Constants.FORBID_WORD_PANE, false);
                            }
                        }
                    }
                ]
            ]
        };

        var forbidWordContent = {
            type: 'tablepane',
            width: 730,
            colSize: [730],
            rowSize: ['auto', 'auto'],
            vgap: 5,
            items: [
                [{
                    type: 'tablepane',
                    colSize: [680, 50],
                    rowSize: [20],
                    items: [
                        [
                            {},
                            {
                                type: 'iconbutton',
                                widgetName: Constants.FORBID_WORD_PANE.EditWD,
                                text: FR.i18nText("FS-Generic-Simple_Edit"),
                                baseClass: 'fs-tagpane-bar',
                                handler: function () {
                                    var dialog = createEditPaneDialog.call(this, Constants.FORBID_WORD_PANE);
                                    dialog.setVisible(true);
                                    var data = getInitData();
                                    dialog.getWidgetByName(Constants.FORBID_WORD_PANE.TransferWD).setValue({
                                        selectedValue: data.SelectedForbidWord,
                                        unSelectedValue: data.UnSelectedForbidWord
                                    });
                                }
                            }
                        ]
                    ]
                }],
                [{
                    type: 'tagpane',
                    widgetName: Constants.FORBID_WORD_PANE.ContentWD,
                    isInitWithData: false,
                    async: {
                        url: FR.servletURL,
                        data: {
                            op: 'fs_psi',
                            cmd: 'get_config'
                        }
                    },
                    onAsyncSuccess: function (res) {
                        this.options.items = _.map(FR.jsonDecode(res).SelectedForbidWord, function (tag) {
                            return {key: tag, value: tag};
                        });
                    },
                    renderTag: function (item) {
                        var $tag = $('<span/>').addClass("fs-tagpane-seltag");
                        $('<span/>').text(item.value).appendTo($tag);
                        return $tag;
                    }
                }]
            ]
        };

        var specialCharLabel = {
            type: 'llabel',
            levelStyle: 1,
            value: FR.i18nText("FS-PSqlInj-Special_Char")
        };

        var useSpecialCharSwitch = {
            type: 'tablepane',
            colSize: [Math.max(40, FR.i18nTextWidth("FS-PSqlInj-Use_Escape", 6.5) + 15), 130],
            rowSize: [25],
            vgap: 10,
            items: [
                [
                    {type: 'llabel', value: FR.i18nText("FS-PSqlInj-Use_Escape")},
                    {
                        type: 'switch',
                        widgetName: Constants.SPECIAL_CHAR_PANE.SwitchWD,
                        onTurnOn: function () {
                            var res = FS.Sync.ajax({
                                url: FR.servletURL,
                                type: 'POST',
                                data: {
                                    op: 'fs_psi',
                                    cmd: 'set_config',
                                    type: 'set_sc',
                                    usesc: true
                                }
                            });
                            if (res.status === 'ok') {
                                setPaneEnable.call(self, Constants.SPECIAL_CHAR_PANE, true);
                            }
                        },
                        onTurnOff: function () {
                            var res = FS.Sync.ajax({
                                url: FR.servletURL,
                                type: 'POST',
                                data: {
                                    op: 'fs_psi',
                                    cmd: 'set_config',
                                    type: 'set_sc',
                                    usesc: false
                                }
                            });
                            if (res.status === 'ok') {
                                setPaneEnable.call(self, Constants.SPECIAL_CHAR_PANE, false);
                            }
                        }
                    }
                ]
            ]
        };

        var specialCharContent = {
            type: 'tablepane',
            width: 730,
            colSize: [730],
            rowSize: ['auto', 'auto'],
            vgap: 5,
            items: [
                [{
                    type: 'tablepane',
                    colSize: [680, 50],
                    rowSize: [25],
                    vgap: 10,
                    items: [
                        [
                            {},
                            {
                                type: 'iconbutton',
                                widgetName: Constants.SPECIAL_CHAR_PANE.EditWD,
                                text: FR.i18nText("FS-Generic-Simple_Edit"),
                                baseClass: 'fs-tagpane-bar',
                                handler: function () {
                                    var dialog = createEditPaneDialog.call(this, Constants.SPECIAL_CHAR_PANE);
                                    dialog.setVisible(true);
                                    var data = getInitData();
                                    dialog.getWidgetByName(Constants.SPECIAL_CHAR_PANE.TransferWD).setValue({
                                        selectedValue: data.SelectedSpecialChar,
                                        unSelectedValue: data.UnSelectedSpecialChar
                                    });
                                }
                            }
                        ]
                    ]
                }],
                [{
                    type: 'tagpane',
                    widgetName: Constants.SPECIAL_CHAR_PANE.ContentWD,
                    isInitWithData: false,
                    async: {
                        url: FR.servletURL,
                        data: {
                            op: 'fs_psi',
                            cmd: 'get_config'
                        }
                    },
                    onAsyncSuccess: function (res) {
                        this.options.items = _.map(FR.jsonDecode(res).SelectedSpecialChar, function (tag) {
                            return {key: tag, value: tag};
                        });
                    },
                    renderTag: function (item) {
                        var $tag = $('<span/>').addClass("fs-tagpane-seltag");
                        $('<span/>').text(item.value).appendTo($tag);
                        return $tag;
                    }
                }]
            ]
        };

        var forbidWordPane = {
            type: 'tablepane',
            width: 730,
            colSize: [730],
            rowSize: ['auto', 'auto', 'auto'],
            vgap: 15,
            items: [
                [forbidWordLabel],
                [useForbidWordSwitch],
                [forbidWordContent]
            ]
        };

        var specialCharPane = {
            type: 'tablepane',
            width: 730,
            colSize: [730],
            rowSize: ['auto', 'auto', 'auto'],
            vgap: 15,
            items: [
                [specialCharLabel],
                [useSpecialCharSwitch],
                [specialCharContent]
            ]
        };

        return {
            title: FR.i18nText("FS-PSqlInj_Title"),
            content: {
                widgetName: 'PreventSqlInjectPanel',
                type: 'tablepane',
                width: 730,
                colSize: [730],
                rowSize: ['auto', 'auto'],
                vgap: 50,
                items: [
                    [forbidWordPane],
                    [specialCharPane]
                ]
            }
        };
    };

    var popData = function () {
        var data = getInitData();
        this.setWidgetValue(Constants.FORBID_WORD_PANE.ContentWD, data.SelectedForbidWord);
        this.setWidgetValue(Constants.SPECIAL_CHAR_PANE.ContentWD, data.SelectedSpecialChar);
        this.setWidgetValue(Constants.FORBID_WORD_PANE.SwitchWD, data.useForbidWord);
        this.setWidgetValue(Constants.SPECIAL_CHAR_PANE.SwitchWD, data.useEscapeSpecialChar);
        setPaneEnable.call(this, Constants.FORBID_WORD_PANE, data.useForbidWord);
        setPaneEnable.call(this, Constants.SPECIAL_CHAR_PANE, data.useEscapeSpecialChar);
    };


    function setPaneEnable(config, enable) {
        this.tabPane.getWidgetByName(config.ContentWD).setEnable(enable);
        this.tabPane.getWidgetByName(config.EditWD).setEnable(enable);
    }

    FS.Plugin.SystemItems.push({
        ui: psiUI,
        pop: popData
    });
})(jQuery);