/**
 * Coder: Sean
 * Date: 13-10-19
 * Time: 下午4:08
 */

/**
 * 常量
 */
var Consts = {
    SERVERNAMEWD : "fs_mpview_server_name",
    SERVERADDRESSWD : "fs_mpview_server_address",
    UNAUTHPANELWD : "unauthPanel",
    AUTHPANELWD : "authPanel",
    MOVEBTNWD : "moveBtn",
    USERSELECTWD : "userSelect",
    MACADDRESSWD : "macAddress",
    ISMOBILEDEVBINDWD : "isMobileDevBind",
    PHONEFILEUPLOADWD : "phoneFileUpload",
    PADFILEUPLOADWD : "padFileUpload",
    PHONEIMGCLS : "fs_mpview_phoneimg",
    PADIMGCLS : "fs_mpview_padimg",
    QRIMGCLS : "fs_mpview_qrimg",
    UNAUTHPANELCONTENTCLS : "unauth_panel_content",
    AUTHPANELCONTENTCLS : "auth_panel_content",
    UNAUTHSEARCHER : "unauth_searcher",
    AUTHSEARCHER : "auth_searcher",

    basicConfigPanelWD: "basicConfigPanel",
    basicConfigTableWD: "basicConfigTable",
    userLimitConfigPanelWD: "userLimitConfigPanel",
    userLimitConfigTableWD: "userLimitConfigTable",
    userLimitUnauthorizedPanelWD: "userLimitUnauthorizedPanel",
    userLimitAuthorizedPanelWD: "userLimitAuthorizedPanel",
    userLimitUnauthorizedListWD: "userLimitUnauthorizedList",
    userLimitAuthorizedListWD: "userLimitAuthorizedList",
    userLimitUnauthorizedListPanelWD: "userLimitUnauthorizedListPanel",
    userLimitAuthorizedListPanelWD: "userLimitAuthorizedListPanel",
    userLimitAuthMoveRightButtonWD: "userLimitAuthMoveRightButton",
    userLimitAuthMoveLeftButtonWD: "userLimitAuthMoveLeftButton",
    deviceBindConfigPanelWD: "deviceBindConfigPanel",
    deviceBindConfigTableWD: "deviceBindConfigTable"
};

/**
 * 移动平台
 */
FS.MOBILEPLATE = FSMP = {

    /**
     * 视图
     */
    View : {
        /**
         * 创建LTabPane
         */
        createTabPane : function(render) {
            var self = this;
            this.renderEl = render;
            var tabs = [
                this.basicTabConfig(),
                this.devBindTabConfig(),
                this.qrCodeTabConfig()
            ];
            var resizeFns = [
                function (container, width, height) {
                    container.getWidgetByName(Consts.basicConfigPanelWD).doResize({
                        width: width,
                        height: height
                    });
                }, function (container, width, height) {
                    container.getWidgetByName(Consts.deviceBindConfigPanelWD).doResize({
                        width: width,
                        height: height
                    });
                }, function (container, width, height) {}
            ];
            var initActions = [
                function() {
                    this.getWidgetByName(Consts.basicConfigTableWD).doLayout();
                }, function() {
                    //设备绑定
                    this.getWidgetByName(Consts.deviceBindConfigTableWD).doLayout();
                    var isMobileDevBind = FS.config.ismobilebinddev;
                    if(isMobileDevBind === "false") {
                        self._getWidget(Consts.ISMOBILEDEVBINDWD).setValue(false, true);
                    } else {
                        self._getWidget(Consts.ISMOBILEDEVBINDWD).setValue(true, true);
                    }
                }, function() {
                    var qrServerName = FS.config.qrcodeServerName;
                    var qrServerUrl = FS.config.qrcodeServerUrl;
                    var qrImageId = FS.config.qrcodeImageID;
                    self._getWidget(Consts.SERVERNAMEWD).setValue(qrServerName);
                    self._getWidget(Consts.SERVERADDRESSWD).setValue(qrServerUrl);
                    if(qrImageId) {
                        var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + qrImageId + '&isAdjust=false');
                        $("img." + Consts.QRIMGCLS).attr("src", url);
                    }
                }
            ];
            // 移动设备用户访问限制
            if (FS.config.mobileUserAuthLimit > 0 && FS.isAdmin()) {
                var tabIndex = 1;
                tabs.splice(tabIndex, 0, this.userLimitTabConfig());
                resizeFns.splice(tabIndex, 0, function (container, width, height) {
                    container.getWidgetByName(Consts.userLimitConfigPanelWD).doResize({
                        width: width,
                        height: height - 70
                    });
                });
                initActions.splice(tabIndex, 0, function() {
                    this.getWidgetByName(Consts.userLimitAuthMoveLeftButtonWD).setEnable(false);
                    this.getWidgetByName(Consts.userLimitAuthMoveRightButtonWD).setEnable(false);
                    this.getWidgetByName(Consts.userLimitConfigTableWD).element.css("overflow", "auto");
                    this.getWidgetByName(Consts.userLimitUnauthorizedPanelWD).element.css({
                        position: "relative",
                        overflow: "visible"
                    });
                    this.getWidgetByName(Consts.userLimitAuthorizedPanelWD).element.css({
                        position: "relative",
                        overflow: "visible"
                    });
                    this.getWidgetByName(Consts.userLimitUnauthorizedListPanelWD).element.css("position", "relative");
                    this.getWidgetByName(Consts.userLimitAuthorizedListPanelWD).element.css("position", "relative");
                    this.getWidgetByName(Consts.userLimitUnauthorizedListWD).element.css("position", "relative");
                    this.getWidgetByName(Consts.userLimitAuthorizedListWD).element.css("position", "relative");
                    this.getWidgetByName(Consts.userLimitConfigTableWD).element.css("position", "relative");
                });
            }
            if(window.FSMobilePlatePlugin && $.isFunction(FSMobilePlatePlugin.mobilePlateCustomTab)) {
                var customTabs = FSMobilePlatePlugin.mobilePlateCustomTab();
                tabs = tabs.concat(customTabs);
            }
            this.tabPane = new FS.LTabPane({
                width : '100%',
                height : '100%',
                vgap:21,
                items : tabs,
                renderEl : render,
                marginLeft : 0,
                initAfterActions : initActions,
                opAfterActions: [
                    function () {
                        self.callResizeFn(resizeFns, 0, render, this);
                    }, function () {
                        self.callResizeFn(resizeFns, 1, render, this);
                    }, function () {
                        self.callResizeFn(resizeFns, 2, render, this);
                    }, function () {
                        self.callResizeFn(resizeFns, 3, render, this);
                    }
                ]
            });
            this.renderEl.css("overflow", "hidden");
            this.renderEl.data("onResize", function(width, height) {
                var tabIdx = self.tabPane.getSelectedIndex();
                if (tabIdx !== null) {
                    resizeFns[tabIdx](self.tabPane, width, height);
                }
            });
        },

        callResizeFn : function(resizeFns, index, render, thisObj) {
            if(resizeFns[index]) {
                resizeFns[index](thisObj, render.width(), render.height());
            }
        },

        /**
         * 基本配置
         */
        basicTabConfig : function() {
            var self = this;
            return {
                title : FR.i18nText("FS-Generic-APP_LAUNCHING"),
                content : {
                    type: 'panel',
                    widgetName: Consts.basicConfigPanelWD,
                    doSize : true,
                    width : self.renderEl.width(),
                    height : self.renderEl.height() - 70,
                    closeAfterAction: false,
                    scrollable: true,
                    contentWidget : {
                        type : 'tablelayout',
                        widgetName: Consts.basicConfigTableWD,
                        columnSize: [Math.max(FR.i18nTextWidth("FS-Generic-Upload_File_Tip") + 500, 750)],
                        rowSize: [435],
                        scrollable: true,
                        items: [[
                            {el: self._createBasicConfigAbsolute()}
                        ]]
                    }
                }
            };
        },

        /**
         * 基本配置部分绝对布局组件
         * @private
         */
        _createBasicConfigAbsolute: function () {
            var self = this;
            return {
                type : 'absolute',
                items : [
                    {
                        x : 40,
                        y : 5,
                        height : 16,
                        type : 'label',
                        value : FR.i18nText("FS-Report-Devices_Phone")
                    },
                    {
                        x : FR.i18nTextWidth("FS-Report-Devices_Phone") + 68,
                        y : 5,
                        el : $('<img/>').addClass(Consts.PHONEIMGCLS)
                    },
                    {
                        x : FR.i18nTextWidth("FS-Report-Devices_Phone") + 293,
                        y : 79,
                        type : 'multifile',
                        widgetName : Consts.PHONEFILEUPLOADWD,
                        maxlength : 1,
                        accept : '.png.jpg.gif',
                        tooltipText : FR.i18nText("FS-Generic-Upload_File_Tip"),
                        height : 32,
                        width : 32,
                        hideFileList : true,
                        listeners : [
                            {
                                eventName : 'afteredit',
                                action : function() {
                                    var attachid = this.getValue().attach_id;
                                    var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
                                    $('.' + Consts.PHONEIMGCLS).attr('src', url);
                                    $('td', this.element).remove();
                                }
                            }
                        ]
                    },
                    {
                        x  : 40,
                        y : 222,
                        type : 'label',
                        height : 16,
                        value : FR.i18nText("FS-Generic-Mobile_Pad")
                    },
                    {
                        x  : FR.i18nTextWidth("FS-Generic-Mobile_Pad") + 68,
                        y : 222,
                        el : $('<img/>').addClass(Consts.PADIMGCLS)
                    },
                    {
                        x  : FR.i18nTextWidth("FS-Generic-Mobile_Pad") + 293,
                        y : 277,
                        type : 'multifile',
                        widgetName : Consts.PADFILEUPLOADWD,
                        maxlength : 1,
                        accept : '.png.jpg.gif',
                        tooltipText :FR.i18nText("FS-Generic-Upload_File_Tip"),
                        height : 32,
                        width : 32,
                        hideFileList : true,
                        listeners : [
                            {
                                eventName : 'afteredit',
                                action : function() {
                                    var attachid = this.getValue().attach_id;
                                    var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
                                    $('.' + Consts.PADIMGCLS).attr('src', url);
                                    $('td', this.element).remove();
                                }
                            }
                        ]
                    },
                    {
                        x : 40,
                        y : 395,
                        type : 'quickbutton',
                        text : FR.i18nText("FS-Frame-Simple_Save"),
                        width : 80,
                        height : 28,
                        handler : function() {
                            var phoneid = self._getWidgetValue(Consts.PHONEFILEUPLOADWD).attach_id;
                            var padid = self._getWidgetValue(Consts.PADFILEUPLOADWD).attach_id;
                            FSMP.Control.saveMobileLaunchImage(phoneid, padid);
                            FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                        }
                    }
                ]
            }
        },

        /**
         * 用户管理
         */
        userLimitTabConfig : function(){
            var self = this;
            return {
                title : FR.i18nText("FS-User-Simple_Management"),
                content : {
                    type : 'panel',
                    widgetName: Consts.userLimitConfigPanelWD,
                    doSize : true,
                    width : self.renderEl.width(),
                    height : self.renderEl.height() - 70,
                    closeAfterAction: false,
                    contentWidget : {
                        type : 'tablepane',
                        widgetName: Consts.userLimitConfigTableWD,
                        colSize: [40, 270, 18, 44, 18, 'fill'],
                        rowSize: [24, 420],
                        scrollable: true,
                        vgap: 8,
                        items: [
                            [
                                {}, null, null, null, null, self._createUserLimitTip()
                            ], [
                                {}, self._createUserPanel(false),
                                {}, self._createUserAuthButtons(),
                                {}, self._createUserPanel(true)
                            ]
                        ]
                    }
                }
            }
        },

        _createUserLimitTip: function() {
            return $('<div/>').addClass("fs-user-limit-tip").append(
                $('<span/>').text(FR.i18nText("FS-Mobile-User_Limit_Tip_Left")
                    + " " + FS.config.mobileUserAuthLimit + " "
                    + FR.i18nText("FS-Mobile-User_Limit_Tip_Right")
                )
            );
        },

        _createUserPanel: function (isAuthorizedList) {
            var self = this;
            var userPanelOptions = isAuthorizedList ? {
                panelWidgetName: Consts.userLimitUnauthorizedPanelWD,
                panelTitle: FR.i18nText("FS-User-Authorized_Users"),
                listWidgetName:  Consts.userLimitAuthorizedListWD,
                listPanelWidgetName: Consts.userLimitAuthorizedListPanelWD,
                listUrl: FR.servletURL + "?op=fs_set&cmd=auth_getall_loginusers&type=mobile"
            } : {
                panelWidgetName: Consts.userLimitAuthorizedPanelWD,
                panelTitle: FR.i18nText("FS-User-Unauthorized_Users"),
                listWidgetName: Consts.userLimitUnauthorizedListWD,
                listPanelWidgetName: Consts.userLimitUnauthorizedListPanelWD,
                listUrl: FR.servletURL + "?op=fs_set&cmd=auth_getallusers&exclude=mobile_login"
            };
            var searchFunc = function(e){
                if (FSMP.View.searchId != null) {
                    clearTimeout(FSMP.View.searchId);
                    FSMP.View.searchId = null;
                }
                FSMP.View.searchId = setTimeout(function () {
                    if (!FR.isNavKeyPress(e)) {
                        var val = this.getValue();
                        var userList = FSMP.View.tabPane.getWidgetByName(userPanelOptions.listWidgetName);
                        userList.refresh({
                            async: {
                                url: userPanelOptions.listUrl,
                                data: {
                                    dataFilter: val
                                }
                            }
                        });
                    }
                }.createDelegate(this), 200);
            };
            var items = [
                [{
                    type: 'search',
                    width: 268,
                    autoSearch: true,
                    onKeyup: searchFunc
                }],
                [{
                    type: 'panel',
                    widgetName: userPanelOptions.listPanelWidgetName,
                    width: 268,
                    height: 346,
                    doSize: true,
                    contentWidget: {
                        type: 'quicklist',
                        width: 268,
                        fit: false,
                        scrollLoading: true,
                        widgetName: userPanelOptions.listWidgetName,
                        async: {
                            url: userPanelOptions.listUrl,
                            data: {
                                serverID: FS.serverID
                            }
                        },
                        dataFilter: function (user) {
                            return {
                                text: (user.realname || "") + '(' + user.username + ')',
                                value: user.username,
                                realname: user.realname
                            }
                        },
                        itemCanBeSelect: true,
                        onItemSelect: function () {
                            self.setMobileAuthButtonStatus();
                        }
                    }
                }]
            ];
            return {
                type: 'panel',
                fit: false,
                title: userPanelOptions.panelTitle,
                width: 270,
                height: 375,
                widgetName: userPanelOptions.panelWidgetName,
                border: true,
                contentWidget: {
                    type: 'tablepane',
                    colSize: [270],
                    rowSize: [28, 'fill'],
                    items: items
                }
            }
        },

        _createUserAuthButtons: function () {
            var self = this;
            return {
                type: 'tablepane',
                colSize: ['fill'],
                rowSize: [148, 24, 30, 24, 'fill'],
                items: [
                    [[]], [{
                        type: 'iconbutton',
                        widgetName: Consts.userLimitAuthMoveRightButtonWD,
                        baseClass: 'fs-user-auth-move-right-icon',
                        imgsrc: 'fs-user-auth-move-right',
                        width: 44,
                        height: 24,
                        handler: function () {
                            var unauthorizedList = self.tabPane.getWidgetByName(Consts.userLimitUnauthorizedListWD);
                            var index = unauthorizedList.getSelectedIndex();
                            if (index == null) {
                                return;
                            }
                            FSMP.Control.setLoginUser(index, false);
                        }
                    }], [[]], [{
                        type: 'iconbutton',
                        widgetName: Consts.userLimitAuthMoveLeftButtonWD,
                        baseClass: 'fs-user-auth-move-left-icon',
                        imgsrc: 'fs-user-auth-move-left',
                        width: 44,
                        height: 24,
                        handler: function () {
                            var authorizedList = self.tabPane.getWidgetByName(Consts.userLimitAuthorizedListWD);
                            var index = authorizedList.getSelectedIndex();
                            if (index === null) {
                                return;
                            }
                            FSMP.Control.setLoginUser(index, true);
                        }
                    }], [[]]
                ]
            }
        },

        /**
         * 支持移动端访问用户设置设置按钮状态
         */
        setMobileAuthButtonStatus : function() {
            var pane = this.tabPane;
            var authorizedList = pane.getWidgetByName(Consts.userLimitAuthorizedListWD),
                unauthorizedList = pane.getWidgetByName(Consts.userLimitUnauthorizedListWD);
            var moveLeftButton = pane.getWidgetByName(Consts.userLimitAuthMoveLeftButtonWD),
                moveRightButton = pane.getWidgetByName(Consts.userLimitAuthMoveRightButtonWD);
            var enableLeft = true,
                enableRight = true;
            enableLeft &= authorizedList.getSelectedIndex() !== undefined;
            enableLeft &= authorizedList.getItemLength() !== 0;
            moveLeftButton.setEnable(Boolean(enableLeft));
            enableRight &= unauthorizedList.getSelectedIndex() !== undefined;
            enableRight &= unauthorizedList.getItemLength() !== 0;
            enableRight &= authorizedList.getItemLength() < FS.config.mobileUserAuthLimit;
            moveRightButton.setEnable(Boolean(enableRight));
        },

        /**
         * 设备绑定
         */
        devBindTabConfig : function() {
            var self = this;
            return {
                title : FR.i18nText('FS-Mobile-Device_Bind'),
                content : {
                    type : 'panel',
                    widgetName: Consts.deviceBindConfigPanelWD,
                    doSize : true,
                    width : self.renderEl.width(),
                    height : self.renderEl.height() - 70,
                    closeAfterAction: false,
                    contentWidget : {
                        type : 'tablelayout',
                        widgetName: Consts.deviceBindConfigTableWD,
                        columnSize: [750],
                        rowSize: [480],
                        scrollable: true,
                        items: [[
                            {el: self._createDeviceBindConfigAbsolute()}
                        ]]
                    }
                }
            }
        },

        /**
         * 设备绑定部分绝对布局组件
         * @private
         */
        _createDeviceBindConfigAbsolute: function() {
            var self = this;
            var keyupFunction = function (e) {
                (function () {
                    var passedfilter = FSMP.View._getWidget(Consts.AUTHSEARCHER).getValue();
                    var unpassedfilter = FSMP.View._getWidget(Consts.UNAUTHSEARCHER).getValue();
                    var config = {
                        url: FR.servletURL + '?op=fs_mobile_main&cmd=bindorunbind',
                        type: 'POST',
                        data: {
                            'bind': 'true'
                        }
                    };
                    var completeFun = function (res, status) {
                        if (res.responseText == null || res.responseText == "") {
                            return;
                        }
                        FSMP.View.authTableTree.$tbody.empty();
                        FSMP.View.unauthTableTree.$tbody.empty();
                        self.devInfo = FR.jsonDecode(res.responseText);
                        var passedtreedata = FSMP.Control._makeTreedata(true, passedfilter);
                        FSMP.View.authTableTree.addNodes(null, passedtreedata, true);
                        var unpassedtreedata = FSMP.Control._makeTreedata(false, unpassedfilter);
                        FSMP.View.unauthTableTree.addNodes(null, unpassedtreedata, true);
                    };

                    FS.Async.ajax(config, completeFun)
                }).createDelegate(this).defer(500);
            };
            return {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Mobile-Mobile_Dev_Binding"),
                        x: 40,
                        y: 5
                    },
                    {
                        type: 'switch',
                        widgetName: Consts.ISMOBILEDEVBINDWD,
                        x: 140,
                        y: 5,
                        onTurnOff: function () {
                            self._hiedDevPanels();
                            FSMP.Control.closeDevBind();
                        },
                        onTurnOn: function () {
                            self._showDevPanels();
                            FSMP.Control.openDevBind();
                        }
                    },
                    {
                        type: 'panel',
                        widgetName: Consts.UNAUTHPANELWD,
                        title: FR.i18nText("FS-Mobile-Unauth_Devices"),
                        border: true,
                        doSize: true,
                        height: 410,
                        width: 300,
                        x: 40,
                        y: 45,
                        contentWidget: {
                            type: 'vertical',
                            items: [
                                {
                                    el: {
                                        type: 'search',
                                        widgetName: Consts.UNAUTHSEARCHER,
                                        width: 300,
                                        autoSearch: true,
                                        onKeyup: keyupFunction
                                    }
                                },
                                {
                                    el: $('<div class="' + Consts.UNAUTHPANELCONTENTCLS + '"/>')
                                }
                            ]

                        }
                    },
                    {
                        type: 'panel',
                        title: FR.i18nText("FS-Mobile-Authorized_Devices"),
                        widgetName: Consts.AUTHPANELWD,
                        border: true,
                        doSize: true,
                        height: 410,
                        width: 300,
                        x: 440,
                        y: 45,
                        tools: [
                            {
                                //添加设备按钮
                                iconCls: 'fs-module-add-white',
                                width: 24,
                                height: 24,
                                handler: function () {
                                    //添加设备对话框
                                    self.createDevDialog();
                                }
                            }
                        ],

                        contentWidget: {
                            type: 'vertical',
                            items: [
                                {
                                    el: {
                                        type: 'search',
                                        widgetName: Consts.AUTHSEARCHER,
                                        width: 300,
                                        autoSearch: true,
                                        onKeyup: keyupFunction
                                    }
                                },
                                {
                                    el: $('<div class="' + Consts.AUTHPANELCONTENTCLS + '"/>')
                                }
                            ]

                        }
                    },
                    {
                        type: 'iconbutton',
                        baseClass:'fs-mobile-dev-binding-move-right-icon',
                        imgsrc: 'fs_mobile_dev_binding_move_right',
                        width: 44,
                        height: 24,
                        widgetName:Consts.MOVEBTNWD,
                        x: 378,
                        y: 279,
                        handler: function () {
                            var selectNode = self.unauthTableTree.getSelectedNodes()[0];
                            if(!selectNode){
                                return;
                            }
                            if(selectNode.pId === "-1") {
                                //针对用户进行操作
                                FSMP.Control.authorizeUser(selectNode);
                                this.setEnable(false);
                                return ;
                            }
                            FSMP.Control.authorizeDevice(selectNode);
                        }
                    }
                ]}
        },

        /**
         * 添加设备对话框
         */
        createDevDialog : function() {
            var labelWidth = FR.i18nTextWidth("FS-Mobile-Add_Mac_Address", 6.5) > 85 ?
                FR.i18nTextWidth("FS-Mobile-Add_Mac_Address", 6.5) + 10 : 90;
            var addDevDialog = new FR.Dialog({
                title: FR.i18nText("FS-Mobile-Add_Device_With_Whitespace"),
                text4OK: FR.i18nText("FS-Generic-Simple_OK"),
                text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
                destroyOnClose: true,
                width: 200 + labelWidth,
                height: 178,
                confirm: true,
                border: true,
                closable: true,
                onCancel: function () {
                },
                onOK: function () {
                    var username = addDevDialog.getWidgetByName(Consts.USERSELECTWD).getValue();
                    var macaddress = addDevDialog.getWidgetByName(Consts.MACADDRESSWD).getValue();
                    var devname = FR.i18nText("FS-Mobile-Dev_Added_By_Admin");
                    if(!username || !macaddress) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Mobile-Need_User_Name_And_Mac_Address"));
                        return;
                    }
                    FSMP.Control.bindDev(username, devname, macaddress);
                },
                contentWidget: {
                    type: 'tablelayout',
                    top: 10,
                    items: [
                        [
                            {
                                el : $('<div/>')
                            },
                            {
                                el : {
                                    type : 'llabel',
                                    textalign : 'right',
                                    value : FR.i18nText("FS-Mobile-Select_Username")
                                }
                            },
                            {
                                el : $('<div/>')
                            },
                            {
                                el : {
                                    type : 'combo',
                                    widgetName : Consts.USERSELECTWD,
                                    widgetUrl : FR.servletURL + "?op=fs_set&cmd=auth_getallusers&serverID="+FS.serverID
                                }
                            }
                        ],
                        [
                            {
                                el : $('<div/>')
                            },
                            {
                                el : {
                                    type : 'llabel',
                                    textalign : 'right',
                                    value : FR.i18nText("FS-Mobile-Add_Mac_Address")
                                }
                            },
                            {
                                el : $('<div/>')
                            },
                            {
                                el : {
                                    type : 'text',
                                    widgetName : Consts.MACADDRESSWD
                                }
                            }
                        ]
                    ],
                    columnSize: [20, labelWidth, 10, 130],
                    rowSize: [21, 21],
                    vgap: 11
                }
            });
            addDevDialog.setVisible(true);
        },

        /**
         * 二维码(Quick Response Code)
         */
        qrCodeTabConfig : function() {
            var self = this;
            return {
                title : FR.i18nText("FS-Generic-QRCode_Config"),
                content : {
                    type : 'panel',
                    doSize : true,
                    width : 500,
                    height : 200,
                    contentWidget : {
                        type : 'absolute',
                        items : [
                            {
                                x : 40,
                                y : 5,
                                type : 'label',
                                value : FR.i18nText("FS-Generic-Server_Name"),
                                width : 92,
                                height : 16
                            },
                            {
                                x : 40,
                                y : 31,
                                type : 'text',
                                width : 290,
                                height : 21	,
                                widgetName : Consts.SERVERNAMEWD
                            },
                            {
                                x : 40,
                                y : 62,
                                type : 'label',
                                value : FR.i18nText("FS-Generic-Server_Address"),
                                width : 92,
                                height : 16
                            },
                            {
                                x : 40,
                                y : 88,
                                type : 'text',
                                width : 290,
                                height : 21,
                                widgetName : Consts.SERVERADDRESSWD
                            },
                            {
                                x : 372,
                                y : 5,
                                el : $('<img/>').addClass(Consts.QRIMGCLS)
                            },
                            {
                                x : 130,
                                y : 124,
                                type : 'quickbutton',
                                text : FR.i18nText("FS-Generic-Create_QRCode"),
                                width : 110,
                                height : 33,
                                handler : function() {
                                    var serverName = self._getWidgetValue(Consts.SERVERNAMEWD);
                                    var serverAddress = self._getWidgetValue(Consts.SERVERADDRESSWD);
                                    FSMP.Control.createQRCode(serverName, serverAddress);
                                }
                            }
                        ]
                    }
                }
            }
        },

        /**
         * 在View.tabPane中根据控件名称获取控件值
         * @param widgetName 控件名
         * @private
         */
        _getWidgetValue : function(widgetName) {
            return this.tabPane.getWidgetByName(widgetName).getValue();
        },

        /**
         * 在View.tabPane中根据控件名称获取控件对象
         * @param widgetName 控件名
         * @private
         */
        _getWidget : function(widgetName) {
            return this.tabPane.getWidgetByName(widgetName);
        },

        /**
         * 隐藏授权&未授权设备面板
         * @private
         */
        _hiedDevPanels : function() {
            this._getWidget(Consts.UNAUTHPANELWD).setVisible(false);
            this._getWidget(Consts.AUTHPANELWD).setVisible(false);
            this._getWidget(Consts.MOVEBTNWD).setVisible(false);
        },

        /**
         * 显示授权&未授权设备面板
         * @private
         */
        _showDevPanels : function() {
            this._getWidget(Consts.UNAUTHPANELWD).setVisible(true);
            this._getWidget(Consts.AUTHPANELWD).setVisible(true);
            this._getWidget(Consts.MOVEBTNWD).setVisible(true);
            //数据加载完后按钮才可用。
            this._getWidget(Consts.MOVEBTNWD).setEnable(false);
            $('.' + Consts.UNAUTHPANELCONTENTCLS).empty();
            $('.' + Consts.AUTHPANELCONTENTCLS).empty();
            //创建树
            this.unauthTableTree = new FS.TableTree(this._unauthTabletreeConfig());
            this.authTableTree = new FS.TableTree(this._authTabletreeConfig());
        },

        /*
         * 未授权设备树配置
         * @private
         */
        _unauthTabletreeConfig : function() {
            var self = this;
            var treeOnClick = function(event, treeId, treeNode){
                FSMP.View.tabPane.getWidgetByName(Consts.MOVEBTNWD).setEnable(true);
            };

            var unauthTreeSetting = {
                view: {
                    showIcon: false  //不显示每个节点前的ICON
                },
                data: {
                    simpleData: {
                        enable: true,
                        idKey: "id",
                        pidKey: "pId",
                        rootPId: "-1"
                    }
                },
                callback: {
                    onClick: treeOnClick
                }
            };
            return {
                treeID: 'unauthTableTree',
                height: '100%',
                width: '100%',
                fit: true,
                setting: unauthTreeSetting,
                alwaysShowTools:false,
                itemHoverCls:'fs_tabletree_item_hover',
                renderEl: $('.unauth_panel_content'),
                tools: [
                    {
                        iconCls: 'fs-module-delete-white',
                        hoverCls: 'fs-module-delete-white-hover',
                        //编辑按钮事件
                        onToolClick: function (e) {
                            var self2 = this;
                            FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete")+"？", function(result) {
                                if(result) {
                                    var nodeID = $(self2).data('nodeID');
                                    var selectNode = self.unauthTableTree.getNodeById(nodeID);
                                    if(!selectNode || selectNode.pId === "-1") {
                                        var config = {
                                            url : FR.servletURL + '?op=fs_mobile_main&cmd=deletedev',
                                            type : 'POST',
                                            data : {
                                                'username':selectNode.username,
                                                'ispassed':false
                                            }
                                        };
                                        var completeFun =  function() {
                                            self.unauthTableTree.removeNode(selectNode);
                                        };

                                        FS.Async.ajax(config, completeFun);
                                        //删除用户
                                        return ;
                                    }

                                    var config = {
                                        url : FR.servletURL + '?op=fs_mobile_main&cmd=deletedev',
                                        type : 'POST',
                                        data : {
                                            'username':selectNode.getParentNode().username,
                                            'macaddress':selectNode.macaddress
                                        }
                                    };
                                    var completeFun = function (res, status) {
                                        var parentNode = selectNode.getParentNode();
                                        if(parentNode.children.length <= 1) {
                                            //说明删除之后，这个用户下就没有设备了，直接把用户删掉
                                            self.unauthTableTree.removeNode(parentNode);
                                        } else {
                                            self.unauthTableTree.removeNode(selectNode);
                                        }
                                    };

                                    FS.Async.ajax(config, completeFun);
                                    e.stopEvent();
                                }
                            });
                        }
                    }
                ]
            }
        },

        /**
         * 授权设备树配置
         * @private
         */
        _authTabletreeConfig : function() {
            var self = this;
            var authTreeSetting = {
                view: {
                    showIcon: false  //不显示每个节点前的ICON
                },
                data: {
                    simpleData: {
                        enable: true,
                        idKey: "id",
                        pidKey: "pId",
                        rootPId: "-1"
                    }
                }
            };
            return {
                treeID: 'authTableTree',
                setting: authTreeSetting,
                height: '100%',
                width: '100%',
                fit: true,
                alwaysShowTools:false,
                itemHoverCls:'fs_tabletree_item_hover',
                renderEl: $('.auth_panel_content'),
                tools: [
                    {
                        iconCls: 'fs-module-delete-white',
                        hoverCls: 'fs-module-delete-white-hover',
                        //编辑按钮事件
                        onToolClick: function (e) {
                            var self2 = this;
                            FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete")+"？", function(result) {
                                if(result) {
                                    var nodeID = $(self2).data('nodeID');
                                    var selectNode = self.authTableTree.getNodeById(nodeID);
                                    if(!selectNode || selectNode.pId === "-1") {
                                        var config = {
                                            url : FR.servletURL + '?op=fs_mobile_main&cmd=deletedev',
                                            type : 'POST',
                                            data : {
                                                'username':selectNode.username,
                                                'ispassed':true
                                            }
                                        };
                                        var completeFun = function (res, status) {
                                            self.authTableTree.removeNode(selectNode);
                                        };

                                        FS.Async.ajax(config, completeFun);

                                        //删除用户
                                        return ;
                                    }
                                    var config = {
                                        url : FR.servletURL + '?op=fs_mobile_main&cmd=deletedev',
                                        type : 'POST',
                                        data : {
                                            'username':selectNode.getParentNode().username,
                                            'macaddress':selectNode.macaddress
                                        }
                                    };
                                    var completeFun = function (res, status) {
                                        var parentNode = selectNode.getParentNode();
                                        if(parentNode.children.length <= 1) {
                                            //说明删除之后，这个用户下就没有设备了，直接把用户删掉
                                            self.authTableTree.removeNode(parentNode);
                                        } else {
                                            self.authTableTree.removeNode(selectNode);
                                        }
                                    };

                                    FS.Async.ajax(config, completeFun);
                                    e.stopEvent();
                                }
                            });
                        }
                    }
                ]
            }
        }
    },

    /**
     * 控制
     */
    Control : {

        /**
         * 初始化数据
         */
        initData : function() {
            var config = {
                url : FR.servletURL + "?op=fs_mobile_main&cmd=initdata",
                type : "POST"
            };
            var completeFun = function (res, status) {
                if (status == "success") {
                    var data = FR.jsonDecode(res.responseText);
                    FS.config.qrcodeServerName = data.qrservername;
                    FS.config.qrcodeServerUrl = data.qrserverurl;
                    FS.config.qrcodeImageID = data.qrcodeid;
                    var url;
                    // Phone
                    if (data.phoneid) {
                        url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + data.phoneid + '&isAdjust=false');
                    } else {
                        url = FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/mobile/phone.png";
                    }
                    $("img." + Consts.PHONEIMGCLS).attr("src", url);
                    // Pad
                    if (data.padid) {
                        url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + data.padid + '&isAdjust=false');
                    } else {
                        url = FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/mobile/pad.png";
                    }
                    $("img." + Consts.PADIMGCLS).attr("src", url);
                }
            };

            FS.Async.ajax(config, completeFun);
        },

        /**
         * 传递服务器名称，服务器地址到后台，生成二维码图片，并在前端展示。
         * @param serverName 服务器名称
         * @param serverUrl 服务器地址
         */
        createQRCode : function(serverName, serverUrl) {
            var config = {
                url : "${servletURL}?op=fs_mobile_main&cmd=qrcode",
                data : {
                    serverName : serverName,
                    serverUrl : serverUrl
                }
            };
            var completeFun = function (res, status) {
                if(status == "success") {
                    var attachid = res.responseText;
                    var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
                    $("img." + Consts.QRIMGCLS).attr("src", url);
                    FS.config.qrcodeServerName = serverName;
                    FS.config.qrcodeServerUrl = serverUrl;
                    FS.config.qrcodeImageID = attachid;
                }
            };

            FS.Async.ajax(config, completeFun);
        },

        /**
         * 开启设备绑定
         */
        openDevBind : function(afterbind) {
            var self = this;
            var passedfilter = FSMP.View._getWidget(Consts.AUTHSEARCHER).getValue();
            var unpassedfilter = FSMP.View._getWidget(Consts.UNAUTHSEARCHER).getValue();
            var config = {
                url: FR.servletURL + '?op=fs_mobile_main&cmd=bindorunbind',
                type: 'POST',
                data: {
                    'bind':'true'
                }
            };
            var completeFun = function (res, status) {
                if (res.responseText == null || res.responseText == "") {
                    return;
                }
                self.devInfo = FR.jsonDecode(res.responseText);
                var passedtreedata = self._makeTreedata(true, passedfilter);
                FSMP.View.authTableTree.addNodes(null, passedtreedata, true);
                var unpassedtreedata = self._makeTreedata(false, unpassedfilter);
                FSMP.View.unauthTableTree.addNodes(null, unpassedtreedata, true);
                FS.config.ismobilebinddev = "true";
            };

            FS.Async.ajax(config, completeFun);
        },

        /**
         * 不开启设备绑定
         */
        closeDevBind : function() {
            var config = {
                url : FR.servletURL + '?op=fs_mobile_main&cmd=bindorunbind',
                type : 'POST',
                data : {
                    'bind':'false'
                }
            };
            var completeFun = function (res, status) {
                FS.config.ismobilebinddev = "false";
            };

            FS.Async.ajax(config, completeFun);
        },

        /**
         * 绑定设备
         * @param username 用户名
         * @param devname 设备名
         * @param macaddress 设备MAC地址
         */
        bindDev : function(username, devname, macaddress) {
            var config = {
                url : FR.servletURL + '?op=fs_mobile_main&cmd=binddev',
                type : 'POST',
                data : {
                    'username':username,
                    'devname':devname,
                    'macaddress':macaddress
                }
            };
            var completeFun = function (res, status) {
                //未授权中移除
                //在授权中添加
                //先看在授权列表中是不是已经存在这个用户
                var authTableTree = FSMP.View.authTableTree;
                var allAuthNodes = authTableTree.getNodes();
                var hasFound = false;
                for(var i = 0; i < allAuthNodes.length; i ++) {
                    var authNode = allAuthNodes[i];
                    if((authNode.username === username) && (authNode.pId === "-1")) {
                        //存在，只需要加子节点
                        var zitem = {};
                        zitem.name = devname + "("+ macaddress +")";
                        zitem.macaddress = macaddress;
                        zitem.open = true;
                        authTableTree.addNodes(authNode, zitem, true);
                        hasFound = true;
                        break;
                    }
                }
                if(!hasFound) {
                    //没找到，先加用户
                    var zitem = {};
                    zitem.name = username;
                    zitem.username = username;
                    zitem.open = true;
                    var usernode = authTableTree.addNodes(null, zitem, true)[0];
                    var zitem = {};
                    zitem.name = devname + "("+ macaddress +")";
                    zitem.macaddress = macaddress;
                    zitem.open = true;
                    authTableTree.addNodes(usernode, zitem, true);
                }
            };

            FS.Async.ajax(config, completeFun);
        },

        /**
         * 设置支持移动端访问的用户
         * @param index 列表中的索引顺序
         * @param isRemove 是否为移除操作
         */
        setLoginUser : function (index, isRemove) {
            var sourceList = isRemove ? FSMP.View.tabPane.getWidgetByName(Consts.userLimitAuthorizedListWD)
                : FSMP.View.tabPane.getWidgetByName(Consts.userLimitUnauthorizedListWD);
            var targetList = isRemove ? FSMP.View.tabPane.getWidgetByName(Consts.userLimitUnauthorizedListWD)
                : FSMP.View.tabPane.getWidgetByName(Consts.userLimitAuthorizedListWD);
            var username = sourceList.getValue();
            var realname = sourceList.options.listItems[index].options.realname;
            var cmd = isRemove ? "auth_removeloginuser" : "auth_addloginuser";
            var config = {
                url: FR.servletURL + "?op=fs_set&cmd=" + cmd + "&type=mobile",
                type: "POST",
                data: {
                    'username': username
                }
            };
            var completeFun = function (res, status) {
                if (status == "success") {
                    var success = FR.jsonDecode(res.responseText).success;
                    if (success) {
                        sourceList.remove(index);
                        targetList.addItem({
                            text: (realname || "") + '(' + username + ')',
                            value: username,
                            realname: realname
                        });
                        //重新选取
                        if (sourceList.getItemLength() === 0) {
                            index = -1;
                        } else if (index >= sourceList.getItemLength()) {
                            index = sourceList.getItemLength() - 1;
                        }
                        if (index !== -1) {
                            sourceList.selectItemByIndex(index);
                        }
                        FSMP.View.setMobileAuthButtonStatus();
                    }
                }
            };


            FS.Async.ajax(config, completeFun);
        },

        /**
         * 为用户下的所有设备授权
         * @param selectNode : 选中的用户节点
         */
        authorizeUser : function(selectNode) {
            var username = selectNode.username;
            var config = {
                url : FR.servletURL + '?op=fs_mobile_main&cmd=binddev',
                type : 'POST',
                data : {
                    'username':username
                }
            };
            var completeFun = function (res, status) {
                //未授权中移除
                FSMP.View.unauthTableTree.removeNode(selectNode);
                //在授权中添加
                //先看在授权列表中是不是已经存在这个用户
                var allAuthNodes = FSMP.View.authTableTree.getNodes();
                var hasFound = false;
                var children = selectNode.children;
                for(var i = 0; i < allAuthNodes.length; i ++) {
                    var authNode = allAuthNodes[i];
                    if((authNode.username === username) && (authNode.pId === "-1")) {
                        //存在，只需要加子节点
                        for(var i = 0; i < children.length; i ++) {
                            var node = children[i];
                            var zitem = {};
                            zitem.name = node.name;
                            zitem.macaddress = node.macaddress;
                            zitem.open = true;
                            FSMP.View.authTableTree.addNodes(authNode, zitem, true);
                        }
                        hasFound = true;
                        break;
                    }
                }
                if(!hasFound) {
                    //没找到，先加用户
                    var zitem = {};
                    zitem.name = selectNode.name;
                    zitem.username = username;
                    zitem.open = true;
                    var authNode = FSMP.View.authTableTree.addNodes(null, zitem, true)[0];
                    for(var i = 0; i < children.length; i ++) {
                        var node = children[i];
                        var zitem = {};
                        zitem.name = node.name;
                        zitem.macaddress = node.macaddress;
                        zitem.open = true;
                        FSMP.View.authTableTree.addNodes(authNode, zitem, true);
                    }
                }
            };

            FS.Async.ajax(config, completeFun);
        },

        /**
         * 为单个设备授权
         * @param selectNode : 选中的设备节点
         */
        authorizeDevice : function(selectNode) {
            var macaddress = selectNode.macaddress;
            var devname = selectNode.name;
            var username = selectNode.getParentNode().username;
            var name = selectNode.getParentNode().name;
            var config = {
                url : FR.servletURL + '?op=fs_mobile_main&cmd=binddev',
                type : 'POST',
                data : {
                    'username':username,
                    'devname':devname,
                    'macaddress':macaddress
                }
            };
            var completeFun = function (res, status) {
                {
                    //未授权中移除
                    var parentNode = selectNode.getParentNode();
                    if(parentNode.children.length <= 1) {
                        //说明删除之后，这个用户下就没有设备了，直接把用户删掉
                        FSMP.View.unauthTableTree.removeNode(parentNode);
                    } else {
                        FSMP.View.unauthTableTree.removeNode(selectNode);
                    }
                    //在授权中添加
                    //先看在授权列表中是不是已经存在这个用户
                    var allAuthNodes = FSMP.View.authTableTree.getNodes();
                    var hasFound = false;
                    for(var i = 0; i < allAuthNodes.length; i ++) {
                        var authNode = allAuthNodes[i];
                        if((authNode.username === username) && (authNode.pId === "-1")) {
                            //存在，只需要加子节点
                            var zitem = {};
                            zitem.name = selectNode.name;
                            zitem.macaddress = selectNode.macaddress;
                            zitem.open = true;
                            FSMP.View.authTableTree.addNodes(authNode, zitem, true);
                            hasFound = true;
                            break;
                        }
                    }
                    if(!hasFound) {
                        //没找到，先加用户
                        var zitem = {};
                        zitem.name = name;
                        zitem.username = username;
                        zitem.open = true;
                        var usernode = FSMP.View.authTableTree.addNodes(null, zitem, true)[0];
                        var zitem = {};
                        zitem.name = selectNode.name;
                        zitem.macaddress = selectNode.macaddress;
                        zitem.open = true;
                        FSMP.View.authTableTree.addNodes(usernode, zitem, true);
                    }
                    FSMP.View.tabPane.getWidgetByName(Consts.MOVEBTNWD).setEnable(false);
                }
            };

            FS.Async.ajax(config, completeFun);
        },

        /**
         * 保存phone和pad端的启动画面
         * @param phoneid 手机端启动图片的ID
         * @param padid 平板端启动图片的ID
         */
        saveMobileLaunchImage : function(phoneid, padid) {
            if(!phoneid && !padid) {
                return ;
            }
            var config = {
                url : FR.servletURL + '?op=fs_mobile_main&cmd=savelaunchimage',
                type : 'POST',
                data : {
                    'phoneid':phoneid,
                    'padid':padid
                }
            };

            FS.Async.ajax(config);
        },

        /**
         * 生成ztree所需要的数据
         * @param isPassed 授权/未授权设备
         * @private
         */
        _makeTreedata: function (isPassed, filter) {
            var self = this;
            var passedTreedata = [];
            var unPassedTreedata = [];
            var userIndex = -1;
            $.each(this.devInfo, function (showName, devinfos) {
                userIndex--;
                var hasPassedDev = false;
                var hasUnPassedDev = false;
                var username = '';
                for (var i = 0; i < devinfos.length; i++) {
                    var devinfo = devinfos[i];
                    username = devinfo.username;
                    var zitem = {};
                    zitem.name = devinfo.devname + "(" + devinfo.macaddress + ")";
                    zitem.id = i + "" + userIndex;
                    zitem.pId = userIndex;
                    zitem.open = true;
                    zitem.macaddress = devinfo.macaddress;
                    if (devinfo.ispassed === true && isPassed && self._isFilter(filter, showName)) {
                        //通过
                        hasPassedDev = true;
                        passedTreedata.push(zitem );
                    } else if(devinfo.ispassed === false&& !isPassed && self._isFilter(filter, showName)){
                        hasUnPassedDev = true;
                        unPassedTreedata.push(zitem);
                    }
                }
                var zitem = {};
                zitem.name = showName;
                zitem.id = userIndex;
                zitem.pId = "-1";
                zitem.open = true;
                zitem.username = username;
                if (hasPassedDev && isPassed && self._isFilter(filter, showName)) {
                    //把用户加进去
                    passedTreedata.push(zitem);
                }
                if (hasUnPassedDev && !isPassed && self._isFilter(filter, showName)) {
                    unPassedTreedata.push(zitem);
                }
            });
            if (isPassed) {
                return passedTreedata;
            } else {
                return unPassedTreedata;
            }
        },
        _isFilter: function (filter, text) {
            return text === undefined ? false : text.indexOf(filter) >= 0 || filter.trim().length === 0;
        }
    },


    /**
     * 初始化移动平台
     * @param render : 父容器
     */
    init : function(render) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_mobileplate.css', 'css');
        this.View.createTabPane(render);
        this.Control.initData();
    }
};