package com.jshx.zzhqfdz.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.entity.Zzhqfhz;
import com.jshx.zzhqfdz.entity.Zzhqfhzlsh;
import com.jshx.zzhqfdz.entity.Zzhqfhzmx;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhqfdz.service.ZzhqfhzService;
import com.jshx.zzhqfdz.service.ZzhqfhzmxService;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import com.jshx.zzhxm.service.ZzhxmSfxxService;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

public class ZzhqfqrAction extends BaseAction
{
	private static Logger logger = LoggerFactory.getLogger(ZzhqfqrAction.class);

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String jktzsbhVal;
	private List<Zzhqfdz> zzhqfdzsList = new ArrayList<>();
	List<ZzhxmSfxx> zzhxmsfxxList = new ArrayList<>();

	private List<ZzhxmSfxx> zzhxmSfxxList = new ArrayList<>();

	/**
	 * 实体类
	 */
	private ZzhxmJktzs zzhxmJktzs = new ZzhxmJktzs();
	private ZzhxmSfxx zzhxmSfxx = new ZzhxmSfxx();
	private Zzhqfhz zzhqfhz = new Zzhqfhz();
	private Yzscwjzpz yzscwjzpz = new Yzscwjzpz();

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhqfdzService zzhqfdzService;
	@Autowired
	private ZzhxmJktzsService zzhxmJktzsService;
	@Autowired
	private ZzhxmSfxxService zzhxmSfxxService;
	@Autowired
	private ZzhqfhzmxService zzhqfhzmxService;
	@Autowired
	private ZzhqfhzService zzhqfhzService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;


	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != zzhxmJktzs){

		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != zzhxmJktzs.getJfdmwybh()) && (0 < zzhxmJktzs.getJfdmwybh().trim().length())){
				paraMap.put("jfdmwybh", "%" + zzhxmJktzs.getJfdmwybh().trim() + "%");
			}
			if ((null != zzhxmJktzs.getAccountDetail()) && (0 < zzhxmJktzs.getAccountDetail().trim().length())){
				paraMap.put("accountDetail", "%" + zzhxmJktzs.getAccountDetail().trim() + "%");
			}
			if ((null != zzhxmJktzs.getJktzsbh()) && (0 < zzhxmJktzs.getJktzsbh().trim().length())){
				paraMap.put("jktzsbh", "%" + zzhxmJktzs.getJktzsbh().trim() + "%");
			}
			if ((null != zzhxmJktzs.getKpzt()) && (0 < zzhxmJktzs.getKpzt().trim().length())){
				paraMap.put("kpzt", "%" + zzhxmJktzs.getKpzt().trim() + "%");
			}
			if ((null != zzhxmJktzs.getQfzt()) && (0 < zzhxmJktzs.getQfzt().trim().length())){
				paraMap.put("qfzt", "%" + zzhxmJktzs.getQfzt().trim() + "%");
			}
			if ((null != zzhxmJktzs.getNfqf()) && (0 < zzhxmJktzs.getNfqf().trim().length())){
				paraMap.put("nfqf", "%" + zzhxmJktzs.getNfqf().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "";
		final String filter = "id|jfdmwybh|accountDetail|zzhhjdzje|jktzsbh|jftzyje|nfkp|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = zzhxmJktzsService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}


	/**
	 * 确认清分
	 */
	public String zzhqfqrSave() throws Exception{
		try{
			List<ZzhxmSfxx> zzhxmSfxxList1 = new ArrayList<>();
			ZzhxmJktzs zzhxmJktzs1 = new ZzhxmJktzs();
			DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
			String qfjklxid = UUID.randomUUID().toString();//获取清分缴款联系id
			//获取清分总金额
			BigDecimal sum = new BigDecimal("0");
			String[] idArray = ids.split("\\|");
			if(idArray != null){
				for(String id:idArray){
					if(id != null && !id.trim().equals("")){
						Map<String, Object> paramMap1 = new HashMap<>();
						zzhxmJktzs1 = zzhxmJktzsService.getById(id);
						String jfdmwybh = zzhxmJktzs1.getJfdmwybh();
						paramMap1.put("jfdmwybh",jfdmwybh);
						zzhxmSfxxList =  zzhxmSfxxService.findZzhxmSfxx(paramMap1);
						if(CollectionUtils.isNotEmpty(zzhxmSfxxList)) {
							for (int j = 0; j < zzhxmSfxxList.size(); j++) {
								zzhxmSfxxList1.add(zzhxmSfxxList.get(j));
							}
						}
						sum = sum.add(new BigDecimal(zzhxmJktzs1.getJftzyje()));
						zzhxmJktzs1.setQfjklxid(qfjklxid);
//						zzhxmJktzs1.setQfzt("1");
						zzhxmJktzsService.update(zzhxmJktzs1);
					}
				}
			}

			//存清分汇总表
			zzhqfhz.setQfjklxid(qfjklxid);
			LocalDateTime localDate = LocalDateTime.now();
			zzhqfhz.setQfqrsj(dateTimeFormatter.format(localDate));//获取清分时间
			zzhqfhz.setDelFlag(0);
			zzhqfhz.setQfjkzje(sum.toString());
			zzhqfhzService.save(zzhqfhz);

			//根据银行划分明细清单
			Map<String,Map<String,String>> bankDetail = new HashMap<>();
			for(ZzhxmSfxx zzhxmSfxx:zzhxmSfxxList1){
				String khyh = zzhxmSfxx.getKhyh();
				if(bankDetail.containsKey(khyh)){
					//计算总金额
					BigDecimal qfyjjemx = new BigDecimal(bankDetail.get(khyh).get("qfyjjemx"));
					qfyjjemx =	qfyjjemx.add(new BigDecimal(zzhxmSfxx.getYjjemx()));
					bankDetail.get(khyh).put("qfyjjemx",qfyjjemx.toPlainString());
				}else{
					//存银行明细
					Map<String,String> map= new HashMap();
					map.put("fshmc",khyh);
					map.put("fshzh",zzhxmSfxx.getSkrzh());
					map.put("qfhzid",zzhqfhz.getId());
					map.put("qfyjjemx",zzhxmSfxx.getYjjemx());
					map.put("qfhzlsh",getQflsh());
					bankDetail.put(khyh,map);
				}
			}
			//更改缴款通知表的清分状态
			Map<String, Object> paramMap = new HashMap<>();
			paramMap.put("qfjklxid", qfjklxid);
			List<ZzhxmJktzs>  zzhxmJktzsList111 = zzhxmJktzsService.findZzhxmJktzs(paramMap);
            zzhqfhzService.saveQrqf(zzhqfhz,bankDetail,zzhxmJktzsList111);

			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}return null;

	}


	/**
	 * 获取清分流水号
	 */
	public String getQflsh() {
		Map<String, Object> paraMap = new HashMap<>();
		StringBuilder sb = new StringBuilder();
		Zzhqfhzlsh zzhqfhzlsh1 = new Zzhqfhzlsh();
		List<Zzhqfhzlsh> zzhqfhzlshList = zzhqfhzmxService.findZzhqfhzlsh(paraMap);
		String lsh = "1";
//		if(zzhqfhzlshList.get(0).getQfhzlsh() == null || "".equals(zzhqfhzlshList.get(0).getQfhzlsh())){
		if(CollectionUtils.isEmpty(zzhqfhzlshList) || StringUtils.isEmpty(zzhqfhzlshList.get(0).getQfhzlsh())){
			for(int i=0;i<4-lsh.length();i++){
				sb.append("0");
			}
			sb.append(lsh);
			zzhqfhzlsh1.setQfhzlsh(sb.toString());
			zzhqfhzlsh1.setDelFlag(0);
			zzhqfhzmxService.save(zzhqfhzlsh1);
		}else{
			Zzhqfhzlsh zzhqfhzlsh2 = zzhqfhzlshList.get(0);
			lsh = String.valueOf(Integer.parseInt(zzhqfhzlsh2.getQfhzlsh())+1);
			for(int i=0;i<4-lsh.length();i++){
				sb.append("0");
			}
			sb.append(lsh);
			zzhqfhzlsh2.setQfhzlsh(sb.toString());
			zzhqfhzmxService.update(zzhqfhzlsh2);
		}

		DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
		LocalDateTime localDate = LocalDateTime.now();
		String strDate =  dateTimeFormatter.format(localDate).replaceAll("-","");
		String aa =  strDate + "QF" + sb.toString();

		return aa;
	}






	public static void main(String[] args) {
		DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
		LocalDateTime localDate = LocalDateTime.now();
		System.out.println("当前时间："+dateTimeFormatter.format(localDate));
	}

	/**
	 *	根据缴款通知书编号获取缴款信息
	 */
	public void getJktzxx() throws Exception {
		BigDecimal bval= new BigDecimal("0");
		try{
			ZzhxmJktzs zzhxmJktzs =  zzhxmJktzsService.getByJktzsbh(jktzsbhVal);
			//获取子账户合计到账总金额
			Map<String, Object> paraMap = new HashMap<>();
			paraMap.put("jfdmwybh",zzhxmJktzs.getJfdmwybh());
			List<Zzhqfdz> zzhqfdzsList = zzhqfdzService.findZzhqfdz(paraMap);
			for(Zzhqfdz zzhqfdz1 : zzhqfdzsList){
				bval = bval.add(new BigDecimal(zzhqfdz1.getDbdzje()));
			}
			if(zzhxmJktzs != null){
				this.getResponse().getWriter().println("{\"result\":true,\"jfdmwybh\":\""+zzhxmJktzs.getJfdmwybh()+"\"," +
						"\"accountDetail\":\""+zzhxmJktzs.getAccountDetail()+"\"," +
						"\"jftzyje\":\""+zzhxmJktzs.getJftzyje()+"\"," +
						"\"zzhhjdzje\":\""+bval.toString()+"\"}");
			}else{
				this.getResponse().getWriter().println("{\"result\":false}");
			}
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		if((null != zzhxmJktzs)&&(null != zzhxmJktzs.getId())){
			zzhxmJktzs = zzhxmJktzsService.getById(zzhxmJktzs.getId());
			Map<String, Object> paramMap = new HashMap<>();
			String jfdmwybh = zzhxmJktzs.getJfdmwybh();
			paramMap.put("jfdmwybh", jfdmwybh);
			zzhxmsfxxList = zzhxmSfxxService.findZzhxmSfxx(paramMap);
		}
		return EDIT;
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != zzhxmJktzs)&&(null != zzhxmJktzs.getId())){
			zzhxmJktzs = zzhxmJktzsService.getById(zzhxmJktzs.getId());
			Map<String, Object> paraMap = new HashMap<>();
			paraMap.put("jfdmwybh",zzhxmJktzs.getJfdmwybh());
			zzhqfdzsList = zzhqfdzService.findZzhqfdz(paraMap);
		}
		return VIEW;
	}

	/**
	 * 	添加字典信息
	 */
	public String initEditadd() throws Exception{
		view();
		return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}

		if ("mod".equalsIgnoreCase(this.flag)){
			String[] sfxxId = zzhxmSfxx.getId().split(",");
			String[] sfxxybjksbh = zzhxmSfxx.getYbjksbh().split(",");
			String[] sfxxkpsj = zzhxmSfxx.getKpsj().split(",");
			String[] sfxxkpje = zzhxmSfxx.getKpje().split(",");

			List<String> sfxxIdList = Arrays.asList(sfxxId);
			List<String> sfxxybjksbhList = Arrays.asList(sfxxybjksbh);
			List<String> sfxxkpsjList = Arrays.asList(sfxxkpsj);
			List<String> sfxxkpjeList = Arrays.asList(sfxxkpje);

			try{
				for(int i=0;i<sfxxIdList.size();i++){
					String sid = sfxxIdList.get(i).trim();
					ZzhxmSfxx zzhxmSfxx1 = zzhxmSfxxService.getById(sid);
					if(zzhxmSfxx1 != null){
						zzhxmSfxx1.setYbjksbh(sfxxybjksbhList.get(i).trim());
						zzhxmSfxx1.setKpsj(sfxxkpsjList.get(i).trim());
						zzhxmSfxx1.setKpje(sfxxkpjeList.get(i).trim());
						zzhxmSfxxService.update(zzhxmSfxx1);
					}
				}
				/*ZzhxmJktzs zzhxmJktzs1 = zzhxmJktzsService.getById(zzhxmJktzs.getId());
				zzhxmJktzs1.setNfkp("0");//改为已开票
				zzhxmJktzsService.update(zzhxmJktzs1);*/
			}catch(Exception e){
				logger.error(e.getMessage());
			}
		}
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (null != zzhxmJktzs)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			zzhxmJktzsService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getJktzsbhVal() {
		return jktzsbhVal;
	}

	public void setJktzsbhVal(String jktzsbhVal) {
		this.jktzsbhVal = jktzsbhVal;
	}

	public ZzhxmJktzs getZzhxmJktzs() {
		return zzhxmJktzs;
	}

	public void setZzhxmJktzs(ZzhxmJktzs zzhxmJktzs) {
		this.zzhxmJktzs = zzhxmJktzs;
	}

	public ZzhxmSfxx getZzhxmSfxx() {
		return zzhxmSfxx;
	}

	public void setZzhxmSfxx(ZzhxmSfxx zzhxmSfxx) {
		this.zzhxmSfxx = zzhxmSfxx;
	}

	public List<Zzhqfdz> getZzhqfdzsList() {
		return zzhqfdzsList;
	}

	public void setZzhqfdzsList(List<Zzhqfdz> zzhqfdzsList) {
		this.zzhqfdzsList = zzhqfdzsList;
	}

	public List<ZzhxmSfxx> getZzhxmsfxxList() {
		return zzhxmsfxxList;
	}

	public void setZzhxmsfxxList(List<ZzhxmSfxx> zzhxmsfxxList) {
		this.zzhxmsfxxList = zzhxmsfxxList;
	}
}
