package com.jshx.zzhqfdz.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.StringUtil;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZzhqfdzAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String autoVal;
	private String autoName;

	/**
	 * 实体类
	 */
	private Zzhqfdz zzhqfdz = new Zzhqfdz();
	private ZzhxmJktzs zzhxmJktzs = new ZzhxmJktzs();
	private Yzscwjzpz yzscwjzpz = new Yzscwjzpz();

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhqfdzService zzhqfdzService;
	@Autowired
	private ZzhxmJktzsService zzhxmJktzsService;
	@Autowired
	private DxpzService dxpzService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != zzhqfdz){

		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != zzhqfdz.getJfdmwybh()) && (0 < zzhqfdz.getJfdmwybh().trim().length())){
				paraMap.put("jfdmwybh", "%" + zzhqfdz.getJfdmwybh().trim() + "%");
			}
			if ((null != zzhqfdz.getAccountDetail()) && (0 < zzhqfdz.getAccountDetail().trim().length())){
				paraMap.put("accountDetail", "%" + zzhqfdz.getAccountDetail().trim() + "%");
			}
			if ((null != zzhqfdz.getJktzsbh()) && (0 < zzhqfdz.getJktzsbh().trim().length())){
				paraMap.put("jktzsbh", "%" + zzhqfdz.getJktzsbh().trim() + "%");
			}
			if ((null != zzhqfdz.getJkrmc()) && (0 < zzhqfdz.getJkrmc().trim().length())){
				paraMap.put("jkrmc", "%" + zzhqfdz.getJkrmc().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|jfdmwybh|accountDetail|jktzsbh|jkrmc|dbdzje|qfhdzsj|czr|qrdzzt|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = zzhqfdzService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 *	根据缴款通知书编号获取缴款信息
	 */
	public void getJktzxx() throws Exception {
		try{
			Map<String,Object> paramMap =  new HashMap<>();
			if("jktzsbh".equals(autoName)){
				paramMap.put("jktzsbh",autoVal);
			}else{
				paramMap.put("accountDetail",autoVal);
			}
			List<ZzhxmJktzs> zzhxmJktzsList =  zzhxmJktzsService.findZzhxmJktzs(paramMap);
			if(CollectionUtils.isNotEmpty(zzhxmJktzsList)){
				ZzhxmJktzs zzhxmJktzs1 = zzhxmJktzsList.get(0);
				if(zzhxmJktzs1 != null){
					this.getResponse().getWriter().println("{\"result\":true,\"jktzsbh\":\""+zzhxmJktzs1.getJktzsbh()+"\",\"jfdmwybh\":\""+zzhxmJktzs1.getJfdmwybh()+"\",\"accountDetail\":\""+zzhxmJktzs1.getAccountDetail()+"\"}");
				}else{
					this.getResponse().getWriter().println("{\"result\":false}");
				}
			}
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}

	/**
	 * 	添加字典信息
	 */
	public String initEditadd() throws Exception{
		view();
		return EDIT;
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != zzhqfdz)&&(null != zzhqfdz.getId()))
			zzhqfdz = zzhqfdzService.getById(zzhqfdz.getId());
		return VIEW;
	}

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}
		zzhqfdz.setCzr(this.getLoginUser().getDisplayName());
		zzhqfdz.setDeptId(this.getLoginUserDepartmentId());
		zzhqfdz.setDelFlag(0);

		//保存清分单笔到账信息至一站式财务记账凭证表
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		DateFormat df1 = DateFormat.getDateInstance();
		System.out.println();
		yzscwjzpz.setDelFlag(0);
		yzscwjzpz.setZdzt("0");//制单状态
		yzscwjzpz.setIspz("0");//是否生成凭证
		String zysj1 = zzhqfdz.getQfhdzsj().substring(0,10);
		yzscwjzpz.setZdtrq(java.sql.Date.valueOf(formatter.format(simpleDateFormat.parse(zysj1))));
		yzscwjzpz.setAccountDetail(zzhqfdz.getAccountDetail());//子账户
		yzscwjzpz.setJfdmwybh(zzhqfdz.getJfdmwybh());//缴费代码唯一编号
		yzscwjzpz.setJzpzje(zzhqfdz.getDbdzje());//机制凭证金额
		yzscwjzpz.setJfje(zzhqfdz.getDbdzje());//借方金额
		yzscwjzpz.setDfje(zzhqfdz.getDbdzje());//贷方金额
		yzscwjzpz.setJzpzlx("资金到账凭证");//机制凭证类型
		//获取缴款通知书信息
		zzhxmJktzs = zzhxmJktzsService.getByJfdmwybh(zzhqfdz.getJfdmwybh());
		if(null != zzhxmJktzs){
			yzscwjzpz.setJktzsbh(zzhxmJktzs.getJktzsbh());//缴款通知书编号
			yzscwjzpz.setJfdwmc(zzhxmJktzs.getJsdwmc());//缴款单位名称
		}
		String zysj = zzhqfdz.getQfhdzsj().substring(0,7);
		String zy = zysj + "收到" + zzhxmJktzs.getJsdwmc() + "缴费"+ "(" + zzhqfdz.getAccountDetail() + ")";
		yzscwjzpz.setZy(zy);
		zzhqfdzService.saveQfdzxx(this.flag,zzhqfdz,yzscwjzpz);

		//单笔到账后，发短信通知
		Zzhqfdz zzhqfdz11 = new Zzhqfdz();
		Map<String,Object> paramMap1 = new HashMap<>();
		paramMap1.put("accountDetail",zzhqfdz.getAccountDetail());
		List<Zzhqfdz> zzhqfdzList = zzhqfdzService.findZzhqfdz(paramMap1);
		if(CollectionUtils.isNotEmpty(zzhqfdzList)){
			zzhqfdz11 = zzhqfdzList.get(0);
		}
		try {
			if (zzhqfdz11 != null) {
				String phonenum=dxpzService.findbyywbm("010","9999");
				if (StringUtil.isNotEmpty(phonenum)) {
					String content = zzhqfdz11.getJktzsbh() + "到账" + zzhqfdz11.getDbdzje() + "元," + zzhqfdz11.getJkrmc() + ",请及时处理。";
//					CommonAction.send(content, phonenum, "","收费处");
					CommonAction.sendNewMessage(content, phonenum, "", "收费处");
				}
			}
		}catch (Exception e)
		{
			e.printStackTrace();
		}

		//获取子账户合计到账总金额
		BigDecimal bval= new BigDecimal("0");
		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("jfdmwybh",zzhqfdz.getJfdmwybh());
		List<Zzhqfdz> zzhqfdzsList = zzhqfdzService.findZzhqfdz(paraMap);
		for(Zzhqfdz zzhqfdz1 : zzhqfdzsList){
			bval = bval.add(new BigDecimal(zzhqfdz1.getDbdzje()));
		}
		ZzhxmJktzs zzhxmJktzs1 =  zzhxmJktzsService.getByJktzsbh(zzhqfdz.getJktzsbh());
		zzhxmJktzs1.setZzhhjdzje(bval.toString());
		zzhxmJktzsService.update(zzhxmJktzs1);
		return RELOAD;
	}

	public static void main(String[] args) throws ParseException {
		String a = "2019-08-20 15:30:50";
		String zysj = a.substring(0,10);
		String zy = zysj + "收到" + "ali" + "缴费";
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat formatter  = new SimpleDateFormat("yyyy-MM-dd");
		DateFormat df1 = DateFormat.getDateInstance();
		Date date = new Date();
		date  = simpleDateFormat.parse(zysj);
		System.out.println("1"+date);

		System.out.println(java.sql.Date.valueOf(formatter.format(date)));
//		System.out.println(simpleDateFormat.format(DateTime.parse(zysj).toDate()));
	}


	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (null != zzhqfdz)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			zzhqfdzService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Zzhqfdz getZzhqfdz(){
		return this.zzhqfdz;
	}

	public void setZzhqfdz(Zzhqfdz zzhqfdz){
		this.zzhqfdz = zzhqfdz;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getAutoVal() {
		return autoVal;
	}

	public void setAutoVal(String autoVal) {
		this.autoVal = autoVal;
	}

	public String getAutoName() {
		return autoName;
	}

	public void setAutoName(String autoName) {
		this.autoName = autoName;
	}
}
