package com.jshx.xxjl.web;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.jkmx.entity.Jkmx;
import com.jshx.jkmx.service.JkmxService;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.qtfymx.service.QtfymxService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.xxjl.entity.Xxjl;
import com.jshx.xxjl.entity.Xxjlhis;
import com.jshx.xxjl.service.XxjlService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;

import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class XxjlAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	private List<File> file1;
	private List<String> file1FileName;
	private String allFileName;
	private String originFileName;
	private List<FawenAttach> attach;
	private List<String> base64;
	/**
	 * 实体类
	 */
	private Xxjl xxjl = new Xxjl();

	/**
	 * 业务类
	 */
	@Autowired
	private XxjlService xxjlService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private FawenAttachService fawenAttachService;
	@Autowired
	private SpjlbService spjlbService;
	 @Autowired
		private QtfymxService qtfymxService;
	    @Autowired
			private PaymentItemPendingService paymentItemPendingService;
		    @Autowired
			private CktzsService cktzsService;
		    @Autowired
			private JktzsService jktzsService;
		    @Autowired
			private JkmxService jkmxService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 修改经办
	 */
	public void list1() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if (pagination == null)
			pagination = new Pagination(this.getRequest());
		if (!this.getLoginUser().getIsSuperAdmin())
		{
			Zsdw zsdw = zsdwService.getzsdw(this.getLoginUserDepartmentId());
			paraMap.put("zsdw", zsdw.getZsdw());
		}
		if (null != xxjl)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件

			if ((null != xxjl.getSlbh()) && (0 < xxjl.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + xxjl.getSlbh().trim() + "%");
			}

			if ((null != xxjl.getXmxxb()) && (0 < xxjl.getXmxxb().trim().length()))
			{
				paraMap.put("xmxxb", "%" + xxjl.getXmxxb().trim() + "%");
			}

			if ((null != xxjl.getDwmc()) && (0 < xxjl.getDwmc().trim().length()))
			{
				paraMap.put("dwmc", "%" + xxjl.getDwmc().trim() + "%");
			}
			if ((null != xxjl.getXmmc()) && (0 < xxjl.getXmmc().trim().length()))
			{
				paraMap.put("xmmc", "%" + xxjl.getXmmc().trim() + "%");
			}

		}
		paraMap.put("state", "0");
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|slbh|xmxxb|dwmc|lxr|phone|jsdwdz|xmmc|jbr|fhr|jbbz|fhbz|xmbzj|zsdw";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xxjlService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 修改经办
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		List<Xxjl> xxjlList = new ArrayList<Xxjl>();
		if (pagination == null)
			pagination = new Pagination(this.getRequest());
		if (!this.getLoginUser().getIsSuperAdmin())
		{
			Zsdw zsdw = zsdwService.getzsdw(this.getLoginUserDepartmentId());
			paraMap.put("zsdw", zsdw.getZsdw());
		}
		if (null != xxjl)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件

			if ((null != xxjl.getSlbh()) && (0 < xxjl.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + xxjl.getSlbh().trim() + "%");
			}

			if ((null != xxjl.getXmxxb()) && (0 < xxjl.getXmxxb().trim().length()))
			{
				paraMap.put("xxylb", "%" + xxjl.getXmxxb().trim() + "%");
			}

			if ((null != xxjl.getDwmc()) && (0 < xxjl.getDwmc().trim().length()))
			{
				paraMap.put("jsdw", "%" + xxjl.getDwmc().trim() + "%");
			}
			if ((null != xxjl.getXmmc()) && (0 < xxjl.getXmmc().trim().length()))
			{
				paraMap.put("xmmc", "%" + xxjl.getXmmc().trim() + "%");
			}

		}
		pagination = xmxxbService.findXmxxbxg(pagination, paraMap);
		int totalcount = pagination.getTotalCount();
		List<Xmxxb> list = pagination.list;
		for (Xmxxb xmxxb : list)
		{
			Xxjl xxjl1 = new Xxjl();
			Xxjl xj = xxjlService.getByxmbzj(xmxxb.getId());
			if (xj != null)
			{

				xxjl1.setState(xj.getState());
			}
			else
			{
				xxjl1.setState("0");
			}

			xxjl1.setXmbzj(xmxxb.getId());
			xxjl1.setSlbh(xmxxb.getSlbh());
			xxjl1.setXmxxb(xmxxb.getXxylb());
			xxjl1.setDwmc(xmxxb.getJsdw());
			xxjl1.setLxr(xmxxb.getLianxiren());
			xxjl1.setPhone(xmxxb.getPhone());
			xxjl1.setJsdwdz(xmxxb.getJzdwdz());
			xxjl1.setXmmc(xmxxb.getXmmc());
			xxjl1.setXmdz(xmxxb.getJsdd());
			xxjl1.setCkbh(xmxxb.getCkbh());
			xxjl1.setGhxmbh(xmxxb.getXmbh());
			xxjl1.setLxwh(xmxxb.getLxpw());
			xxjlList.add(xxjl1);
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|slbh|xmxxb|dwmc|lxr|phone|jsdwdz|xmmc|jbr|fhr|jbbz|fhbz|xmbzj|state|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xxjlService.findByPage(pagination, paraMap);
		pagination.list = xxjlList;
		pagination.setTotalCount(totalcount);
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{

		Xxjlhis Xxjlhis = xxjlService.getByXxjlhis(xxjl.getId());
		xxjl.setSlbh(Xxjlhis.getSlbh());
		xxjl.setXmxxb(Xxjlhis.getXmxxb());
		xxjl.setDwmc(Xxjlhis.getDwmc());
		xxjl.setLxr(Xxjlhis.getLxr());
		xxjl.setPhone(Xxjlhis.getPhone());
		xxjl.setJsdwdz(Xxjlhis.getJsdwdz());
		xxjl.setXmmc(Xxjlhis.getXmmc());
		
		xxjl.setXmdz(Xxjlhis.getXmdz());
		xxjl.setCkbh(Xxjlhis.getCkbh());
		xxjl.setGhxmbh(Xxjlhis.getGhxmbh());
		xxjl.setLxwh(Xxjlhis.getLxwh());
		
		xxjl.setJbbz(Xxjlhis.getJbbz());
		xxjl.setFhbz(Xxjlhis.getFhbz());
		xxjl.setJbr(Xxjlhis.getJbr());
		xxjl.setFhr(Xxjlhis.getFhr());
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", xxjl.getXmbzj());
		//attach = fawenAttachService.queryAttachListByTempleId(paramMap);
		return VIEW;
	}

	public String initEdit1() throws Exception
	{
		// view();
		xxjl = xxjlService.getById(xxjl.getId());
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", xxjl.getXmbzj());
		paramMap.put("xmType1", "信息修改");
		attach = fawenAttachService.queryAttachListByTempleId(paramMap);
		return EDIT;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		// view();
		Xmxxb xmxxb = xmxxbService.getById(xxjl.getId());
		Xxjl xj = xxjlService.getByxmbzj(xmxxb.getId());
		if (xj != null)
		{
			xxjl.setJbbz(xj.getJbbz());
			xxjl.setFhbz(xj.getFhbz());
			xxjl.setJbr(xj.getJbr());
			xxjl.setFhr(xj.getFhr());
			xxjl.setState(xj.getState());
		}
		else
		{
			xxjl.setState("0");
		}
		if (xmxxb != null)
		{

			xxjl.setXmbzj(xmxxb.getId());
			xxjl.setSlbh(xmxxb.getSlbh());
			xxjl.setXmxxb(xmxxb.getXxylb());
			xxjl.setDwmc(xmxxb.getJsdw());
			xxjl.setLxr(xmxxb.getLianxiren());
			xxjl.setPhone(xmxxb.getPhone());
			xxjl.setJsdwdz(xmxxb.getJzdwdz());
			xxjl.setXmmc(xmxxb.getXmmc());
			xxjl.setXmdz(xmxxb.getJsdd());
			xxjl.setCkbh(xmxxb.getCkbh());
			xxjl.setGhxmbh(xmxxb.getXmbh());
			xxjl.setLxwh(xmxxb.getLxpw());
			
		}
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", xmxxb.getId());
		 paramMap.put("xmType1", "信息修改");
		attach = fawenAttachService.queryAttachListByTempleId(paramMap);

		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		FileInputStream in = null;
		Map<String, String> paraMap = new HashMap<String, String>();
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}
		try
		{
			Xmxxb xmxxb = xmxxbService.getById(xxjl.getXmbzj());
			Xxjl his = xxjlService.getByxmbzj(xxjl.getXmbzj());
			if (his == null)
			{
				xxjl.setDeptId(this.getLoginUserDepartmentId());
				xxjl.setDelFlag(0);
				xxjl.setJbr(this.getLoginUser().getDisplayName());
				xxjl.setState("0");
				xxjl.setZsdw(xmxxb.getZsdw());
				xxjlService.save(xxjl);
			}
			else
			{
				his.setState("0");
				his.setXmbzj(xxjl.getXmbzj());
				his.setSlbh(xxjl.getSlbh());
				his.setXmxxb(xxjl.getXmxxb());
				his.setDwmc(xxjl.getDwmc());
				his.setLxr(xxjl.getLxr());
				his.setPhone(xxjl.getPhone());
				his.setJsdwdz(xxjl.getJsdwdz());
				his.setXmmc(xxjl.getXmmc());
				his.setJbbz(xxjl.getJbbz());
				his.setFhbz(xxjl.getFhbz());
				his.setXmdz(xxjl.getXmdz());
				his.setCkbh(xxjl.getCkbh());
				his.setGhxmbh(xxjl.getGhxmbh());
				his.setLxwh(xxjl.getLxwh());
				xxjlService.update(his);
			}
			xmxxb.setBxzd3("1");
			xmxxbService.update(xmxxb);
			// 将附件相关信息放到附件表中
//			String str = this.getRequest().getSession().getServletContext().getRealPath(File.separator);
//			int len = "zhengshouWebRoot".length() + 1;
//			String url = str.substring(1, len);
//			String path = url + "uploads" + File.separator + xmxxb.getSlbh() + File.separator;
			
			 String path =
					 SysPropertiesUtil.jdlj(this.getRequest()) + File.separator + "uploads" + File.separator +
			  xmxxb.getSlbh() + File.separator;
			 

			// 写到指定的路径中
			JSONObject jsonObject = JSONObject.fromObject(allFileName);
			JSONObject jsonObject1 = JSONObject.fromObject(originFileName);
			String fileName = "";
			if ((file1 != null))
			{
				for (int i = 0; i < file1.size(); i++)
				{
					String attachType = jsonObject.getString(file1FileName.get(i));
					String clno = fawenAttachService.getByFscl(attachType);

					fileName = FileUtils.uploadFile(file1.get(i), file1FileName.get(i), path);

					paraMap.put("attachType", attachType);
					paraMap.put("bizrowid", xxjl.getXmbzj());
					List list = fawenAttachService.queryAttachListByTempleId(paraMap);
					if (list.size() > 0)
					{
						FawenAttach fawenAttach = (FawenAttach) list.get(0);
						fawenAttach.setAttachname(file1FileName.get(i));
						fawenAttach.setAttachpath(xmxxb.getSlbh() + File.separator + fileName);
						fawenAttach.setWdno(jsonObject1.getString(file1FileName.get(i)));
						if (StringUtils.isNotEmpty(clno))
						{
							fawenAttach.setXmType("缴费受理");
						}
						else
						{
							fawenAttach.setXmType("信息修改");
						}
						fawenAttachService.update(fawenAttach);
					}
					else
					{
						FawenAttach att = new FawenAttach();
						att.setDelFlag(0);
						att.setAttachname(file1FileName.get(i));
						att.setAttachpath(xmxxb.getSlbh() + File.separator +fileName);
						att.setBizrowid(xmxxb.getId());
						att.setCreateTime(new Date());
						att.setAttachType(attachType);
						if (StringUtils.isNotEmpty(clno))
						{
							att.setXmType("缴费受理");
						}
						else
						{
							att.setXmType("信息修改");
						}
						att.setWdno(jsonObject1.getString(file1FileName.get(i)));
						fawenAttachService.save(att);
					}

				}
			}
		} catch (Exception e)
		{
			throw new BasalException(BasalException.ERROR, e.getMessage(), e);
		}
		return RELOAD;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save1() throws Exception
	{
		FileInputStream in = null;
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}
		try
		{

			if ("1".equals(xxjl.getState()))
			{

				Xmxxb xmxxb = xmxxbService.getById(xxjl.getXmbzj());
				// 将旧的项目信息放入修改信息历史表
				saveXXhis(xmxxb);
				// 将项目信息表更新
				xmxxb.setJsdw(xxjl.getDwmc());
				xmxxb.setLianxiren(xxjl.getLxr());
				xmxxb.setPhone(xxjl.getPhone());
				xmxxb.setXmmc(xxjl.getXmmc());
//				xmxxb.setJsdd(xxjl.getJsdwdz());
				xmxxb.setJzdwdz(xxjl.getJsdwdz());
				xmxxb.setBxzd3("");
				xmxxb.setJsdd(xxjl.getXmdz());
				xmxxb.setCkbh(xxjl.getCkbh());
				xmxxb.setXmbh(xxjl.getGhxmbh());
				xmxxb.setLxpw(xxjl.getLxwh());
				xmxxbService.update(xmxxb);
				// 审批记录表,缴款通知书,代缴款,催款,其他费用,缴款明细
				Map<String, Object> vad = new HashMap<String, Object>();
				vad.put("slbh", xmxxb.getSlbh());
				//zjbh=Xmbh ckbh jsdwmc=jsdw jsdwdz=jzdwdz gcxmmc=xmmc lxr=lianxiren lxdh=phone 
				 List<Spjlb> listspjlb=spjlbService.findSpjlball(vad);
		            if(null!=listspjlb&&listspjlb.size()>0){
		            	Spjlb spbean=listspjlb.get(0);
		            	spbean.setZjbh(xmxxb.getXmbh());
		            	spbean.setCkbh(xmxxb.getCkbh());
		            	spbean.setJsdwmc(xmxxb.getJsdw());
		            	spbean.setJsdwdz(xmxxb.getJzdwdz());
		            	spbean.setGcxmmc(xmxxb.getXmmc());
		            	spbean.setLxr(xmxxb.getLianxiren());
		            	spbean.setLxdh(xmxxb.getPhone());
		            	spjlbService.update(spbean);
		            }
		            //dwmc=jsdw xmmc 
		        	List<PaymentItemPending> lis=paymentItemPendingService.findPaymentItemPending(vad);
		        	if(null!=lis&&lis.size()>0){
		        		PaymentItemPending pidbean=lis.get(0);
		        		pidbean.setDwmc(xmxxb.getJsdw());
		        		pidbean.setXmmc(xmxxb.getXmmc());
		        		paymentItemPendingService.update(pidbean);
		        	}
		        	//dwmc=jsdw xmmc xmdd=jsdd ckbh linxiren=lxr phone
	         		List<Jktzs> jktzs=jktzsService.findByAll(vad);
	         		if(null!=jktzs&&jktzs.size()>0){
	         			Jktzs jkbean=jktzs.get(0);
	         			jkbean.setDwmc(xmxxb.getJsdw());
	         			jkbean.setXmmc(xmxxb.getXmmc());
	         			jkbean.setXmdd(xmxxb.getJsdd());
	         			jkbean.setCkbh(xmxxb.getCkbh());
	         			jkbean.setLianxiren(xmxxb.getLianxiren());
	         			jkbean.setPhone(xmxxb.getPhone());
	         			jktzsService.update(jkbean);
	         		}
	         	
	         		List<Cktzs> lck=cktzsService.findByall(vad);
	         		if(null!=lck&&lck.size()>0){
	         			Cktzs lckbean=lck.get(0);
	         			lckbean.setDwmc(xmxxb.getJsdw());
	         			lckbean.setXmmc(xmxxb.getXmmc());
	         			lckbean.setXmdd(xmxxb.getJsdd());
	         			lckbean.setCkbh(xmxxb.getCkbh());
	         			lckbean.setLianxiren(xmxxb.getLianxiren());
	         			lckbean.setPhone(xmxxb.getPhone());
	         			cktzsService.update(lckbean);
	         		}
	         		
	         		//xmmc 多个
	         		List<Qtfymx> qt=qtfymxService.findall(vad);
	         		if(null!=qt&&qt.size()>0){
	         			for (Qtfymx qtfymxbean : qt) {
	         				qtfymxbean.setXmmc(xmxxb.getXmmc());
	         				qtfymxService.update(qtfymxbean);
						}
	         		}
	         		List<Jkmx> jkmxs=jkmxService.findall(vad);
	         		if(null!=jkmxs&&jkmxs.size()>0){
	         			for (Jkmx jkmxbean : jkmxs) {
	         				jkmxbean.setXmmc(xmxxb.getXmmc());
	         				jkmxService.update(jkmxbean);
						}
	         		}

				xxjl.setFhr(this.getLoginUser().getDisplayName());
				// xxjl.setDelFlag(1);
				xxjlService.update(xxjl);
				//审批表更新字段
				  Map<String, Object> vsp = new HashMap<String, Object>();
		            vsp.put("slbh", xmxxb.getSlbh());
		             List<Spjlb> ls=spjlbService.findSpjlball(vsp);
		             if(ls.size()>0){
		             Spjlb sp=ls.get(0);
		             sp.setJsdwmc(xmxxb.getJsdw());
		             sp.setJsdwdz(xmxxb.getJzdwdz());
		             sp.setGcxmmc(xmxxb.getXmmc());
		             sp.setLxr(xmxxb.getLianxiren());
                 sp.setLxdh(xmxxb.getPhone());	
                 spjlbService.update(sp);
		             }
				
				
			}
			else if ("2".equals(xxjl.getState()))
			{
				Xmxxb xmxxb = xmxxbService.getById(xxjl.getXmbzj());
				xmxxb.setBxzd3("");
				xmxxbService.update(xmxxb);
				// xxjl.setDelFlag(1);
				xxjlService.update(xxjl);
			}

		} catch (Exception e)
		{
			throw new BasalException(BasalException.ERROR, e.getMessage(), e);
		}
		return RELOAD;
	}

	private void saveXXhis(Xmxxb xmxxb)
	{
		Xxjlhis xxjlhis = new Xxjlhis();
		xxjlhis.setDelFlag(0);
		xxjlhis.setDeptId(this.getLoginUserDepartmentId());
		xxjlhis.setXmbzj(xxjl.getXmbzj());
		xxjlhis.setSlbh(xxjl.getSlbh());
		xxjlhis.setXmxxb(xxjl.getXmxxb());
		xxjlhis.setDwmc(xmxxb.getJsdw());
		xxjlhis.setLxr(xmxxb.getLianxiren());
		xxjlhis.setPhone(xmxxb.getPhone());
		xxjlhis.setJsdwdz(xmxxb.getJzdwdz());
		xxjlhis.setXmmc(xmxxb.getXmmc());
		xxjlhis.setJbbz(xxjl.getJbbz());
		xxjlhis.setJbr(xxjl.getJbr());
		xxjlhis.setFhbz(xxjl.getFhbz());
		xxjlhis.setXmdz(xmxxb.getJsdd());
		xxjlhis.setCkbh(xmxxb.getCkbh());
		xxjlhis.setGhxmbh(xmxxb.getXmbh());
		xxjlhis.setLxwh(xmxxb.getLxpw());
		xxjlhis.setFhr(this.getLoginUser().getDisplayName());
		xxjlService.save(xxjlhis);
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != xxjl)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到xxjl中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			xxjlService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Xxjl getXxjl()
	{
		return this.xxjl;
	}

	public void setXxjl(Xxjl xxjl)
	{
		this.xxjl = xxjl;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public void setFile1(List<File> file1)
	{
		this.file1 = file1;
	}

	public List<String> getFile1FileName()
	{
		return file1FileName;
	}

	public List<File> getFile1()
	{
		return file1;
	}

	public String getOriginFileName()
	{
		return originFileName;
	}

	public void setOriginFileName(String originFileName)
	{
		this.originFileName = originFileName;
	}

	public void setFile1FileName(List<String> file1FileName)
	{
		this.file1FileName = file1FileName;
	}

	public String getAllFileName()
	{
		return allFileName;
	}

	public void setAllFileName(String allFileName)
	{
		this.allFileName = allFileName;
	}

	public List<FawenAttach> getAttach()
	{
		return attach;
	}

	public void setAttach(List<FawenAttach> attach)
	{
		this.attach = attach;
	}

	public List<String> getBase64()
	{
		return base64;
	}

	public void setBase64(List<String> base64)
	{
		this.base64 = base64;
	}

}
