package com.jshx.xmdrb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmdrb.entity.Xmdrb;
import com.jshx.xmdrb.dao.XmdrbDao;

@Component("xmdrbDao")
public class XmdrbDaoImpl extends BaseDaoImpl implements XmdrbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findXmdrbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findXmdrb(Map<String, Object> paraMap){
		return this.findListByHqlId("findXmdrbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xmdrb getById(String id)
	{
		return (Xmdrb)this.getObjectById(Xmdrb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Xmdrb xmdrb)
	{
		xmdrb.setId(null);
		this.saveOrUpdateObject(xmdrb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Xmdrb xmdrb)
	{
		this.saveOrUpdateObject(xmdrb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Xmdrb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Xmdrb xmdrb = (Xmdrb)this.getObjectById(Xmdrb.class, id);
		xmdrb.setDelFlag(1);
		this.saveObject(xmdrb);
	}
}
