package com.jshx.wwxzfjb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.wwxzfjb.entity.Wwxzfjb;
import com.jshx.wwxzfjb.dao.WwxzfjbDao;

@Component("wwxzfjbDao")
public class WwxzfjbDaoImpl extends BaseDaoImpl implements WwxzfjbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findWwxzfjbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findWwxzfjb(Map<String, Object> paraMap){
		return this.findListByHqlId("findWwxzfjbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Wwxzfjb getById(String id)
	{
		return (Wwxzfjb)this.getObjectById(Wwxzfjb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Wwxzfjb wwxzfjb)
	{
		wwxzfjb.setId(null);
		this.saveOrUpdateObject(wwxzfjb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Wwxzfjb wwxzfjb)
	{
		this.saveOrUpdateObject(wwxzfjb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Wwxzfjb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Wwxzfjb wwxzfjb = (Wwxzfjb)this.getObjectById(Wwxzfjb.class, id);
		wwxzfjb.setDelFlag(1);
		this.saveObject(wwxzfjb);
	}
}
