package com.jshx.sms;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jshx.common.utils.Constant;
import com.jshx.core.utils.Constants;

import cn.com.jshx.sender.SenderFactory;



/**
 * @author : FengJingzhun
 * @version : 1.0
 * @date : 2009-5-20 16:32:18
 */
public class SMSEntry extends DelayBean {
	public static Logger log = LoggerFactory.getLogger(SMSEntry.class);
    private String phoneNo;
    private String content;
    private String type;
    private Integer insertId;
    private String id;//插入短信表时生成
    private String sendNo;
    /** 发送短信方式*/
    private String mod;
    /**
	 * 短信端口
	 */
	private String sxtPort;

	/**
	 * 短信地址
	 */
	private String sxtAddress;

	/**
	 * 短信帐号
	 */
	private String sxtUser;

	/**
	 * 密码
	 */
	private String sxtPassword;
    
	public String getPhoneNo() {
		return phoneNo;
	}

	public void setPhoneNo(String phoneNo) {
		this.phoneNo = phoneNo;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getInsertId() {
		return insertId;
	}

	public void setInsertId(Integer insertId) {
		this.insertId = insertId;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getMod() {
		return mod;
	}

	public void setMod(String mod) {
		this.mod = mod;
	}
	@Override
    public String toString() {
        return "SMSEntry{" +
                "phoneNo='" + phoneNo + '\'' +
                ", content='" + content + '\'' +
                ", type='" + type + '\'' +
                ", insertId=" + insertId +
                ", id=" + id +
                '}';
    }

    public void doLogic() throws Exception
    {
        SMSCenter.sentResult(this.getId(), Constant.TB_SMS_SENT_RESULT_2);
        //int result = getSmsDriver().send(this.getPhoneNo(), this.getContent());
        Map<String,String> map = new HashMap<String,String>();
        map.put(Constants.SXT_ADDRESS, this.getSxtAddress());	//地址
		map.put(Constants.SXT_PORT, this.getSxtPort());			//端口
		map.put(Constants.SXT_USER, this.getSxtUser());			//用户名
		map.put(Constants.SXT_PASSWORD, this.getSxtPassword());	//密码
		
		int result = SenderFactory.factory().send(map,this.getPhoneNo(), this.getContent());
		log.info("this.getPhoneNo() =========="+this.getPhoneNo()+"==============result ========="+result);
        if (result == 0) {
        	//发送成功
        	SMSCenter.sentResult(this.getId(), Constant.TB_SMS_SENT_RESULT_3);
        } else {
        	SMSCenter.sentResult(this.getId(), Constant.TB_SMS_SENT_RESULT_4);
        }
    }

	public String getSendNo() {
		return sendNo;
	}

	public void setSendNo(String sendNo) {
		this.sendNo = sendNo;
	}

	public String getSxtPort() {
		return sxtPort;
	}

	public void setSxtPort(String sxtPort) {
		this.sxtPort = sxtPort;
	}

	public String getSxtAddress() {
		return sxtAddress;
	}

	public void setSxtAddress(String sxtAddress) {
		this.sxtAddress = sxtAddress;
	}

	public String getSxtUser() {
		return sxtUser;
	}

	public void setSxtUser(String sxtUser) {
		this.sxtUser = sxtUser;
	}

	public String getSxtPassword() {
		return sxtPassword;
	}

	public void setSxtPassword(String sxtPassword) {
		this.sxtPassword = sxtPassword;
	}
}
