package com.jshx.rfdz.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.rfdz.entity.Rfdz;
import com.jshx.rfdz.service.RfdzService;
import com.jshx.zsdw.service.ZsdwService;
import com.neusoft.egov.utils.TextUtils;
import net.sf.json.JsonConfig;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RfdzAction extends BaseAction
{
	String ghxkzbh;
	String jfpzbh;
	String xxbbh;
	String ghxmbh;
	String jsdwmc;
	String gcxmmc;
	String jfhj;
	String hczt;
	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private Rfdz rfdz = new Rfdz();

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 项目id
	 */
	private String ids;
	/**
	 * 业务类
	 */
	@Autowired
	private PaymentItemHisService paymentItemHisService;

	@Autowired
	private RfdzService rfdzService;

	@Autowired
	private ZsdwService zsdwService;


	public void list() throws Exception{

		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
			pagination = new Pagination(this.getRequest());

			paraMap.put("isCwyz", "1");// 财务用章

		if (!TextUtils.isEmpty(ghxkzbh)){
			paraMap.put("xkzh", "%" + ghxkzbh + "%");
		}

		if(!TextUtils.isEmpty(jfpzbh)) {
			paraMap.put("zslxdbh", "%" + jfpzbh + "%");
		}

		if (!TextUtils.isEmpty(xxbbh)){
			paraMap.put("xxbbh", "%" + xxbbh + "%");
		}

		if (!TextUtils.isEmpty(ghxmbh)){
			paraMap.put("xmbh", "%" + ghxmbh + "%");
		}

		if (!TextUtils.isEmpty(jsdwmc)){
			paraMap.put("jsdw", "%" + jsdwmc + "%");
		}

		if (!TextUtils.isEmpty(gcxmmc)){
			paraMap.put("jsdd", "%" + gcxmmc + "%");
		}

		//TODO 缴费环节、核查状态筛选
		//1施工许可前	2：30日内
		if(!TextUtils.isEmpty(jfhj) && "0".equals(jfhj)) {

		}

		//1已同步 2未同步
		if(!TextUtils.isEmpty(hczt) && "0".equals(hczt)) {

		}

		if(!this.getLoginUser().getIsSuperAdmin()){
			String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
			paraMap.put("dwdm", dwdm);
		}

		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
//		final String filter = "isCwyz|id|slbh|isfdx|dwmc|xmmc|mjyj|dkxmslh|zsdw|dkmj|csmj|ptyjmj|ptyjje|ptymje|ptymmj|rfyjmj|rfyjje|rfymmj|rfymje|xqyjje|xqymmj|xqymje|xqyjmj|byyjmj|byyjje|byymmj|byymje|zyjje|zymje|warnFlag|accountbankId|lockFlag|xmbzj|zslxdbh|ECN|xmxxb|xmxxb.xxylb|xmxxb.";
//		if (filter != null && filter.length() > 1) {
//			config.setJsonPropertyFilter(new PropertyFilter() {
//				public boolean apply(Object source, String name, Object value) {
//					if (filter.indexOf(name + "|") != -1)
//						return false;
//					else
//						return true;
//				}
//			});
//		}
		pagination = paymentItemHisService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}


	public void rfList() {
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null) {
			pagination = new Pagination(this.getRequest());
		}

		if(null != ids){
			paraMap.put("zzhxmid", ids);
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
		/*final String filter = "id|accountName|accountDetail|accountStatus|jktzsbh|xmdm|ghxkzbh|ghxmbh|jsdwmc|gcxmmc|gcxmdd|sfxmmc|shbm|yjjemx|jktzyjjehj|cnjfhj|status|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}*/
		/*Map<String, Object> tempMap = new HashMap<>();
		tempMap.put("jfdmwybh", "111SF001南京市城市建设费用征收服务中心第1轮");
		List sfxxs = zzhxmSfxxService.findZzhxmSfxx(tempMap);*/
		pagination = rfdzService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 保存信息（包括新增和补录）
	 */
	public String save() throws Exception{
		if ("add".equalsIgnoreCase(this.flag)){
			rfdz.setDeptId(this.getLoginUserDepartmentId());
			rfdz.setDelFlag(0);
			rfdzService.save(rfdz);
		}else{
			//TODO 判断审核人和创建人是否一致
			Rfdz model = rfdzService.getById(rfdz.getId());
			model.setBeizhu(rfdz.getBeizhu());
			model.setJfcn(rfdz.getJfcn());
			model.setSfxmlxdbh(rfdz.getSfxmlxdbh());
			model.setSfxmmc(rfdz.getSfxmmc());
			model.setDeptId(rfdz.getDeptId());
			model.setShbm(rfdz.getShbm());
			model.setXmbzj(rfdz.getXmbzj());
			model.setYhjn(rfdz.getYhjn());
			rfdzService.update(model);
		}

		return RELOAD;
	}

	/**
	 * 更新状态
	 */
	public void update() {

	}

	/**
	 * 详情
	 */
	public void detail() {

	}


	public String getGhxkzbh() {
		return ghxkzbh;
	}

	public void setGhxkzbh(String ghxkzbh) {
		this.ghxkzbh = ghxkzbh;
	}

	public String getJfpzbh() {
		return jfpzbh;
	}

	public void setJfpzbh(String jfpzbh) {
		this.jfpzbh = jfpzbh;
	}

	public String getXxbbh() {
		return xxbbh;
	}

	public void setXxbbh(String xxbbh) {
		this.xxbbh = xxbbh;
	}

	public String getGhxmbh() {
		return ghxmbh;
	}

	public void setGhxmbh(String ghxmbh) {
		this.ghxmbh = ghxmbh;
	}

	public String getJsdwmc() {
		return jsdwmc;
	}

	public void setJsdwmc(String jsdwmc) {
		this.jsdwmc = jsdwmc;
	}

	public String getGcxmmc() {
		return gcxmmc;
	}

	public void setGcxmmc(String gcxmmc) {
		this.gcxmmc = gcxmmc;
	}

	public String getJfhj() {
		return jfhj;
	}

	public void setJfhj(String jfhj) {
		this.jfhj = jfhj;
	}

	public String getHczt() {
		return hczt;
	}

	public void setHczt(String hczt) {
		this.hczt = hczt;
	}

	public Rfdz getRfdz() {
		return rfdz;
	}

	public void setRfdz(Rfdz rfdz) {
		this.rfdz = rfdz;
	}

	public Pagination getPagination() {
		return pagination;
	}

	public void setPagination(Pagination pagination) {
		this.pagination = pagination;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public String getIds() {
		return ids;
	}

	public void setIds(String ids) {
		this.ids = ids;
	}
}
