package com.jshx.qtfymx.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.qtfymx.dao.QtfymxDao;

@Component("qtfymxDao")
public class QtfymxDaoImpl extends BaseDaoImpl implements QtfymxDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findQtfymxByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findQtfymx(Map<String, Object> paraMap){
		return this.findListByHqlId("findQtfymxByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Qtfymx getById(String id)
	{
		return (Qtfymx)this.getObjectById(Qtfymx.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Qtfymx qtfymx)
	{
		qtfymx.setId(null);
		this.saveOrUpdateObject(qtfymx);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Qtfymx qtfymx)
	{
		this.saveOrUpdateObject(qtfymx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Qtfymx.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Qtfymx qtfymx = (Qtfymx)this.getObjectById(Qtfymx.class, id);
		qtfymx.setDelFlag(1);
		this.saveObject(qtfymx);
	}
}
