package com.jshx.paymentItemHis.web;

import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.jshx.wwjdclinfo.entity.Wwjdclinfo;
import com.jshx.wwjdclinfo.service.WwjdclinfoService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.activiti.service.ActivitiService;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.Constant;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.pzmx.service.PzmxService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.opensymphony.xwork2.ActionContext;

public class PaymentItemHisAction extends BaseAction
{

	/**
	 * 主键ID，用于接收页面提交的主键ID信息
	 */
	private String id;
	
	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private PaymentItemHis paymentItemHis = new PaymentItemHis();

	/**
	 * 业务类
	 */
	@Autowired
	private PaymentItemHisService paymentItemHisService;
	
	@Autowired
	private XmxxbService xmxxbService;
	
	@Autowired
	private ZsdwService zsdwService;
	
	@Autowired
    private IdentityService identityService;
	
	@Autowired
    protected RuntimeService runtimeService;
	
    @Autowired
    protected TaskService taskService;
    
    @Autowired
    private ActivitiService activitiService;
	@Autowired
	private SpjlbService spjlbService;
	@Autowired
	private CktzsService cktzsService;
	 @Autowired
	    private FawenAttachService fawenAttachService;
	 @Autowired
		private DxpzService dxpzService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	@Autowired
	private PzmxService pzmxService;
	@Autowired
	private WwjdclinfoService wwjdclinfoService;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	private String orderId;

	private String taskId;

	private String comment;

	private String outcome;
	
	private String yjje;

	private Xmxxb xmxxb;
	
	private List<FawenAttach> attach;
	private List<File> file1 ;  
	private List<Wwjdclinfo> wwjdclinfos ;
	 private List<String> file1FileName ;
	private String allFileName;
	private String originFileName;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != paymentItemHis){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != paymentItemHis.getSlbh()) && (0 < paymentItemHis.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + paymentItemHis.getSlbh().trim() + "%");
			}

			if ((null != paymentItemHis.getDwmc()) && (0 < paymentItemHis.getDwmc().trim().length())){
				paraMap.put("dwmc", "%" + paymentItemHis.getDwmc().trim() + "%");
			}

			if ((null != paymentItemHis.getXmmc()) && (0 < paymentItemHis.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + paymentItemHis.getXmmc().trim() + "%");
			}
			
			if ((null != paymentItemHis.getZsdw()) && (0 < paymentItemHis.getZsdw().trim().length())){
				paraMap.put("zsdw", "%" + paymentItemHis.getZsdw().trim() + "%");
			}
			
			if ((null != paymentItemHis.getLockFlag()) && (0 < paymentItemHis.getLockFlag().trim().length())){
				paraMap.put("lockFlag", paymentItemHis.getLockFlag().trim());
			}
			
			if ((null != paymentItemHis.getZyjje()) && (0 < paymentItemHis.getZyjje().trim().length())){
				paraMap.put("zyjje", paymentItemHis.getZyjje().trim());
			}
			
			if ((null != paymentItemHis.getPtyjje()) && (0 < paymentItemHis.getPtyjje().trim().length())){
				paraMap.put("ptyjje", paymentItemHis.getPtyjje().trim());
			}
			
			if(null != yjje && 0 < yjje.trim().length()){
				DecimalFormat  df = new DecimalFormat("#0.00");
				yjje = df.format(Double.valueOf(yjje));
				paraMap.put("yjje", yjje);
			}
			
			if ((null != paymentItemHis.getNonTaxStatus()) && (0 < paymentItemHis.getNonTaxStatus().trim().length())){
				paraMap.put("nonTaxStatus", paymentItemHis.getNonTaxStatus().trim());
			}
			
			if ((null != paymentItemHis.getIsCreateJfpz()) && (0 < paymentItemHis.getIsCreateJfpz().trim().length())){
				paraMap.put("isCreateJfpz", paymentItemHis.getIsCreateJfpz().trim());
			}
			if ((null != paymentItemHis.getZslxdbh()) && (0 < paymentItemHis.getZslxdbh().trim().length())){
				paraMap.put("zslxdbh", "%" + paymentItemHis.getZslxdbh().trim() + "%");
			}
			if ((null != paymentItemHis.getECN()) && (0 < paymentItemHis.getECN().trim().length())){
				paraMap.put("ecnn", "%" +paymentItemHis.getECN().trim()+ "%");
			}
			if ((null != paymentItemHis.getIsfdx()) && (0 < paymentItemHis.getIsfdx().trim().length())){
			    if("1".equals(paymentItemHis.getIsfdx().trim())){
			        paraMap.put("isfdx", paymentItemHis.getIsfdx().trim());
			        
			    }
			    if("0".equals(paymentItemHis.getIsfdx().trim())){
			        paraMap.put("notisfdx", "%" +paymentItemHis.getIsfdx().trim()+ "%");
			        
			    }
			}
			
			if(!this.getLoginUser().getIsSuperAdmin()){
            	String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
            	paraMap.put("dwdm", dwdm);
            }

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "isCwyz|id|slbh|isfdx|dwmc|xmmc|mjyj|dkxmslh|zsdw|dkmj|csmj|ptyjmj|ptyjje|ptymje|ptymmj|rfyjmj|rfyjje|rfymmj|rfymje|xqyjje|xqymmj|xqymje|xqyjmj|byyjmj|byyjje|byymmj|byymje|zyjje|zymje|warnFlag|accountbankId|lockFlag|xmbzj|zslxdbh|ECN|xmxxb|xmxxb.xxylb|xmxxb.";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = paymentItemHisService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}


	/**
	 *财务用章
	 * @throws Exception
	 */
	public void cwyz() throws Exception {
		PaymentItemHis model = paymentItemHisService.getById(id);
		model.setIsCwyz("1");
		paymentItemHisService.update(model);
		//TODO 新增表人防费，把他加入人防费表内
	}

	/**
	 * 生成凭证
	 * @throws Exception
	 */
	public void scpz() throws Exception {
		PaymentItemHis model = paymentItemHisService.getById(id);
		model.setIsCreateJfpz("1");
		model.setZslxdbh(paymentItemHisService.getPzbh() + 1 + "");//取出历史最大 + 1
		paymentItemHisService.update(model);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		Map map = new HashMap();
		map.put("xxylb",xmxxb.getXxylb());
		Pagination  pagination1 = wwjdclinfoService.findByPage(new Pagination(1,0),map);
		wwjdclinfos = pagination1.getListOfObject();
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			paymentItemHis.setDeptId(this.getLoginUserDepartmentId());
			paymentItemHis.setDelFlag(0);
			paymentItemHis.setYzsFlag(2);
			paymentItemHisService.save(paymentItemHis);
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", paymentItemHis.getSlbh().trim());
			List<Cktzs> cks=cktzsService.findByall(paraMap);
			if(null!=cks&&cks.size()>0){
//				Cktzs ck=cks.get(0);
//				ck.setIsjk("1");
//				ck.setJksj(new Date());
//				cktzsService.update(ck);
			}
			
		}else{
			PaymentItemHis model = paymentItemHisService.getById(paymentItemHis.getId());
			model.setZslxdbh(paymentItemHis.getZslxdbh());	
			model.setRffpbh(paymentItemHis.getRffpbh());
			model.setRfkpsj(paymentItemHis.getRfkpsj());
			model.setXqfpbh(paymentItemHis.getXqfpbh());
			model.setXqtkpsj(paymentItemHis.getXqtkpsj());
			model.setByfpbh(paymentItemHis.getByfpbh());
			model.setBykpsj(paymentItemHis.getBykpsj());
			paymentItemHisService.update(model);
			
//			Map<String, Object> paraMap = new HashMap<String, Object>();	
//			paraMap.put("mxno", "%"+paymentItemHis.getZslxdbh()+"%");
//			Pzmx pzmx=pzmxService.findPzmxByNo(paraMap);
//			pzmx.setIsprint("1");
//			pzmx.setState("0");
//			pzmx.setSyDate(sdf.format(new Date()));
//			pzmxService.update(pzmx);
			
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != paymentItemHis)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到paymentItemHis中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			paymentItemHisService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	/**
	 * 解锁经办
	 * @return
	 */
	public String toOperator(){
		paymentItemHis = paymentItemHisService.getById(paymentItemHis.getId());
		xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
		return SUCCESS;
	}
	
	/**
	 * 解锁经办办理
	 * @throws Exception
	 */
	public String unlock() throws Exception{
//		try{
			paymentItemHis = paymentItemHisService.getById(paymentItemHis.getId());
			paymentItemHis.setLockFlag(Constant.STATUS_LOCK_0);//解锁状态中
			paymentItemHis.setOperatorComment(comment);//经办意见
			paymentItemHis.setOperatorId(this.getLoginUserId());
			paymentItemHis.setOperateDate(new Date());
			Map<String, String> paraMap = new HashMap<String, String>();
			 String path = SysPropertiesUtil.jdlj(this.getRequest())
						+ File.separator+ "uploads" +File.separator+paymentItemHis.getSlbh()+File.separator;
			
			 JSONObject jsonObject = JSONObject.fromObject(allFileName); 
		        JSONObject jsonObject1= JSONObject.fromObject(originFileName);
		    	String fileName = "";
						if(file1!=null)
						{
						  for(int i = 0 ; i < file1.size() ; i++ )  
					        {  
							  String attachType = jsonObject.getString(file1FileName.get(i));
//							  String clno = fawenAttachService.getByFscl(attachType);
							  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path);
							  paraMap.put("attachType", attachType);
							  paraMap.put("bizrowid", paymentItemHis.getXmbzj());
							  paraMap.put("xmType", "项目解锁");
							 List list = fawenAttachService.queryAttachListByTempleId(paraMap);
							 if(list.size()>0)
							 {
								 FawenAttach fawenAttach = (FawenAttach) list.get(0);
								 fawenAttach.setAttachname(file1FileName.get(i));
								 fawenAttach.setAttachpath(paymentItemHis.getSlbh()+File.separator+fileName);
								fawenAttach.setXmType("项目解锁");
								 fawenAttach.setWdno(jsonObject1.getString(file1FileName.get(i)));
								 fawenAttachService.update(fawenAttach);
							 }
							 else
							 {
							  FawenAttach att = new FawenAttach();
								att.setDelFlag(0);
								att.setAttachname(file1FileName.get(i));
								att.setAttachpath(paymentItemHis.getSlbh()+File.separator+fileName);
								att.setBizrowid( paymentItemHis.getXmbzj());
								att.setCreateTime(new Date());
								att.setAttachType(attachType);
										att.setXmType("项目解锁");
								att.setWdno(jsonObject1.getString(file1FileName.get(i)));
								fawenAttachService.save(att);
							 }
					             
					              
					        } 	
						}
			paymentItemHisService.update(paymentItemHis);
    		identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
    		ProcessInstance processInstance =runtimeService.startProcessInstanceByKey(Constant.PROCESS_UNLOCK,paymentItemHis.getXmbzj());//项目表主键
    		//将解锁工作流实例放入记录表中
    		String aaa=processInstance.getProcessInstanceId();
    		Spjlb s=spjlbService.getByslbh(paymentItemHis.getSlbh());
    		if(null!=s){
    	     	s.setJsgzl(aaa);
    	     	s.setJsr(this.getLoginUser().getDisplayName());
    	     	s.setJssj(new Date());
    	    	spjlbService.update(s);
    	    	String neirong=s.getSlbh()+"-"+s.getGcxmmc()+"已冻结,申请解锁,请予办理";
    	    	//解锁工作流 统一发短信到收费处
    	    	String phones=dxpzService.findbyywbm("003","sf");
    	    	if(!"".equals(phones)){
//    	    		CommonAction.send(neirong, phones, this.getLoginUserDepartmentId(),this.getLoginUser().getDisplayName());
    	    		CommonAction.sendNewMessage(neirong, phones, this.getLoginUserDepartmentId(),this.getLoginUser().getDisplayName());
    	    	}
    		}
    		return RELOAD;
	}
	
	/**
	 * 解锁复核
	 * @return
	 * @throws Exception
	 */
	public String toCheck() throws Exception{
		Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String businessKey =  processInstance.getBusinessKey();
        paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
        xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
        List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
        ActionContext.getContext().put("outcomeList", outcomeList);
        
        Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", xmxxb.getId());
		paramMap.put("xmType", "项目解锁");
		attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		return SUCCESS;
	}
	
	/**
	 * 解锁复核办理
	 * @throws Exception
	 */
	public void submitCheck() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            Map<String, Object> variables = new HashMap<String, Object>();
            variables.put("outcome", outcome);
            if("驳回".equals(outcome)){
            	 ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                 String businessKey =  processInstance.getBusinessKey();
                 paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
                 paymentItemHis.setLockFlag("1");
                 paymentItemHisService.update(paymentItemHis);
            }
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
	
	/**
	 * 解锁审核
	 * @return
	 * @throws Exception
	 */
	public String toAudit() throws Exception{
		Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String businessKey =  processInstance.getBusinessKey();
        paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
        xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
        List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
        ActionContext.getContext().put("outcomeList", outcomeList);
        
        
        Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", xmxxb.getId());
		paramMap.put("xmType", "项目解锁");
		attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		return SUCCESS;
	}
	
	/**
	 * 解锁审核办理
	 * @throws Exception
	 */
	public void submitAudit() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String businessKey =  processInstance.getBusinessKey();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            //状态改为无锁状态
            if(Constant.OUTCOME_PASS.equals(outcome)){
            	paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
            	paymentItemHis.setLockFlag(Constant.STATUS_LOCK_2);
            	paymentItemHisService.update(paymentItemHis);
            }
            Map<String, Object> variables = new HashMap<String, Object>();
            variables.put("outcome", outcome);
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public PaymentItemHis getPaymentItemHis(){
		return this.paymentItemHis;
	}

	public void setPaymentItemHis(PaymentItemHis paymentItemHis){
		this.paymentItemHis = paymentItemHis;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}
       
	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getOutcome() {
		return outcome;
	}

	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}

	public String getYjje() {
		return yjje;
	}

	public void setYjje(String yjje) {
		this.yjje = yjje;
	}

	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	public List<FawenAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<FawenAttach> attach) {
		this.attach = attach;
	}

	public List<File> getFile1() {
		return file1;
	}

	public void setFile1(List<File> file1) {
		this.file1 = file1;
	}

	public List<String> getFile1FileName() {
		return file1FileName;
	}

	public void setFile1FileName(List<String> file1FileName) {
		this.file1FileName = file1FileName;
	}

	public String getAllFileName() {
		return allFileName;
	}

	public void setAllFileName(String allFileName) {
		this.allFileName = allFileName;
	}

	public String getOriginFileName() {
		return originFileName;
	}

	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}
	
	
}
