package com.jshx.paymentItemHis.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.dao.PaymentItemHisDao;

@Component("paymentItemHisDao")
public class PaymentItemHisDaoImpl extends BaseDaoImpl implements PaymentItemHisDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentItemHisByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentItemHis(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentItemHisByMap", paraMap);
	}
	public List findsuoyou(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentItemHisByMap1", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemHis getById(String id)
	{
		return (PaymentItemHis)this.getObjectById(PaymentItemHis.class, id);
	}


	/**
	 * 获取凭证编号，当前最大值+1
	 * @return
	 */
	public int getPzbh()
	{
		Pagination pagination = new Pagination(1,1);
		Pagination page = this.findPageByHqlId("getPzbh", new HashMap<>(), pagination);
		try {
			List<PaymentItemHis> list = page.list;
			return Integer.parseInt(list.get(0).getZslxdbh());
		} catch (Exception e) {

		}
		return 0;
	}

	/**
	 * 保存信息
	 */
	public void save(PaymentItemHis paymentItemHis)
	{
		paymentItemHis.setId(null);
		this.saveOrUpdateObject(paymentItemHis);
	}

	/**
	 * 修改信息
	 */
	public void update(PaymentItemHis paymentItemHis)
	{
		this.saveOrUpdateObject(paymentItemHis);
	}

	/**
	 * 物理删除信息
	 */
	public void delete(String id)
	{
		this.removeObjectById(PaymentItemHis.class, id);
	}

	/**
	 * 逻辑删除信息
	 */
	public void deleteWithFlag(String id)
	{
		PaymentItemHis paymentItemHis = (PaymentItemHis)this.getObjectById(PaymentItemHis.class, id);
		paymentItemHis.setDelFlag(1);
		this.saveObject(paymentItemHis);
	}
}
