package com.jshx.paymentItemDelayHis.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemDelayHis.entity.PaymentItemDelayHis;
import com.jshx.paymentItemDelayHis.dao.PaymentItemDelayHisDao;

@Component("paymentItemDelayHisDao")
public class PaymentItemDelayHisDaoImpl extends BaseDaoImpl implements PaymentItemDelayHisDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentItemDelayHisByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentItemDelayHis(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentItemDelayHisByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemDelayHis getById(String id)
	{
		return (PaymentItemDelayHis)this.getObjectById(PaymentItemDelayHis.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentItemDelayHis paymentItemDelayHis)
	{
		paymentItemDelayHis.setId(null);
		this.saveOrUpdateObject(paymentItemDelayHis);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentItemDelayHis paymentItemDelayHis)
	{
		this.saveOrUpdateObject(paymentItemDelayHis);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(PaymentItemDelayHis.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		PaymentItemDelayHis paymentItemDelayHis = (PaymentItemDelayHis)this.getObjectById(PaymentItemDelayHis.class, id);
		paymentItemDelayHis.setDelFlag(1);
		this.saveObject(paymentItemDelayHis);
	}
}
