package com.jshx.mobile.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.jshx.core.base.vo.Pagination;

public interface MobileDao<T, PK extends Serializable> {

	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	public Object findClassById(Class class1, String id);

	public List<T> findListById(Map<String, Object> paraMap);

	public Object findClassByObject(Class class1, String string, String id);

	public List<T> findListBySqlId(Map<String, Object> paraMap);

	public Pagination findBySqlId(Pagination page, Map<String, Object> paraMap);

	public List<T> findListByObject(Map<String, Object> paraMap);

	public void update(T obj);

	public void saveOrUpdate(T entity);

	public void deleteWithFlag(String hql);

	public String getNextVal();

	public Object getObjectByProperty(Class entity, String[] name, Object[] value);

	public void updateByHql(String hql);

	public void saveOrUpdateByHql(T entity);

	public void saveOrUpdate(List<T> list);

	public void deleteBySql(Map<String, Object> paraMap);

	public void saveAllOrUpdateAll(Collection obj);

	public void delete(T t);

}
