package com.jshx.hisxrsfxxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrsfxxb.entity.Hisxrsfxxb;
import com.jshx.hisxrsfxxb.dao.HisxrsfxxbDao;

@Component("hisxrsfxxbDao")
public class HisxrsfxxbDaoImpl extends BaseDaoImpl implements HisxrsfxxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxrsfxxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxrsfxxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxrsfxxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrsfxxb getById(String id)
	{
		return (Hisxrsfxxb)this.getObjectById(Hisxrsfxxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxrsfxxb hisxrsfxxb)
	{
		hisxrsfxxb.setId(null);
		this.saveOrUpdateObject(hisxrsfxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxrsfxxb hisxrsfxxb)
	{
		this.saveOrUpdateObject(hisxrsfxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxrsfxxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxrsfxxb hisxrsfxxb = (Hisxrsfxxb)this.getObjectById(Hisxrsfxxb.class, id);
		hisxrsfxxb.setDelFlag(1);
		this.saveObject(hisxrsfxxb);
	}
}
