package com.jshx.hisxrhjkb.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrhjkb.dao.HisxrhjkbDao;
import com.jshx.hisxrhjkb.entity.Hisxrhjkb;
import com.jshx.hisxrhjkb.service.HisxrhjkbService;

@Service("hisxrhjkbService")
public class HisxrhjkbServiceImpl extends BaseServiceImpl implements HisxrhjkbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("hisxrhjkbDao")
	private HisxrhjkbDao hisxrhjkbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hisxrhjkbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrhjkb getById(String id)
	{
		return hisxrhjkbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hisxrhjkb hisxrhjkb)
	{
		hisxrhjkbDao.save(hisxrhjkb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hisxrhjkb hisxrhjkb)
	{
		hisxrhjkbDao.update(hisxrhjkb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=hisxrhjkbDao.findHisxrhjkb(paraMap);
		
		hisxrhjkbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    hisxrhjkbDao.deleteWithFlag(id);
			}
		}
	}
}
