package com.jshx.hishxjfjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxjfjlb.entity.Hishxjfjlb;
import com.jshx.hishxjfjlb.dao.HishxjfjlbDao;

@Component("hishxjfjlbDao")
public class HishxjfjlbDaoImpl extends BaseDaoImpl implements HishxjfjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHishxjfjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHishxjfjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHishxjfjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxjfjlb getById(String id)
	{
		return (Hishxjfjlb)this.getObjectById(Hishxjfjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hishxjfjlb hishxjfjlb)
	{
		hishxjfjlb.setId(null);
		this.saveOrUpdateObject(hishxjfjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hishxjfjlb hishxjfjlb)
	{
		this.saveOrUpdateObject(hishxjfjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hishxjfjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hishxjfjlb hishxjfjlb = (Hishxjfjlb)this.getObjectById(Hishxjfjlb.class, id);
		hishxjfjlb.setDelFlag(1);
		this.saveObject(hishxjfjlb);
	}
}
