package com.jshx.hishxjbxxb.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxjbxxb.dao.HishxjbxxbDao;
import com.jshx.hishxjbxxb.entity.Hishxjbxxb;
import com.jshx.hishxjbxxb.service.HishxjbxxbService;

@Service("hishxjbxxbService")
public class HishxjbxxbServiceImpl extends BaseServiceImpl implements HishxjbxxbService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("hishxjbxxbDao")
	private HishxjbxxbDao hishxjbxxbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hishxjbxxbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxjbxxb getById(String id)
	{
		return hishxjbxxbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hishxjbxxb hishxjbxxb)
	{
		hishxjbxxbDao.save(hishxjbxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hishxjbxxb hishxjbxxb)
	{
		hishxjbxxbDao.update(hishxjbxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list = Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = hishxjbxxbDao.findHishxjbxxb(paraMap);

		hishxjbxxbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		String[] idArray = ids.split("\\|");
		if (null != idArray)
		{
			for (String id : idArray)
			{
				if (id != null && !id.trim().equals(""))
					hishxjbxxbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Hishxjbxxb> query(Map<String, Object> map)
	{
		return hishxjbxxbDao.findHishxjbxxb(map);
	}
}
