package com.jshx.dxpz.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.dxpz.dao.DxpzDao;
import com.jshx.dxpz.entity.Dxpz;
import com.jshx.dxpz.service.DxpzService;

@Service("dxpzService")
public class DxpzServiceImpl extends BaseServiceImpl implements DxpzService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("dxpzDao")
	private DxpzDao dxpzDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return dxpzDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Dxpz getById(String id)
	{
		return dxpzDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Dxpz dxpz)
	{
		dxpzDao.save(dxpz);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Dxpz dxpz)
	{
		dxpzDao.update(dxpz);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=dxpzDao.findDxpz(paraMap);
		
		dxpzDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    dxpzDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public String getphones(String bianma, String dwdm) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ywbm", bianma);
		paraMap.put("dwdm", dwdm);
		List<Dxpz> objects=dxpzDao.findDxpz(paraMap);
		if(objects.size()>0){
			String phones="";
 			for (Dxpz dxpz : objects) {
 				phones+=dxpz.getPhone()+",";
			}
 			return phones;
		}else{
			
		return null;
		}
	}

	@Override
	public List<Dxpz> findall(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return dxpzDao.findDxpz(paraMap);
	}

	@Transactional
	public String findbyywbm(String ywbm, String dwdm) {
		Map<String, Object> pmap = new HashMap<>();
		pmap.put("ywbm", ywbm);
		if(!"9999".equals(dwdm)){
		    pmap.put("dwdm", dwdm);
		}
		List<Dxpz> ld= dxpzDao.findDxpz(pmap);
//		String phones="";
		StringBuffer phones=new StringBuffer();
		if(null!=ld&&ld.size()>0){
		   for (Dxpz dxpz : ld) {
			  String phone="";
		      phone=dxpz.getPhone()+",";
		      phones.append(phone);
	     	}	
		}
		
		return phones.toString();
		
	}
}
