package com.jshx.core.utils;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.jshx.zsdw.service.ZsdwService;
/**
 * 读取system.properties的工具类
 * 
 * @author Chenjian
 *
 */
public class SysPropertiesUtil {
	private static SysPropertiesUtil oInstance = new SysPropertiesUtil();
	private static Properties oProperties;
	protected final Log logger = LogFactory.getLog(this.getClass());

	private SysPropertiesUtil() {
	}
	protected void loadProperties() {
		try {
			oProperties = new Properties();

			ClassLoader oClassLoader = Thread.currentThread()
					.getContextClassLoader();

			if (oClassLoader == null) {
				oClassLoader = oInstance.getClass().getClassLoader();
			}

			InputStream is = oClassLoader
					.getResourceAsStream("system.properties");

			if (is != null) {
				oProperties.load(is);
				is.close();
			} else {
				logger.error("SysPropertiesUtil can not load property files!");
			}

		} catch (Exception e) {
			logger.error(e);
			e.printStackTrace();
		}
	}

	/**  
     * 根据key读取属性值
     * @param key 取得其值的键
     * @return 属性值  
     */  
	public static String getProperty(String key) {
		if (oProperties == null) {
			oInstance.loadProperties();
		}
		return oProperties.getProperty(key);
	}

	/**  
     * 根据属性名返回整形的属性值
     */ 
	public static int getInt(String sPropertyName, int iDefaultValue) {
		try {
			String sProperty = getProperty(sPropertyName);
			return Integer.parseInt(sProperty);
		} catch (Exception e) {
			return iDefaultValue;
		}
	}
	
	//千位分割符
	public static void main(String[] args) {
	}
	
	//千位分割符
	public static String qwfgf(String num){
//	       String num="1232132213123213213.23";
	        num = num.replaceAll(",", ""); // 去掉所有逗号
	        String xsd="";
             String[]ab=num.split("\\.");
             if(ab.length>1){
           	  num=ab[0];
           	  xsd="."+ab[1];
             }

	         StringBuffer ret = new StringBuffer();
	        for( int i = num.length()-1; i>=0; i-- ){
	            ret.append( num.charAt(i) );
	            if( (num.length()-i)%3==0 ){
	                ret.append(",");
	            }
	        }
	        return ret.reverse().toString()+xsd;
	       // System.out.println(ret.reverse().toString()+xsd);
	}
	
	
	
	//计算金额相乘
	public static String jinehuoqu(String mianji,String danjia){
	       BigDecimal a1 = new BigDecimal(mianji);  
	       BigDecimal b1 = new BigDecimal(danjia);   
	       BigDecimal result = a1.multiply(b1);// 相乘结果  
	       DecimalFormat   df =new DecimalFormat("0.00");
	       
           return String.valueOf(df.format(result));
	}
	 // 进行减法运算  
    public static String sub(String d1, String d2)
       {       
         BigDecimal b1 = new BigDecimal(d1); 
         BigDecimal b2 = new BigDecimal(d2); 
        return String.valueOf(b1.subtract(b2).doubleValue()); 
     } 
    
    
	
	/**
	 * 相加
	 */
	public static double addd(double   v1,double   v2){
		  BigDecimal   b1   =   new   BigDecimal(Double.toString(v1));     
		  BigDecimal   b2   =   new   BigDecimal(Double.toString(v2));     
		  return   b1.add(b2).doubleValue();   

	}
    public static String add(String d1, String d2)
     {        // 进行加法运算 
    	if(null==d1||"".equals(d1)){
    		d1="0";
    	}
    	if(null==d2||"".equals(d2)){
    		d2="0";
    	}
         BigDecimal b1 = new BigDecimal(d1); 
         BigDecimal b2 = new BigDecimal(d2); 
         return String.valueOf(b1.add(b2)); 
        
     } 
    public static String subtract(String d1, String d2)
    {        // 进行加法运算 
   	if(null==d1||"".equals(d1)){
   		d1="0";
   	}
   	if(null==d2||"".equals(d2)){
   		d1="0";
   	}
        BigDecimal b1 = new BigDecimal(d1); 
        BigDecimal b2 = new BigDecimal(d2); 
        return String.valueOf(b1.subtract(b2)); 
       
    }
	
	/**  
     * 根据属性名返回字符串型属性值
     */
	public static String getString(String sPropertyName, String sDefaultValue) {
		try {
			return getProperty(sPropertyName);
		} catch (Exception e) {
			return sDefaultValue;
		}
	}

	/**
	 * 根据key得到属性键值Map
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static HashMap getProperties(String keyGroup) {
		HashMap hashmap = new HashMap();
		if (oProperties == null) {
			oInstance.loadProperties();
		}
		Enumeration enumeration = oProperties.keys();
		while (enumeration.hasMoreElements()) {
			String tempKey = (String) enumeration.nextElement();
			if (tempKey.startsWith(keyGroup)) {
				hashmap.put(tempKey, oProperties.get(tempKey));
			}
		}
		return hashmap;
	}

	/**  
     * 根据属性名返回布尔型的属性值
     */
	public static boolean getBoolean(String key, boolean bDefaultValue) {
		try {
			String s = getProperty(key);
			if (s != null) {
				return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t");
			} else {
				return bDefaultValue;
			}
		} catch (Exception e) {
			return bDefaultValue;
		}
	}
	
	/**
	 * 四舍五入 保留1位小数
	 */
	
	public static String sswr1w(String m){
		
		BigDecimal b = new BigDecimal(m); 
		String f1 = String.valueOf(b.setScale(1, BigDecimal.ROUND_HALF_UP));
       return f1;
	}
	/**
	 * 文件路径
	 */
	
	public static String jdlj(HttpServletRequest re){
		  String jdlj = re.getSession().getServletContext()
					.getRealPath(File.separator);
	        File fil = new File(jdlj);
	        //上一级目录
	        String zsyj=fil.getParent();
	        String path=new File(zsyj).getParent();
	        return path;
	}
	
//	@SuppressWarnings("unused")
//	public static void main(String[] args) {
//		getProperties("isExceptionLog");
//	}
}
