package com.jshx.activiti.freeflow;

import com.jshx.activiti.service.ActivitiOperLogService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jshx.activiti.freeflow.FreeFlowService;
import com.jshx.activiti.freeflow.command.DeleteExecutionTaskCmd;
import com.jshx.activiti.freeflow.command.DeleteRunningTaskCmd;
import com.jshx.activiti.freeflow.command.DeleteHistoryTaskCmd;

import com.jshx.activiti.service.ActivitiService;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.exception.BasalException;
import net.sf.json.JSONArray;

/**
 * 自由流之回退、跳转
 *
 * @Author yangshunqing
 */
public class OpenWorkFlow extends BaseAction {
    private static final long serialVersionUID = -6508183661101591249L;

    protected static final String ERROR_RESULT = "{\"result\":false}";

    protected static final String SUCCESS_RESULT = "{\"result\":true}";

    protected static final String GATE_WAY = "Gateway";

    private static final Logger activitiLogger = LoggerFactory.getLogger(OpenWorkFlow.class);

    private String taskId;

    private String fprocessInstanceId;

    private String movetoActivityId;

    @Autowired
    RepositoryService repositoryService;

    @Autowired
    protected RuntimeService runtimeService;

    @Autowired
    protected TaskService taskService;

    @Autowired
    ProcessEngine processEngine;

    @Autowired
    protected ActivitiService activitiService;

    @Autowired
    private HistoryService historyService;

    @Autowired
    private ActivitiOperLogService activitiOperLogService;

    /**
     * 判断是否允许回退
     * 主要针对并行网关内跳到网关外
     * 如果有并行的任务已处理，则其他任务不可回退
     * 只能检测出网关内支路单任务的情况
     *
     * @param tfcs 自由流操作服务
     * @return
     */
    public boolean isAllowback(FreeFlowService tfcs) throws Exception {

        try {
            Task task = taskService.createTaskQuery().taskId(this.taskId).singleResult();
            ActivityImpl activityImpl = tfcs.getActivity(task);
            ActivityImpl nextNode = (ActivityImpl) activityImpl.getOutgoingTransitions().get(0).getDestination();
            String activityBehavior = nextNode.getActivityBehavior().toString();

            if (activityBehavior.contains("InclusiveGateway") || activityBehavior.contains("ParallelGateway")) {//并行及包容网关
                List<Execution> execList = runtimeService.createExecutionQuery().processInstanceId(task.getProcessInstanceId()).list();
                for (Execution exec : execList) {
                    if (exec.getActivityId().equals(nextNode.getId())) {
                        return false;
                    }
                }

            }
            return true;

        } catch (Exception e) {
            throw new BasalException(BasalException.ERROR, e);
        }

    }

    /**
     * 回退
     */
    public void drawbackTask() throws Exception {

        try {
            Task task = taskService.createTaskQuery().taskId(this.taskId).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            String currentActivityId = task.getTaskDefinitionKey();

            FreeFlowService tfcs = new FreeFlowService(processEngine, processInstanceId);
            //首先判断是否可回退
            if (!isAllowback(tfcs)) {
                this.getResponse().getWriter().println("{\"result\":false,\"notAllowback\":true}");
                return;
            }

            //后退一步
            tfcs.moveBack(this.taskId);

            //以下步骤为检验回退是否成功
            List<Task> curTaskList = taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();

            activitiOperLogService.saveLog(this.getLoginUser().getLoginId(), "驳回", taskId, task.getName(), task.getProcessInstanceId(), task.getName() + "->" + curTaskList.get(0).getName());
            for (Task curTask : curTaskList) {

                ActivityImpl nextNode = (ActivityImpl) tfcs.getActivity(curTask).getOutgoingTransitions().get(0).getDestination();
                String activityBehavior = nextNode.getActivityBehavior().toString();

                if (activityBehavior.contains(GATE_WAY)) {
                    List<PvmTransition> outTransitions = nextNode.getOutgoingTransitions();
                    for (PvmTransition tr : outTransitions) {
                        PvmActivity ac = tr.getDestination(); //获取线路的终点节点
                        if (task.getTaskDefinitionKey().equals(ac.getId())) {
                            this.getResponse().getWriter().println(SUCCESS_RESULT);
                            return;
                        }
                    }
                }

                if (currentActivityId.equals(nextNode.getId())) {
                    this.getResponse().getWriter().println(SUCCESS_RESULT);
                    return;
                }


            }

            this.getResponse().getWriter().println(ERROR_RESULT);

        } catch (Exception e) {
            activitiLogger.error("跳转失败", e);
            throw new BasalException(BasalException.ERROR, e);
        }

    }

    /**
     * 跳转
     */
    public void movetoTask() throws Exception {
        try {
            Task task = taskService.createTaskQuery().taskId(this.taskId).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            FreeFlowService tfcs = new FreeFlowService(processEngine, processInstanceId);
            //先找到跳转后的节点，然后判断其入口线路是否是网关
            ActivityImpl activityImpl = tfcs.getActivity(task, this.movetoActivityId);
            PvmActivity incomingTransition = activityImpl.getIncomingTransitions().get(0).getSource();//获取从某个节点进来的线路
            String activityBehavior = ((ActivityImpl) incomingTransition).getActivityBehavior().toString();

            int forkNum = incomingTransition.getOutgoingTransitions().size();

            //如果跳转后节点的入口线路是多支路网关
            if (activityBehavior.contains(GATE_WAY) && (!activityBehavior.contains("Exclusive")) && forkNum > 1) {
                boolean isSerialInGateWay = false;
                ActivityImpl nextActivity = (ActivityImpl) activityImpl.getOutgoingTransitions().get(0).getDestination();
                String nextActivityBehavior = nextActivity.getActivityBehavior().toString();
                while (!nextActivityBehavior.contains(GATE_WAY)) {
                    if (task.getTaskDefinitionKey().equals(nextActivity.getId())) {//说明跳转的起点与终点都是在网关的某个支路上
                        isSerialInGateWay = true;
                    }
                    nextActivity = (ActivityImpl) nextActivity.getOutgoingTransitions().get(0).getDestination();
                    nextActivityBehavior = nextActivity.getActivityBehavior().toString();
                }

                if (!isSerialInGateWay) {
                    this.setMovetoActivityId(incomingTransition.getId());
                }

            }

            //自由跳转
            tfcs.moveTo(this.taskId, this.movetoActivityId);

            //判断跳转之前的节点是否在多支路网关内，如果在，删除其他支路任务
            activityImpl = tfcs.getActivity(task);
            incomingTransition = activityImpl.getIncomingTransitions().get(0).getSource();//获取从某个节点进来的线路
            activityBehavior = ((ActivityImpl) incomingTransition).getActivityBehavior().toString();
            List<PvmTransition> pmTransition = incomingTransition.getOutgoingTransitions();
            forkNum = pmTransition.size();
            if (activityBehavior.contains(GATE_WAY) && (!activityBehavior.contains("Exclusive")) && forkNum > 1) {
                boolean isSerialInGateWay = false;
                ActivityImpl nextActivity = (ActivityImpl) activityImpl.getOutgoingTransitions().get(0).getDestination();
                String nextActivityBehavior = nextActivity.getActivityBehavior().toString();
                while (!nextActivityBehavior.contains("Gateway")) {
                    if (nextActivity.getId().equals(this.movetoActivityId)) {//说明跳转的起点与终点都是在网关的某个支路上
                        isSerialInGateWay = true;
                    }
                    nextActivity = (ActivityImpl) nextActivity.getOutgoingTransitions().get(0).getDestination();
                    nextActivityBehavior = nextActivity.getActivityBehavior().toString();
                }

                int m = 0;
                while (!isSerialInGateWay && m < forkNum) {
                    String id = incomingTransition.getOutgoingTransitions().get(m).getDestination().getId();
                    TaskEntity currentTask = (TaskEntity) taskService.createTaskQuery().taskDefinitionKey(id).singleResult();
                    if (currentTask != null) {
                        tfcs.executeCommand(new DeleteRunningTaskCmd(currentTask));
                        tfcs.executeCommand(new DeleteExecutionTaskCmd(currentTask));//删除act_ru_execution表中的记录
                    }
                    m++;
                }

            }


            //以下步骤为检验跳转是否成功
            List<Task> ac = taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();
            activitiOperLogService.saveLog(this.getLoginUser().getLoginId(), "跳转", taskId, task.getName(), task.getProcessInstanceId(), task.getName() + "->" + ac.get(0).getName());
            for (Task Curtask : ac) {

                String taskDefinitionKey = Curtask.getTaskDefinitionKey();
                if (this.movetoActivityId.equals(taskDefinitionKey)) {
                    this.getResponse().getWriter().println(SUCCESS_RESULT);
                    return;
                }
                ActivityImpl curActivityImpl = tfcs.getActivity(Curtask);
                incomingTransition = curActivityImpl.getIncomingTransitions().get(0).getSource();//获取从某个节点进来的线路
                activityBehavior = ((ActivityImpl) incomingTransition).getActivityBehavior().toString();
                String id = ((ActivityImpl) incomingTransition).getId();
                //如果入口来源是网关
                if (activityBehavior.contains(GATE_WAY) && this.movetoActivityId.equals(id)) {
                    this.getResponse().getWriter().println(SUCCESS_RESULT);
                    return;
                }

            }

            this.getResponse().getWriter().println(ERROR_RESULT);

        } catch (Exception e) {
            activitiLogger.error("跳转失败", e);
            throw new BasalException(BasalException.ERROR, e);
        }
    }

    /**
     * 获取可跳转的节点信息
     *
     * @return
     * @throws Exception
     */
    public void getProcessMap() throws Exception {
        try {
            Task task = taskService.createTaskQuery().taskId(this.taskId).singleResult();
            String curTaskdefId = task.getTaskDefinitionKey();

            Map<String, String> isMoveToTaskdefId = activitiService.getJumpToTasks(task.getProcessInstanceId(), curTaskdefId);

            ProcessDefinitionEntity def = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
                    .getDeployedProcessDefinition(task.getProcessDefinitionId());

            List<Task> curTaskList = taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId()).active().list();

            List<String> activitiIds = new ArrayList<String>();
            for (Task curTask : curTaskList) {
                activitiIds.add(curTask.getTaskDefinitionKey());
            }

            List<ActivityImpl> activitiList = def.getActivities();// 获得当前任务的所有节点

            List<HashMap<String, Object>> mapList = new ArrayList<HashMap<String, Object>>();

            for (ActivityImpl activityImpl : activitiList) {

                String id = activityImpl.getId();
                String activityBehavior = activityImpl.getActivityBehavior().toString();
                if (activityBehavior.contains(GATE_WAY) || activityBehavior.contains("NoneStartEvent")
                        || activityBehavior.contains("NoneEndEvent")) {
                    continue;
                }

                if ((!isMoveToTaskdefId.containsKey(id)) && (!activitiIds.contains(id))) {
                    continue;
                }

                HashMap<String, Object> map = new HashMap<String, Object>();
                if (activitiIds.contains(id)) {
                    map.put("isCurTask", "Y");
                }
                map.put("id", id);
                map.put("x", activityImpl.getX());
                map.put("y", activityImpl.getY());
                map.put("width", activityImpl.getWidth());
                map.put("height", activityImpl.getHeight());

                mapList.add(map);
            }

            StringBuilder data = new StringBuilder("{\n");
            data.append("\"result\":true").append(",\n");
            data.append("\"procDefId\":\"").append(task.getProcessDefinitionId()).append("\",\n");
            data.append("\"curTaskdefId\":\"").append(curTaskdefId).append("\",\n");
            data.append("\"total\":").append(mapList.size()).append(",\n");
            data.append("\"rows\":\n");

            JSONArray json = JSONArray.fromObject(mapList);
            data.append(json.toString());
            data.append("  \n").append("}");

            this.getResponse().getWriter().println(data);
        } catch (Exception e) {
            activitiLogger.error("获取用户任务坐标错误", e);
            throw new BasalException(BasalException.ERROR, e);
        }

    }

    /**
     * 收回
     */
    public void withDraw() throws Exception {

        try {
            HistoricTaskInstance task = historyService.createHistoricTaskInstanceQuery().taskId(this.taskId).singleResult();
            //跳转之前活动任务
            List<Task> ac = taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId()).active().list();
            String processInstanceId = task.getProcessInstanceId();
            String taskDefinitionKey = task.getTaskDefinitionKey();
            ProcessDefinitionEntity pde = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
                    .getDeployedProcessDefinition(task.getProcessDefinitionId());

            ActivityImpl curActivityImpl = pde.findActivity(task.getTaskDefinitionKey());

            ActivityImpl theNextActivityImpl = (ActivityImpl) curActivityImpl.getOutgoingTransitions().get(0).getDestination();
            String activityBehavior = theNextActivityImpl.getActivityBehavior().toString();
            //如果下一步是网关
            if (activityBehavior.contains(GATE_WAY)) {
                curActivityImpl = theNextActivityImpl;
            }

            List<PvmTransition> pmTransitionList = curActivityImpl.getOutgoingTransitions();

            List<String> nextTaskIdList = new ArrayList<>();

            for (PvmTransition pmTransition : pmTransitionList) {
                ActivityImpl nextActivityImpl = (ActivityImpl) pmTransition.getDestination();
                Task nextTask = taskService.createTaskQuery().taskDefinitionKey(nextActivityImpl.getId()).singleResult();

                if (nextTask == null && activityBehavior.contains("ParallelGateway")) {
                    this.getResponse().getWriter().println(ERROR_RESULT);
                    return;
                }

                if (nextTask != null) {
                    nextTaskIdList.add(nextTask.getId());
                }
            }

            if (nextTaskIdList.isEmpty()) {
                this.getResponse().getWriter().println(ERROR_RESULT);
                return;
            } else {
                FreeFlowService tfcs = new FreeFlowService(processEngine, processInstanceId);

                tfcs.moveBack(nextTaskIdList.get(0));

                HistoricTaskInstance currentTask = historyService.createHistoricTaskInstanceQuery().taskId(this.taskId).singleResult();
                tfcs.executeCommand(new DeleteHistoryTaskCmd(currentTask));

                nextTaskIdList.forEach(nextTaskId -> {
                    HistoricTaskInstance nextTask = historyService.createHistoricTaskInstanceQuery().taskId(nextTaskId).singleResult();
                    tfcs.executeCommand(new DeleteHistoryTaskCmd(nextTask));
                });


            }

            //以下步骤为检验收回是否成功
            List<Task> curTaskList = taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();
            activitiOperLogService.saveLog(this.getLoginUser().getLoginId(), "收回", ac.get(0).getId(), ac.get(0).getName(), task.getProcessInstanceId(), ac.get(0).getName() + "->" + task.getName());
            for (Task curTask : curTaskList) {
                if (curTask.getTaskDefinitionKey().equals(taskDefinitionKey)) {
                    this.getResponse().getWriter().println(SUCCESS_RESULT);
                    return;
                }
            }

            this.getResponse().getWriter().println(ERROR_RESULT);

        } catch (Exception e) {
            throw new BasalException(BasalException.ERROR, e);
        }

    }

    /**
     * 获取流程信息
     *
     * @return
     * @throws Exception
     */
    public void getProcessInfo() throws Exception {
        try {
            List<Task> curTaskList = taskService.createTaskQuery().processInstanceId(fprocessInstanceId).active().list();

            ProcessDefinitionEntity def = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
                    .getDeployedProcessDefinition(curTaskList.get(0).getProcessDefinitionId());

            List<HashMap<String, Object>> mapList = new ArrayList<HashMap<String, Object>>();

            for (Task curTask : curTaskList) {
                String taskDefKey = curTask.getTaskDefinitionKey();
                ActivityImpl activityImpl = def.findActivity(taskDefKey);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", curTask.getId());
                map.put("taskDefKey", taskDefKey);
                map.put("assignee", curTask.getAssignee());
                map.put("x", activityImpl.getX());
                map.put("y", activityImpl.getY());
                map.put("width", activityImpl.getWidth());
                map.put("height", activityImpl.getHeight());

                mapList.add(map);
            }

            StringBuilder data = new StringBuilder("{\n");
            data.append("\"result\":true").append(",\n");
            data.append("\"procDefId\":\"").append(curTaskList.get(0).getProcessDefinitionId()).append("\",\n");
            data.append("\"total\":").append(mapList.size()).append(",\n");
            data.append("\"rows\":\n");

            JSONArray json = JSONArray.fromObject(mapList);
            data.append(json.toString());
            data.append("  \n").append("}");

            this.getResponse().getWriter().println(data);
        } catch (Exception e) {
            activitiLogger.error("获取用户任务坐标错误", e);
            throw new BasalException(BasalException.ERROR, e);
        }

    }


    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getMovetoActivityId() {
        return movetoActivityId;
    }

    public void setMovetoActivityId(String movetoActivityId) {
        this.movetoActivityId = movetoActivityId;
    }

    public String getFprocessInstanceId() {
        return fprocessInstanceId;
    }

    public void setFprocessInstanceId(String fprocessInstanceId) {
        this.fprocessInstanceId = fprocessInstanceId;
    }

}
