<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@include file="/common/header.jsp"%>
<%@include file="/common/jsLib.jsp"%>
<script src="${ctx}/webResources/js/echarts.common.min.js"
	language="JavaScript"></script>
<html>
<head>
<title></title>
</head>
<body>
	<div class="page_content">
		<div class="box_01 submitdata">
			<div class="inner12px">
				<form name="myform" method="post">
					<div class="cell boxBmargin12">
						<table>
							<tr>
								<th width="15%">流程ID</th>
								<td width="35%"><select style="width: 280px;"
									id="processDefinitionId" name="processDefinitionId">
										<c:forEach items="${piDefList}" var="piDef">
											<option value='${piDef.id}'>${piDef.id }</option>
										</c:forEach>
								</select></td>
								<th width="15%">时间段</th>
								<td width="35%"><input name="startDate" size="15"
									id="startDate" value="" type="text" class="Wdate"
									onfocus="WdatePicker({dateFmt:'yyyy-MM-dd',maxDate:'#F{$dp.$D(\'endDate\')}'})">
									-<input name="endDate" id="endDate" size="15" value=""
									type="text" class="Wdate"
									onfocus="WdatePicker({dateFmt:'yyyy-MM-dd',minDate:'#F{$dp.$D(\'startDate\')}'})">
								</td>
							</tr>
							<tr>
								<td colspan="4">
									<div class="btn_area_setc">
										<a href="###" class="btn_01" onclick="loadPiStat()">查询<b></b></a>
										<a href="###" class="btn_01"
											onclick="clear_form(document.myform);">清空<b></b></a>
									</div>
								</td>
							</tr>
						</table>
					</div>

					<div id="myChart"
						style="position: relative; width: 100%; height: 400px; top: 10px;"></div>

				</form>
			</div>
		</div>
	</div>
</body>
<script>
	$(document).ready(function() {
		var enddate = new Date();
		var startdate = new Date();
		startdate.setDate(startdate.getDate()-5);
		$('#startDate').val(startdate.format("yyyy-MM-dd"));
		$('#endDate').val(enddate.format("yyyy-MM-dd"));
		loadPiStat();
	});

	function loadPiStat() {
		$.ajax({
			url : "${ctx}/jsp/stat/queryPiStatus.action",
			data : {
				"processDefinitionId" : $('#processDefinitionId').val(),
				"startDate" : $('#startDate').val(),
				"endDate" : $('#endDate').val()
			},
			type : "GET",
			dataType : 'json',
			success : function(piDataStatus) {
				window.processName = [];
				window.completeCount = [];
				window.xserial = [];

				var length = piDataStatus.length;
				for (var i = 0; i < length; i++) {
					var temp = piDataStatus[i];
					window.processName.push(temp.processName);
					window.xserial.push(temp.statDate);
					window.completeCount.push(temp.completeCount);
				}
				showPiData();
			}

		});
	}

	function showPiData() {
		if (window.mychart == null)
			window.mychart = echarts.init(document.getElementById("myChart"));
		else
			window.mychart.clear();

		var option = {
			tooltip : {
				trigger : 'axis'
			},
			legend : {
				show : true,
				x : 'center',
				y : 'top',
				data : [ '已完成流程数目' ]
			},
			calculable : false,
			xAxis : [ {
				show : false,
				type : 'category',
				data : window.xserial,
				show : true
			} ],
			yAxis : [ {
				show : true,
				type : 'value',
				splitArea : {
					show : true
				}
			} ],
			series : [ {
				name : '已完成流程数',
				type : 'line',
				data : window.completeCount
			} ]
		};
		window.mychart.setOption(option);
	}
</script>
</html>
