/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class SWFHeader
implements SWFConstants {
    private int version;
    private long length;
    private Dimension size;
    private float rate;
    private int count;
    private boolean compress;

    public SWFHeader(int n2, long l2, Dimension dimension, float f2, int n3, boolean bl) {
        this.version = n2;
        this.length = l2;
        this.size = dimension;
        this.rate = f2;
        this.count = n3;
        this.compress = bl;
    }

    public SWFHeader(SWFInputStream sWFInputStream) throws IOException {
        int n2 = sWFInputStream.readUnsignedByte();
        if (70 != n2 && 67 != n2) {
            throw new IOException();
        }
        if (87 != sWFInputStream.readUnsignedByte()) {
            throw new IOException();
        }
        if (83 != sWFInputStream.readUnsignedByte()) {
            throw new IOException();
        }
        this.version = sWFInputStream.readUnsignedByte();
        this.length = sWFInputStream.readUnsignedInt();
        boolean bl = this.compress = this.version >= 6 && 67 == n2;
        if (this.compress) {
            sWFInputStream.startDecompressing();
        }
        Rectangle2D rectangle2D = sWFInputStream.readRect();
        this.size = new Dimension((int)rectangle2D.getMaxX(), (int)rectangle2D.getMaxY());
        this.rate = (float)sWFInputStream.readUnsignedShort() / 256.0f;
        this.count = sWFInputStream.readUnsignedShort();
    }

    public void write(SWFOutputStream sWFOutputStream) throws IOException {
        if (this.version >= 6 && this.compress) {
            sWFOutputStream.writeUnsignedByte(67);
        } else {
            sWFOutputStream.writeUnsignedByte(70);
        }
        sWFOutputStream.writeUnsignedByte(87);
        sWFOutputStream.writeUnsignedByte(83);
        sWFOutputStream.writeUnsignedByte(this.version);
        sWFOutputStream.writeUnsignedInt(this.length);
        if (this.version >= 6 && this.compress) {
            sWFOutputStream.startCompressing();
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.size.width, this.size.height);
        sWFOutputStream.writeRect(double_);
        sWFOutputStream.writeUnsignedShort((int)(this.rate * 256.0f));
        sWFOutputStream.writeUnsignedShort(this.count);
    }

    public static int size() {
        return 21;
    }

    public int getVersion() {
        return this.version;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isCompressed() {
        return this.compress;
    }

    public Dimension getSize() {
        return this.size;
    }

    public float getRate() {
        return this.rate;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SWF Header\n");
        stringBuffer.append("  version: " + this.version + "\n");
        stringBuffer.append("  length: " + this.length + "\n");
        stringBuffer.append("  compress: " + this.compress + "\n");
        stringBuffer.append("  size: " + this.size + "\n");
        stringBuffer.append("  rate: " + this.rate + "\n");
        stringBuffer.append("  count: " + this.count);
        return stringBuffer.toString();
    }
}

