/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.util;

import com.fr.zip4j.core.HeaderReader;
import com.fr.zip4j.core.HeaderWriter;
import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.io.SplitOutputStream;
import com.fr.zip4j.model.FileHeader;
import com.fr.zip4j.model.LocalFileHeader;
import com.fr.zip4j.model.ZipModel;
import com.fr.zip4j.progress.ProgressMonitor;
import com.fr.zip4j.util.Raw;
import com.fr.zip4j.util.Zip4jUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;

public class ArchiveMaintainer {
    public HashMap removeZipFile(final ZipModel zipModel, final FileHeader fileHeader, final ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (bl) {
            Thread thread = new Thread("Zip4j"){

                public void run() {
                    try {
                        ArchiveMaintainer.this.initRemoveZipFile(zipModel, fileHeader, progressMonitor);
                        progressMonitor.endProgressMonitorSuccess();
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            return null;
        }
        HashMap hashMap = this.initRemoveZipFile(zipModel, fileHeader, progressMonitor);
        progressMonitor.endProgressMonitorSuccess();
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap initRemoveZipFile(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor) throws ZipException {
        HashMap<String, String> hashMap;
        String string;
        boolean bl;
        RandomAccessFile randomAccessFile;
        File file;
        OutputStream outputStream;
        block42: {
            FileHeader fileHeader2;
            block41: {
                if (fileHeader == null) throw new ZipException("input parameters is null in maintain zip file, cannot remove file from archive");
                if (zipModel == null) {
                    throw new ZipException("input parameters is null in maintain zip file, cannot remove file from archive");
                }
                outputStream = null;
                file = null;
                randomAccessFile = null;
                bl = false;
                string = null;
                hashMap = new HashMap<String, String>();
                try {
                    try {
                        ArrayList arrayList;
                        int n2 = Zip4jUtil.getIndexOfFileHeader(zipModel, fileHeader);
                        if (n2 < 0) {
                            throw new ZipException("file header not found in zip model, cannot remove file");
                        }
                        if (zipModel.isSplitArchive()) {
                            throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
                        }
                        long l4 = System.currentTimeMillis();
                        string = zipModel.getZipFile() + l4 % 1000L;
                        File file2 = new File(string);
                        while (file2.exists()) {
                            l4 = System.currentTimeMillis();
                            string = zipModel.getZipFile() + l4 % 1000L;
                            file2 = new File(string);
                        }
                        try {
                            outputStream = new SplitOutputStream(new File(string));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new ZipException(fileNotFoundException);
                        }
                        file = new File(zipModel.getZipFile());
                        randomAccessFile = this.createFileHandler(zipModel, "r");
                        HeaderReader headerReader = new HeaderReader(randomAccessFile);
                        LocalFileHeader localFileHeader = headerReader.readLocalFileHeader(fileHeader);
                        if (localFileHeader == null) {
                            throw new ZipException("invalid local file header, cannot remove file from archive");
                        }
                        long l3 = fileHeader.getOffsetLocalHeader();
                        if (fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                            l3 = fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader();
                        }
                        long l2 = -1L;
                        long l5 = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
                        if (zipModel.isZip64Format() && zipModel.getZip64EndCentralDirRecord() != null) {
                            l5 = zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo();
                        }
                        if (n2 == (arrayList = zipModel.getCentralDirectory().getFileHeaders()).size() - 1) {
                            l2 = l5 - 1L;
                        } else {
                            fileHeader2 = (FileHeader)arrayList.get(n2 + 1);
                            if (fileHeader2 != null) {
                                l2 = fileHeader2.getOffsetLocalHeader() - 1L;
                                if (fileHeader2.getZip64ExtendedInfo() != null && fileHeader2.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                                    l2 = fileHeader2.getZip64ExtendedInfo().getOffsetLocalHeader() - 1L;
                                }
                            }
                        }
                        if (l3 < 0L) throw new ZipException("invalid offset for start and end of local file, cannot remove file");
                        if (l2 < 0L) {
                            throw new ZipException("invalid offset for start and end of local file, cannot remove file");
                        }
                        if (n2 == 0) {
                            if (zipModel.getCentralDirectory().getFileHeaders().size() > 1) {
                                this.copyFile(randomAccessFile, outputStream, l2 + 1L, l5, progressMonitor);
                            }
                        } else if (n2 == arrayList.size() - 1) {
                            this.copyFile(randomAccessFile, outputStream, 0L, l3, progressMonitor);
                        } else {
                            this.copyFile(randomAccessFile, outputStream, 0L, l3, progressMonitor);
                            this.copyFile(randomAccessFile, outputStream, l2 + 1L, l5, progressMonitor);
                        }
                        if (progressMonitor.isCancelAllTasks()) {
                            progressMonitor.setResult(3);
                            progressMonitor.setState(0);
                            fileHeader2 = null;
                            Object var27_25 = null;
                            break block41;
                        }
                        zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(((SplitOutputStream)outputStream).getFilePointer());
                        zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDir(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDir() - 1);
                        zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDirOnThisDisk() - 1);
                        zipModel.getCentralDirectory().getFileHeaders().remove(n2);
                        for (int i2 = n2; i2 < zipModel.getCentralDirectory().getFileHeaders().size(); ++i2) {
                            long l6 = ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).getOffsetLocalHeader();
                            if (((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).getZip64ExtendedInfo() != null && ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                                l6 = ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).getZip64ExtendedInfo().getOffsetLocalHeader();
                            }
                            ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).setOffsetLocalHeader(l6 - (l2 - l3) - 1L);
                        }
                        HeaderWriter headerWriter = new HeaderWriter();
                        headerWriter.finalizeZipFile(zipModel, outputStream);
                        bl = true;
                        hashMap.put("offsetCentralDir", Long.toString(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir()));
                        break block42;
                    }
                    catch (ZipException zipException) {
                        progressMonitor.endProgressMonitorError(zipException);
                        throw zipException;
                    }
                    catch (Exception exception) {
                        progressMonitor.endProgressMonitorError(exception);
                        throw new ZipException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var27_27 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
                    }
                    if (bl) {
                        this.restoreFileName(file, string);
                        throw throwable;
                    }
                    File file5 = new File(string);
                    file5.delete();
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {
                throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (bl) {
                this.restoreFileName(file, string);
                return fileHeader2;
            }
            File file3 = new File(string);
            file3.delete();
            return fileHeader2;
        }
        Object var27_26 = null;
        try {}
        catch (IOException iOException) {
            throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (bl) {
            this.restoreFileName(file, string);
            return hashMap;
        }
        File file4 = new File(string);
        file4.delete();
        return hashMap;
    }

    private void restoreFileName(File file, String string) throws ZipException {
        if (file.delete()) {
            File file2 = new File(string);
            if (!file2.renameTo(file)) {
                throw new ZipException("cannot rename modified zip file");
            }
        } else {
            throw new ZipException("cannot delete old zip file");
        }
    }

    private void copyFile(RandomAccessFile randomAccessFile, OutputStream outputStream, long l2, long l3, ProgressMonitor progressMonitor) throws ZipException {
        if (randomAccessFile == null || outputStream == null) {
            throw new ZipException("input or output stream is null, cannot copy file");
        }
        if (l2 < 0L) {
            throw new ZipException("starting offset is negative, cannot copy file");
        }
        if (l3 < 0L) {
            throw new ZipException("end offset is negative, cannot copy file");
        }
        if (l2 > l3) {
            throw new ZipException("start offset is greater than end offset, cannot copy file");
        }
        if (l2 == l3) {
            return;
        }
        if (progressMonitor.isCancelAllTasks()) {
            progressMonitor.setResult(3);
            progressMonitor.setState(0);
            return;
        }
        try {
            randomAccessFile.seek(l2);
            int n2 = -2;
            long l4 = 0L;
            long l5 = l3 - l2;
            byte[] byArray = l3 - l2 < 4096L ? new byte[(int)(l3 - l2)] : new byte[4096];
            while ((n2 = randomAccessFile.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                progressMonitor.updateWorkCompleted(n2);
                if (progressMonitor.isCancelAllTasks()) {
                    progressMonitor.setResult(3);
                    return;
                }
                if ((l4 += (long)n2) != l5) {
                    if (l4 + (long)byArray.length <= l5) continue;
                    byArray = new byte[(int)(l5 - l4)];
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private RandomAccessFile createFileHandler(ZipModel zipModel, String string) throws ZipException {
        if (zipModel == null || !Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getZipFile())) {
            throw new ZipException("input parameter is null in getFilePointer, cannot create file handler to remove file");
        }
        try {
            return new RandomAccessFile(new File(zipModel.getZipFile()), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
    }

    public void mergeSplitZipFiles(final ZipModel zipModel, final File file, final ProgressMonitor progressMonitor, boolean bl) throws ZipException {
        if (bl) {
            Thread thread = new Thread("Zip4j"){

                public void run() {
                    try {
                        ArchiveMaintainer.this.initMergeSplitZipFile(zipModel, file, progressMonitor);
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        } else {
            this.initMergeSplitZipFile(zipModel, file, progressMonitor);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initMergeSplitZipFile(ZipModel var1_1, File var2_2, ProgressMonitor var3_3) throws ZipException {
        block30: {
            block28: {
                block26: {
                    block27: {
                        if (var1_1 == null) {
                            var4_4 = new ZipException("one of the input parameters is null, cannot merge split zip file");
                            var3_3.endProgressMonitorError(var4_4);
                            throw var4_4;
                        }
                        if (!var1_1.isSplitArchive()) {
                            var4_5 = new ZipException("archive not a split zip file");
                            var3_3.endProgressMonitorError(var4_5);
                            throw var4_5;
                        }
                        var4_6 = null;
                        var5_7 = null;
                        var6_8 = new ArrayList<Long>();
                        var7_9 = 0L;
                        var9_10 = false;
                        try {
                            try {
                                var10_11 = var1_1.getEndCentralDirRecord().getNoOfThisDisk();
                                if (var10_11 <= 0) {
                                    throw new ZipException("corrupt zip model, archive not a split zip file");
                                }
                                var4_6 = this.prepareOutputStreamForMerge(var2_2);
                                for (var11_14 = 0; var11_14 <= var10_11; ++var11_14) {
                                    var5_7 = this.createSplitZipFileHandler(var1_1, var11_14);
                                    var12_16 = 0;
                                    var13_18 = new Long(var5_7.length());
                                    if (var11_14 == 0 && var1_1.getCentralDirectory() != null && var1_1.getCentralDirectory().getFileHeaders() != null && var1_1.getCentralDirectory().getFileHeaders().size() > 0) {
                                        var14_19 = new byte[4];
                                        var5_7.seek(0L);
                                        var5_7.read(var14_19);
                                        if ((long)Raw.readIntLittleEndian(var14_19, 0) == 134695760L) {
                                            var12_16 = 4;
                                            var9_10 = true;
                                        }
                                    }
                                    if (var11_14 == var10_11) {
                                        var13_18 = new Long(var1_1.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                                    }
                                    this.copyFile(var5_7, var4_6, var12_16, var13_18, var3_3);
                                    var7_9 += var13_18 - (long)var12_16;
                                    if (var3_3.isCancelAllTasks()) {
                                        var3_3.setResult(3);
                                        var3_3.setState(0);
                                        var16_21 = null;
                                        if (var4_6 == null) break block26;
                                        break block27;
                                    }
                                    var6_8.add(var13_18);
                                    try {
                                        var5_7.close();
                                        continue;
                                    }
                                    catch (IOException var14_20) {
                                        // empty catch block
                                    }
                                }
                                var11_15 = (ZipModel)var1_1.clone();
                                var11_15.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(var7_9);
                                this.updateSplitZipModel(var11_15, var6_8, var9_10);
                                var12_17 = new HeaderWriter();
                                var12_17.finalizeZipFileWithoutValidations(var11_15, var4_6);
                                var3_3.endProgressMonitorSuccess();
                                break block28;
                            }
                            catch (IOException var10_12) {
                                var3_3.endProgressMonitorError(var10_12);
                                throw new ZipException(var10_12);
                            }
                            catch (Exception var10_13) {
                                var3_3.endProgressMonitorError(var10_13);
                                throw new ZipException(var10_13);
                            }
                        }
                        catch (Throwable var15_27) {
                            var16_23 = null;
                            if (var4_6 != null) {
                                try {
                                    var4_6.close();
                                }
                                catch (IOException var17_26) {
                                    // empty catch block
                                }
                            }
                            if (var5_7 == null) throw var15_27;
                            try {
                                var5_7.close();
                                throw var15_27;
                            }
                            catch (IOException var17_26) {
                                // empty catch block
                            }
                            throw var15_27;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [8 : 420->428)] { 
lbl83:
                    // 1 sources

                    var4_6.close();
                    break block26;
lbl85:
                    // 1 sources

                    catch (IOException var17_24) {
                        // empty catch block
                    }
                }
                if (var5_7 == null) return;
                ** try [egrp 4[TRYBLOCK] [9 : 435->443)] { 
lbl90:
                // 1 sources

                var5_7.close();
                return;
lbl92:
                // 1 sources

                catch (IOException var17_24) {
                    // empty catch block
                }
                return;
            }
            var16_22 = null;
            if (var4_6 != null) {
                ** try [egrp 3[TRYBLOCK] [8 : 420->428)] { 
lbl99:
                // 1 sources

                var4_6.close();
                break block30;
lbl101:
                // 1 sources

                catch (IOException var17_25) {
                    // empty catch block
                }
            }
        }
        if (var5_7 == null) return;
        try {}
        catch (IOException var17_25) {}
        var5_7.close();
        return;
    }

    private RandomAccessFile createSplitZipFileHandler(ZipModel zipModel, int n2) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot create split file handler");
        }
        if (n2 < 0) {
            throw new ZipException("invlaid part number, cannot create split file handler");
        }
        try {
            String string = zipModel.getZipFile();
            String string2 = null;
            string2 = n2 == zipModel.getEndCentralDirRecord().getNoOfThisDisk() ? zipModel.getZipFile() : (n2 >= 9 ? string.substring(0, string.lastIndexOf(".")) + ".z" + (n2 + 1) : string.substring(0, string.lastIndexOf(".")) + ".z0" + (n2 + 1));
            File file = new File(string2);
            if (!Zip4jUtil.checkFileExists(file)) {
                throw new ZipException("split file does not exist: " + string2);
            }
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private OutputStream prepareOutputStreamForMerge(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("outFile is null, cannot create outputstream");
        }
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipException(fileNotFoundException);
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void updateSplitZipModel(ZipModel zipModel, ArrayList arrayList, boolean bl) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split zip model");
        }
        zipModel.setSplitArchive(false);
        this.updateSplitFileHeader(zipModel, arrayList, bl);
        this.updateSplitEndCentralDirectory(zipModel);
        if (zipModel.isZip64Format()) {
            this.updateSplitZip64EndCentralDirLocator(zipModel, arrayList);
            this.updateSplitZip64EndCentralDirRec(zipModel, arrayList);
        }
    }

    private void updateSplitFileHeader(ZipModel zipModel, ArrayList arrayList, boolean bl) throws ZipException {
        try {
            if (zipModel.getCentralDirectory() == null) {
                throw new ZipException("corrupt zip model - getCentralDirectory, cannot update split zip model");
            }
            int n2 = zipModel.getCentralDirectory().getFileHeaders().size();
            int n3 = 0;
            if (bl) {
                n3 = 4;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                long l2 = 0L;
                for (int i3 = 0; i3 < ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).getDiskNumberStart(); ++i3) {
                    l2 += ((Long)arrayList.get(i3)).longValue();
                }
                ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).setOffsetLocalHeader(((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).getOffsetLocalHeader() + l2 - (long)n3);
                ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i2)).setDiskNumberStart(0);
            }
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void updateSplitEndCentralDirectory(ZipModel zipModel) throws ZipException {
        try {
            if (zipModel == null) {
                throw new ZipException("zip model is null - cannot update end of central directory for split zip model");
            }
            if (zipModel.getCentralDirectory() == null) {
                throw new ZipException("corrupt zip model - getCentralDirectory, cannot update split zip model");
            }
            zipModel.getEndCentralDirRecord().setNoOfThisDisk(0);
            zipModel.getEndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(0);
            zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDir(zipModel.getCentralDirectory().getFileHeaders().size());
            zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getCentralDirectory().getFileHeaders().size());
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void updateSplitZip64EndCentralDirLocator(ZipModel zipModel, ArrayList arrayList) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split Zip64 end of central directory locator");
        }
        if (zipModel.getZip64EndCentralDirLocator() == null) {
            return;
        }
        zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(0);
        long l2 = 0L;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            l2 += ((Long)arrayList.get(i2)).longValue();
        }
        zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec() + l2);
        zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(1);
    }

    private void updateSplitZip64EndCentralDirRec(ZipModel zipModel, ArrayList arrayList) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split Zip64 end of central directory record");
        }
        if (zipModel.getZip64EndCentralDirRecord() == null) {
            return;
        }
        zipModel.getZip64EndCentralDirRecord().setNoOfThisDisk(0);
        zipModel.getZip64EndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(0);
        zipModel.getZip64EndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDir());
        long l2 = 0L;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            l2 += ((Long)arrayList.get(i2)).longValue();
        }
        zipModel.getZip64EndCentralDirRecord().setOffsetStartCenDirWRTStartDiskNo(zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo() + l2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setComment(ZipModel zipModel, String string) throws ZipException {
        if (string == null) {
            throw new ZipException("comment is null, cannot update Zip file with comment");
        }
        if (zipModel == null) {
            throw new ZipException("zipModel is null, cannot update Zip file with comment");
        }
        String string2 = string;
        byte[] byArray = string.getBytes();
        int n2 = string.length();
        if (Zip4jUtil.isSupportedCharset("windows-1254")) {
            try {
                string2 = new String(string.getBytes("windows-1254"), "windows-1254");
                byArray = string2.getBytes("windows-1254");
                n2 = string2.length();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = string;
                byArray = string.getBytes();
                n2 = string.length();
            }
        }
        if (n2 > 65535) {
            throw new ZipException("comment length exceeds maximum length");
        }
        zipModel.getEndCentralDirRecord().setComment(string2);
        zipModel.getEndCentralDirRecord().setCommentBytes(byArray);
        zipModel.getEndCentralDirRecord().setCommentLength(n2);
        SplitOutputStream splitOutputStream = null;
        try {
            try {
                HeaderWriter headerWriter = new HeaderWriter();
                splitOutputStream = new SplitOutputStream(zipModel.getZipFile());
                if (zipModel.isZip64Format()) {
                    splitOutputStream.seek(zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo());
                } else {
                    splitOutputStream.seek(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                }
                headerWriter.finalizeZipFileWithoutValidations(zipModel, splitOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ZipException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new ZipException(iOException);
            }
            Object var9_11 = null;
            if (splitOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (splitOutputStream == null) throw throwable;
            try {
                splitOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        splitOutputStream.close();
        return;
    }

    public void initProgressMonitorForRemoveOp(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null || fileHeader == null || progressMonitor == null) {
            throw new ZipException("one of the input parameters is null, cannot calculate total work");
        }
        progressMonitor.setCurrentOperation(2);
        progressMonitor.setFileName(fileHeader.getFileName());
        progressMonitor.setTotalWork(this.calculateTotalWorkForRemoveOp(zipModel, fileHeader));
        progressMonitor.setState(1);
    }

    private long calculateTotalWorkForRemoveOp(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        return Zip4jUtil.getFileLengh(new File(zipModel.getZipFile())) - fileHeader.getCompressedSize();
    }

    public void initProgressMonitorForMergeOp(ZipModel zipModel, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot calculate total work for merge op");
        }
        progressMonitor.setCurrentOperation(4);
        progressMonitor.setFileName(zipModel.getZipFile());
        progressMonitor.setTotalWork(this.calculateTotalWorkForMergeOp(zipModel));
        progressMonitor.setState(1);
    }

    private long calculateTotalWorkForMergeOp(ZipModel zipModel) throws ZipException {
        long l2 = 0L;
        if (zipModel.isSplitArchive()) {
            int n2 = zipModel.getEndCentralDirRecord().getNoOfThisDisk();
            String string = null;
            String string2 = zipModel.getZipFile();
            int n3 = 0;
            for (int i2 = 0; i2 <= n2; ++i2) {
                string = n3 == zipModel.getEndCentralDirRecord().getNoOfThisDisk() ? zipModel.getZipFile() : (n3 >= 9 ? string2.substring(0, string2.lastIndexOf(".")) + ".z" + (n3 + 1) : string2.substring(0, string2.lastIndexOf(".")) + ".z0" + (n3 + 1));
                l2 += Zip4jUtil.getFileLengh(new File(string));
            }
        }
        return l2;
    }
}

