/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.io;

import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.io.BaseInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZipInputStream
extends InputStream {
    private BaseInputStream is;

    public ZipInputStream(BaseInputStream baseInputStream) {
        this.is = baseInputStream;
    }

    public int read() throws IOException {
        int n2 = this.is.read();
        if (n2 != -1) {
            this.is.getUnzipEngine().updateCRC(n2);
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.is.read(byArray, n2, n3);
        if (n4 > 0 && this.is.getUnzipEngine() != null) {
            this.is.getUnzipEngine().updateCRC(byArray, n2, n4);
        }
        return n4;
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean bl) throws IOException {
        try {
            this.is.close();
            if (!bl && this.is.getUnzipEngine() != null) {
                this.is.getUnzipEngine().checkCRC();
            }
        }
        catch (ZipException zipException) {
            throw new IOException(zipException.getMessage());
        }
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public long skip(long l2) throws IOException {
        return this.is.skip(l2);
    }
}

