/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.DataBufferFloat;
import com.fr.third.JAI.FloatDoubleColorModel;
import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.RasterFactory;
import com.fr.third.JAI.SeekableStream;
import com.fr.third.JAI.SimpleRenderedImage;
import com.fr.third.JAI.TIFFDecodeParam;
import com.fr.third.JAI.TIFFDirectory;
import com.fr.third.JAI.TIFFFaxDecoder;
import com.fr.third.JAI.TIFFField;
import com.fr.third.JAI.TIFFLZWDecoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class TIFFImage
extends SimpleRenderedImage {
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_JPEG_OLD = 6;
    public static final int COMP_JPEG_TTN2 = 7;
    public static final int COMP_PACKBITS = 32773;
    public static final int COMP_DEFLATE = 32946;
    private static final int TYPE_UNSUPPORTED = -1;
    private static final int TYPE_BILEVEL = 0;
    private static final int TYPE_GRAY_4BIT = 1;
    private static final int TYPE_GRAY = 2;
    private static final int TYPE_GRAY_ALPHA = 3;
    private static final int TYPE_PALETTE = 4;
    private static final int TYPE_RGB = 5;
    private static final int TYPE_RGB_ALPHA = 6;
    private static final int TYPE_YCBCR_SUB = 7;
    private static final int TYPE_GENERIC = 8;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    SeekableStream stream;
    private boolean isTiled;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    int sampleSize;
    int compression;
    byte[] palette;
    int numBands;
    int chromaSubH;
    int chromaSubV;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    int predictor;
    JPEGDecodeParam decodeParam = null;
    boolean colorConvertJPEG = false;
    Inflater inflater = null;
    boolean isBigEndian;
    int imageType;
    boolean isWhiteZero = false;
    int dataType;
    boolean decodePaletteAsShorts;
    private TIFFFaxDecoder decoder = null;
    private TIFFLZWDecoder lzwDecoder = null;

    private static final Raster decodeJPEG(byte[] byArray, JPEGDecodeParam jPEGDecodeParam, boolean bl, int n2, int n3) {
        Raster raster;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = jPEGDecodeParam == null ? JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream) : JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream, (JPEGDecodeParam)jPEGDecodeParam);
        try {
            raster = bl ? jPEGImageDecoder.decodeAsBufferedImage().getWritableTile(0, 0) : jPEGImageDecoder.decodeAsRaster();
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        return raster.createTranslatedChild(n2, n3);
    }

    private final void inflate(byte[] byArray, byte[] byArray2) {
        this.inflater.setInput(byArray);
        try {
            this.inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage17") + ": " + dataFormatException.getMessage());
        }
        this.inflater.reset();
    }

    private static final SampleModel createPixelInterleavedSampleModel(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        SampleModel sampleModel = null;
        if (n2 == 4) {
            try {
                Class<?> clazz = Class.forName("javax.media.jai.RasterFactory");
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, [I.class};
                Method method = clazz.getMethod("createPixelInterleavedSampleModel", classArray);
                Object[] objectArray = new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), nArray};
                sampleModel = (SampleModel)method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 != 4 || sampleModel == null) {
            sampleModel = RasterFactory.createPixelInterleavedSampleModel(n2, n3, n4, n5, n6, nArray);
        }
        return sampleModel;
    }

    private final long[] getFieldAsLongs(TIFFField tIFFField) {
        long[] lArray = null;
        if (tIFFField.getType() == 3) {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                lArray[i2] = cArray[i2] & 0xFFFF;
            }
        } else if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            throw new RuntimeException();
        }
        return lArray;
    }

    private TIFFField getField(TIFFDirectory tIFFDirectory, int n2, String string) {
        TIFFField tIFFField = tIFFDirectory.getField(n2);
        if (tIFFField == null) {
            MessageFormat messageFormat = new MessageFormat(JaiI18N.getString("TIFFImage5"));
            messageFormat.setLocale(Locale.getDefault());
            throw new RuntimeException(messageFormat.format(new Object[]{string}));
        }
        return tIFFField;
    }

    public TIFFImage(SeekableStream seekableStream, TIFFDecodeParam tIFFDecodeParam, int n2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        TIFFField tIFFField;
        int n3;
        TIFFField tIFFField2;
        int n4;
        char[] cArray;
        char[] cArray2;
        this.stream = seekableStream;
        if (tIFFDecodeParam == null) {
            tIFFDecodeParam = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = tIFFDecodeParam.getDecodePaletteAsShorts();
        TIFFDirectory tIFFDirectory = tIFFDecodeParam.getIFDOffset() == null ? new TIFFDirectory(seekableStream, n2) : new TIFFDirectory(seekableStream, tIFFDecodeParam.getIFDOffset(), n2);
        this.properties.put("tiff_directory", tIFFDirectory);
        TIFFField tIFFField3 = tIFFDirectory.getField(277);
        int n5 = tIFFField3 == null ? 1 : (int)tIFFField3.getAsLong(0);
        TIFFField tIFFField4 = tIFFDirectory.getField(284);
        if (tIFFField4 == null) {
            char[] cArray3 = new char[1];
            cArray2 = cArray3;
            cArray3[0] = '\u0001';
        } else {
            cArray2 = cArray = tIFFField4.getAsChars();
        }
        if (cArray[0] != '\u0001' && n5 != 1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage0"));
        }
        TIFFField tIFFField5 = tIFFDirectory.getField(258);
        char[] cArray4 = null;
        if (tIFFField5 != null) {
            cArray4 = tIFFField5.getAsChars();
        } else {
            cArray4 = new char[]{'\u0001'};
            for (int i2 = 1; i2 < cArray4.length; ++i2) {
                if (cArray4[i2] == cArray4[0]) continue;
                throw new RuntimeException(JaiI18N.getString("TIFFImage1"));
            }
        }
        this.sampleSize = cArray4[0];
        TIFFField tIFFField6 = tIFFDirectory.getField(339);
        char[] cArray5 = null;
        if (tIFFField6 != null) {
            cArray5 = tIFFField6.getAsChars();
            for (n4 = 1; n4 < cArray5.length; ++n4) {
                if (cArray5[n4] == cArray5[0]) continue;
                throw new RuntimeException(JaiI18N.getString("TIFFImage2"));
            }
        } else {
            cArray5 = new char[]{'\u0001'};
        }
        n4 = 0;
        switch (this.sampleSize) {
            case 1: 
            case 4: 
            case 8: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = 0;
                n4 = 1;
                break;
            }
            case 16: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = cArray5[0] == '\u0002' ? 2 : 1;
                n4 = 1;
                break;
            }
            case 32: {
                this.dataType = cArray5[0] == '\u0003' ? 4 : 3;
                n4 = 1;
            }
        }
        if (n4 == 0) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage3"));
        }
        TIFFField tIFFField7 = tIFFDirectory.getField(259);
        this.compression = tIFFField7 == null ? 1 : tIFFField7.getAsInt(0);
        TIFFField tIFFField8 = this.getField(tIFFDirectory, 262, "Photometric Interpretation");
        int n6 = (int)tIFFField8.getAsLong(0);
        this.imageType = -1;
        switch (n6) {
            case 0: {
                this.isWhiteZero = true;
            }
            case 1: {
                if (this.sampleSize == 1 && n5 == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.sampleSize == 4 && n5 == 1) {
                    this.imageType = 1;
                    break;
                }
                if (this.sampleSize % 8 != 0) break;
                if (n5 == 1) {
                    this.imageType = 2;
                    break;
                }
                if (n5 == 2) {
                    this.imageType = 3;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 2: {
                if (this.sampleSize % 8 != 0) break;
                if (n5 == 3) {
                    this.imageType = 5;
                    break;
                }
                if (n5 == 4) {
                    this.imageType = 6;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 3: {
                if (n5 != true || this.sampleSize != 4 && this.sampleSize != 8 && this.sampleSize != 16) break;
                this.imageType = 4;
                break;
            }
            case 4: {
                if (this.sampleSize != 1 || n5 != true) break;
                this.imageType = 0;
                break;
            }
            case 6: {
                if (this.compression == 7 && this.sampleSize == 8 && n5 == 3) {
                    this.colorConvertJPEG = tIFFDecodeParam.getJPEGDecompressYCbCrToRGB();
                    this.imageType = this.colorConvertJPEG ? 5 : 8;
                    break;
                }
                tIFFField2 = tIFFDirectory.getField(530);
                if (tIFFField2 != null) {
                    this.chromaSubH = tIFFField2.getAsInt(0);
                    this.chromaSubV = tIFFField2.getAsInt(1);
                } else {
                    this.chromaSubV = 2;
                    this.chromaSubH = 2;
                }
                if (this.chromaSubH * this.chromaSubV == 1) {
                    this.imageType = 8;
                    break;
                }
                if (this.sampleSize != 8 || n5 != 3) break;
                this.imageType = 7;
                break;
            }
            default: {
                if (this.sampleSize % 8 != 0) break;
                this.imageType = 8;
            }
        }
        if (this.imageType == -1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage4"));
        }
        this.minY = 0;
        this.minX = 0;
        this.width = (int)this.getField(tIFFDirectory, 256, "Image Width").getAsLong(0);
        this.height = (int)this.getField(tIFFDirectory, 257, "Image Length").getAsLong(0);
        this.numBands = n5;
        tIFFField2 = tIFFDirectory.getField(338);
        int n7 = n3 = tIFFField2 == null ? 0 : (int)tIFFField2.getAsLong(0);
        if (tIFFDirectory.getField(324) != null) {
            this.isTiled = true;
            this.tileWidth = (int)this.getField(tIFFDirectory, 322, "Tile Width").getAsLong(0);
            this.tileHeight = (int)this.getField(tIFFDirectory, 323, "Tile Length").getAsLong(0);
            this.tileOffsets = this.getField(tIFFDirectory, 324, "Tile Offsets").getAsLongs();
            this.tileByteCounts = this.getFieldAsLongs(this.getField(tIFFDirectory, 325, "Tile Byte Counts"));
        } else {
            this.isTiled = false;
            this.tileWidth = tIFFDirectory.getField(322) != null ? (int)tIFFDirectory.getFieldAsLong(322) : this.width;
            tIFFField = tIFFDirectory.getField(278);
            if (tIFFField == null) {
                this.tileHeight = tIFFDirectory.getField(323) != null ? (int)tIFFDirectory.getFieldAsLong(323) : this.height;
            } else {
                long l2 = tIFFField.getAsLong(0);
                long l3 = 1L;
                this.tileHeight = l2 == (l3 = (l3 << 32) - 1L) ? this.height : (int)l2;
            }
            object3 = this.getField(tIFFDirectory, 273, "Strip Offsets");
            this.tileOffsets = this.getFieldAsLongs((TIFFField)object3);
            object2 = this.getField(tIFFDirectory, 279, "Strip Byte Counts");
            this.tileByteCounts = this.getFieldAsLongs((TIFFField)object2);
            int n8 = this.width * this.height * this.numBands * ((this.sampleSize + 7) / 8);
            if (this.tileByteCounts.length == 1 && this.compression == 1 && this.tileByteCounts[0] > (long)n8) {
                this.tileByteCounts[0] = n8;
            }
        }
        this.tilesX = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.tilesY = (this.height + this.tileHeight - 1) / this.tileHeight;
        this.tileSize = this.tileWidth * this.tileHeight * this.numBands;
        this.isBigEndian = tIFFDirectory.isBigEndian();
        tIFFField = tIFFDirectory.getField(266);
        this.fillOrder = tIFFField != null ? tIFFField.getAsInt(0) : 1;
        switch (this.compression) {
            case 1: 
            case 32773: {
                break;
            }
            case 32946: {
                this.inflater = new Inflater();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.sampleSize != 1) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage7"));
                }
                if (this.compression == 3) {
                    object3 = tIFFDirectory.getField(292);
                    this.tiffT4Options = object3 != null ? ((TIFFField)object3).getAsLong(0) : 0L;
                }
                if (this.compression == 4) {
                    object3 = tIFFDirectory.getField(293);
                    this.tiffT6Options = object3 != null ? ((TIFFField)object3).getAsLong(0) : 0L;
                }
                this.decoder = new TIFFFaxDecoder(this.fillOrder, this.tileWidth, this.tileHeight);
                break;
            }
            case 5: {
                object3 = tIFFDirectory.getField(317);
                if (object3 == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = ((TIFFField)object3).getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImage8"));
                    }
                    if (this.predictor == 2 && this.sampleSize != 8) {
                        throw new RuntimeException(this.sampleSize + JaiI18N.getString("TIFFImage9"));
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(this.tileWidth, this.predictor, n5);
                break;
            }
            case 6: {
                throw new RuntimeException(JaiI18N.getString("TIFFImage15"));
            }
            case 7: {
                if (!(this.sampleSize == 8 && (this.imageType == 2 && n5 == 1 || this.imageType == 4 && n5 == 1 || this.imageType == 5 && n5 == 3))) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage16"));
                }
                if (!tIFFDirectory.isTagPresent(347)) break;
                object2 = tIFFDirectory.getField(347);
                byte[] byArray = ((TIFFField)object2).getAsBytes();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                object = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                object.decodeAsRaster();
                this.decodeParam = object.getJPEGDecodeParam();
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImage10"));
            }
        }
        switch (this.imageType) {
            case 0: 
            case 1: {
                this.sampleModel = new MultiPixelPackedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.sampleSize);
                if (this.imageType == 0) {
                    object3 = new byte[]{(byte)(this.isWhiteZero ? 255 : 0), (byte)(this.isWhiteZero ? 0 : 255)};
                    this.colorModel = new IndexColorModel(1, 2, (byte[])object3, (byte[])object3, (byte[])object3);
                    break;
                }
                this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, !this.isWhiteZero);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                int n9;
                object3 = new int[this.numBands];
                if (this.compression == 7) {
                    for (n9 = 0; n9 < this.numBands; ++n9) {
                        object3[n9] = this.numBands - 1 - n9;
                    }
                } else {
                    for (n9 = 0; n9 < this.numBands; ++n9) {
                        object3[n9] = n9;
                    }
                }
                this.sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, (int[])object3);
                if (this.imageType == 2 || this.imageType == 5) {
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                n9 = 1;
                if (n3 == 1) {
                    n9 = 3;
                } else if (n3 == 2) {
                    n9 = 2;
                }
                this.colorModel = this.createAlphaComponentColorModel(this.dataType, this.numBands, n3 == 1, n9);
                break;
            }
            case 7: 
            case 8: {
                object2 = new int[this.numBands];
                for (int i3 = 0; i3 < this.numBands; ++i3) {
                    object2[i3] = i3;
                }
                this.sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, (int[])object2);
                this.colorModel = null;
                break;
            }
            case 4: {
                TIFFField tIFFField9 = this.getField(tIFFDirectory, 320, "Colormap");
                this.colormap = tIFFField9.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.numBands = 3;
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                this.numBands = 1;
                if (this.sampleSize == 4) {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.sampleSize);
                } else if (this.sampleSize == 8) {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.numBands);
                } else if (this.sampleSize == 16) {
                    this.dataType = 1;
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(1, this.tileWidth, this.tileHeight, this.numBands);
                }
                int n10 = this.colormap.length / 3;
                object = new byte[n10];
                byte[] byArray = new byte[n10];
                byte[] byArray2 = new byte[n10];
                int n11 = n10;
                int n12 = n10 * 2;
                if (this.dataType == 2) {
                    for (int i4 = 0; i4 < n10; ++i4) {
                        object[i4] = (JPEGImageDecoder)tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[i4]);
                        byArray[i4] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n11 + i4]);
                        byArray2[i4] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n12 + i4]);
                    }
                } else {
                    for (int i5 = 0; i5 < n10; ++i5) {
                        object[i5] = (JPEGImageDecoder)tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[i5] & 0xFFFF);
                        byArray[i5] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n11 + i5] & 0xFFFF);
                        byArray2[i5] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n12 + i5] & 0xFFFF);
                    }
                }
                this.colorModel = new IndexColorModel(this.sampleSize, n10, (byte[])object, byArray, byArray2);
                break;
            }
            default: {
                throw new RuntimeException("TIFFImage4");
            }
        }
    }

    public TIFFDirectory getPrivateIFD(long l2) throws IOException {
        return new TIFFDirectory(this.stream, l2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Raster getTile(int n2, int n3) {
        byte[] byArray;
        Object object;
        if (n2 < 0 || n2 >= this.tilesX || n3 < 0 || n3 >= this.tilesY) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFImage12"));
        }
        byte[] byArray2 = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        DataBuffer dataBuffer = this.sampleModel.createDataBuffer();
        int n4 = this.sampleModel.getDataType();
        if (n4 == 0) {
            byArray2 = ((DataBufferByte)dataBuffer).getData();
        } else if (n4 == 1) {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        } else if (n4 == 2) {
            sArray = ((DataBufferShort)dataBuffer).getData();
        } else if (n4 == 3) {
            nArray = ((DataBufferInt)dataBuffer).getData();
        } else if (n4 == 4) {
            if (dataBuffer instanceof DataBufferFloat) {
                fArray = ((DataBufferFloat)dataBuffer).getData();
            } else {
                try {
                    object = dataBuffer.getClass().getMethod("getData", null);
                    fArray = (float[])((Method)object).invoke((Object)dataBuffer, null);
                }
                catch (Exception exception) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage18"));
                }
            }
        }
        object = RasterFactory.createWritableRaster(this.sampleModel, dataBuffer, new Point(this.tileXToX(n2), this.tileYToY(n3)));
        long l2 = 0L;
        try {
            l2 = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[n3 * this.tilesX + n2]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        int n5 = (int)this.tileByteCounts[n3 * this.tilesX + n2];
        Rectangle rectangle = new Rectangle(this.tileXToX(n2), this.tileYToY(n3), this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = this.isTiled ? rectangle : rectangle.intersection(this.getBounds());
        int n6 = rectangle2.width * rectangle2.height * this.numBands;
        Object object2 = byArray = (Object)(this.compression != 1 || this.imageType == 4 ? new byte[n5] : null);
        if (this.imageType == 0) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n7 = rectangle2.width % 8 == 0 ? rectangle2.width / 8 * rectangle2.height : (rectangle2.width / 8 + 1) * rectangle2.height;
                    this.decodePackbits(byArray, n7, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                } else if (this.compression == 2) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decode1D(byArray2, byArray, 0, rectangle2.height);
                } else if (this.compression == 3) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decode2D(byArray2, byArray, 0, rectangle2.height, this.tiffT4Options);
                } else if (this.compression == 4) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decodeT6(byArray2, byArray, 0, rectangle2.height, this.tiffT6Options);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n5);
                }
                this.stream.seek(l2);
                return object;
            }
            catch (IOException iOException) {
                throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
            }
        }
        if (this.imageType == 4) {
            if (this.sampleSize == 16) {
                if (this.decodePaletteAsShorts) {
                    short[] sArray2 = null;
                    int n8 = n6 / 3;
                    int n9 = n8 * 2;
                    try {
                        byte[] byArray3;
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.decodePackbits(byArray, n9, byArray3);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.lzwDecoder.decode(byArray, byArray3, rectangle2.height);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.inflate(byArray, byArray3);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 1) {
                            sArray2 = new short[n5 / 2];
                            this.readShorts(n5 / 2, sArray2);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                    }
                    if (n4 == 1) {
                        int n10 = 0;
                        int n11 = this.colormap.length / 3;
                        int n12 = n11 * 2;
                        for (int i2 = 0; i2 < n8; ++i2) {
                            int n13 = sArray2[i2] & 0xFFFF;
                            char c2 = this.colormap[n13 + n12];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                            c2 = this.colormap[n13 + n11];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                            c2 = this.colormap[n13];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                        }
                        return object;
                    } else {
                        if (n4 != 2) return object;
                        int n14 = 0;
                        int n15 = this.colormap.length / 3;
                        int n16 = n15 * 2;
                        for (int i3 = 0; i3 < n8; ++i3) {
                            int n17 = sArray2[i3] & 0xFFFF;
                            char c3 = this.colormap[n17 + n16];
                            sArray[n14++] = (short)c3;
                            c3 = this.colormap[n17 + n15];
                            sArray[n14++] = (short)c3;
                            c3 = this.colormap[n17];
                            sArray[n14++] = (short)c3;
                        }
                    }
                    return object;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n5);
                        int n18 = n6 * 2;
                        byte[] byArray4 = new byte[n18];
                        this.decodePackbits(byArray, n18, byArray4);
                        this.interpretBytesAsShorts(byArray4, sArray, n6);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray5 = new byte[n6 * 2];
                        this.lzwDecoder.decode(byArray, byArray5, rectangle2.height);
                        this.interpretBytesAsShorts(byArray5, sArray, n6);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray6 = new byte[n6 * 2];
                        this.inflate(byArray, byArray6);
                        this.interpretBytesAsShorts(byArray6, sArray, n6);
                    } else if (this.compression == 1) {
                        this.readShorts(n5 / 2, sArray);
                    }
                    this.stream.seek(l2);
                    return object;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                }
            }
            if (this.sampleSize == 8) {
                if (this.decodePaletteAsShorts) {
                    int n19;
                    byte[] byArray7 = null;
                    int n20 = n6 / 3;
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n20];
                            this.decodePackbits(byArray, n20, byArray7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n20];
                            this.lzwDecoder.decode(byArray, byArray7, rectangle2.height);
                        } else if (this.compression == 7) {
                            this.stream.readFully(byArray, 0, n5);
                            Raster raster = TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object).getMinX(), ((Raster)object).getMinY());
                            int[] nArray2 = new int[n20];
                            raster.getPixels(((Raster)object).getMinX(), ((Raster)object).getMinY(), ((Raster)object).getWidth(), ((Raster)object).getHeight(), nArray2);
                            byArray7 = new byte[n20];
                            for (n19 = 0; n19 < n20; ++n19) {
                                byArray7[n19] = (byte)nArray2[n19];
                            }
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n20];
                            this.inflate(byArray, byArray7);
                        } else if (this.compression == 1) {
                            byArray7 = new byte[n5];
                            this.stream.readFully(byArray7, 0, n5);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                    }
                    int n21 = 0;
                    int n22 = this.colormap.length / 3;
                    int n23 = n22 * 2;
                    for (int i4 = 0; i4 < n20; ++i4) {
                        n19 = byArray7[i4] & 0xFF;
                        char c4 = this.colormap[n19 + n23];
                        sArray[n21++] = (short)(c4 & 0xFFFF);
                        c4 = this.colormap[n19 + n22];
                        sArray[n21++] = (short)(c4 & 0xFFFF);
                        c4 = this.colormap[n19];
                        sArray[n21++] = (short)(c4 & 0xFFFF);
                    }
                    return object;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n5);
                        this.decodePackbits(byArray, n6, byArray2);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n5);
                        this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                    } else if (this.compression == 7) {
                        this.stream.readFully(byArray, 0, n5);
                        ((WritableRaster)object).setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object).getMinX(), ((Raster)object).getMinY()));
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n5);
                        this.inflate(byArray, byArray2);
                    } else if (this.compression == 1) {
                        this.stream.readFully(byArray2, 0, n5);
                    }
                    this.stream.seek(l2);
                    return object;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                }
            }
            if (this.sampleSize != 4) return object;
            int n24 = rectangle2.width % 2 == 0 ? 0 : 1;
            int n25 = (rectangle2.width / 2 + n24) * rectangle2.height;
            if (this.decodePaletteAsShorts) {
                int n26;
                int n27;
                byte[] byArray8 = null;
                try {
                    this.stream.readFully(byArray, 0, n5);
                    this.stream.seek(l2);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                }
                if (this.compression == 32773) {
                    byArray8 = new byte[n25];
                    this.decodePackbits(byArray, n25, byArray8);
                } else if (this.compression == 5) {
                    byArray8 = new byte[n25];
                    this.lzwDecoder.decode(byArray, byArray8, rectangle2.height);
                } else if (this.compression == 32946) {
                    byArray8 = new byte[n25];
                    this.inflate(byArray, byArray8);
                } else if (this.compression == 1) {
                    byArray8 = byArray;
                }
                int n28 = n6 / 3;
                byArray = new byte[n28];
                int n29 = 0;
                int n30 = 0;
                for (n27 = 0; n27 < rectangle2.height; ++n27) {
                    for (n26 = 0; n26 < rectangle2.width / 2; ++n26) {
                        byArray[n30++] = (byte)((byArray8[n29] & 0xF0) >> 4);
                        byArray[n30++] = (byte)(byArray8[n29++] & 0xF);
                    }
                    if (n24 != 1) continue;
                    byArray[n30++] = (byte)((byArray8[n29++] & 0xF0) >> 4);
                }
                n27 = this.colormap.length / 3;
                n26 = n27 * 2;
                int n31 = 0;
                for (int i5 = 0; i5 < n28; ++i5) {
                    int n32 = byArray[i5] & 0xFF;
                    char c5 = this.colormap[n32 + n26];
                    sArray[n31++] = (short)(c5 & 0xFFFF);
                    c5 = this.colormap[n32 + n27];
                    sArray[n31++] = (short)(c5 & 0xFFFF);
                    c5 = this.colormap[n32];
                    sArray[n31++] = (short)(c5 & 0xFFFF);
                }
                return object;
            }
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decodePackbits(byArray, n25, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n5);
                }
                this.stream.seek(l2);
                return object;
            }
            catch (IOException iOException) {
                throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
            }
        }
        if (this.imageType == 1) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n33 = rectangle2.width % 8 == 0 ? rectangle2.width / 2 * rectangle2.height : (rectangle2.width / 2 + 1) * rectangle2.height;
                    this.decodePackbits(byArray, n33, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                } else {
                    this.stream.readFully(byArray2, 0, n5);
                }
                this.stream.seek(l2);
                return object;
            }
            catch (IOException iOException) {
                throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
            }
        }
        try {
            byte[] byArray9;
            if (this.sampleSize == 8) {
                if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n5);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decodePackbits(byArray, n6, byArray2);
                } else if (this.compression == 7) {
                    this.stream.readFully(byArray, 0, n5);
                    ((WritableRaster)object).setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object).getMinX(), ((Raster)object).getMinY()));
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                }
            } else if (this.sampleSize == 16) {
                if (this.compression == 1) {
                    this.readShorts(n5 / 2, sArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray10 = new byte[n6 * 2];
                    this.lzwDecoder.decode(byArray, byArray10, rectangle2.height);
                    this.interpretBytesAsShorts(byArray10, sArray, n6);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n34 = n6 * 2;
                    byArray9 = new byte[n34];
                    this.decodePackbits(byArray, n34, byArray9);
                    this.interpretBytesAsShorts(byArray9, sArray, n6);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray11 = new byte[n6 * 2];
                    this.inflate(byArray, byArray11);
                    this.interpretBytesAsShorts(byArray11, sArray, n6);
                }
            } else if (this.sampleSize == 32 && n4 == 3) {
                if (this.compression == 1) {
                    this.readInts(n5 / 4, nArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray12 = new byte[n6 * 4];
                    this.lzwDecoder.decode(byArray, byArray12, rectangle2.height);
                    this.interpretBytesAsInts(byArray12, nArray, n6);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n35 = n6 * 4;
                    byArray9 = new byte[n35];
                    this.decodePackbits(byArray, n35, byArray9);
                    this.interpretBytesAsInts(byArray9, nArray, n6);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray13 = new byte[n6 * 4];
                    this.inflate(byArray, byArray13);
                    this.interpretBytesAsInts(byArray13, nArray, n6);
                }
            } else if (this.sampleSize == 32 && n4 == 4) {
                if (this.compression == 1) {
                    this.readFloats(n5 / 4, fArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray14 = new byte[n6 * 4];
                    this.lzwDecoder.decode(byArray, byArray14, rectangle2.height);
                    this.interpretBytesAsFloats(byArray14, fArray, n6);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n36 = n6 * 4;
                    byArray9 = new byte[n36];
                    this.decodePackbits(byArray, n36, byArray9);
                    this.interpretBytesAsFloats(byArray9, fArray, n6);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray15 = new byte[n6 * 4];
                    this.inflate(byArray, byArray15);
                    this.interpretBytesAsFloats(byArray15, fArray, n6);
                }
            }
            this.stream.seek(l2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        switch (this.imageType) {
            case 2: 
            case 3: {
                if (!this.isWhiteZero) return object;
                if (n4 == 0 && !(this.colorModel instanceof IndexColorModel)) {
                    for (int i6 = 0; i6 < byArray2.length; i6 += this.numBands) {
                        byArray2[i6] = (byte)(255 - byArray2[i6]);
                    }
                    return object;
                } else if (n4 == 1) {
                    int n37 = 65535;
                    for (int i7 = 0; i7 < sArray.length; i7 += this.numBands) {
                        sArray[i7] = (short)(n37 - sArray[i7]);
                    }
                    return object;
                } else if (n4 == 2) {
                    for (int i8 = 0; i8 < sArray.length; i8 += this.numBands) {
                        sArray[i8] = ~sArray[i8];
                    }
                    return object;
                } else {
                    if (n4 != 3) return object;
                    long l3 = -1L;
                    for (int i9 = 0; i9 < nArray.length; i9 += this.numBands) {
                        nArray[i9] = (int)(l3 - (long)nArray[i9]);
                    }
                }
                return object;
            }
            case 7: {
                int n38 = this.chromaSubH * this.chromaSubV;
                int n39 = rectangle2.width / this.chromaSubH;
                int n40 = rectangle2.height / this.chromaSubV;
                byte[] byArray16 = new byte[n39 * n40 * (n38 + 2)];
                System.arraycopy(byArray2, 0, byArray16, 0, byArray16.length);
                int n41 = n38 * 3;
                int[] nArray3 = new int[n41];
                int n42 = 0;
                int n43 = n38;
                int n44 = n43 + 1;
                int n45 = rectangle2.y;
                for (int i10 = 0; i10 < n40; ++i10) {
                    int n46 = rectangle2.x;
                    for (int i11 = 0; i11 < n39; ++i11) {
                        int n47 = byArray16[n42 + n43];
                        int n48 = byArray16[n42 + n44];
                        int n49 = 0;
                        while (n49 < n41) {
                            nArray3[n49++] = byArray16[n42++];
                            nArray3[n49++] = n47;
                            nArray3[n49++] = n48;
                        }
                        n42 += 2;
                        ((WritableRaster)object).setPixels(n46, n45, this.chromaSubH, this.chromaSubV, nArray3);
                        n46 += this.chromaSubH;
                    }
                    n45 += this.chromaSubV;
                }
                return object;
            }
        }
        return object;
    }

    private void readShorts(int n2, short[] sArray) {
        int n3 = 2 * n2;
        byte[] byArray = new byte[n3];
        try {
            this.stream.readFully(byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        this.interpretBytesAsShorts(byArray, sArray, n2);
    }

    private void readInts(int n2, int[] nArray) {
        int n3 = 4 * n2;
        byte[] byArray = new byte[n3];
        try {
            this.stream.readFully(byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        this.interpretBytesAsInts(byArray, nArray, n2);
    }

    private void readFloats(int n2, float[] fArray) {
        int n3 = 4 * n2;
        byte[] byArray = new byte[n3];
        try {
            this.stream.readFully(byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        this.interpretBytesAsFloats(byArray, fArray, n2);
    }

    private void interpretBytesAsShorts(byte[] byArray, short[] sArray, int n2) {
        int n3 = 0;
        if (this.isBigEndian) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = byArray[n3++] & 0xFF;
                int n5 = byArray[n3++] & 0xFF;
                sArray[i2] = (short)((n4 << 8) + n5);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = byArray[n3++] & 0xFF;
                int n7 = byArray[n3++] & 0xFF;
                sArray[i3] = (short)((n7 << 8) + n6);
            }
        }
    }

    private void interpretBytesAsInts(byte[] byArray, int[] nArray, int n2) {
        int n3 = 0;
        if (this.isBigEndian) {
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i3] = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
            }
        }
    }

    private void interpretBytesAsFloats(byte[] byArray, float[] fArray, int n2) {
        int n3 = 0;
        if (this.isBigEndian) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
                fArray[i2] = Float.intBitsToFloat(n4);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
                fArray[i3] = Float.intBitsToFloat(n5);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private byte[] decodePackbits(byte[] byArray, int n2, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[n2];
        }
        int n3 = 0;
        int n4 = 0;
        try {
            block2: while (n4 < n2) {
                int n5;
                byte by;
                if ((by = byArray[n3++]) >= 0 && by <= 127) {
                    n5 = 0;
                    while (true) {
                        if (n5 >= by + 1) continue block2;
                        byArray2[n4++] = byArray[n3++];
                        ++n5;
                    }
                }
                if (by <= -1 && by >= -127) {
                    byte by2 = byArray[n3++];
                    n5 = 0;
                    while (true) {
                        if (n5 >= -by + 1) continue block2;
                        byArray2[n4++] = by2;
                        ++n5;
                    }
                }
                ++n3;
            }
            return byArray2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage14"));
        }
    }

    private ComponentColorModel createAlphaComponentColorModel(int n2, int n3, boolean bl, int n4) {
        ComponentColorModel componentColorModel = null;
        int[] nArray = null;
        ColorSpace colorSpace = null;
        switch (n3) {
            case 2: {
                colorSpace = ColorSpace.getInstance(1003);
                break;
            }
            case 4: {
                colorSpace = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (n2 == 4) {
            componentColorModel = new FloatDoubleColorModel(colorSpace, true, bl, n4, n2);
        } else {
            int n5 = 0;
            switch (n2) {
                case 0: {
                    n5 = 8;
                    break;
                }
                case 1: 
                case 2: {
                    n5 = 16;
                    break;
                }
                case 3: {
                    n5 = 32;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            nArray = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = n5;
            }
            componentColorModel = new ComponentColorModel(colorSpace, nArray, true, bl, n4, n2);
        }
        return componentColorModel;
    }
}

