/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.SectorStreamSegmentMapper;
import com.fr.third.JAI.SeekableStream;
import com.fr.third.JAI.StreamSegment;
import com.fr.third.JAI.StreamSegmentMapper;
import com.fr.third.JAI.StreamSegmentMapperImpl;
import java.io.IOException;

public class SegmentedSeekableStream
extends SeekableStream {
    private SeekableStream stream;
    private StreamSegmentMapper mapper;
    private long pointer = 0L;
    private boolean canSeekBackwards;
    private StreamSegment streamSegment = new StreamSegment();

    public SegmentedSeekableStream(SeekableStream seekableStream, StreamSegmentMapper streamSegmentMapper, boolean bl) {
        this.stream = seekableStream;
        this.mapper = streamSegmentMapper;
        this.canSeekBackwards = bl;
        if (bl && !seekableStream.canSeekBackwards()) {
            throw new IllegalArgumentException(JaiI18N.getString("SegmentedSeekableStream0"));
        }
    }

    public SegmentedSeekableStream(SeekableStream seekableStream, long[] lArray, int[] nArray, boolean bl) {
        this(seekableStream, new StreamSegmentMapperImpl(lArray, nArray), bl);
    }

    public SegmentedSeekableStream(SeekableStream seekableStream, long[] lArray, int n2, int n3, boolean bl) {
        this(seekableStream, new SectorStreamSegmentMapper(lArray, n2, n3), bl);
    }

    public long getFilePointer() {
        return this.pointer;
    }

    public boolean canSeekBackwards() {
        return this.canSeekBackwards;
    }

    public void seek(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException();
        }
        this.pointer = l2;
    }

    public int read() throws IOException {
        this.mapper.getStreamSegment(this.pointer, 1, this.streamSegment);
        this.stream.seek(this.streamSegment.getStartPos());
        int n2 = this.stream.read();
        ++this.pointer;
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        this.mapper.getStreamSegment(this.pointer, n3, this.streamSegment);
        this.stream.seek(this.streamSegment.getStartPos());
        int n4 = this.stream.read(byArray, n2, this.streamSegment.getSegmentLength());
        this.pointer += (long)n4;
        return n4;
    }
}

