/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.xml;

import com.fr.stable.xml.StableXMLUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public abstract class XMLWriterHelper {
    public static XmlStartTag startTag(String string) {
        return new XmlStartTag(string);
    }

    public static XmlStartTag completeTagWithNoChildNode(String string) {
        return new XmlStartTag(string, true);
    }

    public static void startTagWithNoAttribute(PrintWriter printWriter, String string) {
        printWriter.print("<" + string + ">");
    }

    public static void endTag(PrintWriter printWriter, String string) {
        printWriter.print("</" + string + ">");
    }

    public static class XmlStartTag {
        private String tagName;
        private Map attributes;
        private boolean withNoChildNode = false;

        private XmlStartTag(String string) {
            this.tagName = string;
        }

        private XmlStartTag(String string, boolean bl) {
            this(string);
            this.withNoChildNode = bl;
        }

        public XmlStartTag attr(String string, String string2) {
            if (string2 == null) {
                return this;
            }
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(string, string2);
            return this;
        }

        public XmlStartTag attr(String string, String string2, String string3) {
            if (string2 == null || string2.equals(string3)) {
                return this;
            }
            return this.attr(string, string2);
        }

        public XmlStartTag attr(String string, boolean bl) {
            return this.attr(string, Boolean.toString(bl));
        }

        public XmlStartTag attr(String string, boolean bl, boolean bl2) {
            if (bl == bl2) {
                return this;
            }
            return this.attr(string, bl);
        }

        public XmlStartTag attr(String string, byte by) {
            return this.attr(string, Byte.toString(by));
        }

        public XmlStartTag attr(String string, byte by, byte by2) {
            if (by == by2) {
                return this;
            }
            return this.attr(string, by);
        }

        public XmlStartTag attr(String string, int n2) {
            return this.attr(string, Integer.toString(n2));
        }

        public XmlStartTag attr(String string, int n2, int n3) {
            if (n2 == n3) {
                return this;
            }
            return this.attr(string, n2);
        }

        public XmlStartTag attr(String string, double d2) {
            return this.attr(string, Double.toString(d2));
        }

        public XmlStartTag attr(String string, double d2, double d3) {
            if (d2 == d3) {
                return this;
            }
            return this.attr(string, d2);
        }

        public void write(PrintWriter printWriter) {
            printWriter.write(new StringBuffer().append('<').append(this.tagName).toString());
            printWriter.write(this.attributeBuffer().toString());
            if (this.withNoChildNode) {
                printWriter.write("/>");
            } else {
                printWriter.write(">");
            }
        }

        private StringBuffer attributeBuffer() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.attributes != null) {
                for (Map.Entry entry : this.attributes.entrySet()) {
                    stringBuffer.append(' ').append(entry.getKey()).append("=\"").append(StableXMLUtils.xmlAttrEncode(entry.getValue().toString())).append('\"');
                }
            }
            return stringBuffer;
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            this.write(new PrintWriter(stringWriter));
            return stringWriter.getBuffer().toString();
        }
    }
}

